/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.type;

import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.odftoolkit.odfdom.type.OdfDataType;

public class Length
implements OdfDataType {
    private static final Logger LOG = Logger.getLogger(Length.class.getName());
    private String mLengthString = null;
    private static final Pattern lengthPattern = Pattern.compile("^-?([0-9]+(\\.[0-9]*)?|\\.[0-9]+)((cm)|(mm)|(in)|(pt)|(pc)|(px))$");

    public Length(String length) throws NumberFormatException {
        if (!Length.isValid((String)length)) {
            try {
                Integer.parseInt((String)length);
                length = (String)length + Unit.POINT.abbr();
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("parameter '" + (String)length + "' is invalid for datatype Length");
            }
        }
        this.mLengthString = length;
    }

    public static boolean isValid(String stringValue) {
        return stringValue != null && lengthPattern.matcher(stringValue).matches();
    }

    public static Unit parseUnit(String length) {
        Unit lengthUnit = null;
        if (length == null) {
            throw new NumberFormatException("The input length should not be null!");
        }
        boolean identifiedInput = false;
        for (Unit unit : Unit.values()) {
            if (!length.contains(unit.abbr())) continue;
            lengthUnit = unit;
            identifiedInput = true;
            break;
        }
        if (!identifiedInput) {
            throw new NumberFormatException("The input length " + length + " has no valid Unit!");
        }
        return lengthUnit;
    }

    public static int parseInt(String length) {
        return (int)Length.parseDouble(length, null);
    }

    public static int parseInt(String length, Unit destinationUnit) {
        return (int)Length.parseDouble(length, destinationUnit);
    }

    public static long parseLong(String length) {
        return (long)Length.parseDouble(length, null);
    }

    public static long parseLong(String length, Unit destinationUnit) {
        return (long)Length.parseDouble(length, destinationUnit);
    }

    public static double parseDouble(String length) {
        return Length.parseDouble(length, null);
    }

    public static double parseDouble(String length, Unit destinationUnit) {
        double newValue = 0.0;
        if (length != null) {
            double roundingFactor = 10000.0;
            boolean identifiedInput = false;
            for (Unit unit : Unit.values()) {
                if (!length.contains(unit.abbr())) continue;
                Double value = Double.valueOf(length.substring(0, length.indexOf(unit.abbr())));
                if (destinationUnit != null) {
                    newValue = (double)Math.round(roundingFactor * value / destinationUnit.unitInMillimiter() * unit.mUnitInMillimiter) / roundingFactor;
                } else {
                    destinationUnit = unit;
                }
                identifiedInput = true;
                break;
            }
            if (!identifiedInput) {
                LOG.warning("The unit " + length + " could not be transformed to " + destinationUnit.toString() + "!");
            }
        } else {
            LOG.warning("The input length should not be null!");
        }
        return newValue;
    }

    public String mapToUnit(Unit destinationUnit) {
        return Length.mapToUnit(this.mLengthString, destinationUnit);
    }

    public Double getMillimeters() {
        return Length.getLength(this.mLengthString, Unit.MILLIMETER);
    }

    public Double getMicrometer() {
        return Length.getLength(this.mLengthString, Unit.MICROMETER);
    }

    public Double getPoint() {
        return Length.getLength(this.mLengthString, Unit.POINT);
    }

    public Double getPixel() {
        return Length.getLength(this.mLengthString, Unit.PIXEL);
    }

    public Double getPica() {
        return Length.getLength(this.mLengthString, Unit.PICA);
    }

    public Double getInch() {
        return Length.getLength(this.mLengthString, Unit.INCH);
    }

    public Double getCentimeter() {
        return Length.getLength(this.mLengthString, Unit.CENTIMETER);
    }

    public static Double getLength(String length, Unit destinationUnit) {
        double newValue = 0.0;
        if (length != null) {
            double roundingFactor = 10000.0;
            boolean identifiedInput = false;
            for (Unit unit : Unit.values()) {
                if (!length.contains(unit.abbr())) continue;
                Double value = Double.valueOf(length.substring(0, length.indexOf(unit.abbr())));
                if (destinationUnit != null) {
                    newValue = (double)Math.round(roundingFactor * value / destinationUnit.unitInMillimiter() * unit.mUnitInMillimiter) / roundingFactor;
                } else {
                    destinationUnit = unit;
                }
                identifiedInput = true;
                break;
            }
            if (!identifiedInput) {
                LOG.warning("The unit " + length + " could not be transformed to " + destinationUnit.toString() + "!");
            }
        } else {
            LOG.warning("The input length should not be null!");
        }
        return newValue;
    }

    public static String mapToUnit(String length, Unit destinationUnit) {
        Double newValue = Length.getLength(length, destinationUnit);
        return String.valueOf(newValue) + destinationUnit.abbr();
    }

    public static Length valueOf(String stringValue) throws NumberFormatException {
        return new Length(stringValue);
    }

    public String toString() {
        return this.mLengthString;
    }

    public static enum Unit {
        POINT(0.352777778, "pt"),
        PIXEL(0.28, "px"),
        MILLIMETER(1.0, "mm"),
        MICROMETER(0.001, "\u00b5m"),
        PICA(4.2176, "pc"),
        CENTIMETER(10.0, "cm"),
        INCH(25.4, "in");

        private final double mUnitInMillimiter;
        private final String mUnitAbbreviation;

        private Unit(double unitInMillimiter, String unitAbbreviation) {
            this.mUnitInMillimiter = unitInMillimiter;
            this.mUnitAbbreviation = unitAbbreviation;
        }

        public double unitInMillimiter() {
            return this.mUnitInMillimiter;
        }

        public String abbr() {
            return this.mUnitAbbreviation;
        }
    }
}

