/**
 * **********************************************************************
 *
 * <p>DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * <p>Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * <p>Use is subject to license terms.
 *
 * <p>Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0. You can also obtain a copy of the License at
 * http://odftoolkit.org/docs/license.txt
 *
 * <p>Unless required by applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied.
 *
 * <p>See the License for the specific language governing permissions and limitations under the
 * License.
 *
 * <p>**********************************************************************
 */

/*
 * This file is automatically generated.
 * Don't edit manually.
 */
package org.odftoolkit.odfdom.dom.element.presentation;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.presentation.PresentationActionAttribute;
import org.odftoolkit.odfdom.dom.attribute.presentation.PresentationDirectionAttribute;
import org.odftoolkit.odfdom.dom.attribute.presentation.PresentationEffectAttribute;
import org.odftoolkit.odfdom.dom.attribute.presentation.PresentationSpeedAttribute;
import org.odftoolkit.odfdom.dom.attribute.presentation.PresentationStartScaleAttribute;
import org.odftoolkit.odfdom.dom.attribute.presentation.PresentationVerbAttribute;
import org.odftoolkit.odfdom.dom.attribute.script.ScriptEventNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.xlink.XlinkActuateAttribute;
import org.odftoolkit.odfdom.dom.attribute.xlink.XlinkHrefAttribute;
import org.odftoolkit.odfdom.dom.attribute.xlink.XlinkShowAttribute;
import org.odftoolkit.odfdom.dom.attribute.xlink.XlinkTypeAttribute;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

/** DOM implementation of OpenDocument element {@odf.element presentation:event-listener}. */
public class PresentationEventListenerElement extends OdfElement {

  public static final OdfName ELEMENT_NAME =
      OdfName.newName(OdfDocumentNamespace.PRESENTATION, "event-listener");

  /**
   * Create the instance of <code>PresentationEventListenerElement</code>
   *
   * @param ownerDoc The type is <code>OdfFileDom</code>
   */
  public PresentationEventListenerElement(OdfFileDom ownerDoc) {
    super(ownerDoc, ELEMENT_NAME);
  }

  /**
   * Get the element name
   *
   * @return return <code>OdfName</code> the name of element {@odf.element
   *     presentation:event-listener}.
   */
  public OdfName getOdfName() {
    return ELEMENT_NAME;
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>PresentationActionAttribute
   * </code> , See {@odf.attribute presentation:action}
   *
   * <p>Attribute is mandatory.
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getPresentationActionAttribute() {
    PresentationActionAttribute attr =
        (PresentationActionAttribute) getOdfAttribute(OdfDocumentNamespace.PRESENTATION, "action");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>PresentationActionAttribute</code> ,
   * See {@odf.attribute presentation:action}
   *
   * @param presentationActionValue The type is <code>String</code>
   */
  public void setPresentationActionAttribute(String presentationActionValue) {
    PresentationActionAttribute attr =
        new PresentationActionAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(presentationActionValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>PresentationDirectionAttribute
   * </code> , See {@odf.attribute presentation:direction}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getPresentationDirectionAttribute() {
    PresentationDirectionAttribute attr =
        (PresentationDirectionAttribute)
            getOdfAttribute(OdfDocumentNamespace.PRESENTATION, "direction");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return PresentationDirectionAttribute.DEFAULT_VALUE;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>PresentationDirectionAttribute</code> ,
   * See {@odf.attribute presentation:direction}
   *
   * @param presentationDirectionValue The type is <code>String</code>
   */
  public void setPresentationDirectionAttribute(String presentationDirectionValue) {
    PresentationDirectionAttribute attr =
        new PresentationDirectionAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(presentationDirectionValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>PresentationEffectAttribute
   * </code> , See {@odf.attribute presentation:effect}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getPresentationEffectAttribute() {
    PresentationEffectAttribute attr =
        (PresentationEffectAttribute) getOdfAttribute(OdfDocumentNamespace.PRESENTATION, "effect");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return PresentationEffectAttribute.DEFAULT_VALUE;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>PresentationEffectAttribute</code> ,
   * See {@odf.attribute presentation:effect}
   *
   * @param presentationEffectValue The type is <code>String</code>
   */
  public void setPresentationEffectAttribute(String presentationEffectValue) {
    PresentationEffectAttribute attr =
        new PresentationEffectAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(presentationEffectValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>PresentationSpeedAttribute
   * </code> , See {@odf.attribute presentation:speed}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getPresentationSpeedAttribute() {
    PresentationSpeedAttribute attr =
        (PresentationSpeedAttribute) getOdfAttribute(OdfDocumentNamespace.PRESENTATION, "speed");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return PresentationSpeedAttribute.DEFAULT_VALUE;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>PresentationSpeedAttribute</code> , See
   * {@odf.attribute presentation:speed}
   *
   * @param presentationSpeedValue The type is <code>String</code>
   */
  public void setPresentationSpeedAttribute(String presentationSpeedValue) {
    PresentationSpeedAttribute attr =
        new PresentationSpeedAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(presentationSpeedValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>PresentationStartScaleAttribute
   * </code> , See {@odf.attribute presentation:start-scale}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getPresentationStartScaleAttribute() {
    PresentationStartScaleAttribute attr =
        (PresentationStartScaleAttribute)
            getOdfAttribute(OdfDocumentNamespace.PRESENTATION, "start-scale");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return PresentationStartScaleAttribute.DEFAULT_VALUE;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>PresentationStartScaleAttribute</code>
   * , See {@odf.attribute presentation:start-scale}
   *
   * @param presentationStartScaleValue The type is <code>String</code>
   */
  public void setPresentationStartScaleAttribute(String presentationStartScaleValue) {
    PresentationStartScaleAttribute attr =
        new PresentationStartScaleAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(presentationStartScaleValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>PresentationVerbAttribute
   * </code> , See {@odf.attribute presentation:verb}
   *
   * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Integer getPresentationVerbAttribute() {
    PresentationVerbAttribute attr =
        (PresentationVerbAttribute) getOdfAttribute(OdfDocumentNamespace.PRESENTATION, "verb");
    if (attr != null) {
      return Integer.valueOf(attr.intValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>PresentationVerbAttribute</code> , See
   * {@odf.attribute presentation:verb}
   *
   * @param presentationVerbValue The type is <code>Integer</code>
   */
  public void setPresentationVerbAttribute(Integer presentationVerbValue) {
    PresentationVerbAttribute attr = new PresentationVerbAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setIntValue(presentationVerbValue.intValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>ScriptEventNameAttribute</code>
   * , See {@odf.attribute script:event-name}
   *
   * <p>Attribute is mandatory.
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getScriptEventNameAttribute() {
    ScriptEventNameAttribute attr =
        (ScriptEventNameAttribute) getOdfAttribute(OdfDocumentNamespace.SCRIPT, "event-name");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>ScriptEventNameAttribute</code> , See
   * {@odf.attribute script:event-name}
   *
   * @param scriptEventNameValue The type is <code>String</code>
   */
  public void setScriptEventNameAttribute(String scriptEventNameValue) {
    ScriptEventNameAttribute attr = new ScriptEventNameAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(scriptEventNameValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>XlinkActuateAttribute</code> ,
   * See {@odf.attribute xlink:actuate}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getXlinkActuateAttribute() {
    XlinkActuateAttribute attr =
        (XlinkActuateAttribute) getOdfAttribute(OdfDocumentNamespace.XLINK, "actuate");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return XlinkActuateAttribute.DEFAULT_VALUE_ONREQUEST;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>XlinkActuateAttribute</code> , See
   * {@odf.attribute xlink:actuate}
   *
   * @param xlinkActuateValue The type is <code>String</code>
   */
  public void setXlinkActuateAttribute(String xlinkActuateValue) {
    XlinkActuateAttribute attr = new XlinkActuateAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(xlinkActuateValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>XlinkHrefAttribute</code> , See
   * {@odf.attribute xlink:href}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getXlinkHrefAttribute() {
    XlinkHrefAttribute attr =
        (XlinkHrefAttribute) getOdfAttribute(OdfDocumentNamespace.XLINK, "href");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>XlinkHrefAttribute</code> , See
   * {@odf.attribute xlink:href}
   *
   * @param xlinkHrefValue The type is <code>String</code>
   */
  public void setXlinkHrefAttribute(String xlinkHrefValue) {
    XlinkHrefAttribute attr = new XlinkHrefAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(xlinkHrefValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>XlinkShowAttribute</code> , See
   * {@odf.attribute xlink:show}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getXlinkShowAttribute() {
    XlinkShowAttribute attr =
        (XlinkShowAttribute) getOdfAttribute(OdfDocumentNamespace.XLINK, "show");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return XlinkShowAttribute.DEFAULT_VALUE_EMBED;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>XlinkShowAttribute</code> , See
   * {@odf.attribute xlink:show}
   *
   * @param xlinkShowValue The type is <code>String</code>
   */
  public void setXlinkShowAttribute(String xlinkShowValue) {
    XlinkShowAttribute attr = new XlinkShowAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(xlinkShowValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>XlinkTypeAttribute</code> , See
   * {@odf.attribute xlink:type}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getXlinkTypeAttribute() {
    XlinkTypeAttribute attr =
        (XlinkTypeAttribute) getOdfAttribute(OdfDocumentNamespace.XLINK, "type");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return XlinkTypeAttribute.DEFAULT_VALUE;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>XlinkTypeAttribute</code> , See
   * {@odf.attribute xlink:type}
   *
   * @param xlinkTypeValue The type is <code>String</code>
   */
  public void setXlinkTypeAttribute(String xlinkTypeValue) {
    XlinkTypeAttribute attr = new XlinkTypeAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(xlinkTypeValue);
  }

  /**
   * Create child element {@odf.element presentation:sound}.
   *
   * @param xlinkHrefValue the <code>String</code> value of <code>XlinkHrefAttribute</code>, see
   *     {@odf.attribute xlink:href} at specification
   * @param xlinkTypeValue the <code>String</code> value of <code>XlinkTypeAttribute</code>, see
   *     {@odf.attribute xlink:type} at specification
   * @return the element {@odf.element presentation:sound}
   */
  public PresentationSoundElement newPresentationSoundElement(
      String xlinkHrefValue, String xlinkTypeValue) {
    PresentationSoundElement presentationSound =
        ((OdfFileDom) this.ownerDocument).newOdfElement(PresentationSoundElement.class);
    presentationSound.setXlinkHrefAttribute(xlinkHrefValue);
    presentationSound.setXlinkTypeAttribute(xlinkTypeValue);
    this.appendChild(presentationSound);
    return presentationSound;
  }

  @Override
  public void accept(ElementVisitor visitor) {
    if (visitor instanceof DefaultElementVisitor) {
      DefaultElementVisitor defaultVisitor = (DefaultElementVisitor) visitor;
      defaultVisitor.visit(this);
    } else {
      visitor.visit(this);
    }
  }
}
