/**
 * **********************************************************************
 *
 * <p>DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * <p>Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * <p>Use is subject to license terms.
 *
 * <p>Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0. You can also obtain a copy of the License at
 * http://odftoolkit.org/docs/license.txt
 *
 * <p>Unless required by applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied.
 *
 * <p>See the License for the specific language governing permissions and limitations under the
 * License.
 *
 * <p>**********************************************************************
 */

/*
 * This file is automatically generated.
 * Don't edit manually.
 */
package org.odftoolkit.odfdom.dom.element.style;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBackgroundColorAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderBottomAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderLeftAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderRightAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderTopAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBreakAfterAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBreakBeforeAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoHyphenationKeepAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoHyphenationLadderCountAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoKeepTogetherAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoKeepWithNextAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoLineHeightAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoMarginAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoMarginBottomAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoMarginLeftAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoMarginRightAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoMarginTopAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoOrphansAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoPaddingAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoPaddingBottomAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoPaddingLeftAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoPaddingRightAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoPaddingTopAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoTextAlignAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoTextAlignLastAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoTextIndentAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoWidowsAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleAutoTextIndentAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBackgroundTransparencyAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthBottomAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthLeftAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthRightAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthTopAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontIndependentLineSpacingAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleJoinBorderAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleJustifySingleWordAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleLineBreakAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleLineHeightAtLeastAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleLineSpacingAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StylePageNumberAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StylePunctuationWrapAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleRegisterTrueAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleShadowAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleSnapToLayoutGridAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTabStopDistanceAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTextAutospaceAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleVerticalAlignAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleWritingModeAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleWritingModeAutomaticAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextLineNumberAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextNumberLinesAttribute;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;
import org.odftoolkit.odfdom.dom.style.props.OdfStyleProperty;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

/** DOM implementation of OpenDocument element {@odf.element style:paragraph-properties}. */
public class StyleParagraphPropertiesElement extends OdfStylePropertiesBase {

  public static final OdfName ELEMENT_NAME =
      OdfName.newName(OdfDocumentNamespace.STYLE, "paragraph-properties");

  /**
   * Create the instance of <code>StyleParagraphPropertiesElement</code>
   *
   * @param ownerDoc The type is <code>OdfFileDom</code>
   */
  public StyleParagraphPropertiesElement(OdfFileDom ownerDoc) {
    super(ownerDoc, ELEMENT_NAME);
  }

  /**
   * Get the element name
   *
   * @return return <code>OdfName</code> the name of element {@odf.element
   *     style:paragraph-properties}.
   */
  public OdfName getOdfName() {
    return ELEMENT_NAME;
  }

  public static final OdfStyleProperty BackgroundColor =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "background-color"));

  public static final OdfStyleProperty Border =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "border"));

  public static final OdfStyleProperty BorderBottom =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "border-bottom"));

  public static final OdfStyleProperty BorderLeft =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "border-left"));

  public static final OdfStyleProperty BorderRight =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "border-right"));

  public static final OdfStyleProperty BorderTop =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "border-top"));

  public static final OdfStyleProperty BreakAfter =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "break-after"));

  public static final OdfStyleProperty BreakBefore =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "break-before"));

  public static final OdfStyleProperty HyphenationKeep =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "hyphenation-keep"));

  public static final OdfStyleProperty HyphenationLadderCount =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "hyphenation-ladder-count"));

  public static final OdfStyleProperty KeepTogether =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "keep-together"));

  public static final OdfStyleProperty KeepWithNext =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "keep-with-next"));

  public static final OdfStyleProperty LineHeight =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "line-height"));

  public static final OdfStyleProperty Margin =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "margin"));

  public static final OdfStyleProperty MarginBottom =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "margin-bottom"));

  public static final OdfStyleProperty MarginLeft =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "margin-left"));

  public static final OdfStyleProperty MarginRight =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "margin-right"));

  public static final OdfStyleProperty MarginTop =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "margin-top"));

  public static final OdfStyleProperty Orphans =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "orphans"));

  public static final OdfStyleProperty Padding =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "padding"));

  public static final OdfStyleProperty PaddingBottom =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "padding-bottom"));

  public static final OdfStyleProperty PaddingLeft =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "padding-left"));

  public static final OdfStyleProperty PaddingRight =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "padding-right"));

  public static final OdfStyleProperty PaddingTop =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "padding-top"));

  public static final OdfStyleProperty TextAlign =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "text-align"));

  public static final OdfStyleProperty TextAlignLast =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "text-align-last"));

  public static final OdfStyleProperty TextIndent =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "text-indent"));

  public static final OdfStyleProperty Widows =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "widows"));

  public static final OdfStyleProperty AutoTextIndent =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "auto-text-indent"));

  public static final OdfStyleProperty BackgroundTransparency =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "background-transparency"));

  public static final OdfStyleProperty BorderLineWidth =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "border-line-width"));

  public static final OdfStyleProperty BorderLineWidthBottom =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "border-line-width-bottom"));

  public static final OdfStyleProperty BorderLineWidthLeft =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "border-line-width-left"));

  public static final OdfStyleProperty BorderLineWidthRight =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "border-line-width-right"));

  public static final OdfStyleProperty BorderLineWidthTop =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "border-line-width-top"));

  public static final OdfStyleProperty FontIndependentLineSpacing =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "font-independent-line-spacing"));

  public static final OdfStyleProperty JoinBorder =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "join-border"));

  public static final OdfStyleProperty JustifySingleWord =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "justify-single-word"));

  public static final OdfStyleProperty LineBreak =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "line-break"));

  public static final OdfStyleProperty LineHeightAtLeast =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "line-height-at-least"));

  public static final OdfStyleProperty LineSpacing =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "line-spacing"));

  public static final OdfStyleProperty PageNumber =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "page-number"));

  public static final OdfStyleProperty PunctuationWrap =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "punctuation-wrap"));

  public static final OdfStyleProperty RegisterTrue =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "register-true"));

  public static final OdfStyleProperty Shadow =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "shadow"));

  public static final OdfStyleProperty SnapToLayoutGrid =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "snap-to-layout-grid"));

  public static final OdfStyleProperty TabStopDistance =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "tab-stop-distance"));

  public static final OdfStyleProperty TextAutospace =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "text-autospace"));

  public static final OdfStyleProperty VerticalAlign =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "vertical-align"));

  public static final OdfStyleProperty WritingMode =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "writing-mode"));

  public static final OdfStyleProperty WritingModeAutomatic =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "writing-mode-automatic"));

  public static final OdfStyleProperty LineNumber =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.TEXT, "line-number"));

  public static final OdfStyleProperty NumberLines =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.ParagraphProperties,
          OdfName.newName(OdfDocumentNamespace.TEXT, "number-lines"));

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoBackgroundColorAttribute
   * </code> , See {@odf.attribute fo:background-color}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoBackgroundColorAttribute() {
    FoBackgroundColorAttribute attr =
        (FoBackgroundColorAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "background-color");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoBackgroundColorAttribute</code> , See
   * {@odf.attribute fo:background-color}
   *
   * @param foBackgroundColorValue The type is <code>String</code>
   */
  public void setFoBackgroundColorAttribute(String foBackgroundColorValue) {
    FoBackgroundColorAttribute attr =
        new FoBackgroundColorAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foBackgroundColorValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoBorderAttribute</code> , See
   * {@odf.attribute fo:border}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoBorderAttribute() {
    FoBorderAttribute attr = (FoBorderAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "border");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoBorderAttribute</code> , See
   * {@odf.attribute fo:border}
   *
   * @param foBorderValue The type is <code>String</code>
   */
  public void setFoBorderAttribute(String foBorderValue) {
    FoBorderAttribute attr = new FoBorderAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foBorderValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoBorderBottomAttribute</code>
   * , See {@odf.attribute fo:border-bottom}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoBorderBottomAttribute() {
    FoBorderBottomAttribute attr =
        (FoBorderBottomAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "border-bottom");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoBorderBottomAttribute</code> , See
   * {@odf.attribute fo:border-bottom}
   *
   * @param foBorderBottomValue The type is <code>String</code>
   */
  public void setFoBorderBottomAttribute(String foBorderBottomValue) {
    FoBorderBottomAttribute attr = new FoBorderBottomAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foBorderBottomValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoBorderLeftAttribute</code> ,
   * See {@odf.attribute fo:border-left}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoBorderLeftAttribute() {
    FoBorderLeftAttribute attr =
        (FoBorderLeftAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "border-left");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoBorderLeftAttribute</code> , See
   * {@odf.attribute fo:border-left}
   *
   * @param foBorderLeftValue The type is <code>String</code>
   */
  public void setFoBorderLeftAttribute(String foBorderLeftValue) {
    FoBorderLeftAttribute attr = new FoBorderLeftAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foBorderLeftValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoBorderRightAttribute</code> ,
   * See {@odf.attribute fo:border-right}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoBorderRightAttribute() {
    FoBorderRightAttribute attr =
        (FoBorderRightAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "border-right");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoBorderRightAttribute</code> , See
   * {@odf.attribute fo:border-right}
   *
   * @param foBorderRightValue The type is <code>String</code>
   */
  public void setFoBorderRightAttribute(String foBorderRightValue) {
    FoBorderRightAttribute attr = new FoBorderRightAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foBorderRightValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoBorderTopAttribute</code> ,
   * See {@odf.attribute fo:border-top}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoBorderTopAttribute() {
    FoBorderTopAttribute attr =
        (FoBorderTopAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "border-top");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoBorderTopAttribute</code> , See
   * {@odf.attribute fo:border-top}
   *
   * @param foBorderTopValue The type is <code>String</code>
   */
  public void setFoBorderTopAttribute(String foBorderTopValue) {
    FoBorderTopAttribute attr = new FoBorderTopAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foBorderTopValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoBreakAfterAttribute</code> ,
   * See {@odf.attribute fo:break-after}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoBreakAfterAttribute() {
    FoBreakAfterAttribute attr =
        (FoBreakAfterAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "break-after");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoBreakAfterAttribute</code> , See
   * {@odf.attribute fo:break-after}
   *
   * @param foBreakAfterValue The type is <code>String</code>
   */
  public void setFoBreakAfterAttribute(String foBreakAfterValue) {
    FoBreakAfterAttribute attr = new FoBreakAfterAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foBreakAfterValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoBreakBeforeAttribute</code> ,
   * See {@odf.attribute fo:break-before}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoBreakBeforeAttribute() {
    FoBreakBeforeAttribute attr =
        (FoBreakBeforeAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "break-before");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoBreakBeforeAttribute</code> , See
   * {@odf.attribute fo:break-before}
   *
   * @param foBreakBeforeValue The type is <code>String</code>
   */
  public void setFoBreakBeforeAttribute(String foBreakBeforeValue) {
    FoBreakBeforeAttribute attr = new FoBreakBeforeAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foBreakBeforeValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoHyphenationKeepAttribute
   * </code> , See {@odf.attribute fo:hyphenation-keep}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoHyphenationKeepAttribute() {
    FoHyphenationKeepAttribute attr =
        (FoHyphenationKeepAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "hyphenation-keep");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoHyphenationKeepAttribute</code> , See
   * {@odf.attribute fo:hyphenation-keep}
   *
   * @param foHyphenationKeepValue The type is <code>String</code>
   */
  public void setFoHyphenationKeepAttribute(String foHyphenationKeepValue) {
    FoHyphenationKeepAttribute attr =
        new FoHyphenationKeepAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foHyphenationKeepValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * FoHyphenationLadderCountAttribute</code> , See {@odf.attribute fo:hyphenation-ladder-count}
   *
   * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Integer getFoHyphenationLadderCountAttribute() {
    FoHyphenationLadderCountAttribute attr =
        (FoHyphenationLadderCountAttribute)
            getOdfAttribute(OdfDocumentNamespace.FO, "hyphenation-ladder-count");
    if (attr != null) {
      return Integer.valueOf(attr.intValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoHyphenationLadderCountAttribute
   * </code> , See {@odf.attribute fo:hyphenation-ladder-count}
   *
   * @param foHyphenationLadderCountValue The type is <code>Integer</code>
   */
  public void setFoHyphenationLadderCountAttribute(Integer foHyphenationLadderCountValue) {
    FoHyphenationLadderCountAttribute attr =
        new FoHyphenationLadderCountAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setIntValue(foHyphenationLadderCountValue.intValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoKeepTogetherAttribute</code>
   * , See {@odf.attribute fo:keep-together}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoKeepTogetherAttribute() {
    FoKeepTogetherAttribute attr =
        (FoKeepTogetherAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "keep-together");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoKeepTogetherAttribute</code> , See
   * {@odf.attribute fo:keep-together}
   *
   * @param foKeepTogetherValue The type is <code>String</code>
   */
  public void setFoKeepTogetherAttribute(String foKeepTogetherValue) {
    FoKeepTogetherAttribute attr = new FoKeepTogetherAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foKeepTogetherValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoKeepWithNextAttribute</code>
   * , See {@odf.attribute fo:keep-with-next}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoKeepWithNextAttribute() {
    FoKeepWithNextAttribute attr =
        (FoKeepWithNextAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "keep-with-next");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoKeepWithNextAttribute</code> , See
   * {@odf.attribute fo:keep-with-next}
   *
   * @param foKeepWithNextValue The type is <code>String</code>
   */
  public void setFoKeepWithNextAttribute(String foKeepWithNextValue) {
    FoKeepWithNextAttribute attr = new FoKeepWithNextAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foKeepWithNextValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoLineHeightAttribute</code> ,
   * See {@odf.attribute fo:line-height}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoLineHeightAttribute() {
    FoLineHeightAttribute attr =
        (FoLineHeightAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "line-height");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoLineHeightAttribute</code> , See
   * {@odf.attribute fo:line-height}
   *
   * @param foLineHeightValue The type is <code>String</code>
   */
  public void setFoLineHeightAttribute(String foLineHeightValue) {
    FoLineHeightAttribute attr = new FoLineHeightAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foLineHeightValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoMarginAttribute</code> , See
   * {@odf.attribute fo:margin}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoMarginAttribute() {
    FoMarginAttribute attr = (FoMarginAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "margin");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoMarginAttribute</code> , See
   * {@odf.attribute fo:margin}
   *
   * @param foMarginValue The type is <code>String</code>
   */
  public void setFoMarginAttribute(String foMarginValue) {
    FoMarginAttribute attr = new FoMarginAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foMarginValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoMarginBottomAttribute</code>
   * , See {@odf.attribute fo:margin-bottom}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoMarginBottomAttribute() {
    FoMarginBottomAttribute attr =
        (FoMarginBottomAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "margin-bottom");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoMarginBottomAttribute</code> , See
   * {@odf.attribute fo:margin-bottom}
   *
   * @param foMarginBottomValue The type is <code>String</code>
   */
  public void setFoMarginBottomAttribute(String foMarginBottomValue) {
    FoMarginBottomAttribute attr = new FoMarginBottomAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foMarginBottomValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoMarginLeftAttribute</code> ,
   * See {@odf.attribute fo:margin-left}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoMarginLeftAttribute() {
    FoMarginLeftAttribute attr =
        (FoMarginLeftAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "margin-left");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoMarginLeftAttribute</code> , See
   * {@odf.attribute fo:margin-left}
   *
   * @param foMarginLeftValue The type is <code>String</code>
   */
  public void setFoMarginLeftAttribute(String foMarginLeftValue) {
    FoMarginLeftAttribute attr = new FoMarginLeftAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foMarginLeftValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoMarginRightAttribute</code> ,
   * See {@odf.attribute fo:margin-right}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoMarginRightAttribute() {
    FoMarginRightAttribute attr =
        (FoMarginRightAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "margin-right");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoMarginRightAttribute</code> , See
   * {@odf.attribute fo:margin-right}
   *
   * @param foMarginRightValue The type is <code>String</code>
   */
  public void setFoMarginRightAttribute(String foMarginRightValue) {
    FoMarginRightAttribute attr = new FoMarginRightAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foMarginRightValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoMarginTopAttribute</code> ,
   * See {@odf.attribute fo:margin-top}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoMarginTopAttribute() {
    FoMarginTopAttribute attr =
        (FoMarginTopAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "margin-top");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoMarginTopAttribute</code> , See
   * {@odf.attribute fo:margin-top}
   *
   * @param foMarginTopValue The type is <code>String</code>
   */
  public void setFoMarginTopAttribute(String foMarginTopValue) {
    FoMarginTopAttribute attr = new FoMarginTopAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foMarginTopValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoOrphansAttribute</code> , See
   * {@odf.attribute fo:orphans}
   *
   * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Integer getFoOrphansAttribute() {
    FoOrphansAttribute attr =
        (FoOrphansAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "orphans");
    if (attr != null) {
      return Integer.valueOf(attr.intValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoOrphansAttribute</code> , See
   * {@odf.attribute fo:orphans}
   *
   * @param foOrphansValue The type is <code>Integer</code>
   */
  public void setFoOrphansAttribute(Integer foOrphansValue) {
    FoOrphansAttribute attr = new FoOrphansAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setIntValue(foOrphansValue.intValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoPaddingAttribute</code> , See
   * {@odf.attribute fo:padding}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoPaddingAttribute() {
    FoPaddingAttribute attr =
        (FoPaddingAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "padding");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoPaddingAttribute</code> , See
   * {@odf.attribute fo:padding}
   *
   * @param foPaddingValue The type is <code>String</code>
   */
  public void setFoPaddingAttribute(String foPaddingValue) {
    FoPaddingAttribute attr = new FoPaddingAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foPaddingValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoPaddingBottomAttribute</code>
   * , See {@odf.attribute fo:padding-bottom}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoPaddingBottomAttribute() {
    FoPaddingBottomAttribute attr =
        (FoPaddingBottomAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "padding-bottom");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoPaddingBottomAttribute</code> , See
   * {@odf.attribute fo:padding-bottom}
   *
   * @param foPaddingBottomValue The type is <code>String</code>
   */
  public void setFoPaddingBottomAttribute(String foPaddingBottomValue) {
    FoPaddingBottomAttribute attr = new FoPaddingBottomAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foPaddingBottomValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoPaddingLeftAttribute</code> ,
   * See {@odf.attribute fo:padding-left}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoPaddingLeftAttribute() {
    FoPaddingLeftAttribute attr =
        (FoPaddingLeftAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "padding-left");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoPaddingLeftAttribute</code> , See
   * {@odf.attribute fo:padding-left}
   *
   * @param foPaddingLeftValue The type is <code>String</code>
   */
  public void setFoPaddingLeftAttribute(String foPaddingLeftValue) {
    FoPaddingLeftAttribute attr = new FoPaddingLeftAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foPaddingLeftValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoPaddingRightAttribute</code>
   * , See {@odf.attribute fo:padding-right}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoPaddingRightAttribute() {
    FoPaddingRightAttribute attr =
        (FoPaddingRightAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "padding-right");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoPaddingRightAttribute</code> , See
   * {@odf.attribute fo:padding-right}
   *
   * @param foPaddingRightValue The type is <code>String</code>
   */
  public void setFoPaddingRightAttribute(String foPaddingRightValue) {
    FoPaddingRightAttribute attr = new FoPaddingRightAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foPaddingRightValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoPaddingTopAttribute</code> ,
   * See {@odf.attribute fo:padding-top}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoPaddingTopAttribute() {
    FoPaddingTopAttribute attr =
        (FoPaddingTopAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "padding-top");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoPaddingTopAttribute</code> , See
   * {@odf.attribute fo:padding-top}
   *
   * @param foPaddingTopValue The type is <code>String</code>
   */
  public void setFoPaddingTopAttribute(String foPaddingTopValue) {
    FoPaddingTopAttribute attr = new FoPaddingTopAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foPaddingTopValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoTextAlignAttribute</code> ,
   * See {@odf.attribute fo:text-align}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoTextAlignAttribute() {
    FoTextAlignAttribute attr =
        (FoTextAlignAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "text-align");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoTextAlignAttribute</code> , See
   * {@odf.attribute fo:text-align}
   *
   * @param foTextAlignValue The type is <code>String</code>
   */
  public void setFoTextAlignAttribute(String foTextAlignValue) {
    FoTextAlignAttribute attr = new FoTextAlignAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foTextAlignValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoTextAlignLastAttribute</code>
   * , See {@odf.attribute fo:text-align-last}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoTextAlignLastAttribute() {
    FoTextAlignLastAttribute attr =
        (FoTextAlignLastAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "text-align-last");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoTextAlignLastAttribute</code> , See
   * {@odf.attribute fo:text-align-last}
   *
   * @param foTextAlignLastValue The type is <code>String</code>
   */
  public void setFoTextAlignLastAttribute(String foTextAlignLastValue) {
    FoTextAlignLastAttribute attr = new FoTextAlignLastAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foTextAlignLastValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoTextIndentAttribute</code> ,
   * See {@odf.attribute fo:text-indent}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoTextIndentAttribute() {
    FoTextIndentAttribute attr =
        (FoTextIndentAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "text-indent");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoTextIndentAttribute</code> , See
   * {@odf.attribute fo:text-indent}
   *
   * @param foTextIndentValue The type is <code>String</code>
   */
  public void setFoTextIndentAttribute(String foTextIndentValue) {
    FoTextIndentAttribute attr = new FoTextIndentAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foTextIndentValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoWidowsAttribute</code> , See
   * {@odf.attribute fo:widows}
   *
   * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Integer getFoWidowsAttribute() {
    FoWidowsAttribute attr = (FoWidowsAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "widows");
    if (attr != null) {
      return Integer.valueOf(attr.intValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoWidowsAttribute</code> , See
   * {@odf.attribute fo:widows}
   *
   * @param foWidowsValue The type is <code>Integer</code>
   */
  public void setFoWidowsAttribute(Integer foWidowsValue) {
    FoWidowsAttribute attr = new FoWidowsAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setIntValue(foWidowsValue.intValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleAutoTextIndentAttribute
   * </code> , See {@odf.attribute style:auto-text-indent}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getStyleAutoTextIndentAttribute() {
    StyleAutoTextIndentAttribute attr =
        (StyleAutoTextIndentAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "auto-text-indent");
    if (attr != null) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleAutoTextIndentAttribute</code> ,
   * See {@odf.attribute style:auto-text-indent}
   *
   * @param styleAutoTextIndentValue The type is <code>Boolean</code>
   */
  public void setStyleAutoTextIndentAttribute(Boolean styleAutoTextIndentValue) {
    StyleAutoTextIndentAttribute attr =
        new StyleAutoTextIndentAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(styleAutoTextIndentValue.booleanValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * StyleBackgroundTransparencyAttribute</code> , See {@odf.attribute
   * style:background-transparency}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleBackgroundTransparencyAttribute() {
    StyleBackgroundTransparencyAttribute attr =
        (StyleBackgroundTransparencyAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "background-transparency");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleBackgroundTransparencyAttribute
   * </code> , See {@odf.attribute style:background-transparency}
   *
   * @param styleBackgroundTransparencyValue The type is <code>String</code>
   */
  public void setStyleBackgroundTransparencyAttribute(String styleBackgroundTransparencyValue) {
    StyleBackgroundTransparencyAttribute attr =
        new StyleBackgroundTransparencyAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleBackgroundTransparencyValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleBorderLineWidthAttribute
   * </code> , See {@odf.attribute style:border-line-width}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleBorderLineWidthAttribute() {
    StyleBorderLineWidthAttribute attr =
        (StyleBorderLineWidthAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "border-line-width");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleBorderLineWidthAttribute</code> ,
   * See {@odf.attribute style:border-line-width}
   *
   * @param styleBorderLineWidthValue The type is <code>String</code>
   */
  public void setStyleBorderLineWidthAttribute(String styleBorderLineWidthValue) {
    StyleBorderLineWidthAttribute attr =
        new StyleBorderLineWidthAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleBorderLineWidthValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * StyleBorderLineWidthBottomAttribute</code> , See {@odf.attribute
   * style:border-line-width-bottom}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleBorderLineWidthBottomAttribute() {
    StyleBorderLineWidthBottomAttribute attr =
        (StyleBorderLineWidthBottomAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "border-line-width-bottom");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleBorderLineWidthBottomAttribute
   * </code> , See {@odf.attribute style:border-line-width-bottom}
   *
   * @param styleBorderLineWidthBottomValue The type is <code>String</code>
   */
  public void setStyleBorderLineWidthBottomAttribute(String styleBorderLineWidthBottomValue) {
    StyleBorderLineWidthBottomAttribute attr =
        new StyleBorderLineWidthBottomAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleBorderLineWidthBottomValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * StyleBorderLineWidthLeftAttribute</code> , See {@odf.attribute style:border-line-width-left}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleBorderLineWidthLeftAttribute() {
    StyleBorderLineWidthLeftAttribute attr =
        (StyleBorderLineWidthLeftAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "border-line-width-left");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleBorderLineWidthLeftAttribute
   * </code> , See {@odf.attribute style:border-line-width-left}
   *
   * @param styleBorderLineWidthLeftValue The type is <code>String</code>
   */
  public void setStyleBorderLineWidthLeftAttribute(String styleBorderLineWidthLeftValue) {
    StyleBorderLineWidthLeftAttribute attr =
        new StyleBorderLineWidthLeftAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleBorderLineWidthLeftValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * StyleBorderLineWidthRightAttribute</code> , See {@odf.attribute style:border-line-width-right}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleBorderLineWidthRightAttribute() {
    StyleBorderLineWidthRightAttribute attr =
        (StyleBorderLineWidthRightAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "border-line-width-right");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleBorderLineWidthRightAttribute
   * </code> , See {@odf.attribute style:border-line-width-right}
   *
   * @param styleBorderLineWidthRightValue The type is <code>String</code>
   */
  public void setStyleBorderLineWidthRightAttribute(String styleBorderLineWidthRightValue) {
    StyleBorderLineWidthRightAttribute attr =
        new StyleBorderLineWidthRightAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleBorderLineWidthRightValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * StyleBorderLineWidthTopAttribute</code> , See {@odf.attribute style:border-line-width-top}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleBorderLineWidthTopAttribute() {
    StyleBorderLineWidthTopAttribute attr =
        (StyleBorderLineWidthTopAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "border-line-width-top");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleBorderLineWidthTopAttribute</code>
   * , See {@odf.attribute style:border-line-width-top}
   *
   * @param styleBorderLineWidthTopValue The type is <code>String</code>
   */
  public void setStyleBorderLineWidthTopAttribute(String styleBorderLineWidthTopValue) {
    StyleBorderLineWidthTopAttribute attr =
        new StyleBorderLineWidthTopAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleBorderLineWidthTopValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * StyleFontIndependentLineSpacingAttribute</code> , See {@odf.attribute
   * style:font-independent-line-spacing}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getStyleFontIndependentLineSpacingAttribute() {
    StyleFontIndependentLineSpacingAttribute attr =
        (StyleFontIndependentLineSpacingAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "font-independent-line-spacing");
    if (attr != null) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>
   * StyleFontIndependentLineSpacingAttribute</code> , See {@odf.attribute
   * style:font-independent-line-spacing}
   *
   * @param styleFontIndependentLineSpacingValue The type is <code>Boolean</code>
   */
  public void setStyleFontIndependentLineSpacingAttribute(
      Boolean styleFontIndependentLineSpacingValue) {
    StyleFontIndependentLineSpacingAttribute attr =
        new StyleFontIndependentLineSpacingAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(styleFontIndependentLineSpacingValue.booleanValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleJoinBorderAttribute</code>
   * , See {@odf.attribute style:join-border}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getStyleJoinBorderAttribute() {
    StyleJoinBorderAttribute attr =
        (StyleJoinBorderAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "join-border");
    if (attr != null) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleJoinBorderAttribute</code> , See
   * {@odf.attribute style:join-border}
   *
   * @param styleJoinBorderValue The type is <code>Boolean</code>
   */
  public void setStyleJoinBorderAttribute(Boolean styleJoinBorderValue) {
    StyleJoinBorderAttribute attr = new StyleJoinBorderAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(styleJoinBorderValue.booleanValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleJustifySingleWordAttribute
   * </code> , See {@odf.attribute style:justify-single-word}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getStyleJustifySingleWordAttribute() {
    StyleJustifySingleWordAttribute attr =
        (StyleJustifySingleWordAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "justify-single-word");
    if (attr != null) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleJustifySingleWordAttribute</code>
   * , See {@odf.attribute style:justify-single-word}
   *
   * @param styleJustifySingleWordValue The type is <code>Boolean</code>
   */
  public void setStyleJustifySingleWordAttribute(Boolean styleJustifySingleWordValue) {
    StyleJustifySingleWordAttribute attr =
        new StyleJustifySingleWordAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(styleJustifySingleWordValue.booleanValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleLineBreakAttribute</code>
   * , See {@odf.attribute style:line-break}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleLineBreakAttribute() {
    StyleLineBreakAttribute attr =
        (StyleLineBreakAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "line-break");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleLineBreakAttribute</code> , See
   * {@odf.attribute style:line-break}
   *
   * @param styleLineBreakValue The type is <code>String</code>
   */
  public void setStyleLineBreakAttribute(String styleLineBreakValue) {
    StyleLineBreakAttribute attr = new StyleLineBreakAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleLineBreakValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleLineHeightAtLeastAttribute
   * </code> , See {@odf.attribute style:line-height-at-least}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleLineHeightAtLeastAttribute() {
    StyleLineHeightAtLeastAttribute attr =
        (StyleLineHeightAtLeastAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "line-height-at-least");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleLineHeightAtLeastAttribute</code>
   * , See {@odf.attribute style:line-height-at-least}
   *
   * @param styleLineHeightAtLeastValue The type is <code>String</code>
   */
  public void setStyleLineHeightAtLeastAttribute(String styleLineHeightAtLeastValue) {
    StyleLineHeightAtLeastAttribute attr =
        new StyleLineHeightAtLeastAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleLineHeightAtLeastValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleLineSpacingAttribute
   * </code> , See {@odf.attribute style:line-spacing}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleLineSpacingAttribute() {
    StyleLineSpacingAttribute attr =
        (StyleLineSpacingAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "line-spacing");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleLineSpacingAttribute</code> , See
   * {@odf.attribute style:line-spacing}
   *
   * @param styleLineSpacingValue The type is <code>String</code>
   */
  public void setStyleLineSpacingAttribute(String styleLineSpacingValue) {
    StyleLineSpacingAttribute attr = new StyleLineSpacingAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleLineSpacingValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StylePageNumberAttribute</code>
   * , See {@odf.attribute style:page-number}
   *
   * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Integer getStylePageNumberAttribute() {
    StylePageNumberAttribute attr =
        (StylePageNumberAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "page-number");
    if (attr != null) {
      return Integer.valueOf(attr.intValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StylePageNumberAttribute</code> , See
   * {@odf.attribute style:page-number}
   *
   * @param stylePageNumberValue The type is <code>Integer</code>
   */
  public void setStylePageNumberAttribute(Integer stylePageNumberValue) {
    StylePageNumberAttribute attr = new StylePageNumberAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setIntValue(stylePageNumberValue.intValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StylePunctuationWrapAttribute
   * </code> , See {@odf.attribute style:punctuation-wrap}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStylePunctuationWrapAttribute() {
    StylePunctuationWrapAttribute attr =
        (StylePunctuationWrapAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "punctuation-wrap");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StylePunctuationWrapAttribute</code> ,
   * See {@odf.attribute style:punctuation-wrap}
   *
   * @param stylePunctuationWrapValue The type is <code>String</code>
   */
  public void setStylePunctuationWrapAttribute(String stylePunctuationWrapValue) {
    StylePunctuationWrapAttribute attr =
        new StylePunctuationWrapAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(stylePunctuationWrapValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleRegisterTrueAttribute
   * </code> , See {@odf.attribute style:register-true}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getStyleRegisterTrueAttribute() {
    StyleRegisterTrueAttribute attr =
        (StyleRegisterTrueAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "register-true");
    if (attr != null) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleRegisterTrueAttribute</code> , See
   * {@odf.attribute style:register-true}
   *
   * @param styleRegisterTrueValue The type is <code>Boolean</code>
   */
  public void setStyleRegisterTrueAttribute(Boolean styleRegisterTrueValue) {
    StyleRegisterTrueAttribute attr =
        new StyleRegisterTrueAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(styleRegisterTrueValue.booleanValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleShadowAttribute</code> ,
   * See {@odf.attribute style:shadow}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleShadowAttribute() {
    StyleShadowAttribute attr =
        (StyleShadowAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "shadow");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleShadowAttribute</code> , See
   * {@odf.attribute style:shadow}
   *
   * @param styleShadowValue The type is <code>String</code>
   */
  public void setStyleShadowAttribute(String styleShadowValue) {
    StyleShadowAttribute attr = new StyleShadowAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleShadowValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleSnapToLayoutGridAttribute
   * </code> , See {@odf.attribute style:snap-to-layout-grid}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getStyleSnapToLayoutGridAttribute() {
    StyleSnapToLayoutGridAttribute attr =
        (StyleSnapToLayoutGridAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "snap-to-layout-grid");
    if (attr != null) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleSnapToLayoutGridAttribute</code> ,
   * See {@odf.attribute style:snap-to-layout-grid}
   *
   * @param styleSnapToLayoutGridValue The type is <code>Boolean</code>
   */
  public void setStyleSnapToLayoutGridAttribute(Boolean styleSnapToLayoutGridValue) {
    StyleSnapToLayoutGridAttribute attr =
        new StyleSnapToLayoutGridAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(styleSnapToLayoutGridValue.booleanValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleTabStopDistanceAttribute
   * </code> , See {@odf.attribute style:tab-stop-distance}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleTabStopDistanceAttribute() {
    StyleTabStopDistanceAttribute attr =
        (StyleTabStopDistanceAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "tab-stop-distance");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleTabStopDistanceAttribute</code> ,
   * See {@odf.attribute style:tab-stop-distance}
   *
   * @param styleTabStopDistanceValue The type is <code>String</code>
   */
  public void setStyleTabStopDistanceAttribute(String styleTabStopDistanceValue) {
    StyleTabStopDistanceAttribute attr =
        new StyleTabStopDistanceAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleTabStopDistanceValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleTextAutospaceAttribute
   * </code> , See {@odf.attribute style:text-autospace}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleTextAutospaceAttribute() {
    StyleTextAutospaceAttribute attr =
        (StyleTextAutospaceAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "text-autospace");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleTextAutospaceAttribute</code> ,
   * See {@odf.attribute style:text-autospace}
   *
   * @param styleTextAutospaceValue The type is <code>String</code>
   */
  public void setStyleTextAutospaceAttribute(String styleTextAutospaceValue) {
    StyleTextAutospaceAttribute attr =
        new StyleTextAutospaceAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleTextAutospaceValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleVerticalAlignAttribute
   * </code> , See {@odf.attribute style:vertical-align}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleVerticalAlignAttribute() {
    StyleVerticalAlignAttribute attr =
        (StyleVerticalAlignAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "vertical-align");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleVerticalAlignAttribute</code> ,
   * See {@odf.attribute style:vertical-align}
   *
   * @param styleVerticalAlignValue The type is <code>String</code>
   */
  public void setStyleVerticalAlignAttribute(String styleVerticalAlignValue) {
    StyleVerticalAlignAttribute attr =
        new StyleVerticalAlignAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleVerticalAlignValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleWritingModeAttribute
   * </code> , See {@odf.attribute style:writing-mode}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleWritingModeAttribute() {
    StyleWritingModeAttribute attr =
        (StyleWritingModeAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "writing-mode");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleWritingModeAttribute</code> , See
   * {@odf.attribute style:writing-mode}
   *
   * @param styleWritingModeValue The type is <code>String</code>
   */
  public void setStyleWritingModeAttribute(String styleWritingModeValue) {
    StyleWritingModeAttribute attr = new StyleWritingModeAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleWritingModeValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * StyleWritingModeAutomaticAttribute</code> , See {@odf.attribute style:writing-mode-automatic}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getStyleWritingModeAutomaticAttribute() {
    StyleWritingModeAutomaticAttribute attr =
        (StyleWritingModeAutomaticAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "writing-mode-automatic");
    if (attr != null) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleWritingModeAutomaticAttribute
   * </code> , See {@odf.attribute style:writing-mode-automatic}
   *
   * @param styleWritingModeAutomaticValue The type is <code>Boolean</code>
   */
  public void setStyleWritingModeAutomaticAttribute(Boolean styleWritingModeAutomaticValue) {
    StyleWritingModeAutomaticAttribute attr =
        new StyleWritingModeAutomaticAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(styleWritingModeAutomaticValue.booleanValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>TextLineNumberAttribute</code>
   * , See {@odf.attribute text:line-number}
   *
   * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Integer getTextLineNumberAttribute() {
    TextLineNumberAttribute attr =
        (TextLineNumberAttribute) getOdfAttribute(OdfDocumentNamespace.TEXT, "line-number");
    if (attr != null) {
      return Integer.valueOf(attr.intValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>TextLineNumberAttribute</code> , See
   * {@odf.attribute text:line-number}
   *
   * @param textLineNumberValue The type is <code>Integer</code>
   */
  public void setTextLineNumberAttribute(Integer textLineNumberValue) {
    TextLineNumberAttribute attr = new TextLineNumberAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setIntValue(textLineNumberValue.intValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>TextNumberLinesAttribute</code>
   * , See {@odf.attribute text:number-lines}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getTextNumberLinesAttribute() {
    TextNumberLinesAttribute attr =
        (TextNumberLinesAttribute) getOdfAttribute(OdfDocumentNamespace.TEXT, "number-lines");
    if (attr != null) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>TextNumberLinesAttribute</code> , See
   * {@odf.attribute text:number-lines}
   *
   * @param textNumberLinesValue The type is <code>Boolean</code>
   */
  public void setTextNumberLinesAttribute(Boolean textNumberLinesValue) {
    TextNumberLinesAttribute attr = new TextNumberLinesAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(textNumberLinesValue.booleanValue());
  }

  /**
   * Create child element {@odf.element style:background-image}.
   *
   * <p>Child element is new in Odf 1.2
   *
   * @return the element {@odf.element style:background-image}
   */
  public StyleBackgroundImageElement newStyleBackgroundImageElement() {
    StyleBackgroundImageElement styleBackgroundImage =
        ((OdfFileDom) this.ownerDocument).newOdfElement(StyleBackgroundImageElement.class);
    this.appendChild(styleBackgroundImage);
    return styleBackgroundImage;
  }

  /**
   * Create child element {@odf.element style:drop-cap}.
   *
   * <p>Child element is new in Odf 1.2
   *
   * @return the element {@odf.element style:drop-cap}
   */
  public StyleDropCapElement newStyleDropCapElement() {
    StyleDropCapElement styleDropCap =
        ((OdfFileDom) this.ownerDocument).newOdfElement(StyleDropCapElement.class);
    this.appendChild(styleDropCap);
    return styleDropCap;
  }

  /**
   * Create child element {@odf.element style:tab-stops}.
   *
   * <p>Child element is new in Odf 1.2
   *
   * @return the element {@odf.element style:tab-stops}
   */
  public StyleTabStopsElement newStyleTabStopsElement() {
    StyleTabStopsElement styleTabStops =
        ((OdfFileDom) this.ownerDocument).newOdfElement(StyleTabStopsElement.class);
    this.appendChild(styleTabStops);
    return styleTabStops;
  }

  @Override
  public void accept(ElementVisitor visitor) {
    if (visitor instanceof DefaultElementVisitor) {
      DefaultElementVisitor defaultVisitor = (DefaultElementVisitor) visitor;
      defaultVisitor.visit(this);
    } else {
      visitor.visit(this);
    }
  }
}
