/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.config;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalSettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalSettings.class);
    private static ThreadLocal<Properties> properties = new InheritableThreadLocal<Properties>(){

        @Override
        protected Properties initialValue() {
            Properties copy = new Properties();
            copy.putAll((Map<?, ?>)System.getProperties());
            return copy;
        }
    };

    public static String getProperty(String key, String defaultValue) {
        return properties.get().getProperty(key, defaultValue);
    }

    public static String getProperty(String key) {
        return properties.get().getProperty(key);
    }

    public static void setProperty(String key, String value) {
        properties.get().setProperty(key, value);
    }

    public static void clearProperty(String key) {
        properties.get().remove(key);
    }

    public static void reset() {
        properties.remove();
    }

    public static void log() {
        StringWriter stringWriter = new StringWriter();
        properties.get().list(new PrintWriter(stringWriter));
        LOGGER.debug("GlobalSettings: {}", (Object)stringWriter);
    }
}

