/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.acacia.shared;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opencms.acacia.shared.CmsEntity;

public class CmsEntityAttribute
implements Serializable {
    private static final long serialVersionUID = 8283921354261037725L;
    private List<CmsEntity> m_entityValues;
    private String m_name;
    private List<String> m_simpleValues;

    protected CmsEntityAttribute() {
    }

    public static CmsEntityAttribute createEntityAttribute(String name, List<CmsEntity> values) {
        CmsEntityAttribute result = new CmsEntityAttribute();
        result.m_name = name;
        result.m_entityValues = Collections.unmodifiableList(values);
        return result;
    }

    public static CmsEntityAttribute createSimpleAttribute(String name, List<String> values) {
        CmsEntityAttribute result = new CmsEntityAttribute();
        result.m_name = name;
        result.m_simpleValues = Collections.unmodifiableList(values);
        return result;
    }

    public String getAttributeName() {
        return this.m_name;
    }

    public CmsEntity getComplexValue() {
        return this.m_entityValues.get(0);
    }

    public List<CmsEntity> getComplexValues() {
        ArrayList<CmsEntity> result = new ArrayList<CmsEntity>();
        result.addAll(this.m_entityValues);
        return Collections.unmodifiableList(result);
    }

    public String getSimpleValue() {
        return this.m_simpleValues.get(0);
    }

    public List<String> getSimpleValues() {
        return Collections.unmodifiableList(this.m_simpleValues);
    }

    public int getValueCount() {
        if (this.isComplexValue()) {
            return this.m_entityValues.size();
        }
        return this.m_simpleValues.size();
    }

    public boolean isComplexValue() {
        return this.m_entityValues != null;
    }

    public boolean isSimpleValue() {
        return this.m_simpleValues != null;
    }

    public boolean isSingleValue() {
        if (this.isComplexValue()) {
            return this.m_entityValues.size() == 1;
        }
        return this.m_simpleValues.size() == 1;
    }
}

