/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.acacia.shared;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CmsType
implements Serializable {
    public static final String CHOICE_ATTRIBUTE_NAME = "ATTRIBUTE_CHOICE";
    private static final long serialVersionUID = -7965094404314721990L;
    private int m_choiceMaxOccurrence;
    private String m_id;
    private Map<String, Integer> m_maxs;
    private Map<String, Integer> m_mins;
    private List<String> m_names = new ArrayList<String>();
    private Map<String, CmsType> m_types = new HashMap<String, CmsType>();

    public CmsType(String id) {
        this();
        this.m_id = id;
    }

    protected CmsType() {
        this.m_maxs = new HashMap<String, Integer>();
        this.m_mins = new HashMap<String, Integer>();
    }

    public void addAttribute(String attributeName, CmsType attributeType, int minOccurrence, int maxOccurrence) {
        this.m_names.add(attributeName);
        this.m_types.put(attributeName, attributeType);
        this.m_mins.put(attributeName, new Integer(minOccurrence));
        this.m_maxs.put(attributeName, new Integer(maxOccurrence));
    }

    public int getAttributeMaxOccurrence(String attributeName) {
        return this.m_maxs.get(attributeName);
    }

    public int getAttributeMinOccurrence(String attributeName) {
        return this.m_mins.get(attributeName);
    }

    public List<String> getAttributeNames() {
        return Collections.unmodifiableList(this.m_names);
    }

    public CmsType getAttributeType(String attributeName) {
        return this.m_types.get(attributeName);
    }

    public String getAttributeTypeName(String attributeName) {
        CmsType attrType = this.m_types.get(attributeName);
        return attrType == null ? null : attrType.getId();
    }

    public int getChoiceMaxOccurrence() {
        return this.m_choiceMaxOccurrence;
    }

    public String getId() {
        return this.m_id;
    }

    public boolean isChoice() {
        return this.m_choiceMaxOccurrence > 0;
    }

    public boolean isSimpleType() {
        return this.m_names.isEmpty();
    }

    public void setChoiceMaxOccurrence(int choiceMaxOccurrence) {
        this.m_choiceMaxOccurrence = choiceMaxOccurrence;
    }
}

