/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.containerpage;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsElementView;
import org.opencms.ade.configuration.CmsResourceTypeConfig;
import org.opencms.ade.containerpage.I_CmsResourceTypeEnabledCheck;
import org.opencms.ade.galleries.CmsGalleryService;
import org.opencms.ade.galleries.shared.CmsResourceTypeBean;
import org.opencms.file.CmsObject;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;

public class CmsAddDialogTypeHelper {
    private static final Log LOG = CmsLog.getLog(CmsAddDialogTypeHelper.class);
    private Set<String> m_allAdeTypes = Sets.newHashSet();
    private Multimap<CmsUUID, CmsResourceTypeBean> m_cachedTypes;
    private Set<String> m_includedAdeTypes = Sets.newHashSet();

    public CmsAddDialogTypeHelper() {
        LOG.debug((Object)"Creating type helper.");
    }

    public List<CmsResourceTypeBean> getPrecomputedTypes(CmsElementView view) {
        return Lists.newArrayList((Iterable)this.m_cachedTypes.get((Object)view.getId()));
    }

    public List<CmsResourceTypeBean> getResourceTypes(CmsObject cms, String folderRootPath, String checkViewableReferenceUri, CmsElementView elementView, I_CmsResourceTypeEnabledCheck checkEnabled) throws CmsException {
        if (elementView == null) {
            LOG.error((Object)"Element view is null");
            return Collections.emptyList();
        }
        ArrayList additionalTypes = Lists.newArrayList();
        HashMap additionalTypeMap = Maps.newHashMap();
        if (elementView.getExplorerType() != null) {
            List<CmsExplorerTypeSettings> explorerTypes = OpenCms.getWorkplaceManager().getExplorerTypesForView(elementView.getExplorerType().getName());
            for (CmsExplorerTypeSettings explorerType : explorerTypes) {
                if (elementView.isOther() && this.m_includedAdeTypes.contains(explorerType.getName())) continue;
                additionalTypeMap.put(explorerType.getName(), OpenCms.getResourceManager().getResourceType(explorerType.getName()));
            }
        }
        if (OpenCms.getRoleManager().hasRole(cms, CmsRole.DEVELOPER) && elementView.isOther()) {
            HashSet<String> hiddenTypes = new HashSet<String>(this.m_allAdeTypes);
            hiddenTypes.removeAll(this.m_includedAdeTypes);
            for (String typeName : hiddenTypes) {
                if (!OpenCms.getResourceManager().hasResourceType(typeName)) continue;
                additionalTypeMap.put(typeName, OpenCms.getResourceManager().getResourceType(typeName));
            }
        }
        additionalTypes.addAll(additionalTypeMap.values());
        return this.internalGetResourceTypesFromConfig(cms, folderRootPath, checkViewableReferenceUri, elementView, additionalTypes, checkEnabled);
    }

    public void precomputeTypeLists(CmsObject cms, String folderRootPath, String checkViewableReferenceUri, List<CmsElementView> views, I_CmsResourceTypeEnabledCheck check) {
        ArrayListMultimap result = ArrayListMultimap.create();
        Collections.sort(views, new Comparator<CmsElementView>(){

            @Override
            public int compare(CmsElementView view0, CmsElementView view1) {
                return ComparisonChain.start().compareFalseFirst(view0.isOther(), view1.isOther()).result();
            }
        });
        for (CmsElementView view : views) {
            try {
                result.putAll((Object)view.getId(), this.getResourceTypes(cms, folderRootPath, checkViewableReferenceUri, view, check));
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        this.m_cachedTypes = result;
    }

    protected boolean exclude(CmsResourceTypeBean type) {
        return false;
    }

    private List<CmsResourceTypeBean> internalGetResourceTypesFromConfig(CmsObject cms, String folderRootPath, String checkViewableReferenceUri, CmsElementView elementView, List<I_CmsResourceType> additionalTypes, I_CmsResourceTypeEnabledCheck checkEnabled) throws CmsException {
        String typeName;
        CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(cms, folderRootPath);
        ArrayList<I_CmsResourceType> resourceTypes = new ArrayList<I_CmsResourceType>();
        HashSet<String> disabledTypes = new HashSet<String>();
        final HashSet typesAtTheEndOfTheList = Sets.newHashSet();
        HashSet typesFromConfig = Sets.newHashSet();
        HashMap createPaths = Maps.newHashMap();
        HashMap namePatterns = Maps.newHashMap();
        for (CmsResourceTypeConfig cmsResourceTypeConfig : config.getResourceTypes()) {
            this.m_allAdeTypes.add(cmsResourceTypeConfig.getTypeName());
            typesFromConfig.add(cmsResourceTypeConfig.getTypeName());
            boolean isModelGroup = "modelgroup".equals(cmsResourceTypeConfig.getTypeName());
            try {
                CmsResourceTypeConfig.AddMenuVisibility addMenuVisibility = cmsResourceTypeConfig.getAddMenuVisibility(elementView.getId());
                if (addMenuVisibility == CmsResourceTypeConfig.AddMenuVisibility.disabled) continue;
                if (isModelGroup || addMenuVisibility == CmsResourceTypeConfig.AddMenuVisibility.fromOtherView) {
                    typesAtTheEndOfTheList.add(cmsResourceTypeConfig.getTypeName());
                }
                if (!cmsResourceTypeConfig.checkViewable(cms, checkViewableReferenceUri)) continue;
                typeName = cmsResourceTypeConfig.getTypeName();
                I_CmsResourceType resType = OpenCms.getResourceManager().getResourceType(typeName);
                resourceTypes.add(resType);
                if (checkEnabled == null || checkEnabled.checkEnabled(cms, config, resType)) continue;
                disabledTypes.add(resType.getTypeName());
            }
            catch (Exception exception) {
                LOG.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        HashSet<String> creatableTypes = new HashSet<String>();
        for (CmsResourceTypeConfig typeConfig : config.getCreatableTypes(cms, folderRootPath)) {
            if (typeConfig.isHiddenFromAddMenu(elementView.getId()) || disabledTypes.contains(typeConfig.getTypeName())) continue;
            createPaths.put(typeConfig.getTypeName(), typeConfig.getFolderPath(cms, folderRootPath));
            namePatterns.put(typeConfig.getTypeName(), typeConfig.getNamePattern(false));
            String string = typeConfig.getTypeName();
            creatableTypes.add(string);
        }
        this.m_includedAdeTypes.addAll(createPaths.keySet());
        CmsGalleryService cmsGalleryService = new CmsGalleryService();
        cmsGalleryService.setCms(cms);
        Collections.sort(resourceTypes, new Comparator<I_CmsResourceType>(){

            @Override
            public int compare(I_CmsResourceType first, I_CmsResourceType second) {
                return ComparisonChain.start().compare(this.rank(first), this.rank(second)).result();
            }

            int rank(I_CmsResourceType type) {
                return typesAtTheEndOfTheList.contains(type.getTypeName()) ? 1 : 0;
            }
        });
        Collections.sort(additionalTypes, new Comparator<I_CmsResourceType>(){

            @Override
            public int compare(I_CmsResourceType type1, I_CmsResourceType type2) {
                CmsExplorerTypeSettings settings1 = OpenCms.getWorkplaceManager().getExplorerTypeSetting(type1.getTypeName());
                CmsExplorerTypeSettings settings2 = OpenCms.getWorkplaceManager().getExplorerTypeSetting(type2.getTypeName());
                return ComparisonChain.start().compare((Comparable)settings1.getViewOrder(true), (Comparable)settings2.getViewOrder(true)).compare(this.parse(settings1.getNewResourceOrder()), this.parse(settings2.getNewResourceOrder())).result();
            }

            long parse(String order) {
                try {
                    return Integer.parseInt(order);
                }
                catch (NumberFormatException e) {
                    return 9999L;
                }
            }
        });
        for (I_CmsResourceType i_CmsResourceType : additionalTypes) {
            CmsExplorerTypeSettings explorerType;
            CmsPermissionSet permissions;
            typeName = i_CmsResourceType.getTypeName();
            if (typesFromConfig.contains(typeName) && !elementView.isOther() || !(permissions = (explorerType = OpenCms.getWorkplaceManager().getExplorerTypeSetting(typeName)).getAccess().getPermissions(cms, cms.readResource(checkViewableReferenceUri))).requiresControlPermission() || !permissions.requiresViewPermission()) continue;
            resourceTypes.add(i_CmsResourceType);
            creatableTypes.add(i_CmsResourceType.getTypeName());
        }
        List<CmsResourceTypeBean> results = cmsGalleryService.buildTypesList(resourceTypes, creatableTypes, disabledTypes, null);
        for (CmsResourceTypeBean typeBean : results) {
            if (typesFromConfig.contains(typeBean.getType())) {
                typeBean.setOrigin(CmsResourceTypeBean.Origin.config);
                typeBean.setCreatePath((String)createPaths.get(typeBean.getType()));
                typeBean.setNamePattern((String)namePatterns.get(typeBean.getType()));
                continue;
            }
            typeBean.setOrigin(CmsResourceTypeBean.Origin.other);
        }
        ArrayList arrayList = Lists.newArrayList();
        for (CmsResourceTypeBean result : results) {
            if (this.exclude(result)) continue;
            arrayList.add(result);
        }
        return arrayList;
    }
}

