/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.containerpage;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsADEManager;
import org.opencms.ade.configuration.CmsElementView;
import org.opencms.ade.configuration.CmsModelPageConfig;
import org.opencms.ade.configuration.CmsResourceTypeConfig;
import org.opencms.ade.containerpage.CmsAddDialogTypeHelper;
import org.opencms.ade.containerpage.CmsElementUtil;
import org.opencms.ade.containerpage.CmsModelGroupHelper;
import org.opencms.ade.containerpage.I_CmsResourceTypeEnabledCheck;
import org.opencms.ade.containerpage.Messages;
import org.opencms.ade.containerpage.inherited.CmsInheritanceReference;
import org.opencms.ade.containerpage.inherited.CmsInheritanceReferenceParser;
import org.opencms.ade.containerpage.inherited.CmsInheritedContainerState;
import org.opencms.ade.containerpage.shared.CmsCntPageData;
import org.opencms.ade.containerpage.shared.CmsContainer;
import org.opencms.ade.containerpage.shared.CmsContainerElement;
import org.opencms.ade.containerpage.shared.CmsContainerElementData;
import org.opencms.ade.containerpage.shared.CmsContainerPageGalleryData;
import org.opencms.ade.containerpage.shared.CmsContainerPageRpcContext;
import org.opencms.ade.containerpage.shared.CmsCreateElementData;
import org.opencms.ade.containerpage.shared.CmsElementViewInfo;
import org.opencms.ade.containerpage.shared.CmsFormatterConfig;
import org.opencms.ade.containerpage.shared.CmsGroupContainer;
import org.opencms.ade.containerpage.shared.CmsGroupContainerSaveResult;
import org.opencms.ade.containerpage.shared.CmsInheritanceContainer;
import org.opencms.ade.containerpage.shared.CmsInheritanceInfo;
import org.opencms.ade.containerpage.shared.CmsLocaleLinkBean;
import org.opencms.ade.containerpage.shared.CmsRemovedElementStatus;
import org.opencms.ade.containerpage.shared.rpc.I_CmsContainerpageService;
import org.opencms.ade.detailpage.CmsDetailPageResourceHandler;
import org.opencms.ade.galleries.CmsGalleryService;
import org.opencms.ade.galleries.shared.CmsGalleryDataBean;
import org.opencms.ade.galleries.shared.CmsGallerySearchBean;
import org.opencms.ade.galleries.shared.CmsResourceTypeBean;
import org.opencms.ade.galleries.shared.CmsVfsEntryBean;
import org.opencms.ade.galleries.shared.I_CmsGalleryProviderConstants;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.types.CmsResourceTypeFolder;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.flex.CmsFlexController;
import org.opencms.gwt.CmsDefaultResourceStatusProvider;
import org.opencms.gwt.CmsGwtActionElement;
import org.opencms.gwt.CmsGwtService;
import org.opencms.gwt.CmsRpcException;
import org.opencms.gwt.CmsVfsService;
import org.opencms.gwt.shared.CmsListInfoBean;
import org.opencms.gwt.shared.CmsModelResourceInfo;
import org.opencms.gwt.shared.CmsTemplateContextInfo;
import org.opencms.i18n.CmsLocaleGroup;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.jsp.CmsJspTagContainer;
import org.opencms.jsp.util.CmsJspStandardContextBean;
import org.opencms.lock.CmsLock;
import org.opencms.lock.CmsLockType;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.relations.CmsRelationType;
import org.opencms.search.galleries.CmsGallerySearch;
import org.opencms.search.galleries.CmsGallerySearchResult;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsRole;
import org.opencms.site.CmsSiteManagerImpl;
import org.opencms.ui.apps.CmsQuickLaunchLocationCache;
import org.opencms.util.CmsPair;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.editors.CmsWorkplaceEditorManager;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.containerpage.CmsADESessionCache;
import org.opencms.xml.containerpage.CmsContainerBean;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.CmsFormatterConfiguration;
import org.opencms.xml.containerpage.CmsGroupContainerBean;
import org.opencms.xml.containerpage.CmsMacroFormatterBean;
import org.opencms.xml.containerpage.CmsXmlContainerPage;
import org.opencms.xml.containerpage.CmsXmlContainerPageFactory;
import org.opencms.xml.containerpage.CmsXmlGroupContainer;
import org.opencms.xml.containerpage.CmsXmlGroupContainerFactory;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.content.CmsXmlContentProperty;
import org.opencms.xml.content.CmsXmlContentPropertyHelper;

public class CmsContainerpageService
extends CmsGwtService
implements I_CmsContainerpageService {
    public static final String ADDINFO_EDIT_SMALL_ELEMENTS = "EDIT_SMALL_ELEMENTS";
    public static final String ATTR_CLIPBOARD_TAB = "clipboardtab";
    public static final String MODEL_GROUP_PATH_FRAGMENT = "/.content/.modelgroups/";
    public static final String SOURCE_CONTAINERPAGE_ID_SETTING = "source_containerpage_id";
    private static final Log LOG = CmsLog.getLog(CmsContainerpageService.class);
    private static final long serialVersionUID = -6188370638303594280L;
    private CmsADEConfigData m_configData;
    private CmsADESessionCache m_sessionCache;
    private CmsWorkplaceSettings m_workplaceSettings;

    public static List<CmsModelResourceInfo> generateModelResourceList(CmsObject cms, String resourceType, List<CmsResource> modelResources, Locale contentLocale) throws CmsException {
        ArrayList<CmsModelResourceInfo> result = new ArrayList<CmsModelResourceInfo>();
        Locale wpLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        CmsModelResourceInfo defaultInfo = new CmsModelResourceInfo(Messages.get().getBundle(wpLocale).key("GUI_TITLE_DEFAULT_RESOURCE_CONTENT_0"), Messages.get().getBundle(wpLocale).key("GUI_DESCRIPTION_DEFAULT_RESOURCE_CONTENT_0"), null);
        defaultInfo.setResourceType(resourceType);
        result.add(defaultInfo);
        for (CmsResource model : modelResources) {
            CmsGallerySearchResult searchInfo = CmsGallerySearch.searchById(cms, model.getStructureId(), contentLocale);
            CmsModelResourceInfo modelInfo = new CmsModelResourceInfo(searchInfo.getTitle(), searchInfo.getDescription(), null);
            modelInfo.addAdditionalInfo(Messages.get().getBundle(wpLocale).key("GUI_LABEL_PATH_0"), cms.getSitePath(model));
            modelInfo.setResourceType(resourceType);
            modelInfo.setStructureId(model.getStructureId());
            result.add(modelInfo);
        }
        return result;
    }

    public static String getSerializedContainerInfo(CmsContainer container) throws Exception {
        return CmsGwtActionElement.serialize(I_CmsContainerpageService.class.getMethod("getContainerInfo", new Class[0]), container);
    }

    public static String getSerializedElementInfo(CmsObject cms, HttpServletRequest request, HttpServletResponse response, CmsContainerElementBean elementBean, CmsContainerPageBean page) throws Exception {
        CmsContainerElement result = new CmsContainerElement();
        CmsElementUtil util = new CmsElementUtil(cms, cms.getRequestContext().getUri(), page, null, request, response, false, cms.getRequestContext().getLocale());
        util.setElementInfo(elementBean, result);
        return CmsGwtActionElement.serialize(I_CmsContainerpageService.class.getMethod("getElementInfo", new Class[0]), result);
    }

    public static boolean isEditingModelGroups(CmsObject cms, CmsResource containerPage) {
        return OpenCms.getResourceManager().getResourceType(containerPage).getTypeName().equals("modelgroup") && OpenCms.getRoleManager().hasRole(cms, CmsRole.DEVELOPER);
    }

    public static CmsCntPageData prefetch(HttpServletRequest request) throws CmsRpcException {
        CmsContainerpageService srv = new CmsContainerpageService();
        srv.setCms(CmsFlexController.getCmsObject((ServletRequest)request));
        srv.setRequest(request);
        CmsCntPageData result = null;
        try {
            result = srv.prefetch();
        }
        finally {
            srv.clearThreadStorage();
        }
        return result;
    }

    private static String getServerIdString(String id) {
        if (id.contains("#")) {
            id = id.substring(0, id.indexOf("#"));
        }
        return id;
    }

    @Override
    public void addToFavoriteList(CmsContainerPageRpcContext context, String clientId) throws CmsRpcException {
        try {
            this.ensureSession();
            List<CmsContainerElementBean> list = OpenCms.getADEManager().getFavoriteList(this.getCmsObject());
            CmsResource containerPage = this.getCmsObject().readResource(context.getPageStructureId());
            this.updateFavoriteRecentList(containerPage, clientId, list);
            OpenCms.getADEManager().saveFavoriteList(this.getCmsObject(), list);
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    @Override
    public void addToRecentList(CmsContainerPageRpcContext context, String clientId) throws CmsRpcException {
        try {
            this.ensureSession();
            List<CmsContainerElementBean> list = OpenCms.getADEManager().getRecentList(this.getCmsObject());
            CmsResource containerPage = this.getCmsObject().readResource(context.getPageStructureId());
            this.updateFavoriteRecentList(containerPage, clientId, list);
            OpenCms.getADEManager().saveRecentList(this.getCmsObject(), list);
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    @Override
    public boolean checkContainerpageOrElementsChanged(CmsUUID structureId, CmsUUID detailContentId, String contentLocale) throws CmsRpcException {
        try {
            ArrayList<CmsUUID> additionalIds = new ArrayList<CmsUUID>();
            additionalIds.add(structureId);
            boolean detailOnlyChanged = false;
            if (detailContentId != null) {
                additionalIds.add(detailContentId);
                try {
                    CmsObject cms = this.getCmsObject();
                    CmsResource detailContentRes = cms.readResource(detailContentId, CmsResourceFilter.ALL);
                    OpenCms.getLocaleManager();
                    Optional<CmsResource> detailOnlyRes = CmsJspTagContainer.getDetailOnlyPage(cms, detailContentRes, CmsJspTagContainer.getDetailContainerLocale(cms, contentLocale, cms.readResource(structureId)));
                    if (detailOnlyRes.isPresent()) {
                        detailOnlyChanged = CmsDefaultResourceStatusProvider.getContainerpageRelationTargets(this.getCmsObject(), ((CmsResource)detailOnlyRes.get()).getStructureId(), Arrays.asList(((CmsResource)detailOnlyRes.get()).getStructureId()), true).isChanged();
                    }
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            return detailOnlyChanged || CmsDefaultResourceStatusProvider.getContainerpageRelationTargets(this.getCmsObject(), structureId, additionalIds, true).isChanged();
        }
        catch (Throwable e) {
            this.error(e);
            return false;
        }
    }

    @Override
    public CmsCreateElementData checkCreateNewElement(CmsUUID pageStructureId, String clientId, String resourceType, CmsContainer container, String locale) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        CmsCreateElementData result = new CmsCreateElementData();
        try {
            CmsResource currentPage = cms.readResource(pageStructureId);
            List<CmsResource> modelResources = CmsResourceTypeXmlContent.getModelFiles(this.getCmsObject(), CmsResource.getFolderPath(cms.getSitePath(currentPage)), resourceType);
            if (modelResources.isEmpty()) {
                CmsContainerElementBean bean = this.getCachedElement(clientId, currentPage.getRootPath());
                I_CmsFormatterBean formatter = CmsElementUtil.getFormatterForContainer(cms, bean, container, this.getConfigData(currentPage.getRootPath()), true, this.getSessionCache());
                CmsUUID modelResId = null;
                if (formatter instanceof CmsMacroFormatterBean) {
                    modelResId = ((CmsMacroFormatterBean)formatter).getDefaultContentStructureId();
                }
                result.setCreatedElement(this.createNewElement(pageStructureId, clientId, resourceType, modelResId, locale));
            } else {
                result.setModelResources(CmsContainerpageService.generateModelResourceList(this.getCmsObject(), resourceType, modelResources, CmsLocaleManager.getLocale(locale)));
            }
        }
        catch (CmsException e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public boolean checkNewWidgetsAvailable(CmsUUID structureId) throws CmsRpcException {
        try {
            CmsObject cms = this.getCmsObject();
            CmsResource resource = cms.readResource(structureId);
            return CmsWorkplaceEditorManager.checkAcaciaEditorAvailable(cms, resource);
        }
        catch (Throwable t) {
            this.error(t);
            return false;
        }
    }

    public CmsUUID convertToServerId(String id) throws CmsIllegalArgumentException {
        if (id == null) {
            throw new CmsIllegalArgumentException(org.opencms.xml.containerpage.Messages.get().container("ERR_INVALID_ID_1", id));
        }
        String serverId = CmsContainerpageService.getServerIdString(id);
        try {
            return new CmsUUID(serverId);
        }
        catch (NumberFormatException e) {
            throw new CmsIllegalArgumentException(org.opencms.xml.containerpage.Messages.get().container("ERR_INVALID_ID_1", id), (Throwable)e);
        }
    }

    @Override
    public CmsUUID copyElement(CmsUUID pageId, CmsUUID originalElementId) throws CmsRpcException {
        try {
            CmsObject cms = this.getCmsObject();
            CmsResource page = cms.readResource(pageId, CmsResourceFilter.IGNORE_EXPIRATION);
            CmsResource element = cms.readResource(originalElementId, CmsResourceFilter.IGNORE_EXPIRATION);
            CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(cms, page.getRootPath());
            String typeName = OpenCms.getResourceManager().getResourceType(element.getTypeId()).getTypeName();
            CmsResourceTypeConfig typeConfig = config.getResourceType(typeName);
            if (typeConfig == null) {
                LOG.error((Object)("copyElement: Type not configured in ADE configuration: " + typeName));
                return originalElementId;
            }
            CmsResource newResource = typeConfig.createNewElement(cms, element, CmsResource.getParentFolder(page.getRootPath()));
            return newResource.getStructureId();
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsContainerElement createNewElement(CmsUUID pageStructureId, String clientId, String resourceType, CmsUUID modelResourceStructureId, String locale) throws CmsRpcException {
        CmsContainerElement element = null;
        try {
            this.ensureSession();
            CmsObject cms = this.getCmsObject();
            CmsResource pageResource = cms.readResource(pageStructureId);
            CmsADEConfigData configData = this.getConfigData(pageResource.getRootPath());
            CmsResourceTypeConfig typeConfig = configData.getResourceType(resourceType);
            CmsObject cloneCms = OpenCms.initCmsObject(cms);
            cloneCms.getRequestContext().setLocale(CmsLocaleManager.getLocale(locale));
            CmsResource modelResource = null;
            if (modelResourceStructureId != null) {
                modelResource = cms.readResource(modelResourceStructureId);
            }
            CmsResource newResource = typeConfig.createNewElement(cloneCms, modelResource, CmsResource.getParentFolder(pageResource.getRootPath()));
            CmsContainerElementBean bean = this.getCachedElement(clientId, pageResource.getRootPath());
            CmsContainerElementBean newBean = new CmsContainerElementBean(newResource.getStructureId(), null, bean.getIndividualSettings(), typeConfig.isCopyInModels());
            String newClientId = newBean.editorHash();
            this.getSessionCache().setCacheContainerElement(newClientId, newBean);
            element = new CmsContainerElement();
            element.setNewEditorDisabled(!CmsWorkplaceEditorManager.checkAcaciaEditorAvailable(cms, newResource));
            element.setClientId(newClientId);
            element.setSitePath(cms.getSitePath(newResource));
            element.setResourceType(resourceType);
            element.setCreateNew(newBean.isCreateNew());
        }
        catch (CmsException e) {
            this.error(e);
        }
        return element;
    }

    @Override
    public CmsContainer getContainerInfo() {
        throw new UnsupportedOperationException("This method is used for serialization only.");
    }

    @Override
    public CmsContainerElement getElementInfo() {
        throw new UnsupportedOperationException("This method is used for serialization only.");
    }

    @Override
    public Map<String, CmsContainerElementData> getElementsData(CmsContainerPageRpcContext context, CmsUUID detailContentId, String reqParams, Collection<String> clientIds, Collection<CmsContainer> containers, boolean allowNested, boolean allwaysCopy, String dndSource, String locale) throws CmsRpcException {
        Map<String, CmsContainerElementData> result = null;
        try {
            this.ensureSession();
            CmsResource pageResource = this.getCmsObject().readResource(context.getPageStructureId());
            this.initRequestFromRpcContext(context);
            String containerpageUri = this.getCmsObject().getSitePath(pageResource);
            result = this.getElements(pageResource, clientIds, containerpageUri, detailContentId, containers, allowNested, allwaysCopy, dndSource, CmsStringUtil.isNotEmptyOrWhitespaceOnly(dndSource), CmsLocaleManager.getLocale(locale));
        }
        catch (Throwable e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public CmsContainerElementData getElementSettingsConfig(CmsContainerPageRpcContext context, String clientId, String containerId, Collection<CmsContainer> containers, boolean allowNested, String locale) throws CmsRpcException {
        try {
            this.ensureSession();
            CmsObject cms = this.getCmsObject();
            CmsResource pageResource = cms.readResource(context.getPageStructureId());
            this.initRequestFromRpcContext(context);
            String containerpageUri = cms.getSitePath(pageResource);
            CmsContainerPageBean pageBean = this.generateContainerPageForContainers(containers, cms.getRequestContext().addSiteRoot(containerpageUri));
            CmsElementUtil elemUtil = new CmsElementUtil(cms, containerpageUri, pageBean, null, this.getRequest(), this.getResponse(), false, CmsLocaleManager.getLocale(locale));
            CmsContainerElementBean element = this.getCachedElement(clientId, cms.getRequestContext().addSiteRoot(containerpageUri));
            if (element.getInstanceId() == null) {
                element = element.clone();
                this.getSessionCache().setCacheContainerElement(element.editorHash(), element);
            }
            element.initResource(cms);
            return elemUtil.getElementSettingsConfig(pageResource, element, containerId, containers, allowNested);
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsContainerElementData getElementWithSettings(CmsContainerPageRpcContext context, CmsUUID detailContentId, String uriParams, String clientId, Map<String, String> settings, Collection<CmsContainer> containers, boolean allowNested, String locale) throws CmsRpcException {
        CmsContainerElementData element = null;
        try {
            this.ensureSession();
            CmsObject cms = this.getCmsObject();
            CmsResource pageResource = cms.readResource(context.getPageStructureId());
            this.initRequestFromRpcContext(context);
            String containerpageUri = cms.getSitePath(pageResource);
            Locale contentLocale = CmsLocaleManager.getLocale(locale);
            CmsElementUtil elemUtil = new CmsElementUtil(cms, containerpageUri, this.generateContainerPageForContainers(containers, pageResource.getRootPath()), detailContentId, this.getRequest(), this.getResponse(), false, contentLocale);
            CmsContainerElementBean elementBean = this.getCachedElement(clientId, pageResource.getRootPath());
            elementBean.initResource(cms);
            this.storeFormatterSelection(elementBean, settings);
            if (!settings.containsKey("element_instance_id") && elementBean.getIndividualSettings().containsKey("element_instance_id")) {
                settings.put("element_instance_id", elementBean.getIndividualSettings().get("element_instance_id"));
            }
            elementBean = CmsContainerElementBean.cloneWithSettings(elementBean, this.convertSettingValues(elementBean.getResource(), settings, contentLocale));
            this.getSessionCache().setCacheContainerElement(elementBean.editorHash(), elementBean);
            element = elemUtil.getElementData(pageResource, elementBean, containers, allowNested);
        }
        catch (Throwable e) {
            this.error(e);
        }
        return element;
    }

    @Override
    public List<CmsContainerElementData> getFavoriteList(CmsUUID pageStructureId, CmsUUID detailContentId, Collection<CmsContainer> containers, boolean allowNested, String locale) throws CmsRpcException {
        List<CmsContainerElementData> result = null;
        try {
            this.ensureSession();
            CmsResource containerpage = this.getCmsObject().readResource(pageStructureId);
            String containerpageUri = this.getCmsObject().getSitePath(containerpage);
            result = this.getListElementsData(OpenCms.getADEManager().getFavoriteList(this.getCmsObject()), containerpageUri, detailContentId, containers, allowNested, CmsLocaleManager.getLocale(locale));
        }
        catch (Throwable e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public CmsContainerPageGalleryData getGalleryDataForPage(final List<CmsContainer> containers, CmsUUID elementView, String uri, String locale) throws CmsRpcException {
        CmsGalleryDataBean data = null;
        try {
            CmsObject cms = this.getCmsObject();
            CmsAddDialogTypeHelper typeHelper = new CmsAddDialogTypeHelper();
            List<CmsResourceTypeBean> resTypeBeans = typeHelper.getResourceTypes(cms, cms.getRequestContext().addSiteRoot(uri), uri, OpenCms.getADEManager().getElementViews(cms).get(elementView), new I_CmsResourceTypeEnabledCheck(){

                @Override
                public boolean checkEnabled(CmsObject paramCms, CmsADEConfigData config, I_CmsResourceType resType) {
                    boolean isModelGroup = "modelgroup".equals(resType.getTypeName());
                    return isModelGroup || config.hasFormatters(paramCms, resType, containers);
                }
            });
            CmsGalleryService srv = new CmsGalleryService();
            srv.setCms(cms);
            srv.setRequest(this.getRequest());
            data = srv.getInitialSettingsForContainerPage(resTypeBeans, uri, locale);
            CmsContainerPageGalleryData result = new CmsContainerPageGalleryData();
            CmsADESessionCache cache = CmsADESessionCache.getCache(this.getRequest(), cms);
            CmsGallerySearchBean search = cache.getLastPageEditorGallerySearch();
            String subsite = OpenCms.getADEManager().getSubSiteRoot(cms, cms.addSiteRoot(uri));
            String searchStoreKey = elementView + "|" + subsite + "|" + locale;
            data.getContextParameters().put("searchStoreKey", searchStoreKey);
            if (search != null && searchStoreKey.equals(search.getOriginalGalleryData().getContextParameters().get("searchStoreKey")) && this.hasCompatibleSearchData(search.getOriginalGalleryData(), data, search)) {
                CmsVfsEntryBean preloadData = null;
                if (search.getFolders() != null) {
                    preloadData = CmsGalleryService.generateVfsPreloadData(this.getCmsObject(), CmsGalleryService.getVfsTreeState(this.getRequest(), data.getTreeToken()), search.getFolders());
                }
                search.setTabId(I_CmsGalleryProviderConstants.GalleryTabId.cms_tab_results.toString());
                search.setPage(1);
                search.setLastPage(0);
                data.setStartTab(I_CmsGalleryProviderConstants.GalleryTabId.cms_tab_results);
                search = srv.getSearch(search);
                data.setVfsPreloadData(preloadData);
                data.setIncludeExpiredDefault(search.isIncludeExpired());
                result.setGallerySearch(search);
            }
            result.setGalleryData(data);
            return result;
        }
        catch (Exception e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsContainerElementData getNewElementData(CmsContainerPageRpcContext context, CmsUUID detailContentId, String reqParams, String resourceType, Collection<CmsContainer> containers, boolean allowNested, String localeName) throws CmsRpcException {
        CmsContainerElementData result = null;
        try {
            this.ensureSession();
            CmsResource pageResource = this.getCmsObject().readResource(context.getPageStructureId());
            this.initRequestFromRpcContext(context);
            String containerpageUri = this.getCmsObject().getSitePath(pageResource);
            Locale locale = CmsLocaleManager.getLocale(localeName);
            result = this.getNewElement(CmsContainerpageService.getServerIdString(resourceType), containerpageUri, detailContentId, containers, allowNested, locale);
        }
        catch (Throwable e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public List<CmsContainerElementData> getRecentList(CmsUUID pageStructureId, CmsUUID detailContentId, Collection<CmsContainer> containers, boolean allowNested, String locale) throws CmsRpcException {
        List<CmsContainerElementData> result = null;
        try {
            this.ensureSession();
            CmsResource containerpage = this.getCmsObject().readResource(pageStructureId);
            String containerpageUri = this.getCmsObject().getSitePath(containerpage);
            result = this.getListElementsData(OpenCms.getADEManager().getRecentList(this.getCmsObject()), containerpageUri, detailContentId, containers, allowNested, CmsLocaleManager.getLocale(locale));
        }
        catch (Throwable e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public CmsRemovedElementStatus getRemovedElementStatus(String id, CmsUUID containerpageId) throws CmsRpcException {
        if (id == null || !id.matches("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}.*$")) {
            return new CmsRemovedElementStatus(null, null, false, null);
        }
        try {
            CmsUUID structureId = this.convertToServerId(id);
            return this.internalGetRemovedElementStatus(structureId, containerpageId);
        }
        catch (CmsException e) {
            this.error(e);
            return null;
        }
    }

    public CmsRemovedElementStatus internalGetRemovedElementStatus(CmsUUID structureId, CmsUUID containerpageId) throws CmsException {
        boolean hasNoRelations;
        CmsObject cms = this.getCmsObject();
        CmsResource elementResource = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
        boolean hasWritePermissions = cms.hasPermissions(elementResource, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.ALL);
        boolean isSystemResource = elementResource.getRootPath().startsWith("/system/");
        CmsRelationFilter relationFilter = CmsRelationFilter.relationsToStructureId(structureId);
        List<CmsRelation> relationsToElement = cms.readRelations(relationFilter);
        Iterator<CmsRelation> iter = relationsToElement.iterator();
        while (iter.hasNext()) {
            CmsRelation relation = iter.next();
            if (containerpageId == null || !containerpageId.equals(relation.getSourceId()) || !relation.getType().equals(CmsRelationType.XML_STRONG)) continue;
            iter.remove();
        }
        CmsCntPageData.ElementDeleteMode elementDeleteMode = null;
        CmsResource pageResource = cms.readResource(containerpageId, CmsResourceFilter.IGNORE_EXPIRATION);
        CmsADEConfigData adeConfig = OpenCms.getADEManager().lookupConfiguration(cms, pageResource.getRootPath());
        CmsResourceTypeConfig typeConfig = adeConfig.getResourceType(OpenCms.getResourceManager().getResourceType(elementResource).getTypeName());
        if (typeConfig != null) {
            elementDeleteMode = typeConfig.getElementDeleteMode();
        }
        boolean deletionCandidate = (hasNoRelations = relationsToElement.isEmpty()) && hasWritePermissions && !isSystemResource;
        CmsListInfoBean elementInfo = CmsVfsService.getPageInfo(cms, elementResource);
        return new CmsRemovedElementStatus(structureId, elementInfo, deletionCandidate, elementDeleteMode);
    }

    @Override
    public int loadClipboardTab() {
        Integer clipboardTab = (Integer)this.getRequest().getSession().getAttribute(ATTR_CLIPBOARD_TAB);
        if (clipboardTab == null) {
            clipboardTab = 0;
        }
        return clipboardTab;
    }

    @Override
    public CmsCntPageData prefetch() throws CmsRpcException {
        CmsCntPageData data = null;
        CmsObject cms = this.getCmsObject();
        Locale wpLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        HttpServletRequest request = this.getRequest();
        try {
            CmsCntPageData.ElementDeleteMode deleteMode;
            CmsProperty modelElementProp;
            String noEditReason;
            CmsTemplateContextInfo info = OpenCms.getTemplateContextManager().getContextInfoBean(cms, request);
            CmsResource containerPage = this.getContainerpage(cms);
            boolean isEditingModelGroup = CmsContainerpageService.isEditingModelGroups(cms, containerPage);
            boolean isModelPage = this.isModelPage(cms, containerPage);
            if (isModelPage) {
                this.getRequest().getSession().setAttribute("showModelEditConfirm", (Object)Boolean.FALSE);
            }
            CmsJspStandardContextBean.TemplateBean templateBean = (CmsJspStandardContextBean.TemplateBean)this.getRequest().getAttribute("ATTR_TEMPLATE_BEAN");
            CmsADESessionCache sessionCache = CmsADESessionCache.getCache(this.getRequest(), cms);
            sessionCache.setTemplateBean(containerPage.getRootPath(), templateBean);
            long lastModified = containerPage.getDateLastModified();
            String editorUri = OpenCms.getWorkplaceManager().getEditorHandler().getEditorUri(cms, "xmlcontent", "User agent", false);
            boolean useClassicEditor = editorUri == null || !editorUri.contains("acacia");
            CmsResource detailResource = CmsDetailPageResourceHandler.getDetailResource((ServletRequest)request);
            String detailContainerPage = null;
            CmsQuickLaunchLocationCache locationCache = CmsQuickLaunchLocationCache.getLocationCache(request.getSession());
            if (detailResource != null) {
                locationCache.setPageEditorLocation(cms.getRequestContext().getSiteRoot(), cms.getSitePath(detailResource));
                CmsObject rootCms = OpenCms.initCmsObject(cms);
                rootCms.getRequestContext().setSiteRoot("");
                detailContainerPage = CmsJspTagContainer.getDetailOnlyPageName(detailResource.getRootPath(), CmsJspTagContainer.getDetailContainerLocale(cms, cms.getRequestContext().getLocale().toString(), containerPage));
                if (rootCms.existsResource(detailContainerPage, CmsResourceFilter.IGNORE_EXPIRATION)) {
                    noEditReason = this.getNoEditReason(rootCms, rootCms.readResource(detailContainerPage, CmsResourceFilter.IGNORE_EXPIRATION));
                } else {
                    String permissionFolder = CmsResource.getFolderPath(detailContainerPage);
                    while (!rootCms.existsResource(permissionFolder, CmsResourceFilter.IGNORE_EXPIRATION)) {
                        permissionFolder = CmsResource.getParentFolder(permissionFolder);
                    }
                    noEditReason = this.getNoEditReason(rootCms, rootCms.readResource(permissionFolder, CmsResourceFilter.IGNORE_EXPIRATION));
                }
            } else {
                if (!isModelPage && !isEditingModelGroup) {
                    locationCache.setPageEditorLocation(cms.getRequestContext().getSiteRoot(), cms.getSitePath(containerPage));
                }
                noEditReason = this.getNoEditReason(cms, containerPage);
            }
            String sitemapPath = "";
            boolean sitemapManager = OpenCms.getRoleManager().hasRole(cms, CmsRole.EDITOR);
            if (sitemapManager) {
                sitemapPath = "/system/workplace/commons/sitemap.jsp";
            }
            CmsCntPageData.ElementReuseMode reuseMode = CmsCntPageData.ElementReuseMode.reuse;
            String reuseModeString = this.getWorkplaceSettings().getUserSettings().getAdditionalPreference("elementReuseMode", true);
            try {
                reuseMode = CmsCntPageData.ElementReuseMode.valueOf(reuseModeString);
            }
            catch (Exception e) {
                LOG.info((Object)("Invalid reuse mode : " + reuseModeString), (Throwable)e);
            }
            InitialElementViewProvider viewHelper = new InitialElementViewProvider();
            viewHelper.init(this.getSessionCache().getElementView(), containerPage);
            CmsLocaleGroup group = cms.getLocaleGroupService().readLocaleGroup(containerPage);
            Locale mainLocale = null;
            if (group.isRealGroup() && !cms.getRequestContext().getLocale().equals(group.getMainLocale())) {
                mainLocale = group.getMainLocale();
            }
            CmsSiteManagerImpl siteManager = OpenCms.getSiteManager();
            String ownRoot = siteManager.getSiteRoot(containerPage.getRootPath());
            HashMap localeLinkBeans = null;
            if (group.isRealGroup()) {
                localeLinkBeans = Maps.newHashMap();
                Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
                for (Map.Entry<Locale, CmsResource> entry : group.getResourcesByLocale().entrySet()) {
                    String otherRoot = siteManager.getSiteRoot(entry.getValue().getRootPath());
                    if (otherRoot != null && otherRoot.equals(ownRoot)) {
                        String theLink = OpenCms.getLinkManager().substituteLinkForUnknownTarget(cms, cms.getRequestContext().removeSiteRoot(entry.getValue().getRootPath()));
                        localeLinkBeans.put(entry.getKey().getDisplayLanguage(locale), CmsLocaleLinkBean.link(theLink));
                        continue;
                    }
                    localeLinkBeans.put(entry.getKey().getDisplayLanguage(locale), CmsLocaleLinkBean.error(Messages.get().getBundle(locale).key("GUI_SHOWLOCALE_WRONG_SITE_0")));
                }
            }
            String onlineLink = null;
            if (!OpenCms.getSiteManager().getWorkplaceServer().equals(OpenCms.getSiteManager().getSiteForSiteRoot(cms.getRequestContext().getSiteRoot()).getUrl())) {
                onlineLink = detailResource != null ? OpenCms.getLinkManager().getOnlineLink(cms, cms.getSitePath(containerPage), cms.getSitePath(detailResource), false) : OpenCms.getLinkManager().getOnlineLink(cms, cms.getSitePath(containerPage));
            }
            String modelGroupElementId = null;
            if (isEditingModelGroup && !(modelElementProp = cms.readPropertyObject(containerPage, "template-elements", false)).isNullProperty() && CmsUUID.isValidUUID(modelElementProp.getValue())) {
                modelGroupElementId = modelElementProp.getValue();
            }
            String title = null;
            if (isModelPage || isEditingModelGroup) {
                title = Messages.get().getBundle(wpLocale).key("GUI_TITLE_MODEL_0");
            }
            if ((deleteMode = OpenCms.getWorkplaceManager().getElementDeleteMode()) == null) {
                deleteMode = CmsCntPageData.ElementDeleteMode.askDelete;
            }
            data = new CmsCntPageData(onlineLink, noEditReason, CmsRequestUtil.encodeParams(request), sitemapPath, sitemapManager, detailResource != null ? detailResource.getStructureId() : null, detailContainerPage, lastModified, this.getLockInfo(containerPage), cms.getRequestContext().getLocale().toString(), useClassicEditor, info, this.isEditSmallElements(request, cms), Lists.newArrayList(viewHelper.getViewMap().values()), viewHelper.getDefaultView(), reuseMode, deleteMode, isModelPage, isEditingModelGroup, modelGroupElementId, mainLocale != null ? mainLocale.toString() : null, localeLinkBeans, title);
        }
        catch (Throwable e) {
            this.error(e);
        }
        return data;
    }

    @Override
    public void saveClipboardTab(int tabIndex) {
        this.getRequest().getSession().setAttribute(ATTR_CLIPBOARD_TAB, (Object)new Integer(tabIndex));
    }

    @Override
    public void saveContainerpage(CmsUUID pageStructureId, List<CmsContainer> containers) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        try {
            this.ensureSession();
            CmsResource containerpage = cms.readResource(pageStructureId);
            this.ensureLock(containerpage);
            String containerpageUri = cms.getSitePath(containerpage);
            this.saveContainers(cms, containerpage, containerpageUri, containers);
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    @Override
    public void saveDetailContainers(CmsUUID detailId, String detailContainerResource, List<CmsContainer> containers) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        try {
            CmsResource containerpage;
            CmsObject rootCms = OpenCms.initCmsObject(cms);
            rootCms.getRequestContext().setSiteRoot("");
            this.ensureSession();
            if (rootCms.existsResource(detailContainerResource)) {
                containerpage = rootCms.readResource(detailContainerResource);
            } else {
                String parentFolder = CmsResource.getFolderPath(detailContainerResource);
                ArrayList<String> foldersToCreate = new ArrayList<String>();
                while (!rootCms.existsResource(parentFolder)) {
                    foldersToCreate.add(0, parentFolder);
                    parentFolder = CmsResource.getParentFolder(parentFolder);
                }
                for (String folderName : foldersToCreate) {
                    CmsResource parentRes = rootCms.createResource(folderName, OpenCms.getResourceManager().getResourceType(CmsResourceTypeFolder.getStaticTypeName()));
                    rootCms.writePropertyObject(folderName, new CmsProperty("search.exclude", "all", null));
                    this.tryUnlock(parentRes);
                }
                containerpage = rootCms.createResource(detailContainerResource, OpenCms.getResourceManager().getResourceType(CmsResourceTypeXmlContainerPage.getStaticTypeName()));
            }
            this.ensureLock(containerpage);
            try {
                CmsResource detailResource = cms.readResource(detailId, CmsResourceFilter.IGNORE_EXPIRATION);
                String title = cms.readPropertyObject(detailResource, "Title", true).getValue();
                if (title != null) {
                    title = Messages.get().getBundle(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms)).key("GUI_DETAIL_CONTENT_PAGE_TITLE_1", title);
                    CmsProperty titleProp = new CmsProperty("Title", title, null);
                    cms.writePropertyObjects(containerpage, Arrays.asList(titleProp));
                }
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            this.saveContainers(rootCms, containerpage, detailContainerResource, containers);
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    @Override
    public CmsContainerElementData saveElementSettings(CmsContainerPageRpcContext context, CmsUUID detailContentId, String reqParams, String clientId, Map<String, String> settings, List<CmsContainer> containers, boolean allowNested, String locale) throws CmsRpcException {
        CmsContainerElementData element = null;
        try {
            this.ensureSession();
            CmsObject cms = this.getCmsObject();
            CmsResource pageResource = cms.readResource(context.getPageStructureId());
            this.initRequestFromRpcContext(context);
            Locale contentLocale = CmsLocaleManager.getLocale(locale);
            CmsContainerElementBean elementBean = this.getCachedElement(clientId, pageResource.getRootPath());
            elementBean.initResource(cms);
            this.storeFormatterSelection(elementBean, settings);
            if (!settings.containsKey("element_instance_id") && elementBean.getIndividualSettings().containsKey("element_instance_id")) {
                settings.put("element_instance_id", elementBean.getIndividualSettings().get("element_instance_id"));
            }
            if (!(CmsContainerpageService.isEditingModelGroups(cms, pageResource) || settings.containsKey("model_group_state") && CmsContainerElement.ModelGroupState.noGroup == CmsContainerElement.ModelGroupState.evaluate(settings.get("model_group_state")))) {
                if (elementBean.getIndividualSettings().containsKey("model_group_id")) {
                    settings.put("model_group_id", elementBean.getIndividualSettings().get("model_group_id"));
                }
                if (elementBean.getIndividualSettings().containsKey("model_group_state")) {
                    settings.put("model_group_state", elementBean.getIndividualSettings().get("model_group_state"));
                }
            }
            elementBean = CmsContainerElementBean.cloneWithSettings(elementBean, this.convertSettingValues(elementBean.getResource(), settings, contentLocale));
            this.getSessionCache().setCacheContainerElement(elementBean.editorHash(), elementBean);
            for (CmsContainer cmsContainer : containers) {
                for (CmsContainerElement child : cmsContainer.getElements()) {
                    if (!child.getClientId().equals(clientId)) continue;
                    child.setClientId(elementBean.editorHash());
                }
            }
            if (detailContentId == null) {
                this.saveContainers(cms, pageResource, cms.getSitePath(pageResource), containers);
            } else {
                ArrayList<CmsContainer> detailContainers = new ArrayList<CmsContainer>();
                for (CmsContainer container : containers) {
                    if (!container.isDetailOnly()) continue;
                    detailContainers.add(container);
                }
                CmsObject cmsObject = OpenCms.initCmsObject(cms);
                cmsObject.getRequestContext().setSiteRoot("");
                CmsResource detailResource = cmsObject.readResource(detailContentId, CmsResourceFilter.IGNORE_EXPIRATION);
                CmsResource detailContainerPage = cmsObject.readResource(CmsJspTagContainer.getDetailOnlyPageName(detailResource.getRootPath(), CmsJspTagContainer.getDetailContainerLocale(cms, locale, pageResource)));
                this.ensureLock(detailContainerPage);
                this.saveContainers(cmsObject, detailContainerPage, detailContainerPage.getRootPath(), detailContainers);
            }
            String containerpageUri = cms.getSitePath(pageResource);
            CmsElementUtil cmsElementUtil = new CmsElementUtil(cms, containerpageUri, this.generateContainerPageForContainers(containers, pageResource.getRootPath()), detailContentId, this.getRequest(), this.getResponse(), false, contentLocale);
            element = cmsElementUtil.getElementData(pageResource, elementBean, containers, allowNested);
        }
        catch (Throwable e) {
            this.error(e);
        }
        return element;
    }

    @Override
    public void saveFavoriteList(List<String> clientIds, String uri) throws CmsRpcException {
        try {
            this.ensureSession();
            OpenCms.getADEManager().saveFavoriteList(this.getCmsObject(), this.getCachedElements(clientIds, this.getCmsObject().getRequestContext().addSiteRoot(uri)));
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    @Override
    public CmsGroupContainerSaveResult saveGroupContainer(CmsContainerPageRpcContext context, CmsUUID detailContentId, String reqParams, CmsGroupContainer groupContainer, Collection<CmsContainer> containers, String locale) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        List<CmsRemovedElementStatus> removedElements = null;
        try {
            CmsPair<CmsContainerElement, List<CmsRemovedElementStatus>> saveResult = this.internalSaveGroupContainer(cms, context.getPageStructureId(), groupContainer);
            removedElements = saveResult.getSecond();
        }
        catch (Throwable e) {
            this.error(e);
        }
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(groupContainer.getClientId());
        OpenCms.getSearchManager().updateOfflineIndexes();
        return new CmsGroupContainerSaveResult(this.getElementsData(context, detailContentId, reqParams, ids, containers, false, false, null, locale), removedElements);
    }

    @Override
    public Map<String, CmsContainerElementData> saveInheritanceContainer(CmsUUID pageStructureId, CmsUUID detailContentId, CmsInheritanceContainer inheritanceContainer, Collection<CmsContainer> containers, String locale) throws CmsRpcException {
        try {
            CmsObject cms = this.getCmsObject();
            CmsResource containerPage = cms.readResource(pageStructureId);
            String sitePath = cms.getSitePath(containerPage);
            Locale requestedLocale = CmsLocaleManager.getLocale(locale);
            CmsResource referenceResource = null;
            if (inheritanceContainer.isNew()) {
                CmsADEConfigData config = this.getConfigData(containerPage.getRootPath());
                CmsResourceTypeConfig typeConfig = config.getResourceType("inheritance_group");
                referenceResource = typeConfig.createNewElement(cms, containerPage.getRootPath());
                inheritanceContainer.setClientId(referenceResource.getStructureId().toString());
            }
            if (referenceResource == null) {
                CmsUUID id = this.convertToServerId(inheritanceContainer.getClientId());
                referenceResource = cms.readResource(id, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
            }
            this.ensureLock(referenceResource);
            this.saveInheritanceGroup(referenceResource, inheritanceContainer);
            this.tryUnlock(referenceResource);
            ArrayList<CmsContainerElementBean> elements = new ArrayList<CmsContainerElementBean>();
            for (CmsContainerElement clientElement : inheritanceContainer.getElements()) {
                CmsContainerElementBean elementBean = this.getCachedElement(clientElement.getClientId(), containerPage.getRootPath());
                elementBean = CmsContainerElementBean.cloneWithSettings(elementBean, elementBean.getIndividualSettings());
                CmsInheritanceInfo inheritanceInfo = clientElement.getInheritanceInfo();
                if (inheritanceInfo.isNew() && CmsStringUtil.isEmptyOrWhitespaceOnly(inheritanceInfo.getKey())) {
                    inheritanceInfo.setKey(CmsResource.getFolderPath(sitePath) + new CmsUUID().toString());
                }
                elementBean.setInheritanceInfo(inheritanceInfo);
                elements.add(elementBean);
            }
            cms.getRequestContext().setLocale(requestedLocale);
            if (inheritanceContainer.getElementsChanged()) {
                OpenCms.getADEManager().saveInheritedContainer(cms, containerPage, inheritanceContainer.getName(), true, elements);
            }
            return this.getElements(containerPage, new ArrayList<String>(Collections.singletonList(inheritanceContainer.getClientId())), sitePath, detailContentId, containers, false, false, null, false, requestedLocale);
        }
        catch (Exception e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public void saveRecentList(List<String> clientIds, String uri) throws CmsRpcException {
        try {
            this.ensureSession();
            OpenCms.getADEManager().saveRecentList(this.getCmsObject(), this.getCachedElements(clientIds, this.getCmsObject().getRequestContext().addSiteRoot(uri)));
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    @Override
    public void setEditSmallElements(boolean editSmallElements) throws CmsRpcException {
        try {
            CmsObject cms = this.getCmsObject();
            CmsUser user = cms.getRequestContext().getCurrentUser();
            user.getAdditionalInfo().put(ADDINFO_EDIT_SMALL_ELEMENTS, "" + editSmallElements);
            cms.writeUser(user);
        }
        catch (Throwable t) {
            this.error(t);
        }
    }

    @Override
    public void setElementView(CmsUUID elementView) {
        this.getSessionCache().setElementView(elementView);
    }

    @Override
    public void setLastPage(CmsUUID pageId, CmsUUID detailId) throws CmsRpcException {
        try {
            HttpServletRequest req = this.getRequest();
            CmsObject cms = this.getCmsObject();
            CmsADESessionCache cache = CmsADESessionCache.getCache(req, cms);
            cache.setLastPage(cms, pageId, detailId);
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    public void setSessionCache(CmsADESessionCache cache) {
        this.m_sessionCache = cache;
    }

    @Override
    public void syncSaveContainerpage(CmsUUID pageStructureId, List<CmsContainer> containers) throws CmsRpcException {
        this.saveContainerpage(pageStructureId, containers);
    }

    @Override
    public void syncSaveDetailContainers(CmsUUID detailId, String detailContainerResource, List<CmsContainer> containers) throws CmsRpcException {
        this.saveDetailContainers(detailId, detailContainerResource, containers);
    }

    Map<String, String> getSettingsToChangeForDnd(Map<String, String> originalSettings, CmsFormatterConfiguration formatterConfig, Collection<CmsContainer> containers, String dndContainer, boolean allowNested) {
        HashMap result = Maps.newHashMap();
        if (dndContainer == null) {
            return result;
        }
        String key = CmsFormatterConfig.getSettingsKeyForContainer(dndContainer);
        String formatterId = originalSettings.get(key);
        if (formatterId == null) {
            return result;
        }
        for (CmsContainer container : containers) {
            Map<String, I_CmsFormatterBean> formatterSelection;
            if (container.getName().equals(dndContainer) || !(formatterSelection = formatterConfig.getFormatterSelection(container.getType(), container.getWidth(), allowNested)).containsKey(formatterId)) continue;
            String newKey = CmsFormatterConfig.getSettingsKeyForContainer(container.getName());
            result.put(newKey, formatterId);
        }
        return result;
    }

    CmsContainerElementBean overrideSettings(CmsContainerElementBean element, Map<String, String> settingsToOverride) {
        HashMap settings = Maps.newHashMap(element.getIndividualSettings());
        settings.putAll(settingsToOverride);
        CmsContainerElementBean result = new CmsContainerElementBean(element.getId(), element.getFormatterId(), settings, element.isCreateNew());
        return result;
    }

    void storeFormatterSelection(CmsContainerElementBean elementBean, Map<String, String> settings) {
        String idString;
        Map.Entry<String, String> previousFormatterEntry = null;
        for (Map.Entry<String, String> entry : elementBean.getIndividualSettings().entrySet()) {
            if (!entry.getKey().startsWith("formatterSettings#")) continue;
            previousFormatterEntry = entry;
            break;
        }
        Map.Entry formatterEntry = null;
        for (Map.Entry entry : settings.entrySet()) {
            if (!((String)entry.getKey()).startsWith("formatterSettings#")) continue;
            formatterEntry = entry;
            break;
        }
        if (!(formatterEntry == null || previousFormatterEntry != null && ((String)formatterEntry.getKey()).equals(previousFormatterEntry.getKey()) && ((String)formatterEntry.getValue()).equals(previousFormatterEntry.getValue()) || !CmsUUID.isValidUUID(idString = (String)formatterEntry.getValue()))) {
            I_CmsResourceType i_CmsResourceType = OpenCms.getResourceManager().getResourceType(elementBean.getResource());
            this.getSessionCache().addRecentFormatter(i_CmsResourceType.getTypeName(), new CmsUUID(idString));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> convertSettingValues(CmsResource resource, Map<String, String> settings, Locale locale) throws CmsException {
        CmsObject cms = this.getCmsObject();
        Locale origLocale = cms.getRequestContext().getLocale();
        try {
            cms.getRequestContext().setLocale(locale);
            Map<String, CmsXmlContentProperty> settingsConf = OpenCms.getADEManager().getElementSettings(cms, resource);
            HashMap<String, String> changedSettings = new HashMap<String, String>();
            if (settings != null) {
                for (Map.Entry entry : settings.entrySet()) {
                    String settingName = (String)entry.getKey();
                    String settingType = "string";
                    if (settingsConf.get(settingName) != null) {
                        settingType = settingsConf.get(settingName).getType();
                    }
                    changedSettings.put(settingName, CmsXmlContentPropertyHelper.getPropValueIds(this.getCmsObject(), settingType, (String)entry.getValue()));
                }
            }
            HashMap<String, String> hashMap = changedSettings;
            return hashMap;
        }
        finally {
            cms.getRequestContext().setLocale(origLocale);
        }
    }

    private CmsContainerPageBean generateContainerPageForContainers(Collection<CmsContainer> containers, String containerpageRootPath) throws CmsException {
        ArrayList<CmsContainerBean> containerBeans = new ArrayList<CmsContainerBean>();
        for (CmsContainer container : containers) {
            CmsContainerBean containerBean = this.getContainerBeanToSave(container, containerpageRootPath);
            containerBeans.add(containerBean);
        }
        CmsContainerPageBean page = new CmsContainerPageBean(containerBeans);
        return page;
    }

    private CmsContainerElementBean getCachedElement(String clientId, String pageRootPath) throws CmsException {
        String id = clientId;
        CmsContainerElementBean element = null;
        element = this.getSessionCache().getCacheContainerElement(id);
        if (element != null) {
            return element;
        }
        if (id.contains("#")) {
            throw new CmsException(Messages.get().container("ERR_MISSING_CACHED_ELEMENT_0"));
        }
        CmsResource resource = this.getCmsObject().readResource(this.convertToServerId(id), CmsResourceFilter.IGNORE_EXPIRATION);
        CmsADEConfigData configData = this.getConfigData(pageRootPath);
        CmsResourceTypeConfig typeConfig = configData.getResourceType(OpenCms.getResourceManager().getResourceType(resource).getTypeName());
        element = new CmsContainerElementBean(this.convertToServerId(id), null, null, typeConfig != null && typeConfig.isCopyInModels());
        this.getSessionCache().setCacheContainerElement(element.editorHash(), element);
        return element;
    }

    private List<CmsContainerElementBean> getCachedElements(List<String> clientIds, String pageRootPath) throws CmsException {
        ArrayList<CmsContainerElementBean> result = new ArrayList<CmsContainerElementBean>();
        for (String id : clientIds) {
            try {
                result.add(this.getCachedElement(id, pageRootPath));
            }
            catch (CmsIllegalArgumentException e) {
                this.log(e.getLocalizedMessage(), e);
            }
        }
        return result;
    }

    private CmsADEConfigData getConfigData(String pageRootPath) {
        if (this.m_configData == null) {
            this.m_configData = OpenCms.getADEManager().lookupConfiguration(this.getCmsObject(), pageRootPath);
        }
        return this.m_configData;
    }

    private CmsContainerBean getContainerBeanToSave(CmsContainer container, String containerpageRootPath) throws CmsException {
        CmsObject cms = this.getCmsObject();
        ArrayList<CmsContainerElementBean> elements = new ArrayList<CmsContainerElementBean>();
        for (CmsContainerElement elementData : container.getElements()) {
            CmsContainerElementBean newElementBean;
            if (elementData.isNew() || (newElementBean = this.getContainerElementBeanToSave(cms, containerpageRootPath, container, elementData)) == null) continue;
            elements.add(newElementBean);
        }
        CmsContainerBean result = new CmsContainerBean(container.getName(), container.getType(), container.getParentInstanceId(), container.isRootContainer(), elements);
        return result;
    }

    private CmsContainerElementBean getContainerElementBeanToSave(CmsObject cms, String containerpageRootPath, CmsContainer container, CmsContainerElement elementData) throws CmsException {
        CmsResource resource;
        String elementClientId = elementData.getClientId();
        boolean hasUuidPrefix = elementClientId != null && elementClientId.matches("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}.*$");
        boolean isCreateNew = elementData.isCreateNew();
        if (elementData.isNew() && !hasUuidPrefix) {
            return null;
        }
        CmsContainerElementBean element = this.getCachedElement(elementData.getClientId(), containerpageRootPath);
        if (element.getResource() == null) {
            element.initResource(cms);
            resource = element.getResource();
        } else {
            if (element.getId().isNullUUID()) {
                return null;
            }
            resource = cms.readResource(element.getId(), CmsResourceFilter.IGNORE_EXPIRATION);
        }
        int containerWidth = container.getWidth();
        CmsADEConfigData config = this.getConfigData(containerpageRootPath);
        CmsFormatterConfiguration formatters = config.getFormatters(cms, resource);
        String containerType = null;
        containerType = container.getType();
        I_CmsFormatterBean formatter = null;
        String formatterConfigId = null;
        if (element.getIndividualSettings() != null && element.getIndividualSettings().get(CmsFormatterConfig.getSettingsKeyForContainer(container.getName())) != null) {
            formatterConfigId = element.getIndividualSettings().get(CmsFormatterConfig.getSettingsKeyForContainer(container.getName()));
            if (CmsUUID.isValidUUID(formatterConfigId)) {
                formatter = OpenCms.getADEManager().getCachedFormatters(false).getFormatters().get(new CmsUUID(formatterConfigId));
            } else if (formatterConfigId.startsWith("schema_formatter") && CmsUUID.isValidUUID(formatterConfigId.substring("schema_formatter".length()))) {
                formatter = formatters.getFormatterSelection(containerType, containerWidth, true).get(formatterConfigId);
            }
        }
        if (formatter == null && (formatter = CmsElementUtil.getFormatterForContainer(cms, element, container, config, true, this.getSessionCache())) != null) {
            formatterConfigId = formatter.isFromFormatterConfigFile() ? formatter.getId() : "schema_formatter" + formatter.getJspStructureId().toString();
        }
        CmsContainerElementBean newElementBean = null;
        if (formatter != null) {
            HashMap<String, String> settings = new HashMap<String, String>(element.getIndividualSettings());
            String formatterKey = CmsFormatterConfig.getSettingsKeyForContainer(container.getName());
            settings.put(formatterKey, formatterConfigId);
            Iterator entries = settings.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                if (!((String)entry.getKey()).startsWith("formatterSettings#") || ((String)entry.getKey()).equals(formatterKey)) continue;
                entries.remove();
            }
            newElementBean = new CmsContainerElementBean(element.getId(), formatter.getJspStructureId(), settings, isCreateNew);
        }
        return newElementBean;
    }

    private CmsResource getContainerpage(CmsObject cms) throws CmsException {
        String currentUri = cms.getRequestContext().getUri();
        CmsResource containerPage = cms.readResource(currentUri);
        if (!CmsResourceTypeXmlContainerPage.isContainerPage(containerPage)) {
            String cntPagePath = cms.readPropertyObject(containerPage, "template-elements", true).getValue("");
            try {
                containerPage = cms.readResource(cntPagePath);
            }
            catch (CmsException e) {
                if (!LOG.isDebugEnabled()) {
                    LOG.warn((Object)e.getLocalizedMessage());
                }
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return containerPage;
    }

    private Map<String, CmsContainerElementData> getElements(CmsResource page, Collection<String> clientIds, String uriParam, CmsUUID detailContentId, Collection<CmsContainer> containers, boolean allowNested, boolean allwaysCopy, String dndOriginContainer, boolean isDragMode, Locale locale) throws CmsException {
        CmsObject cms = this.getCmsObject();
        CmsContainerPageBean pageBean = this.generateContainerPageForContainers(containers, cms.getRequestContext().addSiteRoot(uriParam));
        HashMap<String, CmsContainerElementBean> idMapping = new HashMap<String, CmsContainerElementBean>();
        for (String elemId : clientIds) {
            if (elemId == null) continue;
            CmsContainerElementBean element = this.getCachedElement(elemId, cms.getRequestContext().addSiteRoot(uriParam));
            if (element.getInstanceId() == null) {
                element = element.clone();
                this.getSessionCache().setCacheContainerElement(element.editorHash(), element);
            }
            element.initResource(cms);
            idMapping.put(elemId, element);
        }
        ArrayList<String> foundGroups = new ArrayList<String>();
        if ("cms_edit_menu_container".equals(dndOriginContainer)) {
            CmsModelGroupHelper modelHelper = new CmsModelGroupHelper(cms, this.getConfigData(uriParam), this.getSessionCache(), CmsContainerpageService.isEditingModelGroups(cms, page));
            pageBean = modelHelper.prepareforModelGroupContent(idMapping, foundGroups, pageBean, allwaysCopy, locale);
        }
        CmsElementUtil elemUtil = new CmsElementUtil(cms, uriParam, pageBean, detailContentId, this.getRequest(), this.getResponse(), isDragMode, locale);
        HashMap<String, CmsContainerElementData> result = new HashMap<String, CmsContainerElementData>();
        HashSet<String> ids = new HashSet<String>();
        for (Map.Entry entry : idMapping.entrySet()) {
            CmsContainerElementData elementData;
            CmsContainerElementBean element = (CmsContainerElementBean)entry.getValue();
            String dndId = null;
            if (ids.contains(element.editorHash())) continue;
            if (dndOriginContainer != null && !"cms_edit_menu_container".equals(dndOriginContainer)) {
                CmsFormatterConfiguration formatterConfig = elemUtil.getFormatterConfiguration(element.getResource());
                Map<String, String> dndSettings = this.getSettingsToChangeForDnd(element.getIndividualSettings(), formatterConfig, containers, dndOriginContainer, allowNested);
                if (!dndSettings.isEmpty()) {
                    CmsContainerElementBean dndElementBean = this.overrideSettings(element, dndSettings);
                    this.getSessionCache().setCacheContainerElement(dndElementBean.editorHash(), dndElementBean);
                    dndId = dndElementBean.editorHash();
                    Map<String, CmsContainerElementData> dndResults = this.getElements(page, Arrays.asList(dndId), uriParam, detailContentId, containers, allowNested, false, null, isDragMode, locale);
                    result.putAll(dndResults);
                }
            }
            if ((elementData = elemUtil.getElementData(page, element, containers, allowNested)) == null) continue;
            elementData.setDndId(dndId);
            result.put((String)entry.getKey(), elementData);
            if (elementData.isGroupContainer() || elementData.isInheritContainer()) {
                CmsResource elementRes = cms.readResource(element.getId());
                List<CmsContainerElementBean> subElements = elementData.isGroupContainer() ? this.getGroupContainerElements(elementRes) : this.getInheritedElements(elementRes, locale, uriParam);
                for (CmsContainerElementBean subElement : subElements) {
                    this.getSessionCache().setCacheContainerElement(subElement.editorHash(), subElement);
                    if (ids.contains(subElement.editorHash())) continue;
                    CmsContainerElementData subItemData = elemUtil.getElementData(page, subElement, containers, allowNested);
                    ids.add(subElement.editorHash());
                    result.put(subElement.editorHash(), subItemData);
                }
            }
            ids.add(element.editorHash());
        }
        for (CmsContainerElementData elementData : result.values()) {
            elementData.setGroup(foundGroups.contains(elementData.getClientId()));
        }
        return result;
    }

    private CmsGroupContainerBean getGroupContainerBean(CmsGroupContainer groupContainer, CmsResource containerPage, String locale) {
        CmsObject cms = this.getCmsObject();
        ArrayList<CmsContainerElementBean> elements = new ArrayList<CmsContainerElementBean>();
        for (CmsContainerElement elementData : groupContainer.getElements()) {
            try {
                CmsContainerElementBean element;
                if (elementData.isNew()) {
                    elementData = this.createNewElement(containerPage.getStructureId(), elementData.getClientId(), elementData.getResourceType(), null, locale);
                }
                if (!cms.existsResource((element = this.getCachedElement(elementData.getClientId(), containerPage.getRootPath())).getId(), CmsResourceFilter.IGNORE_EXPIRATION)) continue;
                elements.add(element);
            }
            catch (Exception e) {
                this.log(e.getLocalizedMessage(), e);
            }
        }
        return new CmsGroupContainerBean(groupContainer.getTitle(), groupContainer.getDescription(), elements, groupContainer.getTypes());
    }

    private List<CmsContainerElementBean> getGroupContainerElements(CmsResource resource) throws CmsException {
        CmsXmlGroupContainer xmlGroupContainer = CmsXmlGroupContainerFactory.unmarshal(this.getCmsObject(), resource, (ServletRequest)this.getRequest());
        CmsGroupContainerBean groupContainer = xmlGroupContainer.getGroupContainer(this.getCmsObject());
        return groupContainer.getElements();
    }

    private Set<CmsUUID> getGroupElementIds(CmsXmlGroupContainer groupContainer, Locale locale) {
        HashSet<CmsUUID> idSet = new HashSet<CmsUUID>();
        CmsGroupContainerBean groupContainerBean = groupContainer.getGroupContainer(this.getCmsObject());
        if (groupContainerBean != null) {
            for (CmsContainerElementBean element : groupContainerBean.getElements()) {
                idSet.add(element.getId());
            }
        }
        return idSet;
    }

    private List<CmsContainerElementBean> getInheritedElements(CmsResource resource, Locale locale, String uriParam) throws CmsException {
        CmsObject cms = this.getCmsObject();
        cms.getRequestContext().setLocale(locale);
        CmsInheritanceReferenceParser parser = new CmsInheritanceReferenceParser(cms);
        parser.parse(resource);
        CmsInheritanceReference ref = parser.getReference(locale);
        if (ref == null) {
            return Collections.emptyList();
        }
        String name = ref.getName();
        CmsADEManager adeManager = OpenCms.getADEManager();
        CmsInheritedContainerState result = adeManager.getInheritedContainerState(cms, cms.addSiteRoot(uriParam), name);
        return result.getElements(true);
    }

    private List<CmsContainerElementData> getListElementsData(List<CmsContainerElementBean> listElements, String containerpageUri, CmsUUID detailContentId, Collection<CmsContainer> containers, boolean allowNested, Locale locale) throws CmsException {
        CmsObject cms = this.getCmsObject();
        CmsElementUtil elemUtil = new CmsElementUtil(cms, containerpageUri, this.generateContainerPageForContainers(containers, cms.getRequestContext().addSiteRoot(containerpageUri)), detailContentId, this.getRequest(), this.getResponse(), true, locale);
        CmsADESessionCache cache = this.getSessionCache();
        ArrayList<CmsContainerElementData> result = new ArrayList<CmsContainerElementData>();
        for (CmsContainerElementBean element : listElements) {
            if (!cms.existsResource(element.getId(), CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireFile())) continue;
            cache.setCacheContainerElement(element.editorHash(), element);
            CmsContainerElementData elementData = elemUtil.getElementData(elemUtil.getPage(), element, containers, allowNested);
            result.add(elementData);
        }
        return result;
    }

    private String getLockInfo(CmsResource resource) throws CmsException {
        CmsObject cms = this.getCmsObject();
        CmsResourceUtil resourceUtil = new CmsResourceUtil(cms, resource);
        CmsLock lock = resourceUtil.getLock();
        String lockInfo = null;
        if (!lock.isLockableBy(cms.getRequestContext().getCurrentUser())) {
            if (lock.getType() == CmsLockType.PUBLISH) {
                lockInfo = Messages.get().getBundle(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms)).key("GUI_LOCKED_FOR_PUBLISH_0");
            } else {
                CmsUser lockOwner = cms.readUser(lock.getUserId());
                lockInfo = Messages.get().getBundle(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms)).key("GUI_LOCKED_BY_1", lockOwner.getFullName());
            }
        }
        return lockInfo;
    }

    private CmsContainerElementData getNewElement(String resourceTypeName, String uriParam, CmsUUID detailContentId, Collection<CmsContainer> containers, boolean allowNested, Locale locale) throws CmsException {
        CmsObject cms = this.getCmsObject();
        CmsElementUtil elemUtil = new CmsElementUtil(cms, uriParam, this.generateContainerPageForContainers(containers, cms.getRequestContext().addSiteRoot(uriParam)), detailContentId, this.getRequest(), this.getResponse(), true, locale);
        CmsADEConfigData configData = this.getConfigData(cms.getRequestContext().addSiteRoot(uriParam));
        CmsResourceTypeConfig typeConfig = configData.getResourceType(resourceTypeName);
        CmsContainerElementBean elementBean = CmsContainerElementBean.createElementForResourceType(cms, OpenCms.getResourceManager().getResourceType(resourceTypeName), "/", Collections.emptyMap(), typeConfig.isCopyInModels(), locale);
        CmsContainerElementData data = elemUtil.getElementData(elemUtil.getPage(), elementBean, containers, allowNested);
        data.setClientId(elementBean.editorHash());
        this.getSessionCache().setCacheContainerElement(resourceTypeName, elementBean);
        this.getSessionCache().setCacheContainerElement(elementBean.editorHash(), elementBean);
        return data;
    }

    private String getNoEditReason(CmsObject cms, CmsResource containerPage) throws CmsException {
        return new CmsResourceUtil(cms, containerPage).getNoEditReason(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms));
    }

    private CmsADESessionCache getSessionCache() {
        if (this.m_sessionCache == null) {
            this.m_sessionCache = CmsADESessionCache.getCache(this.getRequest(), this.getCmsObject());
        }
        return this.m_sessionCache;
    }

    private CmsWorkplaceSettings getWorkplaceSettings() {
        if (this.m_workplaceSettings == null) {
            this.m_workplaceSettings = CmsWorkplace.getWorkplaceSettings(this.getCmsObject(), this.getRequest());
        }
        return this.m_workplaceSettings;
    }

    private boolean hasCompatibleSearchData(CmsGalleryDataBean originalGalleryData, CmsGalleryDataBean data, CmsGallerySearchBean search) {
        HashSet originalUsableTypes = Sets.newHashSet();
        HashSet usableTypes = Sets.newHashSet();
        for (CmsResourceTypeBean type : originalGalleryData.getTypes()) {
            if (type.isDeactivated()) continue;
            originalUsableTypes.add(type.getType());
        }
        for (CmsResourceTypeBean type : data.getTypes()) {
            if (type.isDeactivated()) continue;
            usableTypes.add(type.getType());
        }
        return usableTypes.containsAll(originalUsableTypes);
    }

    private void initRequestFromRpcContext(CmsContainerPageRpcContext context) {
        if (context.getTemplateContext() != null) {
            this.getRequest().setAttribute("ATTR_RPC_CONTEXT_OVERRIDE", (Object)context.getTemplateContext());
        }
    }

    private CmsPair<CmsContainerElement, List<CmsRemovedElementStatus>> internalSaveGroupContainer(CmsObject cms, CmsUUID pageStructureId, CmsGroupContainer groupContainer) throws CmsException, CmsXmlException {
        this.ensureSession();
        CmsResource pageResource = this.getCmsObject().readResource(pageStructureId, CmsResourceFilter.IGNORE_EXPIRATION);
        CmsResource groupContainerResource = null;
        if (groupContainer.isNew()) {
            CmsADEConfigData config = this.getConfigData(pageResource.getRootPath());
            CmsResourceTypeConfig typeConfig = config.getResourceType("groupcontainer");
            groupContainerResource = typeConfig.createNewElement(this.getCmsObject(), pageResource.getRootPath());
            String resourceName = cms.getSitePath(groupContainerResource);
            groupContainer.setSitePath(resourceName);
            groupContainer.setClientId(groupContainerResource.getStructureId().toString());
        }
        if (groupContainerResource == null) {
            CmsUUID id = this.convertToServerId(groupContainer.getClientId());
            groupContainerResource = cms.readResource(id, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
        }
        CmsGroupContainerBean groupContainerBean = this.getGroupContainerBean(groupContainer, pageResource, Locale.ENGLISH.toString());
        cms.lockResourceTemporary(groupContainerResource);
        CmsFile groupContainerFile = cms.readFile(groupContainerResource);
        Locale locale = Locale.ENGLISH;
        CmsXmlGroupContainer xmlGroupContainer = CmsXmlGroupContainerFactory.unmarshal(cms, groupContainerFile);
        Set<CmsUUID> oldElementIds = this.getGroupElementIds(xmlGroupContainer, locale);
        xmlGroupContainer.clearLocales();
        xmlGroupContainer.save(cms, groupContainerBean, locale);
        cms.unlockResource(groupContainerResource);
        Set<CmsUUID> newElementIds = this.getGroupElementIds(xmlGroupContainer, locale);
        Sets.SetView removedElementIds = Sets.difference(oldElementIds, newElementIds);
        ArrayList<CmsRemovedElementStatus> deletionCandidateStatuses = new ArrayList<CmsRemovedElementStatus>();
        for (CmsUUID removedId : removedElementIds) {
            CmsRemovedElementStatus status = this.internalGetRemovedElementStatus(removedId, null);
            if (!status.isDeletionCandidate()) continue;
            deletionCandidateStatuses.add(status);
        }
        CmsContainerElement element = new CmsContainerElement();
        element.setClientId(groupContainerFile.getStructureId().toString());
        element.setSitePath(cms.getSitePath(groupContainerFile));
        element.setResourceType("groupcontainer");
        return CmsPair.create(element, deletionCandidateStatuses);
    }

    private boolean isEditSmallElements(HttpServletRequest request, CmsObject cms) {
        CmsUser user = cms.getRequestContext().getCurrentUser();
        String editSmallElementsStr = (String)user.getAdditionalInfo().get(ADDINFO_EDIT_SMALL_ELEMENTS);
        if (editSmallElementsStr == null) {
            return true;
        }
        return Boolean.valueOf(editSmallElementsStr);
    }

    private boolean isModelPage(CmsObject cms, CmsResource containerPage) {
        CmsADEConfigData config = this.getConfigData(containerPage.getRootPath());
        for (CmsModelPageConfig modelConfig : config.getModelPages()) {
            if (!modelConfig.getResource().getStructureId().equals(containerPage.getStructureId())) continue;
            return true;
        }
        return false;
    }

    private void saveContainers(CmsObject cms, CmsResource containerpage, String containerpageUri, List<CmsContainer> containers) throws CmsException {
        CmsContainerPageBean page = this.generateContainerPageForContainers(containers, containerpage.getRootPath());
        CmsModelGroupHelper modelHelper = new CmsModelGroupHelper(this.getCmsObject(), this.getConfigData(containerpage.getRootPath()), this.getSessionCache(), CmsContainerpageService.isEditingModelGroups(cms, containerpage));
        page = CmsContainerpageService.isEditingModelGroups(cms, containerpage) ? modelHelper.saveModelGroups(page, containerpage) : modelHelper.removeModelGroupContainers(page);
        CmsXmlContainerPage xmlCnt = CmsXmlContainerPageFactory.unmarshal(cms, cms.readFile(containerpageUri));
        xmlCnt.save(cms, page);
    }

    private void saveInheritanceGroup(CmsResource resource, CmsInheritanceContainer inheritanceContainer) throws CmsException {
        CmsObject cms = this.getCmsObject();
        CmsFile file = cms.readFile(resource);
        CmsXmlContent document = CmsXmlContentFactory.unmarshal(cms, file);
        for (Locale docLocale : document.getLocales()) {
            document.removeLocale(docLocale);
        }
        Locale locale = Locale.ENGLISH;
        document.addLocale(cms, locale);
        document.getValue("Title", locale).setStringValue(cms, inheritanceContainer.getTitle());
        document.getValue("Description", locale).setStringValue(cms, inheritanceContainer.getDescription());
        document.getValue("ConfigName", locale).setStringValue(cms, inheritanceContainer.getName());
        byte[] content = document.marshal();
        file.setContents(content);
        cms.writeFile(file);
    }

    private List<CmsContainerElementBean> updateFavoriteRecentList(CmsResource containerPage, String clientId, List<CmsContainerElementBean> list) throws CmsException {
        try {
            CmsContainerElementBean element = this.getCachedElement(clientId, containerPage.getRootPath());
            HashMap<String, String> settings = new HashMap<String, String>(element.getIndividualSettings());
            String formatterID = null;
            Iterator entries = settings.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                if (!((String)entry.getKey()).startsWith("formatterSettings#")) continue;
                formatterID = (String)entry.getValue();
                entries.remove();
            }
            settings.put("formatterSettings#", formatterID);
            settings.put(SOURCE_CONTAINERPAGE_ID_SETTING, containerPage.getStructureId().toString());
            element = CmsContainerElementBean.cloneWithSettings(element, settings);
            Iterator<CmsContainerElementBean> listIt = list.iterator();
            while (listIt.hasNext()) {
                CmsContainerElementBean listElem = listIt.next();
                if (!element.getInstanceId().equals(listElem.getInstanceId())) continue;
                listIt.remove();
            }
            list.add(0, element);
            return list;
        }
        catch (CmsVfsResourceNotFoundException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            return list;
        }
    }

    private class InitialElementViewProvider {
        private CmsUUID m_defaultView;
        private Map<CmsUUID, CmsElementViewInfo> m_viewMap;

        public CmsElementViewInfo getDefaultView() {
            return this.getViewMap().get(this.getDefaultViewId());
        }

        public CmsUUID getDefaultViewId() {
            return this.m_defaultView;
        }

        public Map<CmsUUID, CmsElementViewInfo> getViewMap() {
            return this.m_viewMap;
        }

        public void init(CmsUUID defaultValue, CmsResource checkRes) {
            LinkedHashMap<CmsUUID, CmsElementViewInfo> result = new LinkedHashMap<CmsUUID, CmsElementViewInfo>();
            CmsObject cms = CmsContainerpageService.this.getCmsObject();
            CmsADEConfigData config = CmsContainerpageService.this.getConfigData(cms.getRequestContext().addSiteRoot(cms.getRequestContext().getUri()));
            HashSet<CmsUUID> usedIds = new HashSet<CmsUUID>();
            for (CmsResourceTypeConfig typeConfig : config.getResourceTypes()) {
                usedIds.add(typeConfig.getElementView());
            }
            Locale wpLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
            Map<CmsUUID, CmsElementView> realViewMap = OpenCms.getADEManager().getElementViews(cms);
            HashSet parentIds = Sets.newHashSet();
            for (CmsElementView cmsElementView : realViewMap.values()) {
                if (cmsElementView.getParentViewId() != null) {
                    parentIds.add(cmsElementView.getParentViewId());
                }
                if (!usedIds.contains(cmsElementView.getId()) || !cmsElementView.hasPermission(cms, checkRes) || cmsElementView.isOther()) continue;
                result.put(cmsElementView.getId(), new CmsElementViewInfo(cmsElementView.getTitle(cms, wpLocale), cmsElementView.getId()));
            }
            this.m_viewMap = result;
            for (Map.Entry entry : this.m_viewMap.entrySet()) {
                CmsElementViewInfo parentBean;
                CmsElementView realView = realViewMap.get(entry.getKey());
                CmsUUID parentViewId = realView.getParentViewId();
                if (parentViewId == null || parentIds.contains(entry.getKey()) || (parentBean = this.m_viewMap.get(parentViewId)) == null) continue;
                ((CmsElementViewInfo)entry.getValue()).setParent(parentBean);
            }
            if (this.m_viewMap.containsKey(defaultValue)) {
                this.m_defaultView = defaultValue;
            } else if (this.m_viewMap.containsKey(CmsElementView.DEFAULT_ELEMENT_VIEW.getId())) {
                this.m_defaultView = CmsElementView.DEFAULT_ELEMENT_VIEW.getId();
            } else if (!this.m_viewMap.isEmpty()) {
                this.m_defaultView = this.m_viewMap.values().iterator().next().getElementViewId();
            } else {
                this.m_defaultView = defaultValue;
                LOG.error((Object)("Initial view not available and no suitable replacement view found: user=" + CmsContainerpageService.this.getCmsObject().getRequestContext().getCurrentUser().getName() + " view=" + defaultValue + " path=" + checkRes.getRootPath()));
            }
        }
    }
}

