/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.containerpage.inherited;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsSynchronizedUpdateSet;
import org.opencms.ade.configuration.I_CmsGlobalConfigurationCache;
import org.opencms.ade.containerpage.inherited.CmsContainerConfigurationCacheState;
import org.opencms.ade.containerpage.inherited.CmsContainerConfigurationGroup;
import org.opencms.ade.containerpage.inherited.CmsContainerConfigurationParser;
import org.opencms.db.CmsPublishedResource;
import org.opencms.db.CmsResourceState;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsUUID;

public class CmsContainerConfigurationCache
implements I_CmsGlobalConfigurationCache {
    public static final long UPDATE_INTERVAL_MILLIS = 500L;
    public static final String INHERITANCE_CONFIG_FILE_NAME = ".inherited";
    public static final CmsUUID UPDATE_ALL = CmsUUID.getNullUUID();
    public static final Log LOG = CmsLog.getLog(CmsContainerConfigurationCache.class);
    protected boolean m_initialized;
    private CmsObject m_cms;
    private String m_name;
    private volatile CmsContainerConfigurationCacheState m_state = new CmsContainerConfigurationCacheState(new ArrayList<CmsContainerConfigurationGroup>());
    private ScheduledFuture<?> m_taskFuture;
    private CmsSynchronizedUpdateSet<CmsUUID> m_updateSet = new CmsSynchronizedUpdateSet();

    public CmsContainerConfigurationCache(CmsObject cms, String name) throws CmsException {
        this.m_cms = OpenCms.initCmsObject(cms);
        this.m_name = name;
    }

    @Override
    public synchronized void clear() {
        this.m_updateSet.add(UPDATE_ALL);
    }

    public synchronized void flushUpdates() {
        Set<CmsUUID> updateIds = this.m_updateSet.removeAll();
        if (!updateIds.isEmpty()) {
            if (updateIds.contains(UPDATE_ALL)) {
                this.initialize();
            } else {
                CmsContainerConfigurationCacheState state;
                Map<CmsUUID, CmsContainerConfigurationGroup> groups = this.loadFromIds(updateIds);
                this.m_state = state = this.m_state.updateWithChangedGroups(groups);
            }
        }
    }

    public CmsContainerConfigurationCacheState getState() {
        return this.m_state;
    }

    public synchronized void initialize() {
        LOG.info((Object)("Initializing inheritance group cache: " + this.m_name));
        if (this.m_taskFuture != null) {
            this.m_taskFuture.cancel(false);
            this.m_taskFuture = null;
        }
        if (this.m_cms.existsResource("/", CmsResourceFilter.IGNORE_EXPIRATION)) {
            try {
                List<CmsResource> resources = this.m_cms.readResources("/", CmsResourceFilter.IGNORE_EXPIRATION.addRequireType(OpenCms.getResourceManager().getResourceType("inheritance_config")), true);
                this.m_state = new CmsContainerConfigurationCacheState(this.load(resources).values());
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        Runnable updateAction = new Runnable(){

            @Override
            public void run() {
                try {
                    CmsContainerConfigurationCache.this.flushUpdates();
                }
                catch (Throwable e) {
                    LOG.error((Object)e.getLocalizedMessage(), e);
                }
            }
        };
        this.m_taskFuture = OpenCms.getExecutor().scheduleWithFixedDelay(updateAction, 500L, 500L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void remove(CmsPublishedResource resource) {
        this.remove(resource.getStructureId(), resource.getRootPath(), resource.getType());
    }

    @Override
    public void remove(CmsResource resource) {
        this.remove(resource.getStructureId(), resource.getRootPath(), resource.getTypeId());
    }

    @Override
    public void update(CmsPublishedResource resource) {
        this.update(resource.getStructureId(), resource.getRootPath(), resource.getType(), resource.getState());
    }

    @Override
    public void update(CmsResource resource) {
        this.update(resource.getStructureId(), resource.getRootPath(), resource.getTypeId(), resource.getState());
    }

    protected String getBasePath(String rootPath) {
        if (rootPath.endsWith(INHERITANCE_CONFIG_FILE_NAME)) {
            return rootPath.substring(0, rootPath.length() - INHERITANCE_CONFIG_FILE_NAME.length());
        }
        return rootPath;
    }

    protected String getCacheKey(String basePath) {
        assert (!basePath.endsWith(INHERITANCE_CONFIG_FILE_NAME));
        return CmsFileUtil.addTrailingSeparator(basePath);
    }

    protected boolean isContainerConfiguration(String rootPath, int type) {
        return OpenCms.getResourceManager().matchResourceType("inheritance_config", type) && !CmsResource.isTemporaryFileName(rootPath) && rootPath.endsWith("/.inherited");
    }

    protected Map<CmsUUID, CmsContainerConfigurationGroup> load(Collection<CmsResource> resources) {
        HashMap result = Maps.newHashMap();
        for (CmsResource resource : resources) {
            CmsContainerConfigurationGroup parsedGroup = null;
            try {
                CmsFile file = this.m_cms.readFile(resource);
                CmsContainerConfigurationParser parser = new CmsContainerConfigurationParser(this.m_cms);
                parser.parse(file);
                parsedGroup = new CmsContainerConfigurationGroup(parser.getParsedResults());
                parsedGroup.setResource(resource);
            }
            catch (CmsVfsResourceNotFoundException e) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (Throwable e) {
                LOG.error((Object)e.getLocalizedMessage(), e);
            }
            result.put(resource.getStructureId(), parsedGroup);
        }
        return result;
    }

    protected Map<CmsUUID, CmsContainerConfigurationGroup> loadFromIds(Collection<CmsUUID> structureIds) {
        HashMap result = Maps.newHashMap();
        for (CmsUUID id : structureIds) {
            CmsContainerConfigurationGroup parsedGroup = null;
            try {
                CmsResource resource = this.m_cms.readResource(id, CmsResourceFilter.IGNORE_EXPIRATION);
                CmsFile file = this.m_cms.readFile(resource);
                CmsContainerConfigurationParser parser = new CmsContainerConfigurationParser(this.m_cms);
                parser.parse(file);
                parsedGroup = new CmsContainerConfigurationGroup(parser.getParsedResults());
                parsedGroup.setResource(resource);
            }
            catch (CmsVfsResourceNotFoundException e) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (Throwable e) {
                LOG.error((Object)e.getLocalizedMessage(), e);
            }
            result.put(id, parsedGroup);
        }
        return result;
    }

    protected void remove(CmsUUID structureId, String rootPath, int type) {
        if (!this.isContainerConfiguration(rootPath, type)) {
            return;
        }
        this.m_updateSet.add(structureId);
    }

    protected void update(CmsUUID structureId, String rootPath, int type, CmsResourceState state) {
        if (!this.isContainerConfiguration(rootPath, type)) {
            return;
        }
        this.m_updateSet.add(structureId);
    }
}

