/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.containerpage.inherited;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.ade.containerpage.inherited.CmsContainerConfiguration;
import org.opencms.ade.containerpage.inherited.CmsContainerConfigurationGroup;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsUUID;

public class CmsContainerConfigurationCacheState {
    public static final String INHERITANCE_CONFIG_FILE_NAME = ".inherited";
    public static final Log LOG = CmsLog.getLog(CmsContainerConfigurationCacheState.class);
    private Map<CmsUUID, CmsContainerConfigurationGroup> m_configurationsById = new HashMap<CmsUUID, CmsContainerConfigurationGroup>();
    private Map<String, CmsContainerConfigurationGroup> m_configurationsByPath = new HashMap<String, CmsContainerConfigurationGroup>();

    public CmsContainerConfigurationCacheState(Collection<CmsContainerConfigurationGroup> groups) {
        for (CmsContainerConfigurationGroup group : groups) {
            if (group == null) continue;
            this.m_configurationsByPath.put(this.getBasePath(group.getRootPath()), group);
            this.m_configurationsById.put(group.getStructureId(), group);
        }
    }

    public synchronized CmsContainerConfiguration getContainerConfiguration(String rootPath, String name) {
        String key = this.getCacheKey(rootPath);
        if (this.m_configurationsByPath.containsKey(key)) {
            CmsContainerConfigurationGroup group = this.m_configurationsByPath.get(key);
            CmsContainerConfiguration result = group.getConfiguration(name);
            return result;
        }
        return null;
    }

    public CmsContainerConfigurationCacheState updateWithChangedGroups(Map<CmsUUID, CmsContainerConfigurationGroup> updateGroups) {
        HashMap newGroups = Maps.newHashMap(this.m_configurationsById);
        for (Map.Entry<CmsUUID, CmsContainerConfigurationGroup> entry : updateGroups.entrySet()) {
            CmsUUID key = entry.getKey();
            CmsContainerConfigurationGroup group = entry.getValue();
            if (group == null) {
                newGroups.remove(key);
                continue;
            }
            newGroups.put(key, group);
        }
        return new CmsContainerConfigurationCacheState(newGroups.values());
    }

    protected String getBasePath(String rootPath) {
        if (rootPath.endsWith(INHERITANCE_CONFIG_FILE_NAME)) {
            return rootPath.substring(0, rootPath.length() - INHERITANCE_CONFIG_FILE_NAME.length());
        }
        return rootPath;
    }

    protected String getCacheKey(String basePath) {
        assert (!basePath.endsWith(INHERITANCE_CONFIG_FILE_NAME));
        return CmsFileUtil.addTrailingSeparator(basePath);
    }
}

