/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.containerpage.inherited;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.dom4j.Element;
import org.opencms.ade.containerpage.inherited.CmsContainerConfiguration;
import org.opencms.ade.containerpage.inherited.CmsInheritedContainerState;
import org.opencms.ade.containerpage.shared.CmsInheritanceInfo;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelationType;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.content.CmsXmlContentProperty;
import org.opencms.xml.content.CmsXmlContentPropertyHelper;
import org.opencms.xml.types.CmsXmlVfsFileValue;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsContainerConfigurationWriter {
    private static final Log LOG = CmsLog.getLog(CmsContainerConfigurationWriter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(CmsObject cms, String name, boolean newOrdering, CmsResource pageResource, List<CmsContainerElementBean> elements) throws CmsException {
        cms = OpenCms.initCmsObject(cms);
        cms.getRequestContext().setSiteRoot("");
        String configPath = pageResource.isFolder() ? CmsStringUtil.joinPaths(pageResource.getRootPath(), ".inherited") : CmsStringUtil.joinPaths(CmsResource.getParentFolder(pageResource.getRootPath()), ".inherited");
        CmsInheritedContainerState state = OpenCms.getADEManager().getInheritedContainerState(cms, CmsResource.getParentFolder(CmsResource.getParentFolder(configPath)), name);
        Set<String> keys = state.getNewElementKeys();
        CmsResource configRes = null;
        boolean needToUnlock = false;
        if (!cms.existsResource(configPath)) {
            configRes = cms.createResource(configPath, OpenCms.getResourceManager().getResourceType("inheritance_config"));
            needToUnlock = true;
        }
        if (configRes == null) {
            configRes = cms.readResource(configPath);
        }
        CmsFile configFile = cms.readFile(configRes);
        configFile.setFlags(configFile.getFlags() | 0x200);
        CmsXmlContent content = CmsXmlContentFactory.unmarshal(cms, configFile);
        for (Locale localeToRemoveEntryFrom : content.getLocales()) {
            this.removeExistingEntry(cms, content, localeToRemoveEntryFrom, name);
        }
        CmsContainerConfiguration configuration = this.createConfigurationBean(newOrdering, elements, keys);
        Locale saveLocale = Locale.ENGLISH;
        for (Locale locale : content.getLocales()) {
            if (saveLocale.equals(locale)) continue;
            content.removeLocale(locale);
        }
        if (!content.hasLocale(saveLocale)) {
            content.addLocale(cms, saveLocale);
        }
        Element parentElement = content.getLocaleNode(saveLocale);
        this.serializeSingleConfiguration(cms, name, configuration, parentElement);
        byte[] contentBytes = content.marshal();
        configFile.setContents(contentBytes);
        CmsLock prevLock = cms.getLock(configRes);
        boolean alreadyLocked = prevLock.isOwnedBy(cms.getRequestContext().getCurrentUser());
        if (!alreadyLocked) {
            cms.lockResourceTemporary(configRes);
            needToUnlock = true;
        }
        try {
            cms.writeFile(configFile);
        }
        finally {
            if (needToUnlock) {
                cms.unlockResource(configRes);
            }
        }
    }

    public Element serializeSingleConfiguration(CmsObject cms, String name, CmsContainerConfiguration config, Element parentElement) throws CmsException {
        ArrayList<String> visibles = new ArrayList<String>();
        ArrayList<String> invisibles = new ArrayList<String>();
        for (String key : config.getVisibility().keySet()) {
            Boolean bl = config.getVisibility().get(key);
            if (bl.booleanValue()) {
                visibles.add(key);
                continue;
            }
            invisibles.add(key);
        }
        if (config.getOrdering().isEmpty() && visibles.isEmpty() && invisibles.isEmpty() && config.getNewElements().isEmpty()) {
            return null;
        }
        Element root = parentElement.addElement("Configuration");
        root.addElement("Name").addCDATA(name);
        for (String string : config.getOrdering()) {
            root.addElement("OrderKey").addCDATA(string);
        }
        for (String string : visibles) {
            root.addElement("Visible").addCDATA(string);
        }
        for (String string : invisibles) {
            root.addElement("Hidden").addCDATA(string);
        }
        for (Map.Entry entry : config.getNewElements().entrySet()) {
            String key = (String)entry.getKey();
            CmsContainerElementBean elementBean = (CmsContainerElementBean)entry.getValue();
            elementBean.initResource(cms);
            Map<String, CmsXmlContentProperty> settingConfiguration = this.getSettingConfiguration(cms, elementBean.getResource());
            CmsUUID structureId = elementBean.getId();
            Map<String, String> settings = elementBean.getIndividualSettings();
            Element newElementElement = root.addElement("NewElement");
            newElementElement.addElement("Key").addCDATA(key);
            Element elementElement = newElementElement.addElement("Element");
            Element uriElement = elementElement.addElement("Uri");
            CmsXmlVfsFileValue.fillEntry(uriElement, structureId, "", CmsRelationType.XML_STRONG);
            CmsXmlContentPropertyHelper.saveProperties(cms, elementElement, settings, settingConfiguration);
        }
        return root;
    }

    protected CmsContainerConfiguration createConfigurationBean(boolean newOrdering, List<CmsContainerElementBean> elements, Set<String> parentKeys) {
        CmsInheritanceInfo info;
        HashMap<String, CmsContainerElementBean> newElements = new HashMap<String, CmsContainerElementBean>();
        ArrayList<String> ordering = new ArrayList<String>();
        HashMap<String, Boolean> visibility = new HashMap<String, Boolean>();
        for (CmsContainerElementBean elementBean : elements) {
            info = elementBean.getInheritanceInfo();
            if (!info.isNew()) continue;
            newElements.put(info.getKey(), elementBean);
        }
        if (newOrdering) {
            for (CmsContainerElementBean elementBean : elements) {
                info = elementBean.getInheritanceInfo();
                if (!parentKeys.contains(info.getKey()) && !newElements.containsKey(info.getKey())) continue;
                ordering.add(info.getKey());
            }
        }
        for (CmsContainerElementBean elementBean : elements) {
            info = elementBean.getInheritanceInfo();
            if (info.isVisible() == info.isParentVisible()) continue;
            visibility.put(info.getKey(), new Boolean(info.isVisible()));
        }
        CmsContainerConfiguration configuration = new CmsContainerConfiguration(ordering, visibility, newElements);
        return configuration;
    }

    protected Map<String, CmsXmlContentProperty> getSettingConfiguration(CmsObject cms, CmsResource resource) throws CmsException {
        return OpenCms.getADEManager().getElementSettings(cms, resource);
    }

    protected void removeExistingEntry(CmsObject cms, CmsXmlContent content, Locale locale, String name) {
        if (!content.hasLocale(locale)) {
            return;
        }
        String entriesXpath = "Configuration";
        List<I_CmsXmlContentValue> values = content.getValues(entriesXpath, locale);
        int valueIndex = 0;
        for (I_CmsXmlContentValue value : values) {
            String valueXpath = value.getPath();
            I_CmsXmlContentValue nameValue = content.getValue(CmsXmlUtils.concatXpath(valueXpath, "Name"), locale);
            String currentName = nameValue.getStringValue(cms);
            if (currentName.equals(name)) {
                content.removeValue(valueXpath, locale, valueIndex);
                break;
            }
            ++valueIndex;
        }
    }

    protected CmsXmlContent saveInContentObject(CmsObject cms, CmsXmlContent content, Locale locale, String name, CmsContainerConfiguration configuration) throws CmsException {
        if (content == null) {
            content = CmsXmlContentFactory.createDocument(cms, locale, (CmsResourceTypeXmlContent)OpenCms.getResourceManager().getResourceType("inheritance_config"));
        }
        if (!content.hasLocale(locale)) {
            content.addLocale(cms, locale);
        }
        Element parentElement = content.getLocaleNode(locale);
        this.serializeSingleConfiguration(cms, name, configuration, parentElement);
        return content;
    }
}

