/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.publish.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.ArrayList;
import java.util.List;
import org.opencms.ade.publish.shared.CmsPublishResourceInfo;
import org.opencms.db.CmsResourceState;
import org.opencms.gwt.shared.CmsPermissionInfo;
import org.opencms.util.CmsUUID;

public class CmsPublishResource
implements IsSerializable {
    private long m_dateLastModified;
    private String m_dateLastModifiedStr;
    private String m_detailResourceType;
    private CmsUUID m_id;
    private CmsPublishResourceInfo m_info;
    private String m_name;
    private CmsPermissionInfo m_permissionInfo;
    private List<CmsPublishResource> m_related;
    private boolean m_removable;
    private String m_resourceType;
    private CmsResourceState m_state;
    private String m_title;
    private String m_userLastModified;

    public CmsPublishResource(CmsUUID id, String name, String title, String resourceType, String detailResourceType, CmsResourceState state, CmsPermissionInfo permissionInfo, long dateLastModified, String userLastModified, String dateLastModifiedStr, boolean removable, CmsPublishResourceInfo info, List<CmsPublishResource> related) {
        this.m_resourceType = resourceType;
        this.m_detailResourceType = detailResourceType;
        this.m_id = id;
        this.m_name = name;
        this.m_related = related == null ? new ArrayList() : related;
        this.m_state = state;
        this.m_permissionInfo = permissionInfo;
        this.m_title = title;
        this.m_removable = removable;
        this.m_info = info;
        this.m_dateLastModified = dateLastModified;
        this.m_dateLastModifiedStr = dateLastModifiedStr;
        this.m_userLastModified = userLastModified;
    }

    protected CmsPublishResource() {
    }

    public long getDateLastModified() {
        return this.m_dateLastModified;
    }

    public String getDateLastModifiedString() {
        return this.m_dateLastModifiedStr;
    }

    public String getDetailResourceType() {
        return this.m_detailResourceType;
    }

    public CmsUUID getId() {
        return this.m_id;
    }

    public CmsPublishResourceInfo getInfo() {
        return this.m_info;
    }

    public String getName() {
        return this.m_name;
    }

    public CmsPermissionInfo getPermissionInfo() {
        return this.m_permissionInfo;
    }

    public List<CmsPublishResource> getRelated() {
        return this.m_related;
    }

    public String getResourceType() {
        return this.m_resourceType;
    }

    public long getSortDate() {
        long result = this.getDateLastModified();
        if (this.m_related != null) {
            for (CmsPublishResource rel : this.m_related) {
                result = Math.max(result, rel.getSortDate());
            }
        }
        return result;
    }

    public CmsResourceState getState() {
        return this.m_state;
    }

    public String getTitle() {
        return this.m_title;
    }

    public String getUserLastModified() {
        return this.m_userLastModified;
    }

    public boolean isRemovable() {
        return this.m_removable;
    }

    public void setInfo(CmsPublishResourceInfo info) {
        this.m_info = info;
    }

    public void setRemovable(boolean removable) {
        this.m_removable = removable;
    }
}

