/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.sitemap;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.opencms.ade.sitemap.CmsVfsSitemapService;
import org.opencms.ade.sitemap.Messages;
import org.opencms.db.CmsAlias;
import org.opencms.db.CmsAliasManager;
import org.opencms.db.CmsRewriteAlias;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.gwt.shared.alias.CmsAliasEditValidationReply;
import org.opencms.gwt.shared.alias.CmsAliasEditValidationRequest;
import org.opencms.gwt.shared.alias.CmsAliasImportResult;
import org.opencms.gwt.shared.alias.CmsAliasSaveValidationRequest;
import org.opencms.gwt.shared.alias.CmsAliasTableRow;
import org.opencms.gwt.shared.alias.CmsRewriteAliasTableRow;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsUUID;

public class CmsAliasBulkEditHelper {
    private CmsObject m_cms;
    private boolean m_hasErrors;

    public CmsAliasBulkEditHelper(CmsObject cms) {
        this.m_cms = cms;
    }

    public void importAliases(HttpServletRequest request, HttpServletResponse response) throws Exception {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        List items = upload.parseRequest(request);
        byte[] data = null;
        String siteRoot = null;
        String separator = ",";
        for (FileItem fileItem : items) {
            String name = fileItem.getFieldName();
            if ("importfile".equals(name)) {
                data = fileItem.get();
                continue;
            }
            if ("siteroot".equals(name)) {
                siteRoot = new String(fileItem.get(), request.getCharacterEncoding());
                continue;
            }
            if (!"separator".equals(name)) continue;
            separator = new String(fileItem.get(), request.getCharacterEncoding());
        }
        List<CmsAliasImportResult> result = new ArrayList<CmsAliasImportResult>();
        if (siteRoot != null && data != null) {
            result = OpenCms.getAliasManager().importAliases(this.m_cms, data, siteRoot, separator);
        }
        String key = CmsVfsSitemapService.addAliasImportResult(result);
        response.getWriter().print(key);
    }

    public CmsAliasEditValidationReply saveAliases(CmsAliasSaveValidationRequest saveRequest) throws CmsException {
        CmsAliasEditValidationReply reply = this.validateAliases(saveRequest);
        if (this.m_hasErrors) {
            return reply;
        }
        List<CmsRewriteAliasTableRow> rewriteData = saveRequest.getRewriteData();
        OpenCms.getAliasManager().saveRewriteAliases(this.m_cms, this.m_cms.getRequestContext().getSiteRoot(), this.convertRewriteData(rewriteData));
        HashSet<CmsUUID> allTouchedIds = new HashSet<CmsUUID>();
        List<CmsAliasTableRow> rows = saveRequest.getEditedData();
        for (CmsAliasTableRow row : rows) {
            if (!row.isEdited()) continue;
            allTouchedIds.add(row.getStructureId());
            if (row.getOriginalStructureId() == null) continue;
            allTouchedIds.add(row.getOriginalStructureId());
        }
        allTouchedIds.addAll(saveRequest.getDeletedIds());
        CmsAliasManager aliasManager = OpenCms.getAliasManager();
        String siteRoot = saveRequest.getSiteRoot();
        List<CmsAlias> aliases = aliasManager.getAliasesForSite(this.m_cms, siteRoot);
        HashSet<CmsAlias> aliasSet = new HashSet<CmsAlias>();
        HashSet<CmsAlias> editedAliasSet = new HashSet<CmsAlias>();
        aliasSet.addAll(aliases);
        for (CmsAliasTableRow row : rows) {
            CmsAlias editedAlias = new CmsAlias(row.getStructureId(), siteRoot, row.getAliasPath(), row.getMode());
            editedAliasSet.add(editedAlias);
        }
        Object toDelete = Sets.difference(aliasSet, editedAliasSet);
        toDelete = this.filterStructureId((Set<CmsAlias>)toDelete, allTouchedIds);
        Object toAdd = Sets.difference(editedAliasSet, aliasSet);
        toAdd = this.filterStructureId((Set<CmsAlias>)toAdd, allTouchedIds);
        aliasManager.updateAliases(this.m_cms, (Collection<CmsAlias>)toDelete, (Collection<CmsAlias>)toAdd);
        return null;
    }

    public CmsAliasEditValidationReply validateAliases(CmsAliasEditValidationRequest validationRequest) {
        List<CmsAliasTableRow> editedData = validationRequest.getEditedData();
        CmsAliasTableRow newEntry = validationRequest.getNewEntry();
        if (newEntry != null) {
            newEntry.setKey(new CmsUUID().toString());
            editedData.add(newEntry);
        }
        CmsObject cms = this.m_cms;
        Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        for (CmsAliasTableRow row : editedData) {
            row.clearErrors();
            this.validateSingleAliasRow(cms, row);
        }
        HashSet<String> foundAliasPaths = new HashSet<String>();
        HashSet<String> duplicateAliasPaths = new HashSet<String>();
        for (CmsAliasTableRow row : editedData) {
            String aliasPath = row.getAliasPath();
            if (foundAliasPaths.contains(aliasPath)) {
                duplicateAliasPaths.add(aliasPath);
            }
            foundAliasPaths.add(aliasPath);
        }
        for (CmsAliasTableRow row : editedData) {
            if (!duplicateAliasPaths.contains(row.getAliasPath()) || row.getPathError() != null) continue;
            row.setAliasError(this.messageDuplicateAliasPath(locale));
            this.m_hasErrors = true;
        }
        CmsAliasEditValidationReply result = new CmsAliasEditValidationReply();
        ArrayList<CmsAliasTableRow> changedRows = new ArrayList<CmsAliasTableRow>();
        for (CmsAliasTableRow row : editedData) {
            if (!row.isChanged()) continue;
            changedRows.add(row);
        }
        if (newEntry != null) {
            changedRows.remove(newEntry);
        }
        result.setChangedRows(changedRows);
        result.setValidatedNewEntry(newEntry);
        return result;
    }

    protected Set<CmsAlias> filterStructureId(Set<CmsAlias> aliases, Set<CmsUUID> structureIds) {
        HashSet<CmsAlias> result = new HashSet<CmsAlias>();
        for (CmsAlias alias : aliases) {
            if (!structureIds.contains(alias.getStructureId())) continue;
            result.add(alias);
        }
        return result;
    }

    private List<CmsRewriteAlias> convertRewriteData(List<CmsRewriteAliasTableRow> rewriteData) {
        String siteRoot = this.m_cms.getRequestContext().getSiteRoot();
        ArrayList<CmsRewriteAlias> result = new ArrayList<CmsRewriteAlias>();
        for (CmsRewriteAliasTableRow row : rewriteData) {
            CmsRewriteAlias alias = new CmsRewriteAlias(row.getId(), siteRoot, row.getPatternString(), row.getReplacementString(), row.getMode());
            result.add(alias);
        }
        return result;
    }

    private String messageDuplicateAliasPath(Locale locale) {
        return Messages.get().getBundle(locale).key("ERR_ALIAS_DUPLICATE_ALIAS_PATH_0");
    }

    private String messageInvalidAliasPath(Locale locale) {
        return Messages.get().getBundle(locale).key("ERR_ALIAS_INVALID_ALIAS_PATH_0");
    }

    private String messageResourceNotFound(Locale locale) {
        return Messages.get().getBundle(locale).key("ERR_ALIAS_RESOURCE_NOT_FOUND_0");
    }

    private void validateSingleAliasRow(CmsObject cms, CmsAliasTableRow row) {
        Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        if (row.getStructureId() == null) {
            String path = row.getResourcePath();
            try {
                CmsResource resource = cms.readResource(path, CmsResourceFilter.ALL);
                row.setStructureId(resource.getStructureId());
                if (row.getOriginalStructureId() == null) {
                    row.setOriginalStructureId(resource.getStructureId());
                }
            }
            catch (CmsException e) {
                row.setPathError(this.messageResourceNotFound(locale));
                this.m_hasErrors = true;
            }
        }
        if (!CmsAlias.ALIAS_PATTERN.matcher(row.getAliasPath()).matches()) {
            row.setAliasError(this.messageInvalidAliasPath(locale));
            this.m_hasErrors = true;
        }
    }
}

