/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.sitemap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsResource;
import org.opencms.jsp.CmsJspNavElement;
import org.opencms.main.CmsLog;

public class CmsSitemapNavPosCalculator {
    public static final String DUMMY_PATH = "@moved@";
    private static final Log LOG = CmsLog.getLog(CmsSitemapNavPosCalculator.class);
    private int m_insertPositionInResult;
    private List<CmsJspNavElement> m_resultList;

    public CmsSitemapNavPosCalculator(List<CmsJspNavElement> navigation, CmsResource movedElement, int insertPosition) {
        ArrayList<CmsJspNavElement> workList = new ArrayList<CmsJspNavElement>(navigation);
        CmsJspNavElement dummyNavElement = new CmsJspNavElement(DUMMY_PATH, movedElement, new HashMap<String, String>());
        for (int i = 0; i < workList.size(); ++i) {
            CmsJspNavElement currentElement = (CmsJspNavElement)workList.get(i);
            if (i == insertPosition || !currentElement.getResource().getStructureId().equals(movedElement.getStructureId())) continue;
            workList.remove(i);
            break;
        }
        if (insertPosition > workList.size()) {
            insertPosition = workList.size();
        }
        workList.add(insertPosition, dummyNavElement);
        Iterator it = workList.iterator();
        while (it.hasNext()) {
            CmsJspNavElement nav = (CmsJspNavElement)it.next();
            if (nav.isInNavigation() || nav == dummyNavElement) continue;
            it.remove();
        }
        this.m_insertPositionInResult = insertPosition = workList.indexOf(dummyNavElement);
        int blockStart = insertPosition;
        int blockEnd = insertPosition + 1;
        PositionInfo before = this.getPositionInfo(workList, insertPosition - 1);
        PositionInfo after = this.getPositionInfo(workList, insertPosition + 1);
        boolean extendBlock = false;
        float blockValue = 0.0f;
        if (before.isMax()) {
            blockValue = Float.MAX_VALUE;
            extendBlock = true;
        } else if (before.isNormal() && after.isNormal() && before.getNavPos() == after.getNavPos()) {
            blockValue = before.getNavPos();
            extendBlock = true;
        }
        if (extendBlock) {
            while (blockStart > 0 && ((CmsJspNavElement)workList.get(blockStart - 1)).getNavPosition() == blockValue) {
                --blockStart;
            }
            while (blockEnd < workList.size() && (blockEnd == insertPosition + 1 || ((CmsJspNavElement)workList.get(blockEnd)).getNavPosition() == blockValue)) {
                ++blockEnd;
            }
        }
        PositionInfo beforeBlock = this.getPositionInfo(workList, blockStart - 1);
        PositionInfo afterBlock = this.getPositionInfo(workList, blockEnd);
        List<Float> newNavPositions = this.interpolatePositions(beforeBlock, afterBlock, blockEnd - blockStart);
        for (int i = 0; i < blockEnd - blockStart; ++i) {
            ((CmsJspNavElement)workList.get(i + blockStart)).setNavPosition(newNavPositions.get(i).floatValue());
        }
        this.m_resultList = Collections.unmodifiableList(workList);
    }

    public int getInsertPositionInResult() {
        return this.m_insertPositionInResult;
    }

    public List<CmsJspNavElement> getNavigationChanges() {
        List<CmsJspNavElement> newNav = this.getResultList();
        ArrayList<CmsJspNavElement> changedElements = new ArrayList<CmsJspNavElement>();
        for (CmsJspNavElement elem : newNav) {
            if (!elem.hasChangedNavPosition()) continue;
            changedElements.add(elem);
        }
        return changedElements;
    }

    public List<CmsJspNavElement> getResultList() {
        return this.m_resultList;
    }

    private PositionInfo getPositionInfo(List<CmsJspNavElement> navigation, int index) {
        if (index < 0 || index >= navigation.size()) {
            return new PositionInfo(false, -1.0f);
        }
        float navPos = navigation.get(index).getNavPosition();
        return new PositionInfo(true, navPos);
    }

    private List<Float> interpolateBetween(float min, float max, int steps) {
        float delta = (max - min) / (float)(steps + 1);
        ArrayList<Float> result = new ArrayList<Float>();
        float num = min;
        for (int i = 0; i < steps; ++i) {
            result.add(new Float(num += delta));
        }
        return result;
    }

    private List<Float> interpolateDownwards(float max, int steps) {
        ArrayList<Float> result = new ArrayList<Float>();
        if (max > 0.0f) {
            float base = max > 1.0f ? (float)Math.floor(max) : max;
            float stepSize = 1000.0f;
            while (base - (float)steps * stepSize < max / 10.0f) {
                stepSize = this.reduceStepSize(stepSize);
            }
            for (int i = 0; i < steps; ++i) {
                result.add(new Float(base - (float)(i + 1) * stepSize));
            }
            Collections.reverse(result);
        } else {
            LOG.warn((Object)("Invalid navpos value: " + max));
            for (int i = 0; i < steps; ++i) {
                result.add(new Float(max - (float)(i + 1)));
            }
            Collections.reverse(result);
        }
        return result;
    }

    private List<Float> interpolateEmpty(int steps) {
        ArrayList<Float> result = new ArrayList<Float>();
        for (int i = 0; i < steps; ++i) {
            result.add(new Float(1 + i));
        }
        return result;
    }

    private List<Float> interpolatePositions(PositionInfo left, PositionInfo right, int steps) {
        if (left.isOutOfBounds()) {
            if (right.isNormal()) {
                return this.interpolateDownwards(right.getNavPos(), steps);
            }
            if (right.isMax() || right.isOutOfBounds()) {
                return this.interpolateEmpty(steps);
            }
            assert (false);
        } else if (left.isNormal()) {
            if (right.isOutOfBounds() || right.isMax()) {
                return this.interpolateUpwards(left.getNavPos(), steps);
            }
            if (right.isNormal()) {
                return this.interpolateBetween(left.getNavPos(), right.getNavPos(), steps);
            }
            assert (false);
        } else assert (false);
        return null;
    }

    private List<Float> interpolateUpwards(float min, int steps) {
        ArrayList<Float> result = new ArrayList<Float>();
        for (int i = 0; i < steps; ++i) {
            result.add(new Float(min + 1.0f + (float)i));
        }
        return result;
    }

    private float reduceStepSize(float oldStepSize) {
        if (oldStepSize > 1.0f) {
            return oldStepSize / 10.0f;
        }
        return oldStepSize / 2.0f;
    }

    private class PositionInfo {
        private boolean m_exists;
        private float m_navPos;

        public PositionInfo(boolean exists, float navPos) {
            this.m_exists = exists;
            this.m_navPos = navPos;
        }

        public float getNavPos() {
            return this.m_navPos;
        }

        public boolean isMax() {
            return this.m_navPos == Float.MAX_VALUE;
        }

        public boolean isNormal() {
            return !this.isOutOfBounds() && !this.isMax();
        }

        public boolean isOutOfBounds() {
            return !this.m_exists;
        }
    }
}

