/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.sitemap.shared;

import com.google.common.collect.ArrayListMultimap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opencms.ade.detailpage.CmsDetailPageInfo;
import org.opencms.util.CmsUUID;

public class CmsDetailPageTable
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -4561142050519767250L;
    private Map<CmsUUID, CmsDetailPageInfo> m_infoById = new HashMap<CmsUUID, CmsDetailPageInfo>();
    private ArrayListMultimap<String, CmsDetailPageInfo> m_map = ArrayListMultimap.create();

    public CmsDetailPageTable(List<CmsDetailPageInfo> infos) {
        for (CmsDetailPageInfo info : infos) {
            this.m_map.put((Object)info.getType(), (Object)info);
            this.m_infoById.put(info.getId(), info);
        }
    }

    protected CmsDetailPageTable() {
    }

    public void add(CmsDetailPageInfo info) {
        this.m_map.put((Object)info.getType(), (Object)info);
        this.m_infoById.put(info.getId(), info);
    }

    public int bump(CmsUUID id) {
        CmsDetailPageInfo info = this.m_infoById.get(id);
        if (info == null) {
            throw new IllegalArgumentException();
        }
        String type = info.getType();
        List infos = this.m_map.get((Object)type);
        int oldPos = infos.indexOf(info);
        infos.remove(oldPos);
        infos.add(0, info);
        return oldPos;
    }

    public boolean contains(CmsUUID id) {
        return this.m_infoById.containsKey(id);
    }

    public CmsDetailPageTable copy() {
        List<CmsDetailPageInfo> infos = this.toList();
        CmsDetailPageTable result = new CmsDetailPageTable();
        for (CmsDetailPageInfo info : infos) {
            result.add(info);
        }
        return result;
    }

    public CmsDetailPageInfo get(CmsUUID id) {
        return this.m_infoById.get(id);
    }

    public Collection<CmsUUID> getAllIds() {
        return this.m_infoById.keySet();
    }

    public CmsDetailPageInfo getBestDetailPage(String type) {
        List infos = this.m_map.get((Object)type);
        if (infos == null || infos.isEmpty()) {
            return null;
        }
        return (CmsDetailPageInfo)infos.get(0);
    }

    public List<CmsDetailPageInfo> getBestDetailPages() {
        ArrayList<CmsDetailPageInfo> result = new ArrayList<CmsDetailPageInfo>();
        for (String key : this.m_map.keySet()) {
            List vals = this.m_map.get((Object)key);
            if (vals.isEmpty()) continue;
            result.add((CmsDetailPageInfo)vals.get(0));
        }
        return result;
    }

    public List<CmsDetailPageInfo> getInfosForType(String type) {
        return new ArrayList<CmsDetailPageInfo>(this.m_map.get((Object)type));
    }

    public Status getStatus(CmsUUID id) {
        CmsDetailPageInfo info = this.m_infoById.get(id);
        if (info == null) {
            return Status.noDetailPage;
        }
        String type = info.getType();
        int index = this.m_map.get((Object)type).indexOf(info);
        if (index == 0) {
            return Status.firstDetailPage;
        }
        return Status.otherDetailPage;
    }

    public boolean isDefaultDetailPage(CmsUUID id) {
        CmsDetailPageInfo info = this.m_infoById.get(id);
        if (info == null) {
            return false;
        }
        return ((CmsDetailPageInfo)this.m_map.get((Object)info.getType()).get(0)).getId().equals(id);
    }

    public int move(CmsUUID id, int newPos) {
        CmsDetailPageInfo info = this.m_infoById.get(id);
        if (info == null) {
            throw new IllegalArgumentException();
        }
        String type = info.getType();
        List infos = this.m_map.get((Object)type);
        int oldPos = infos.indexOf(info);
        infos.remove(oldPos);
        infos.add(newPos, info);
        return oldPos;
    }

    public int remove(CmsUUID id) {
        CmsDetailPageInfo info = this.m_infoById.get(id);
        if (info == null) {
            throw new IllegalArgumentException();
        }
        String type = info.getType();
        List infos = this.m_map.get((Object)type);
        int pos = infos.indexOf(info);
        infos.remove(pos);
        this.m_infoById.remove(id);
        return pos;
    }

    public int size() {
        return this.m_infoById.size();
    }

    public List<CmsDetailPageInfo> toList() {
        ArrayList<CmsDetailPageInfo> result = new ArrayList<CmsDetailPageInfo>();
        for (String key : this.m_map.keySet()) {
            for (CmsDetailPageInfo info : this.m_map.get((Object)key)) {
                result.add(info);
            }
        }
        return result;
    }

    public static enum Status {
        firstDetailPage,
        noDetailPage,
        otherDetailPage;

    }
}

