/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.upload;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.fileupload.InvalidFileNameException;
import org.apache.commons.fileupload.util.Streams;
import org.opencms.ade.upload.CmsUploadBean;
import org.opencms.ade.upload.CmsUploadException;
import org.opencms.ade.upload.CmsUploadListener;
import org.opencms.ade.upload.Messages;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.gwt.CmsGwtService;
import org.opencms.gwt.shared.CmsUploadFileBean;
import org.opencms.gwt.shared.CmsUploadProgessInfo;
import org.opencms.gwt.shared.rpc.I_CmsUploadService;
import org.opencms.main.CmsException;
import org.opencms.util.CmsUUID;

public class CmsUploadService
extends CmsGwtService
implements I_CmsUploadService {
    private static final long serialVersionUID = -2235662141861687012L;

    @Override
    public Boolean cancelUpload() {
        CmsUUID listenerId;
        CmsUploadListener listener;
        if (this.getRequest().getSession().getAttribute("__CmsUploadBean.LISTENER") != null && (listener = CmsUploadBean.getCurrentListener(listenerId = (CmsUUID)this.getRequest().getSession().getAttribute("__CmsUploadBean.LISTENER"))) != null && !listener.isCanceled()) {
            listener.cancelUpload(new CmsUploadException(Messages.get().getBundle().key("ERR_UPLOAD_USER_CANCELED_0")));
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public CmsUploadFileBean checkUploadFiles(List<String> fileNames, String targetFolder, boolean isRootPath) {
        ArrayList<String> existingResourceNames = new ArrayList<String>();
        ArrayList<String> invalidFileNames = new ArrayList<String>();
        ArrayList<String> existingDeleted = new ArrayList<String>();
        boolean isActive = false;
        if (this.getRequest().getSession().getAttribute("__CmsUploadBean.LISTENER") == null) {
            for (String fileName : fileNames) {
                try {
                    Streams.checkFileName((String)fileName);
                    String newResName = CmsUploadBean.getNewResourceName(this.getCmsObject(), fileName, targetFolder);
                    if (!this.existsResource(newResName, isRootPath)) continue;
                    if (this.isDeletedResource(newResName, isRootPath)) {
                        existingDeleted.add(fileName);
                        continue;
                    }
                    existingResourceNames.add(fileName);
                }
                catch (InvalidFileNameException e) {
                    invalidFileNames.add(fileName);
                }
            }
        } else {
            isActive = true;
        }
        return new CmsUploadFileBean(existingResourceNames, invalidFileNames, existingDeleted, isActive);
    }

    @Override
    public CmsUploadProgessInfo getUploadProgressInfo() {
        CmsUUID listenerId;
        CmsUploadListener listener;
        CmsUploadProgessInfo info = new CmsUploadProgessInfo(0, 0, CmsUploadProgessInfo.UPLOAD_STATE.notStarted, 0L, 0L);
        if (this.getRequest().getSession().getAttribute("__CmsUploadBean.LISTENER") != null && (listener = CmsUploadBean.getCurrentListener(listenerId = (CmsUUID)this.getRequest().getSession().getAttribute("__CmsUploadBean.LISTENER"))) != null) {
            info = listener.getInfo();
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean existsResource(String path, boolean rootPath) {
        block6: {
            CmsObject cms = this.getCmsObject();
            if (rootPath) {
                String origSiteRoot = cms.getRequestContext().getSiteRoot();
                try {
                    cms.getRequestContext().setSiteRoot("");
                    if (cms.existsResource(path, CmsResourceFilter.ALL)) {
                        boolean bl = true;
                        return bl;
                    }
                    break block6;
                }
                finally {
                    cms.getRequestContext().setSiteRoot(origSiteRoot);
                }
            }
            if (cms.existsResource(path, CmsResourceFilter.ALL)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDeletedResource(String path, boolean rootPath) {
        CmsResource res;
        block6: {
            CmsObject cms = this.getCmsObject();
            res = null;
            try {
                if (rootPath) {
                    String origSiteRoot = cms.getRequestContext().getSiteRoot();
                    try {
                        cms.getRequestContext().setSiteRoot("");
                        res = cms.readResource(path, CmsResourceFilter.ALL);
                        break block6;
                    }
                    finally {
                        cms.getRequestContext().setSiteRoot(origSiteRoot);
                    }
                }
                res = cms.readResource(path, CmsResourceFilter.ALL);
            }
            catch (CmsException cmsException) {
                // empty catch block
            }
        }
        return res != null && res.getState().isDeleted();
    }
}

