/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.cache;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.opencms.cache.CmsVfsDiskCache;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsFileUtil;

public class CmsVfsNameBasedDiskCache {
    private static final Log LOG = CmsLog.getLog(CmsVfsNameBasedDiskCache.class);
    private String m_rfsRepository;

    public CmsVfsNameBasedDiskCache(String basepath, String foldername) {
        this.m_rfsRepository = CmsFileUtil.normalizePath(basepath + foldername + File.separatorChar);
    }

    public byte[] getCacheContent(String rfsName) {
        try {
            File f = new File(rfsName);
            if (f.exists()) {
                long age = f.lastModified();
                if (System.currentTimeMillis() - age > 3600000L) {
                    f.setLastModified(System.currentTimeMillis());
                }
                return CmsFileUtil.readFile(f);
            }
        }
        catch (IOException e) {
            LOG.debug((Object)("Unable to read file " + rfsName), (Throwable)e);
        }
        return null;
    }

    public String getCacheName(CmsResource resource, String parameters) {
        String rfsName = this.m_rfsRepository + resource.getRootPath();
        String extension = CmsFileUtil.getExtension(rfsName);
        StringBuffer buf = new StringBuffer(rfsName.length() + 24);
        buf.append(rfsName.substring(0, rfsName.length() - extension.length()));
        StringBuffer ext = new StringBuffer(48);
        ext.append(resource.getDateLastModified());
        ext.append(';');
        ext.append(resource.getDateCreated());
        if (resource.getLength() > 0) {
            ext.append(';');
            ext.append(resource.getLength());
        }
        buf.append('_');
        buf.append(ext.toString().hashCode());
        if (parameters != null) {
            buf.append('_');
            buf.append(parameters.hashCode());
        }
        buf.append(extension);
        return buf.toString();
    }

    public String getRepositoryPath() {
        return this.m_rfsRepository;
    }

    public boolean hasCacheContent(String rfsName) {
        File f = new File(rfsName);
        return f.exists();
    }

    public void saveCacheFile(String rfsName, byte[] content) throws IOException {
        CmsVfsDiskCache.saveFile(rfsName, content);
    }
}

