/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.configuration.preferences;

import org.dom4j.Element;
import org.opencms.configuration.CmsDefaultUserSettings;
import org.opencms.configuration.preferences.A_CmsPreference;
import org.opencms.configuration.preferences.CmsPreferenceData;
import org.opencms.file.CmsObject;
import org.opencms.xml.content.CmsXmlContentProperty;

public class CmsUserDefinedPreference
extends A_CmsPreference {
    private CmsPreferenceData m_preferenceData;

    public CmsUserDefinedPreference(String name, String value, CmsXmlContentProperty prop, String tab) {
        this.m_preferenceData = new CmsPreferenceData(name, value, prop, tab);
    }

    public static void fillAttributes(CmsPreferenceData pref, Element elem) {
        CmsXmlContentProperty prop = pref.getPropertyDefinition();
        for (String[] attrToSet : new String[][]{{"value", pref.getDefaultValue()}, {"nice-name", prop.getNiceName()}, {"description", prop.getDescription()}, {"widget", prop.getWidget()}, {"widget-config", prop.getWidgetConfiguration()}, {"rule-regex", prop.getRuleRegex()}, {"error", prop.getError()}}) {
            String attrName = attrToSet[0];
            String value = attrToSet[1];
            if (value == null) continue;
            elem.addAttribute(attrName, value);
        }
    }

    @Override
    public String getDefaultValue() {
        return this.m_preferenceData.getDefaultValue();
    }

    @Override
    public String getName() {
        return this.m_preferenceData.getName();
    }

    @Override
    public CmsXmlContentProperty getPropertyDefinition(CmsObject cms) {
        return this.getPropertyDefinition();
    }

    @Override
    public String getTab() {
        return this.m_preferenceData.getTab();
    }

    @Override
    public String getValue(CmsDefaultUserSettings userSettings) {
        return userSettings.getAdditionalPreference(this.getName(), true);
    }

    @Override
    public void setValue(CmsDefaultUserSettings settings, String value) {
        settings.setAdditionalPreference(this.getName(), value);
    }

    @Override
    protected CmsXmlContentProperty getPropertyDefinition() {
        return this.m_preferenceData.getPropertyDefinition();
    }
}

