/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db;

public class CmsCacheSettings {
    private int m_aclCacheSize;
    private String m_cacheKeyGenerator;
    private int m_groupCacheSize;
    private int m_orgUnitCacheSize = -1;
    private int m_permissionCacheSize;
    private int m_projectCacheSize;
    private int m_projectResourcesCacheSize = -1;
    private int m_propertyCacheSize;
    private int m_propertyListsCacheSize = -1;
    private int m_resourceCacheSize;
    private int m_resourcelistCacheSize;
    private int m_rolesCacheSize = -1;
    private int m_userCacheSize;
    private int m_userGroupsCacheSize;

    public int getAclCacheSize() {
        return this.m_aclCacheSize;
    }

    public String getCacheKeyGenerator() {
        return this.m_cacheKeyGenerator;
    }

    public int getConfiguredOrgUnitCacheSize() {
        return this.m_orgUnitCacheSize;
    }

    public int getConfiguredProjectResourcesCacheSize() {
        return this.m_projectResourcesCacheSize;
    }

    public int getConfiguredPropertyListsCacheSize() {
        return this.m_propertyListsCacheSize;
    }

    public int getConfiguredRolesCacheSize() {
        return this.m_rolesCacheSize;
    }

    public int getGroupCacheSize() {
        return this.m_groupCacheSize;
    }

    public int getOrgUnitCacheSize() {
        if (this.m_orgUnitCacheSize < 0) {
            return this.getGroupCacheSize();
        }
        return this.m_orgUnitCacheSize;
    }

    public int getPermissionCacheSize() {
        return this.m_permissionCacheSize;
    }

    public int getProjectCacheSize() {
        return this.m_projectCacheSize;
    }

    public int getProjectResourcesCacheSize() {
        if (this.m_propertyListsCacheSize < 0) {
            return this.getProjectCacheSize();
        }
        return this.m_projectResourcesCacheSize;
    }

    public int getPropertyCacheSize() {
        return this.m_propertyCacheSize;
    }

    public int getPropertyListsCacheSize() {
        if (this.m_propertyListsCacheSize < 0) {
            return this.getPropertyCacheSize();
        }
        return this.m_propertyListsCacheSize;
    }

    public int getResourceCacheSize() {
        return this.m_resourceCacheSize;
    }

    public int getResourcelistCacheSize() {
        return this.m_resourcelistCacheSize;
    }

    public int getRolesCacheSize() {
        if (this.m_rolesCacheSize < 0) {
            return this.getPermissionCacheSize();
        }
        return this.m_rolesCacheSize;
    }

    public int getUserCacheSize() {
        return this.m_userCacheSize;
    }

    public int getUserGroupsCacheSize() {
        return this.m_userGroupsCacheSize;
    }

    public void setAclCacheSize(String size) {
        this.m_aclCacheSize = this.getIntValue(size, 1024);
    }

    public void setCacheKeyGenerator(String classname) {
        this.m_cacheKeyGenerator = classname;
    }

    public void setGroupCacheSize(String size) {
        this.m_groupCacheSize = this.getIntValue(size, 64);
    }

    public void setOrgUnitCacheSize(String size) {
        this.m_orgUnitCacheSize = this.getIntValue(size, 64);
    }

    public void setPermissionCacheSize(String size) {
        this.m_permissionCacheSize = this.getIntValue(size, 1024);
    }

    public void setProjectCacheSize(String size) {
        this.m_projectCacheSize = this.getIntValue(size, 32);
    }

    public void setProjectResourcesCacheSize(String size) {
        this.m_projectResourcesCacheSize = this.getIntValue(size, -1);
    }

    public void setPropertyCacheSize(String size) {
        this.m_propertyCacheSize = this.getIntValue(size, 128);
    }

    public void setPropertyListsCacheSize(String size) {
        this.m_propertyListsCacheSize = this.getIntValue(size, -1);
    }

    public void setResourceCacheSize(String size) {
        this.m_resourceCacheSize = this.getIntValue(size, 8192);
    }

    public void setResourcelistCacheSize(String size) {
        this.m_resourcelistCacheSize = this.getIntValue(size, 256);
    }

    public void setRolesCacheSize(String size) {
        this.m_rolesCacheSize = this.getIntValue(size, 8192);
    }

    public void setUserCacheSize(String size) {
        this.m_userCacheSize = this.getIntValue(size, 64);
    }

    public void setUserGroupsCacheSize(String size) {
        this.m_userGroupsCacheSize = this.getIntValue(size, 256);
    }

    private int getIntValue(String str, int defaultValue) {
        try {
            int intValue = Integer.parseInt(str);
            return intValue > 0 ? intValue : defaultValue;
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }
}

