/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db;

import org.opencms.db.CmsCompositeQueryFragment;
import org.opencms.db.CmsSelectQuery;
import org.opencms.db.CmsSimpleQueryFragment;
import org.opencms.db.CmsStatementBuilder;
import org.opencms.db.I_CmsQueryFragment;

public class CmsPagingQuery
implements I_CmsQueryFragment {
    private boolean m_nameSubquery;
    private int m_page;
    private int m_pageSize;
    private CmsSelectQuery m_select;
    private boolean m_useWindowFunctions;

    public CmsPagingQuery(CmsSelectQuery select) {
        this.m_select = select;
    }

    public void setNameSubquery(boolean nameSubquery) {
        this.m_nameSubquery = nameSubquery;
    }

    public void setPaging(int pageSize, int page) {
        this.m_pageSize = pageSize;
        this.m_page = page;
    }

    public void setUseWindowFunctions(boolean useWindowFunctions) {
        this.m_useWindowFunctions = useWindowFunctions;
    }

    @Override
    public void visit(CmsStatementBuilder builder) {
        if (this.m_useWindowFunctions) {
            I_CmsQueryFragment order = this.m_select.getOrdering();
            assert (order != null);
            CmsCompositeQueryFragment rownumFragment = new CmsCompositeQueryFragment();
            rownumFragment.add(new CmsSimpleQueryFragment("ROW_NUMBER() OVER (ORDER BY ", new Object[0]));
            rownumFragment.add(order);
            rownumFragment.add(new CmsSimpleQueryFragment(") AS rownumber", new Object[0]));
            this.m_select.addColumn(rownumFragment);
            builder.add("SELECT * FROM ( ", new Object[0]);
            this.m_select.visit(builder);
            int start = 1 + this.m_pageSize * (this.m_page - 1);
            int end = start + this.m_pageSize - 1;
            builder.add(")", new Object[0]);
            if (this.m_nameSubquery) {
                builder.add(" AS rnsq ", new Object[0]);
            }
            builder.add(" WHERE rownumber BETWEEN " + start + " AND " + end, new Object[0]);
        } else {
            this.m_select.visit(builder);
            int offset = (this.m_page - 1) * this.m_pageSize;
            builder.add("\nLIMIT " + this.m_pageSize + " OFFSET " + offset, new Object[0]);
        }
    }
}

