/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.opencms.configuration.preferences.I_CmsPreference;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsUser;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.synchronize.CmsSynchronizeSettings;
import org.opencms.util.A_CmsModeStringEnumeration;
import org.opencms.util.CmsStringUtil;

public class CmsUserSettings {
    public static final String ADDITIONAL_INFO_ADDRESS = "USER_ADDRESS";
    public static final String ADDITIONAL_INFO_CITY = "USER_TOWN";
    public static final String ADDITIONAL_INFO_CONFIRMED_RESOURCES = "ADDITIONAL_INFO_CONFIRMED_RESOURCES";
    public static final String ADDITIONAL_INFO_COUNTRY = "USER_COUNTRY";
    public static final String ADDITIONAL_INFO_DEFAULTGROUP = "USER_DEFAULTGROUP";
    public static final String ADDITIONAL_INFO_DESCRIPTION = "USER_DESCRIPTION";
    public static final String ADDITIONAL_INFO_EXPLORERSETTINGS = "USER_EXPLORERSETTINGS";
    public static final String ADDITIONAL_INFO_INSTITUTION = "USER_INSTITUTION";
    public static final String ADDITIONAL_INFO_LAST_PASSWORD_CHANGE = "LAST_PASSWORD_CHANGE";
    public static final String ADDITIONAL_INFO_LAST_USER_DATA_CHECK = "ADDITIONAL_INFO_LAST_USER_DATA_CHECK";
    public static final String ADDITIONAL_INFO_PREFERENCES = "USER_PREFERENCES";
    public static final String ADDITIONAL_INFO_STARTSETTINGS = "USER_STARTSETTINGS";
    public static final String ADDITIONAL_INFO_TIMEWARP = "USER_TIMEWARP";
    public static final String ADDITIONAL_INFO_UPLOADAPPLET_CLIENTFOLDER = "USER_UPLOADAPPLET_CLIENTFOLDER";
    public static final String ADDITIONAL_INFO_ZIPCODE = "USER_ZIPCODE";
    public static final int FILELIST_DATE_CREATED = 1024;
    public static final int FILELIST_DATE_EXPIRED = 8192;
    public static final int FILELIST_DATE_LASTMODIFIED = 4;
    public static final int FILELIST_DATE_RELEASED = 4096;
    public static final int FILELIST_LOCKEDBY = 256;
    public static final int FILELIST_NAME = 512;
    public static final int FILELIST_NAVTEXT = 64;
    public static final int FILELIST_PERMISSIONS = 128;
    public static final int FILELIST_SIZE = 8;
    public static final int FILELIST_STATE = 16;
    public static final int FILELIST_TITLE = 1;
    public static final int FILELIST_TYPE = 2;
    public static final int FILELIST_USER_CREATED = 32;
    public static final int FILELIST_USER_LASTMODIFIED = 2048;
    public static final String LOGIN_USERAGREEMENT_ACCEPTED = "LOGIN_UA_ACCEPTED";
    public static final String PREF_WORKPLACE_MODE = "workplaceMode";
    public static final String PREFERENCES = "USERPREFERENCES_";
    public static final String PREFERENCES_ADDITIONAL_PREFIX = "USERPREFERENCES_additional_";
    public static final String SYNC_DESTINATION = "DESTINATION";
    public static final String SYNC_ENABLED = "ENABLED";
    public static final String SYNC_SETTINGS = "SYNC_SETTINGS_";
    public static final String SYNC_VFS_LIST = "VFS_LIST";
    public static final String WORKPLACE_MODE_NEW = "new";
    public static final String WORKPLACE_MODE_OLD = "old";
    private static final int BUTTONSTYLE_DEFAULT = 1;
    private static final int ENTRYS_PER_PAGE_DEFAULT = 50;
    private static final Log LOG = CmsLog.getLog(CmsUserSettings.class);
    private static final String SEARCH_INDEX_DEFAULT = "Offline project (VFS)";
    private Map<String, String> m_additionalPreferences = new LinkedHashMap<String, String>();
    private boolean m_dialogDirectpublish;
    private boolean m_dialogExpandInheritedPermissions;
    private boolean m_dialogExpandUserPermissions;
    private CmsResource.CmsResourceCopyMode m_dialogFileCopy;
    private CmsResource.CmsResourceDeleteMode m_dialogFileDelete;
    private CmsResource.CmsResourceCopyMode m_dialogFolderCopy;
    private boolean m_dialogPermissionsInheritOnFolder;
    private int m_directeditButtonStyle;
    private int m_editorButtonStyle;
    private SortedMap<String, String> m_editorSettings;
    private int m_explorerButtonStyle;
    private int m_explorerFileEntries;
    private String m_explorerFileEntryOptions;
    private int m_explorerSettings;
    private boolean m_listAllProjects;
    private Locale m_locale;
    private Boolean m_newFolderCreateIndexPage;
    private Boolean m_newFolderEditProperties;
    private String m_project;
    private String m_publishButtonAppearance;
    private boolean m_restrictExplorerView;
    private boolean m_showExportSettings;
    private boolean m_showFileUploadButton;
    private boolean m_showLock;
    private boolean m_showPublishNotification;
    private Boolean m_showUploadTypeDialog;
    private String m_startFolder;
    private SortedMap<String, String> m_startGalleriesSettings;
    private String m_startSite;
    private CmsSynchronizeSettings m_synchronizeSettings;
    private long m_timeWarp;
    private String m_uploadAppletClientFolder;
    private UploadVariant m_uploadVariant;
    private CmsUser m_user;
    private String m_view;
    private int m_workplaceButtonStyle;
    private String m_workplaceReportType;
    private String m_workplaceSearchIndexName;
    private CmsSearchResultStyle m_workplaceSearchViewStyle;

    public CmsUserSettings() {
        this.m_workplaceButtonStyle = 1;
        this.m_workplaceReportType = "simple";
        this.m_explorerButtonStyle = 1;
        this.m_explorerFileEntries = 50;
        this.m_explorerSettings = 512;
        this.m_editorSettings = new TreeMap<String, String>();
        this.m_startGalleriesSettings = new TreeMap<String, String>();
        this.m_showFileUploadButton = true;
        this.m_showPublishNotification = false;
        this.m_listAllProjects = false;
        this.m_uploadVariant = UploadVariant.gwt;
        this.m_publishButtonAppearance = "always";
        this.m_newFolderCreateIndexPage = Boolean.TRUE;
        this.m_newFolderEditProperties = Boolean.TRUE;
        this.m_showUploadTypeDialog = Boolean.TRUE;
        this.m_workplaceSearchIndexName = SEARCH_INDEX_DEFAULT;
        this.m_workplaceSearchViewStyle = CmsSearchResultStyle.STYLE_EXPLORER;
    }

    public CmsUserSettings(CmsObject cms) {
        this(cms.getRequestContext().getCurrentUser());
    }

    public CmsUserSettings(CmsUser user) {
        this.init(user);
    }

    public static String getAdditionalPreference(CmsObject cms, String key, boolean useDefault) {
        CmsUser user = cms.getRequestContext().getCurrentUser();
        CmsUserSettings settings = new CmsUserSettings(user);
        return settings.getAdditionalPreference(key, useDefault);
    }

    public static void setAdditionalPreference(CmsObject cms, String key, String value) {
        CmsUser user = cms.getRequestContext().getCurrentUser();
        CmsUserSettings settings = new CmsUserSettings(user);
        settings.setAdditionalPreference(key, value);
        try {
            settings.save(cms);
        }
        catch (CmsException e) {
            LOG.error((Object)("Could not store preference " + key + ": " + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    public String getAdditionalPreference(String name, boolean useDefault) {
        I_CmsPreference pref;
        String value = this.m_additionalPreferences.get(name);
        if (value == null && useDefault && (pref = OpenCms.getWorkplaceManager().getDefaultUserSettings().getPreferences().get(name)) != null) {
            value = pref.getDefaultValue();
        }
        return value;
    }

    public CmsResource.CmsResourceCopyMode getDialogCopyFileMode() {
        return this.m_dialogFileCopy;
    }

    public CmsResource.CmsResourceCopyMode getDialogCopyFolderMode() {
        return this.m_dialogFolderCopy;
    }

    public CmsResource.CmsResourceDeleteMode getDialogDeleteFileMode() {
        return this.m_dialogFileDelete;
    }

    public boolean getDialogExpandInheritedPermissions() {
        return this.m_dialogExpandInheritedPermissions;
    }

    public boolean getDialogExpandUserPermissions() {
        return this.m_dialogExpandUserPermissions;
    }

    public boolean getDialogPermissionsInheritOnFolder() {
        return this.m_dialogPermissionsInheritOnFolder;
    }

    public boolean getDialogPublishSiblings() {
        return this.m_dialogDirectpublish;
    }

    public boolean getDialogShowExportSettings() {
        return this.m_showExportSettings;
    }

    public boolean getDialogShowLock() {
        return this.m_showLock;
    }

    public int getDirectEditButtonStyle() {
        return this.m_directeditButtonStyle;
    }

    public int getEditorButtonStyle() {
        return this.m_editorButtonStyle;
    }

    public Map<String, String> getEditorSettings() {
        return this.m_editorSettings;
    }

    public int getExplorerButtonStyle() {
        return this.m_explorerButtonStyle;
    }

    public int getExplorerFileEntries() {
        return this.m_explorerFileEntries;
    }

    public String getExplorerFileEntryOptions() {
        return this.m_explorerFileEntryOptions;
    }

    public int getExplorerSettings() {
        return this.m_explorerSettings;
    }

    public boolean getListAllProjects() {
        return this.m_listAllProjects;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public Boolean getNewFolderCreateIndexPage() {
        return this.m_newFolderCreateIndexPage;
    }

    public Boolean getNewFolderEditProperties() {
        return this.m_newFolderEditProperties;
    }

    public String getPreferredEditor(String resourceType) {
        return (String)this.m_editorSettings.get(resourceType);
    }

    public String getPublishButtonAppearance() {
        return this.m_publishButtonAppearance;
    }

    public boolean getRestrictExplorerView() {
        return this.m_restrictExplorerView;
    }

    public boolean getShowFileUploadButton() {
        return this.m_showFileUploadButton;
    }

    public boolean getShowPublishNotification() {
        return this.m_showPublishNotification;
    }

    public Boolean getShowUploadTypeDialog() {
        return this.m_showUploadTypeDialog;
    }

    public String getStartFolder() {
        return this.m_startFolder;
    }

    public Map<String, String> getStartGalleriesSettings() {
        return this.m_startGalleriesSettings;
    }

    public String getStartGallery(String galleryType) {
        return (String)this.m_startGalleriesSettings.get(galleryType);
    }

    public String getStartGallery(String galleryType, CmsObject cms) {
        String startGallerySetting = this.getStartGallery(galleryType);
        String pathSetting = null;
        if (startGallerySetting != null && !startGallerySetting.equals("none")) {
            String sitePath = cms.getRequestContext().removeSiteRoot(startGallerySetting);
            pathSetting = cms.existsResource(sitePath) ? startGallerySetting : "default";
        } else if (startGallerySetting == null) {
            pathSetting = "default";
        }
        return pathSetting;
    }

    public String getStartProject() {
        return this.m_project;
    }

    public String getStartSite() {
        return this.m_startSite;
    }

    public String getStartView() {
        return this.m_view;
    }

    public CmsSynchronizeSettings getSynchronizeSettings() {
        return this.m_synchronizeSettings;
    }

    public long getTimeWarp() {
        return this.m_timeWarp;
    }

    public String getUploadAppletClientFolder() {
        return this.m_uploadAppletClientFolder;
    }

    public UploadVariant getUploadVariant() {
        return this.m_uploadVariant;
    }

    public CmsUser getUser() {
        return this.m_user;
    }

    public int getWorkplaceButtonStyle() {
        return this.m_workplaceButtonStyle;
    }

    public String getWorkplaceReportType() {
        return this.m_workplaceReportType;
    }

    public String getWorkplaceSearchIndexName() {
        return this.m_workplaceSearchIndexName;
    }

    public CmsSearchResultStyle getWorkplaceSearchViewStyle() {
        return this.m_workplaceSearchViewStyle;
    }

    public void init(CmsUser user) {
        block63: {
            String startFolder;
            this.m_user = user;
            try {
                this.m_workplaceButtonStyle = (Integer)this.m_user.getAdditionalInfo("USERPREFERENCES_workplace-generaloptionsbuttonstyle");
            }
            catch (Throwable t) {
                this.m_workplaceButtonStyle = OpenCms.getWorkplaceManager().getDefaultUserSettings().getWorkplaceButtonStyle();
            }
            Object timeWarpObj = this.m_user.getAdditionalInfo(ADDITIONAL_INFO_TIMEWARP);
            try {
                this.m_timeWarp = (Long)timeWarpObj;
            }
            catch (ClassCastException e) {
                try {
                    this.m_timeWarp = Long.parseLong((String)timeWarpObj);
                    if (this.m_timeWarp < 0L) {
                        this.m_timeWarp = -1L;
                    }
                }
                catch (Throwable t) {
                    this.m_timeWarp = -1L;
                }
            }
            catch (Throwable t) {
                this.m_timeWarp = -1L;
            }
            this.m_workplaceReportType = (String)this.m_user.getAdditionalInfo("USERPREFERENCES_workplace-generaloptionsreporttype");
            if (this.m_workplaceReportType == null) {
                this.m_workplaceReportType = OpenCms.getWorkplaceManager().getDefaultUserSettings().getWorkplaceReportType();
            }
            try {
                this.m_listAllProjects = (Boolean)this.m_user.getAdditionalInfo("USERPREFERENCES_workplace-generaloptionslistallprojects");
            }
            catch (Throwable t) {
                this.m_listAllProjects = OpenCms.getWorkplaceManager().getDefaultUserSettings().getListAllProjects();
            }
            try {
                this.m_showPublishNotification = (Boolean)this.m_user.getAdditionalInfo("USERPREFERENCES_workplace-generaloptionspublishnotification");
            }
            catch (Throwable t) {
                this.m_showPublishNotification = OpenCms.getWorkplaceManager().getDefaultUserSettings().getShowPublishNotification();
            }
            this.setUploadVariant(String.valueOf(this.m_user.getAdditionalInfo("USERPREFERENCES_workplace-generaloptionsuploadapplet")));
            Object obj = this.m_user.getAdditionalInfo("USERPREFERENCES_workplace-startupsettingslocale");
            this.m_locale = obj == null ? null : CmsLocaleManager.getLocale(String.valueOf(obj));
            if (this.m_locale == null) {
                this.m_locale = OpenCms.getWorkplaceManager().getDefaultUserSettings().getLocale();
            }
            try {
                this.m_project = (String)this.m_user.getAdditionalInfo("USERPREFERENCES_workplace-startupsettingsproject");
            }
            catch (Throwable t) {
                this.m_project = null;
            }
            if (this.m_project == null) {
                this.m_project = OpenCms.getWorkplaceManager().getDefaultUserSettings().getStartProject();
                String ou = user.getOuFqn();
                if (ou == null) {
                    ou = "";
                }
                this.m_project = user.getOuFqn() + this.m_project;
            }
            this.m_view = (String)this.m_user.getAdditionalInfo("USERPREFERENCES_workplace-startupsettingsworkplaceview");
            if (this.m_view == null) {
                this.m_view = OpenCms.getWorkplaceManager().getDefaultUserSettings().getStartView();
            }
            try {
                this.m_explorerButtonStyle = (Integer)this.m_user.getAdditionalInfo("USERPREFERENCES_explorer-generaloptionsbuttonstyle");
            }
            catch (Throwable t) {
                this.m_explorerButtonStyle = OpenCms.getWorkplaceManager().getDefaultUserSettings().getExplorerButtonStyle();
            }
            try {
                this.m_explorerFileEntries = (Integer)this.m_user.getAdditionalInfo("USERPREFERENCES_explorer-generaloptionsentries");
            }
            catch (Throwable t) {
                this.m_explorerFileEntries = OpenCms.getWorkplaceManager().getDefaultUserSettings().getExplorerFileEntries();
            }
            try {
                this.m_explorerSettings = (Integer)this.m_user.getAdditionalInfo("USERPREFERENCES_explorer-generaloptionsexplorer-displayoptions");
            }
            catch (Throwable t) {
                this.m_explorerSettings = OpenCms.getWorkplaceManager().getDefaultUserSettings().getExplorerSettings();
            }
            try {
                this.m_dialogFileCopy = CmsResource.CmsResourceCopyMode.valueOf((Integer)this.m_user.getAdditionalInfo("USERPREFERENCES_dialogs-defaultsettingsfilecopy"));
            }
            catch (Throwable t) {
                this.m_dialogFileCopy = OpenCms.getWorkplaceManager().getDefaultUserSettings().getDialogCopyFileMode();
            }
            try {
                this.m_dialogFolderCopy = CmsResource.CmsResourceCopyMode.valueOf((Integer)this.m_user.getAdditionalInfo("USERPREFERENCES_dialogs-defaultsettingsfoldercopy"));
            }
            catch (Throwable t) {
                this.m_dialogFolderCopy = OpenCms.getWorkplaceManager().getDefaultUserSettings().getDialogCopyFolderMode();
            }
            try {
                this.m_dialogFileDelete = CmsResource.CmsResourceDeleteMode.valueOf((Integer)this.m_user.getAdditionalInfo("USERPREFERENCES_dialogs-defaultsettingsfiledeletion"));
            }
            catch (Throwable t) {
                this.m_dialogFileDelete = OpenCms.getWorkplaceManager().getDefaultUserSettings().getDialogDeleteFileMode();
            }
            try {
                this.m_dialogDirectpublish = (Boolean)this.m_user.getAdditionalInfo("USERPREFERENCES_dialogs-defaultsettingsdirectpublish");
            }
            catch (Throwable t) {
                this.m_dialogDirectpublish = OpenCms.getWorkplaceManager().getDefaultUserSettings().getDialogPublishSiblings();
            }
            try {
                this.m_showLock = (Boolean)this.m_user.getAdditionalInfo("USERPREFERENCES_dialogs-defaultsettingsshowlock");
            }
            catch (Throwable t) {
                this.m_showLock = OpenCms.getWorkplaceManager().getDefaultUserSettings().getDialogShowLock();
            }
            try {
                this.m_showExportSettings = (Boolean)this.m_user.getAdditionalInfo("USERPREFERENCES_dialogs-defaultsettingsshowexportsettings");
            }
            catch (Throwable t) {
                this.m_showExportSettings = OpenCms.getWorkplaceManager().getDefaultUserSettings().getDialogShowExportSettings();
            }
            try {
                this.m_dialogPermissionsInheritOnFolder = (Boolean)this.m_user.getAdditionalInfo("USERPREFERENCES_dialogs-defaultsettingspermissions-inheritonfolder");
            }
            catch (Throwable t) {
                this.m_dialogPermissionsInheritOnFolder = OpenCms.getWorkplaceManager().getDefaultUserSettings().getDialogPermissionsInheritOnFolder();
            }
            try {
                this.m_dialogExpandInheritedPermissions = (Boolean)this.m_user.getAdditionalInfo("USERPREFERENCES_dialogs-defaultsettingsexpand-permissionsinherited");
            }
            catch (Throwable t) {
                this.m_dialogExpandInheritedPermissions = OpenCms.getWorkplaceManager().getDefaultUserSettings().getDialogExpandInheritedPermissions();
            }
            try {
                this.m_dialogExpandUserPermissions = (Boolean)this.m_user.getAdditionalInfo("USERPREFERENCES_dialogs-defaultsettingsexpand-permissionsuser");
            }
            catch (Throwable t) {
                this.m_dialogExpandUserPermissions = OpenCms.getWorkplaceManager().getDefaultUserSettings().getDialogExpandUserPermissions();
            }
            try {
                this.m_editorButtonStyle = (Integer)this.m_user.getAdditionalInfo("USERPREFERENCES_editors-generaloptionsbuttonstyle");
            }
            catch (Throwable t) {
                this.m_editorButtonStyle = OpenCms.getWorkplaceManager().getDefaultUserSettings().getEditorButtonStyle();
            }
            try {
                this.m_directeditButtonStyle = (Integer)this.m_user.getAdditionalInfo("USERPREFERENCES_editors-generaloptionsdirecteditstyle");
            }
            catch (Throwable t) {
                this.m_directeditButtonStyle = OpenCms.getWorkplaceManager().getDefaultUserSettings().getDirectEditButtonStyle();
            }
            this.m_editorSettings = new TreeMap<String, String>();
            for (String key : this.m_user.getAdditionalInfo().keySet()) {
                if (!key.startsWith("USERPREFERENCES_editors-preferrededitors")) continue;
                String editKey = key.substring("USERPREFERENCES_editors-preferrededitors".length());
                this.m_editorSettings.put(editKey, this.m_user.getAdditionalInfo(key).toString());
            }
            if (this.m_editorSettings.isEmpty()) {
                this.m_editorSettings = new TreeMap<String, String>(OpenCms.getWorkplaceManager().getDefaultUserSettings().getEditorSettings());
            }
            this.m_startGalleriesSettings = new TreeMap<String, String>();
            for (String key : this.m_user.getAdditionalInfo().keySet()) {
                if (!key.startsWith("USERPREFERENCES_startgalleries")) continue;
                String editKey = key.substring("USERPREFERENCES_startgalleries".length());
                this.m_startGalleriesSettings.put(editKey, this.m_user.getAdditionalInfo(key).toString());
            }
            if (this.m_startGalleriesSettings.isEmpty()) {
                this.m_startGalleriesSettings = new TreeMap<String, String>(OpenCms.getWorkplaceManager().getDefaultUserSettings().getStartGalleriesSettings());
            }
            this.m_startSite = (String)this.m_user.getAdditionalInfo("USERPREFERENCES_workplace-startupsettingssite");
            if (this.m_startSite == null) {
                this.m_startSite = OpenCms.getWorkplaceManager().getDefaultUserSettings().getStartSite();
            }
            if ((startFolder = (String)this.m_user.getAdditionalInfo("USERPREFERENCES_workplace-startupsettingsfolder")) == null) {
                startFolder = OpenCms.getWorkplaceManager().getDefaultUserSettings().getStartFolder();
            }
            this.setStartFolder(startFolder);
            try {
                this.m_restrictExplorerView = (Boolean)this.m_user.getAdditionalInfo("USERPREFERENCES_workplace-startupsettingsrestrictexplorerview");
            }
            catch (Throwable t) {
                this.m_restrictExplorerView = OpenCms.getWorkplaceManager().getDefaultUserSettings().getRestrictExplorerView();
            }
            this.m_workplaceSearchIndexName = OpenCms.getWorkplaceManager().getDefaultUserSettings().getWorkplaceSearchIndexName();
            this.m_workplaceSearchViewStyle = CmsSearchResultStyle.valueOf((String)this.m_user.getAdditionalInfo("USERPREFERENCES_workplace-searchsearchview-style"));
            if (this.m_workplaceSearchViewStyle == null) {
                this.m_workplaceSearchViewStyle = OpenCms.getWorkplaceManager().getDefaultUserSettings().getWorkplaceSearchViewStyle();
            }
            try {
                boolean enabled = (Boolean)this.m_user.getAdditionalInfo("USERPREFERENCES_SYNC_SETTINGS_ENABLED");
                String destination = (String)this.m_user.getAdditionalInfo("USERPREFERENCES_SYNC_SETTINGS_DESTINATION");
                List<String> vfsList = CmsStringUtil.splitAsList((String)this.m_user.getAdditionalInfo("USERPREFERENCES_SYNC_SETTINGS_VFS_LIST"), '|');
                this.m_synchronizeSettings = new CmsSynchronizeSettings();
                this.m_synchronizeSettings.setEnabled(enabled);
                this.m_synchronizeSettings.setDestinationPathInRfs(destination);
                this.m_synchronizeSettings.setSourceListInVfs(vfsList);
            }
            catch (Throwable t) {
                this.m_synchronizeSettings = null;
            }
            this.m_uploadAppletClientFolder = (String)this.m_user.getAdditionalInfo(ADDITIONAL_INFO_UPLOADAPPLET_CLIENTFOLDER);
            for (Map.Entry<String, Object> entry : this.m_user.getAdditionalInfo().entrySet()) {
                String key = entry.getKey();
                if (!key.startsWith(PREFERENCES_ADDITIONAL_PREFIX)) continue;
                try {
                    String value = (String)entry.getValue();
                    this.m_additionalPreferences.put(key.substring(PREFERENCES_ADDITIONAL_PREFIX.length()), value);
                }
                catch (ClassCastException e) {
                    LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            try {
                this.save(null);
            }
            catch (CmsException e) {
                if (!LOG.isWarnEnabled()) break block63;
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public void save(CmsObject cms) throws CmsException {
        if (this.getWorkplaceButtonStyle() != OpenCms.getWorkplaceManager().getDefaultUserSettings().getWorkplaceButtonStyle()) {
            this.m_user.setAdditionalInfo("USERPREFERENCES_workplace-generaloptionsbuttonstyle", new Integer(this.getWorkplaceButtonStyle()));
        } else if (cms != null) {
            this.m_user.deleteAdditionalInfo("USERPREFERENCES_workplace-generaloptionsbuttonstyle");
        }
        if (!this.getWorkplaceReportType().equals(OpenCms.getWorkplaceManager().getDefaultUserSettings().getWorkplaceReportType())) {
            this.m_user.setAdditionalInfo("USERPREFERENCES_workplace-generaloptionsreporttype", this.getWorkplaceReportType());
        } else if (cms != null) {
            this.m_user.deleteAdditionalInfo("USERPREFERENCES_workplace-generaloptionsreporttype");
        }
        if (this.getUploadVariant() != OpenCms.getWorkplaceManager().getDefaultUserSettings().getUploadVariant()) {
            this.m_user.setAdditionalInfo("USERPREFERENCES_workplace-generaloptionsuploadapplet", this.getUploadVariant().name());
        } else if (cms != null) {
            this.m_user.deleteAdditionalInfo("USERPREFERENCES_workplace-generaloptionsuploadapplet");
        }
        if (this.getListAllProjects() != OpenCms.getWorkplaceManager().getDefaultUserSettings().getListAllProjects()) {
            this.m_user.setAdditionalInfo("USERPREFERENCES_workplace-generaloptionslistallprojects", this.getListAllProjects());
        } else if (cms != null) {
            this.m_user.deleteAdditionalInfo("USERPREFERENCES_workplace-generaloptionslistallprojects");
        }
        if (this.getShowPublishNotification() != OpenCms.getWorkplaceManager().getDefaultUserSettings().getShowPublishNotification()) {
            this.m_user.setAdditionalInfo("USERPREFERENCES_workplace-generaloptionspublishnotification", this.getShowPublishNotification());
        } else if (cms != null) {
            this.m_user.deleteAdditionalInfo("USERPREFERENCES_workplace-generaloptionspublishnotification");
        }
        if (!this.getLocale().equals(OpenCms.getWorkplaceManager().getDefaultUserSettings().getLocale())) {
            this.m_user.setAdditionalInfo("USERPREFERENCES_workplace-startupsettingslocale", this.getLocale().toString());
        } else if (cms != null) {
            this.m_user.deleteAdditionalInfo("USERPREFERENCES_workplace-startupsettingslocale");
        }
        if (!this.getStartProject().equals(OpenCms.getWorkplaceManager().getDefaultUserSettings().getStartProject())) {
            try {
                if (cms != null) {
                    cms.readProject(this.getStartProject());
                }
                this.m_user.setAdditionalInfo("USERPREFERENCES_workplace-startupsettingsproject", this.getStartProject());
            }
            catch (Exception e) {
                if (cms != null) {
                    this.m_user.deleteAdditionalInfo("USERPREFERENCES_workplace-startupsettingsproject");
                }
            }
        } else if (cms != null) {
            this.m_user.deleteAdditionalInfo("USERPREFERENCES_workplace-startupsettingsproject");
        }
        if (!this.getStartView().equals(OpenCms.getWorkplaceManager().getDefaultUserSettings().getStartView())) {
            this.m_user.setAdditionalInfo("USERPREFERENCES_workplace-startupsettingsworkplaceview", this.getStartView());
        } else if (cms != null) {
            this.m_user.deleteAdditionalInfo("USERPREFERENCES_workplace-startupsettingsworkplaceview");
        }
        if (!this.getStartSite().equals(OpenCms.getWorkplaceManager().getDefaultUserSettings().getStartSite())) {
            this.m_user.setAdditionalInfo("USERPREFERENCES_workplace-startupsettingssite", this.getStartSite());
        } else if (cms != null) {
            this.m_user.deleteAdditionalInfo("USERPREFERENCES_workplace-startupsettingssite");
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getStartFolder()) && !this.getStartFolder().equals(OpenCms.getWorkplaceManager().getDefaultUserSettings().getStartFolder())) {
            this.m_user.setAdditionalInfo("USERPREFERENCES_workplace-startupsettingsfolder", this.getStartFolder());
        } else if (cms != null) {
            this.m_user.deleteAdditionalInfo("USERPREFERENCES_workplace-startupsettingsfolder");
        }
        if (this.getRestrictExplorerView() != OpenCms.getWorkplaceManager().getDefaultUserSettings().getRestrictExplorerView()) {
            this.m_user.setAdditionalInfo("USERPREFERENCES_workplace-startupsettingsrestrictexplorerview", this.getRestrictExplorerView());
        } else if (cms != null) {
            this.m_user.deleteAdditionalInfo("USERPREFERENCES_workplace-startupsettingsrestrictexplorerview");
        }
        if (this.getExplorerButtonStyle() != OpenCms.getWorkplaceManager().getDefaultUserSettings().getExplorerButtonStyle()) {
            this.m_user.setAdditionalInfo("USERPREFERENCES_explorer-generaloptionsbuttonstyle", new Integer(this.getExplorerButtonStyle()));
        } else if (cms != null) {
            this.m_user.deleteAdditionalInfo("USERPREFERENCES_explorer-generaloptionsbuttonstyle");
        }
        if (this.getExplorerFileEntries() != OpenCms.getWorkplaceManager().getDefaultUserSettings().getExplorerFileEntries()) {
            this.m_user.setAdditionalInfo("USERPREFERENCES_explorer-generaloptionsentries", new Integer(this.getExplorerFileEntries()));
        } else if (cms != null) {
            this.m_user.deleteAdditionalInfo("USERPREFERENCES_explorer-generaloptionsentries");
        }
        if (this.getExplorerSettings() != OpenCms.getWorkplaceManager().getDefaultUserSettings().getExplorerSettings()) {
            this.m_user.setAdditionalInfo("USERPREFERENCES_explorer-generaloptionsexplorer-displayoptions", new Integer(this.getExplorerSettings()));
        } else if (cms != null) {
            this.m_user.deleteAdditionalInfo("USERPREFERENCES_explorer-generaloptionsexplorer-displayoptions");
        }
        if (this.getDialogCopyFileMode() != OpenCms.getWorkplaceManager().getDefaultUserSettings().getDialogCopyFileMode()) {
            this.m_user.setAdditionalInfo("USERPREFERENCES_dialogs-defaultsettingsfilecopy", new Integer(this.getDialogCopyFileMode().getMode()));
        } else if (cms != null) {
            this.m_user.deleteAdditionalInfo("USERPREFERENCES_dialogs-defaultsettingsfilecopy");
        }
        if (this.getDialogCopyFolderMode() != OpenCms.getWorkplaceManager().getDefaultUserSettings().getDialogCopyFolderMode()) {
            this.m_user.setAdditionalInfo("USERPREFERENCES_dialogs-defaultsettingsfoldercopy", new Integer(this.getDialogCopyFolderMode().getMode()));
        } else if (cms != null) {
            this.m_user.deleteAdditionalInfo("USERPREFERENCES_dialogs-defaultsettingsfoldercopy");
        }
        if (this.getDialogDeleteFileMode() != OpenCms.getWorkplaceManager().getDefaultUserSettings().getDialogDeleteFileMode()) {
            this.m_user.setAdditionalInfo("USERPREFERENCES_dialogs-defaultsettingsfiledeletion", new Integer(this.getDialogDeleteFileMode().getMode()));
        } else if (cms != null) {
            this.m_user.deleteAdditionalInfo("USERPREFERENCES_dialogs-defaultsettingsfiledeletion");
        }
        if (this.getDialogPublishSiblings() != OpenCms.getWorkplaceManager().getDefaultUserSettings().getDialogPublishSiblings()) {
            this.m_user.setAdditionalInfo("USERPREFERENCES_dialogs-defaultsettingsdirectpublish", this.getDialogPublishSiblings());
        } else if (cms != null) {
            this.m_user.deleteAdditionalInfo("USERPREFERENCES_dialogs-defaultsettingsdirectpublish");
        }
        if (this.getDialogShowLock() != OpenCms.getWorkplaceManager().getDefaultUserSettings().getDialogShowLock()) {
            this.m_user.setAdditionalInfo("USERPREFERENCES_dialogs-defaultsettingsshowlock", this.getDialogShowLock());
        } else if (cms != null) {
            this.m_user.deleteAdditionalInfo("USERPREFERENCES_dialogs-defaultsettingsshowlock");
        }
        if (this.getDialogPermissionsInheritOnFolder() != OpenCms.getWorkplaceManager().getDefaultUserSettings().getDialogPermissionsInheritOnFolder()) {
            this.m_user.setAdditionalInfo("USERPREFERENCES_dialogs-defaultsettingspermissions-inheritonfolder", this.getDialogPermissionsInheritOnFolder());
        } else if (cms != null) {
            this.m_user.deleteAdditionalInfo("USERPREFERENCES_dialogs-defaultsettingspermissions-inheritonfolder");
        }
        if (this.getDialogExpandInheritedPermissions() != OpenCms.getWorkplaceManager().getDefaultUserSettings().getDialogExpandInheritedPermissions()) {
            this.m_user.setAdditionalInfo("USERPREFERENCES_dialogs-defaultsettingsexpand-permissionsinherited", this.getDialogExpandInheritedPermissions());
        } else if (cms != null) {
            this.m_user.deleteAdditionalInfo("USERPREFERENCES_dialogs-defaultsettingsexpand-permissionsinherited");
        }
        if (this.getDialogExpandUserPermissions() != OpenCms.getWorkplaceManager().getDefaultUserSettings().getDialogExpandUserPermissions()) {
            this.m_user.setAdditionalInfo("USERPREFERENCES_dialogs-defaultsettingsexpand-permissionsuser", this.getDialogExpandUserPermissions());
        } else if (cms != null) {
            this.m_user.deleteAdditionalInfo("USERPREFERENCES_dialogs-defaultsettingsexpand-permissionsuser");
        }
        if (this.getEditorButtonStyle() != OpenCms.getWorkplaceManager().getDefaultUserSettings().getEditorButtonStyle()) {
            this.m_user.setAdditionalInfo("USERPREFERENCES_editors-generaloptionsbuttonstyle", new Integer(this.getEditorButtonStyle()));
        } else if (cms != null) {
            this.m_user.deleteAdditionalInfo("USERPREFERENCES_editors-generaloptionsbuttonstyle");
        }
        if (this.getDirectEditButtonStyle() != OpenCms.getWorkplaceManager().getDefaultUserSettings().getDirectEditButtonStyle()) {
            this.m_user.setAdditionalInfo("USERPREFERENCES_editors-generaloptionsdirecteditstyle", new Integer(this.getDirectEditButtonStyle()));
        } else if (cms != null) {
            this.m_user.deleteAdditionalInfo("USERPREFERENCES_editors-generaloptionsdirecteditstyle");
        }
        if (this.m_editorSettings.size() > 0) {
            for (Map.Entry<String, String> entry : this.m_editorSettings.entrySet()) {
                if (entry.getValue() != null) {
                    this.m_user.setAdditionalInfo("USERPREFERENCES_editors-preferrededitors" + entry.getKey(), entry.getValue());
                    continue;
                }
                this.m_user.deleteAdditionalInfo("USERPREFERENCES_editors-preferrededitors" + entry.getKey());
            }
        } else if (cms != null) {
            Iterator<String> itKeys = this.m_user.getAdditionalInfo().keySet().iterator();
            ArrayList<String> keysToDelete = new ArrayList<String>(3);
            while (itKeys.hasNext()) {
                String string = itKeys.next();
                if (!string.startsWith("USERPREFERENCES_editors-preferrededitors")) continue;
                keysToDelete.add(string);
            }
            for (String string : keysToDelete) {
                this.m_user.deleteAdditionalInfo(string);
            }
        }
        if (this.m_startGalleriesSettings.size() > 0) {
            for (Map.Entry<String, String> entry : this.m_startGalleriesSettings.entrySet()) {
                if (entry.getValue() != null && !entry.getValue().equals("default")) {
                    this.m_user.setAdditionalInfo("USERPREFERENCES_startgalleries" + entry.getKey(), entry.getValue());
                    continue;
                }
                this.m_user.deleteAdditionalInfo("USERPREFERENCES_startgalleries" + entry.getKey());
            }
        } else if (cms != null) {
            for (String key : this.m_user.getAdditionalInfo().keySet()) {
                if (!key.startsWith("USERPREFERENCES_startgalleries")) continue;
                this.m_user.deleteAdditionalInfo(key);
            }
        }
        if (this.getWorkplaceSearchViewStyle() != null) {
            this.m_user.setAdditionalInfo("USERPREFERENCES_workplace-searchsearchview-style", this.getWorkplaceSearchViewStyle().toString());
        }
        if (this.getSynchronizeSettings() != null) {
            this.m_user.setAdditionalInfo("USERPREFERENCES_SYNC_SETTINGS_ENABLED", this.getSynchronizeSettings().isEnabled());
            this.m_user.setAdditionalInfo("USERPREFERENCES_SYNC_SETTINGS_DESTINATION", this.getSynchronizeSettings().getDestinationPathInRfs());
            this.m_user.setAdditionalInfo("USERPREFERENCES_SYNC_SETTINGS_VFS_LIST", CmsStringUtil.collectionAsString(this.getSynchronizeSettings().getSourceListInVfs(), "|"));
        } else {
            this.m_user.deleteAdditionalInfo("USERPREFERENCES_SYNC_SETTINGS_ENABLED");
            this.m_user.deleteAdditionalInfo("USERPREFERENCES_SYNC_SETTINGS_DESTINATION");
            this.m_user.deleteAdditionalInfo("USERPREFERENCES_SYNC_SETTINGS_VFS_LIST");
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_uploadAppletClientFolder)) {
            this.m_user.setAdditionalInfo(ADDITIONAL_INFO_UPLOADAPPLET_CLIENTFOLDER, this.m_uploadAppletClientFolder);
        } else {
            this.m_user.deleteAdditionalInfo(ADDITIONAL_INFO_UPLOADAPPLET_CLIENTFOLDER);
        }
        if (this.getTimeWarp() != -1L) {
            this.m_user.setAdditionalInfo(ADDITIONAL_INFO_TIMEWARP, new Long(this.getTimeWarp()));
        } else if (cms != null) {
            this.m_user.deleteAdditionalInfo(ADDITIONAL_INFO_TIMEWARP);
        }
        HashSet<String> additionalInfosToDelete = new HashSet<String>();
        for (String string : this.m_user.getAdditionalInfo().keySet()) {
            if (!string.startsWith(PREFERENCES_ADDITIONAL_PREFIX) || this.m_additionalPreferences.containsKey(string.substring(PREFERENCES_ADDITIONAL_PREFIX.length()))) continue;
            additionalInfosToDelete.add(string);
        }
        for (String string : additionalInfosToDelete) {
            this.m_user.deleteAdditionalInfo(string);
        }
        for (Map.Entry entry : this.m_additionalPreferences.entrySet()) {
            String string = (String)entry.getKey();
            String value = (String)entry.getValue();
            this.m_user.setAdditionalInfo(PREFERENCES_ADDITIONAL_PREFIX + string, value);
        }
        if (cms != null) {
            cms.writeUser(this.m_user);
        }
    }

    public void setAdditionalPreference(String name, String value) {
        if (value == null) {
            this.m_additionalPreferences.remove(name);
        } else {
            this.m_additionalPreferences.put(name, value);
        }
    }

    public void setAdditionalPreferencesFrom(CmsUserSettings userSettings) {
        this.m_additionalPreferences = Maps.newLinkedHashMap(userSettings.m_additionalPreferences);
    }

    public void setDialogCopyFileMode(CmsResource.CmsResourceCopyMode mode) {
        this.m_dialogFileCopy = mode;
    }

    public void setDialogCopyFolderMode(CmsResource.CmsResourceCopyMode mode) {
        this.m_dialogFolderCopy = mode;
    }

    public void setDialogDeleteFileMode(CmsResource.CmsResourceDeleteMode mode) {
        this.m_dialogFileDelete = mode;
    }

    public void setDialogExpandInheritedPermissions(boolean dialogShowInheritedPermissions) {
        this.m_dialogExpandInheritedPermissions = dialogShowInheritedPermissions;
    }

    public void setDialogExpandUserPermissions(boolean dialogShowUserPermissions) {
        this.m_dialogExpandUserPermissions = dialogShowUserPermissions;
    }

    public void setDialogPermissionsInheritOnFolder(boolean dialogPermissionsInheritOnFolder) {
        this.m_dialogPermissionsInheritOnFolder = dialogPermissionsInheritOnFolder;
    }

    public void setDialogPublishSiblings(boolean publishSiblings) {
        this.m_dialogDirectpublish = publishSiblings;
    }

    public void setDialogShowExportSettings(boolean show) {
        this.m_showExportSettings = show;
    }

    public void setDialogShowLock(boolean show) {
        this.m_showLock = show;
    }

    public void setDirectEditButtonStyle(int style) {
        this.m_directeditButtonStyle = style;
    }

    public void setEditorButtonStyle(int style) {
        this.m_editorButtonStyle = style;
    }

    public void setEditorSettings(Map<String, String> settings) {
        this.m_editorSettings = new TreeMap<String, String>(settings);
    }

    public void setExplorerButtonStyle(int style) {
        this.m_explorerButtonStyle = style;
    }

    public void setExplorerFileEntries(int entries) {
        this.m_explorerFileEntries = entries;
    }

    public void setExplorerFileEntryOptions(String explorerFileEntryOptions) {
        this.m_explorerFileEntryOptions = explorerFileEntryOptions;
    }

    public void setExplorerSettings(int settings) {
        this.m_explorerSettings = settings;
    }

    public void setListAllProjects(boolean listAllProjects) {
        this.m_listAllProjects = listAllProjects;
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    public void setNewFolderCreateIndexPage(Boolean setting) {
        this.m_newFolderCreateIndexPage = setting;
    }

    public void setNewFolderEditPropertes(Boolean setting) {
        this.m_newFolderEditProperties = setting;
    }

    public void setPreferredEditor(String resourceType, String editorUri) {
        if (editorUri == null) {
            this.m_editorSettings.remove(resourceType);
        } else {
            this.m_editorSettings.put(resourceType, editorUri);
        }
    }

    public void setPublishButtonAppearance(String publishButtonAppearance) {
        String value = "always";
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(publishButtonAppearance)) {
            if ("auto".equals(publishButtonAppearance = publishButtonAppearance.trim().toLowerCase())) {
                value = "auto";
            } else if ("never".equals(publishButtonAppearance)) {
                value = "never";
            }
        }
        this.m_publishButtonAppearance = value;
    }

    public void setRestrictExplorerView(boolean restrict) {
        this.m_restrictExplorerView = restrict;
    }

    public void setShowExplorerFileDateCreated(boolean show) {
        this.setExplorerSetting(show, 1024);
    }

    public void setShowExplorerFileDateExpired(boolean show) {
        this.setExplorerSetting(show, 8192);
    }

    public void setShowExplorerFileDateLastModified(boolean show) {
        this.setExplorerSetting(show, 4);
    }

    public void setShowExplorerFileDateReleased(boolean show) {
        this.setExplorerSetting(show, 4096);
    }

    public void setShowExplorerFileLockedBy(boolean show) {
        this.setExplorerSetting(show, 256);
    }

    public void setShowExplorerFileNavText(boolean show) {
        this.setExplorerSetting(show, 64);
    }

    public void setShowExplorerFilePermissions(boolean show) {
        this.setExplorerSetting(show, 128);
    }

    public void setShowExplorerFileSize(boolean show) {
        this.setExplorerSetting(show, 8);
    }

    public void setShowExplorerFileState(boolean show) {
        this.setExplorerSetting(show, 16);
    }

    public void setShowExplorerFileTitle(boolean show) {
        this.setExplorerSetting(show, 1);
    }

    public void setShowExplorerFileType(boolean show) {
        this.setExplorerSetting(show, 2);
    }

    public void setShowExplorerFileUserCreated(boolean show) {
        this.setExplorerSetting(show, 32);
    }

    public void setShowExplorerFileUserLastModified(boolean show) {
        this.setExplorerSetting(show, 2048);
    }

    public void setShowFileUploadButton(boolean flag) {
        this.m_showFileUploadButton = flag;
    }

    public void setShowPublishNotification(boolean showPublishNotification) {
        this.m_showPublishNotification = showPublishNotification;
    }

    public void setShowUploadTypeDialog(Boolean showUploadTypeDialog) {
        this.m_showUploadTypeDialog = showUploadTypeDialog;
    }

    public void setStartFolder(String folder) {
        if (!folder.startsWith("/")) {
            folder = "/" + folder;
        }
        if (!folder.endsWith("/")) {
            folder = folder + "/";
        }
        this.m_startFolder = folder;
    }

    public void setStartGalleriesSetting(Map<String, String> settings) {
        this.m_startGalleriesSettings = new TreeMap<String, String>(settings);
    }

    public void setStartGallery(String galleryType, String galleryUri) {
        if (galleryUri == null) {
            this.m_startGalleriesSettings.remove(galleryType);
        } else {
            this.m_startGalleriesSettings.put(galleryType, galleryUri);
        }
    }

    public void setStartProject(String project) {
        this.m_project = project;
    }

    public void setStartSite(String site) {
        this.m_startSite = site;
    }

    public void setStartView(String view) {
        this.m_view = view;
    }

    public void setSynchronizeSettings(CmsSynchronizeSettings synchronizeSettings) {
        this.m_synchronizeSettings = synchronizeSettings;
    }

    public void setTimeWarp(long timewarp) {
        if (timewarp < 0L) {
            timewarp = -1L;
        }
        this.m_timeWarp = timewarp;
    }

    public void setUploadAppletClientFolder(String uploadAppletClientFolder) {
        this.m_uploadAppletClientFolder = uploadAppletClientFolder;
    }

    public void setUploadVariant(String uploadVariant) {
        UploadVariant upload;
        block3: {
            upload = null;
            try {
                upload = UploadVariant.valueOf(uploadVariant);
            }
            catch (Exception e) {
                if (upload == null) {
                    upload = OpenCms.getWorkplaceManager().getDefaultUserSettings().getUploadVariant();
                }
                if (upload != null) break block3;
                upload = UploadVariant.gwt;
            }
        }
        this.setUploadVariant(upload);
    }

    public void setUploadVariant(UploadVariant uploadVariant) {
        this.m_uploadVariant = uploadVariant;
    }

    public void setUser(CmsUser user) {
        this.m_user = user;
    }

    public void setWorkplaceButtonStyle(int style) {
        this.m_workplaceButtonStyle = style;
    }

    public void setWorkplaceReportType(String type) {
        this.m_workplaceReportType = type;
    }

    public void setWorkplaceSearchIndexName(String workplaceSearchIndexName) {
        this.m_workplaceSearchIndexName = workplaceSearchIndexName;
    }

    public void setWorkplaceSearchViewStyle(CmsSearchResultStyle workplaceSearchViewStyle) {
        this.m_workplaceSearchViewStyle = workplaceSearchViewStyle;
    }

    public boolean showExplorerFileDateCreated() {
        return (this.m_explorerSettings & 0x400) > 0;
    }

    public boolean showExplorerFileDateExpired() {
        return (this.m_explorerSettings & 0x2000) > 0;
    }

    public boolean showExplorerFileDateLastModified() {
        return (this.m_explorerSettings & 4) > 0;
    }

    public boolean showExplorerFileDateReleased() {
        return (this.m_explorerSettings & 0x1000) > 0;
    }

    public boolean showExplorerFileLockedBy() {
        return (this.m_explorerSettings & 0x100) > 0;
    }

    public boolean showExplorerFileNavText() {
        return (this.m_explorerSettings & 0x40) > 0;
    }

    public boolean showExplorerFilePermissions() {
        return (this.m_explorerSettings & 0x80) > 0;
    }

    public boolean showExplorerFileSize() {
        return (this.m_explorerSettings & 8) > 0;
    }

    public boolean showExplorerFileState() {
        return (this.m_explorerSettings & 0x10) > 0;
    }

    public boolean showExplorerFileTitle() {
        return (this.m_explorerSettings & 1) > 0;
    }

    public boolean showExplorerFileType() {
        return (this.m_explorerSettings & 2) > 0;
    }

    public boolean showExplorerFileUserCreated() {
        return (this.m_explorerSettings & 0x20) > 0;
    }

    public boolean showExplorerFileUserLastModified() {
        return (this.m_explorerSettings & 0x800) > 0;
    }

    public boolean startWithNewWorkplace() {
        return ("/system/workplace/views/explorer/explorer_fs.jsp".equals(this.getStartView()) || "/system/workplace/views/admin/admin-fs.jsp".equals(this.getStartView())) && this.usesNewWorkplace();
    }

    public boolean usesNewWorkplace() {
        boolean traditionalWorkplaceExists = OpenCms.getModuleManager().hasModule("org.opencms.workplace.traditional");
        if (!traditionalWorkplaceExists) {
            return true;
        }
        return !WORKPLACE_MODE_OLD.equals(this.getAdditionalPreference(PREF_WORKPLACE_MODE, true));
    }

    private void setExplorerSetting(boolean set, int setting) {
        this.m_explorerSettings = set ? (this.m_explorerSettings |= setting) : (this.m_explorerSettings &= ~setting);
    }

    public static enum UploadVariant {
        basic,
        gwt;

    }

    public static final class CmsSearchResultStyle
    extends A_CmsModeStringEnumeration {
        public static final CmsSearchResultStyle STYLE_EXPLORER = new CmsSearchResultStyle("explorer", "GUI_WORKPLACE_SEARCH_STYLE_EXPLORER_0");
        public static final CmsSearchResultStyle STYLE_LIST_WITH_EXCERPTS = new CmsSearchResultStyle("list-with-excerpts", "GUI_WORKPLACE_SEARCH_STYLE_LIST_WITH_EXCERPTS_0");
        public static final CmsSearchResultStyle STYLE_LIST_WITHOUT_EXCERPTS = new CmsSearchResultStyle("list-without-excerpts", "GUI_WORKPLACE_SEARCH_STYLE_LIST_WITHOUT_EXCERPTS_0");
        private static final long serialVersionUID = 6611568161885127011L;
        private final String m_key;

        private CmsSearchResultStyle(String style, String key) {
            super(style);
            this.m_key = key;
        }

        public static CmsSearchResultStyle valueOf(String mode) {
            if (STYLE_LIST_WITHOUT_EXCERPTS.getMode().equals(mode)) {
                return STYLE_LIST_WITHOUT_EXCERPTS;
            }
            if (STYLE_LIST_WITH_EXCERPTS.getMode().equals(mode)) {
                return STYLE_LIST_WITH_EXCERPTS;
            }
            return STYLE_EXPLORER;
        }

        public String getKey() {
            return this.m_key;
        }
    }
}

