/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.I_CmsResourceInit;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;

public class CmsUserTrackingResourceHandler
implements I_CmsResourceInit {
    public static final String PROPERTY_USERTRACKING_MARK = "usertracking.mark";
    public static final String VALUE_ONLINE = "online";
    private static final Log LOG = CmsLog.getLog(CmsUserTrackingResourceHandler.class);

    @Override
    public CmsResource initResource(CmsResource resource, CmsObject cms, HttpServletRequest req, HttpServletResponse res) {
        if (resource != null && resource.isFile()) {
            String mark = "";
            try {
                mark = cms.readPropertyObject(resource, PROPERTY_USERTRACKING_MARK, true).getValue(CmsStringUtil.FALSE);
            }
            catch (CmsException cmsException) {
                // empty catch block
            }
            if (Boolean.valueOf(mark).booleanValue() || VALUE_ONLINE.equalsIgnoreCase(mark) && cms.getRequestContext().getCurrentProject().isOnlineProject()) {
                try {
                    OpenCms.getSubscriptionManager().markResourceAsVisitedBy(cms, resource, cms.getRequestContext().getCurrentUser());
                }
                catch (CmsException e) {
                    LOG.error((Object)e);
                }
            }
        }
        return resource;
    }
}

