/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db.jpa;

import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsConfigurationManager;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.db.CmsDbContext;
import org.opencms.db.CmsDbEntryNotFoundException;
import org.opencms.db.CmsDbIoException;
import org.opencms.db.CmsDbSqlException;
import org.opencms.db.CmsDriverManager;
import org.opencms.db.CmsPublishList;
import org.opencms.db.CmsPublishedResource;
import org.opencms.db.CmsResourceState;
import org.opencms.db.CmsVisitEntryFilter;
import org.opencms.db.I_CmsDriver;
import org.opencms.db.I_CmsHistoryDriver;
import org.opencms.db.I_CmsProjectDriver;
import org.opencms.db.I_CmsVfsDriver;
import org.opencms.db.generic.Messages;
import org.opencms.db.jpa.CmsSqlManager;
import org.opencms.db.jpa.CmsVfsDriver;
import org.opencms.db.jpa.persistence.CmsDAOLog;
import org.opencms.db.jpa.persistence.CmsDAOOfflineResources;
import org.opencms.db.jpa.persistence.CmsDAOOfflineStructure;
import org.opencms.db.jpa.persistence.CmsDAOProjectResources;
import org.opencms.db.jpa.persistence.CmsDAOProjects;
import org.opencms.db.jpa.persistence.CmsDAOPublishHistory;
import org.opencms.db.jpa.persistence.CmsDAOPublishJobs;
import org.opencms.db.jpa.persistence.CmsDAOResourceLocks;
import org.opencms.db.jpa.persistence.CmsDAOStaticExportLinks;
import org.opencms.db.jpa.persistence.CmsDAOUserPublishListEntry;
import org.opencms.db.jpa.utils.CmsQueryIntParameter;
import org.opencms.db.jpa.utils.CmsQueryLongParameter;
import org.opencms.db.jpa.utils.CmsQueryStringParameter;
import org.opencms.db.jpa.utils.I_CmsQueryParameter;
import org.opencms.db.log.CmsLogEntry;
import org.opencms.db.log.CmsLogEntryType;
import org.opencms.db.log.CmsLogFilter;
import org.opencms.db.userpublishlist.CmsUserPublishListEntry;
import org.opencms.file.CmsDataAccessException;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsFolder;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.CmsVfsResourceAlreadyExistsException;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.history.CmsHistoryFile;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.lock.CmsLock;
import org.opencms.lock.CmsLockType;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.publish.CmsPublishJobInfoBean;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.report.I_CmsReport;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.util.CmsDataTypeUtil;
import org.opencms.util.CmsPair;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsProjectDriver
implements I_CmsDriver,
I_CmsProjectDriver {
    public static final String DBC_ATTR_READ_PROJECT_FOR_RESOURCE = "DBC_ATTR_READ_PROJECT_FOR_RESOURCE";
    private static final String C_DELETE_PUBLISH_HISTORY = "C_DELETE_PUBLISH_HISTORY";
    private static final String C_LOG_DELETE_ENTRIES = "C_LOG_DELETE_ENTRIES";
    private static final String C_LOG_FILTER_DATE_FROM = "C_LOG_FILTER_DATE_FROM";
    private static final String C_LOG_FILTER_DATE_TO = "C_LOG_FILTER_DATE_TO";
    private static final String C_LOG_FILTER_EXCLUDE_TYPE = "C_LOG_FILTER_EXCLUDE_TYPE";
    private static final String C_LOG_FILTER_INCLUDE_TYPE = "C_LOG_FILTER_INCLUDE_TYPE";
    private static final String C_LOG_FILTER_RESOURCE_ID = "C_LOG_FILTER_RESOURCE_ID";
    private static final String C_LOG_FILTER_USER_ID = "C_LOG_FILTER_USER_ID";
    private static final String C_LOG_READ_ENTRIES = "C_LOG_READ_ENTRIES";
    private static final String C_PROJECTRESOURCES_DELETEALL_1 = "C_PROJECTRESOURCES_DELETEALL_1";
    private static final String C_PROJECTRESOURCES_READ_2 = "C_PROJECTRESOURCES_READ_2";
    private static final String C_PROJECTRESOURCES_READ_BY_ID_1 = "C_PROJECTRESOURCES_READ_BY_ID_1";
    private static final String C_PROJECTS_READ_1 = "C_PROJECTS_READ_1";
    private static final String C_PROJECTS_READ_BYGROUP_2 = "C_PROJECTS_READ_BYGROUP_2";
    private static final String C_PROJECTS_READ_BYMANAGER_1 = "C_PROJECTS_READ_BYMANAGER_1";
    private static final String C_PROJECTS_READ_BYNAME_2 = "C_PROJECTS_READ_BYNAME_2";
    private static final String C_PROJECTS_READ_BYOU_1 = "C_PROJECTS_READ_BYOU_1";
    private static final String C_PROJECTS_READ_BYRESOURCE_1 = "C_PROJECTS_READ_BYRESOURCE_1";
    private static final String C_PROJECTS_READ_BYUSER_1 = "C_PROJECTS_READ_BYUSER_1";
    private static final String C_PROJECTS_WRITE_6 = "C_PROJECTS_WRITE_6";
    private static final String C_PUBLISHJOB_DELETE_PUBLISHLIST = "C_PUBLISHJOB_DELETE_PUBLISHLIST";
    private static final String C_PUBLISHJOB_READ_JOB = "C_PUBLISHJOB_READ_JOB";
    private static final String C_PUBLISHJOB_READ_JOBS_IN_TIMERANGE = "C_PUBLISHJOB_READ_JOBS_IN_TIMERANGE";
    private static final String C_PUBLISHJOB_READ_PUBLISHLIST = "C_PUBLISHJOB_READ_PUBLISHLIST";
    private static final String C_PUBLISHJOB_READ_REPORT = "C_PUBLISHJOB_READ_REPORT";
    private static final String C_RESOURCE_LOCKS_DELETEALL = "C_RESOURCE_LOCKS_DELETEALL";
    private static final String C_RESOURCE_LOCKS_READALL = "C_RESOURCE_LOCKS_READALL";
    private static final String C_RESOURCES_DELETE_PUBLISH_HISTORY_ENTRY = "C_RESOURCES_DELETE_PUBLISH_HISTORY_ENTRY";
    private static final String C_RESOURCES_UNMARK = "C_RESOURCES_UNMARK";
    private static final String C_SELECT_PUBLISHED_RESOURCES = "C_SELECT_PUBLISHED_RESOURCES";
    private static final String C_STATICEXPORT_DELETE_ALL_PUBLISHED_LINKS = "C_STATICEXPORT_DELETE_ALL_PUBLISHED_LINKS";
    private static final String C_STATICEXPORT_DELETE_PUBLISHED_LINKS = "C_STATICEXPORT_DELETE_PUBLISHED_LINKS";
    private static final String C_STATICEXPORT_READ_ALL_PUBLISHED_LINKS = "C_STATICEXPORT_READ_ALL_PUBLISHED_LINKS";
    private static final String C_STATICEXPORT_READ_PUBLISHED_LINK_PARAMETERS = "C_STATICEXPORT_READ_PUBLISHED_LINK_PARAMETERS";
    private static final String C_STATICEXPORT_READ_PUBLISHED_RESOURCES = "C_STATICEXPORT_READ_PUBLISHED_RESOURCES";
    private static final Log LOG = CmsLog.getLog(CmsProjectDriver.class);
    protected CmsDriverManager m_driverManager;
    protected CmsSqlManager m_sqlManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CmsProject createProject(CmsDbContext dbc, CmsUUID id, CmsUser owner, CmsGroup group, CmsGroup managergroup, String projectFqn, String description, int flags, CmsProject.CmsProjectType type) throws CmsDataAccessException {
        CmsProject project = null;
        if (description == null || description.length() < 1) {
            description = " ";
        }
        try {
            CmsDAOProjects p = new CmsDAOProjects();
            p.setProjectId(id.toString());
            p.setUserId(owner.getId().toString());
            p.setGroupId(group.getId().toString());
            p.setManagerGroupId(managergroup.getId().toString());
            p.setProjectName(CmsOrganizationalUnit.getSimpleName(projectFqn));
            p.setProjectDescription(description);
            p.setProjectFlags(flags);
            p.setProjectType(type.getMode());
            p.setProjectOu("/" + CmsOrganizationalUnit.getParentFqn(projectFqn));
            CmsProjectDriver cmsProjectDriver = this;
            synchronized (cmsProjectDriver) {
                long createTime = System.currentTimeMillis();
                p.setDateCreated(createTime);
                this.m_sqlManager.persist(dbc, p);
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                project = new CmsProject(id, projectFqn, description, owner.getId(), group.getId(), managergroup.getId(), flags, createTime, type);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return project;
    }

    @Override
    public void createProjectResource(CmsDbContext dbc, CmsUUID projectId, String resourcePath) throws CmsDataAccessException {
        boolean projectResourceExists = false;
        try {
            this.readProjectResource(dbc, projectId, resourcePath);
            projectResourceExists = true;
        }
        catch (CmsVfsResourceNotFoundException e) {
            projectResourceExists = false;
        }
        if (projectResourceExists) {
            throw new CmsVfsResourceAlreadyExistsException(Messages.get().container("ERR_RESOURCE_WITH_NAME_ALREADY_EXISTS_1", dbc.removeSiteRoot(resourcePath)));
        }
        try {
            CmsDAOProjectResources pr = new CmsDAOProjectResources();
            pr.setProjectId(projectId.toString());
            pr.setResourcePath(resourcePath);
            this.m_sqlManager.persist(dbc, pr);
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void createPublishJob(CmsDbContext dbc, CmsPublishJobInfoBean publishJob) throws CmsDataAccessException {
        try {
            CmsPublishJobInfoBean currentJob = this.readPublishJob(dbc, publishJob.getPublishHistoryId());
            LOG.error((Object)("wanted to write: " + publishJob));
            LOG.error((Object)("already on db: " + currentJob));
            return;
        }
        catch (CmsDbEntryNotFoundException currentJob) {
            try {
                CmsDAOPublishJobs pj = new CmsDAOPublishJobs();
                pj.setHistoryId(publishJob.getPublishHistoryId().toString());
                pj.setProjectId(publishJob.getProjectId().toString());
                pj.setProjectName(publishJob.getProjectName());
                pj.setUserId(publishJob.getUserId().toString());
                pj.setPublishLocale(publishJob.getLocale().toString());
                pj.setPublishFlags(publishJob.getFlags());
                pj.setResourceCount(publishJob.getSize());
                pj.setEnqueueTime(publishJob.getEnqueueTime());
                pj.setStartTime(publishJob.getStartTime());
                pj.setFinishTime(publishJob.getFinishTime());
                byte[] publishList = this.internalSerializePublishList(publishJob.getPublishList());
                pj.setPublishList(publishList);
                this.m_sqlManager.persist(dbc, pj);
            }
            catch (PersistenceException e) {
                throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
            }
            catch (IOException e) {
                throw new CmsDbIoException(Messages.get().container("ERR_SERIALIZING_PUBLISHLIST_1", publishJob.getPublishHistoryId().toString()), (Throwable)e);
            }
            return;
        }
    }

    @Override
    public void deleteAllStaticExportPublishedResources(CmsDbContext dbc, int linkType) throws CmsDataAccessException {
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_STATICEXPORT_DELETE_ALL_PUBLISHED_LINKS);
            q.setParameter(1, (Object)linkType);
            List res = q.getResultList();
            for (CmsDAOStaticExportLinks sel : res) {
                this.m_sqlManager.remove(dbc, sel);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void deleteLog(CmsDbContext dbc, CmsLogFilter filter) throws CmsDataAccessException {
        try {
            StringBuffer queryBuf = new StringBuffer(256);
            queryBuf.append(this.m_sqlManager.readQuery(C_LOG_DELETE_ENTRIES));
            CmsPair<String, List<I_CmsQueryParameter>> conditionsAndParams = this.prepareLogConditions(filter);
            queryBuf.append(conditionsAndParams.getFirst());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)queryBuf.toString());
            }
            Query q = this.m_sqlManager.createQueryFromJPQL(dbc, queryBuf.toString());
            List<I_CmsQueryParameter> params = conditionsAndParams.getSecond();
            for (int i = 0; i < params.size(); ++i) {
                I_CmsQueryParameter param = conditionsAndParams.getSecond().get(i);
                param.insertIntoQuery(q, i + 1);
            }
            q.executeUpdate();
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void deleteProject(CmsDbContext dbc, CmsProject project) throws CmsDataAccessException {
        this.deleteProjectResources(dbc, project);
        this.unmarkProjectResources(dbc, project);
        try {
            CmsDAOProjects p = this.m_sqlManager.find(dbc, CmsDAOProjects.class, project.getUuid().toString());
            if (p != null) {
                this.m_sqlManager.remove(dbc, p);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void deleteProjectResource(CmsDbContext dbc, CmsUUID projectId, String resourceName) throws CmsDataAccessException {
        try {
            CmsDAOProjectResources.CmsDAOProjectResourcesPK pk = new CmsDAOProjectResources.CmsDAOProjectResourcesPK();
            pk.setProjectId(projectId.toString());
            pk.setResourcePath(resourceName);
            CmsDAOProjectResources pr = this.m_sqlManager.find(dbc, CmsDAOProjectResources.class, pk);
            if (pr != null) {
                this.m_sqlManager.remove(dbc, pr);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void deleteProjectResources(CmsDbContext dbc, CmsProject project) throws CmsDataAccessException {
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_PROJECTRESOURCES_DELETEALL_1);
            q.setParameter(1, (Object)project.getUuid().toString());
            List res = q.getResultList();
            for (CmsDAOProjectResources pr : res) {
                this.m_sqlManager.remove(dbc, pr);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void deletePublishHistory(CmsDbContext dbc, CmsUUID projectId, int maxpublishTag) throws CmsDataAccessException {
        try {
            Query q = this.m_sqlManager.createQuery(dbc, projectId, C_DELETE_PUBLISH_HISTORY);
            q.setParameter(1, (Object)maxpublishTag);
            List res = q.getResultList();
            for (CmsDAOPublishHistory ph : res) {
                this.m_sqlManager.remove(dbc, ph);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void deletePublishHistoryEntry(CmsDbContext dbc, CmsUUID publishHistoryId, CmsPublishedResource publishedResource) throws CmsDataAccessException {
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_RESOURCES_DELETE_PUBLISH_HISTORY_ENTRY);
            q.setParameter(1, (Object)publishHistoryId.toString());
            q.setParameter(2, (Object)publishedResource.getPublishTag());
            q.setParameter(3, (Object)publishedResource.getStructureId().toString());
            q.setParameter(4, (Object)publishedResource.getRootPath());
            List res = q.getResultList();
            for (CmsDAOPublishHistory ph : res) {
                this.m_sqlManager.remove(dbc, ph);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void deletePublishJob(CmsDbContext dbc, CmsUUID publishHistoryId) throws CmsDataAccessException {
        try {
            CmsDAOPublishJobs pj = this.m_sqlManager.find(dbc, CmsDAOPublishJobs.class, publishHistoryId.toString());
            if (pj != null) {
                this.m_sqlManager.remove(dbc, pj);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void deletePublishList(CmsDbContext dbc, CmsUUID publishHistoryId) throws CmsDataAccessException {
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_PUBLISHJOB_DELETE_PUBLISHLIST);
            q.setParameter(1, (Object)publishHistoryId.toString());
            List res = q.getResultList();
            for (CmsDAOPublishJobs pj : res) {
                pj.setPublishList(null);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void deleteStaticExportPublishedResource(CmsDbContext dbc, String resourceName, int linkType, String linkParameter) throws CmsDataAccessException {
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_STATICEXPORT_DELETE_PUBLISHED_LINKS);
            q.setParameter(1, (Object)resourceName);
            q.setParameter(2, (Object)linkType);
            q.setParameter(3, (Object)linkParameter);
            List res = q.getResultList();
            for (CmsDAOStaticExportLinks sel : res) {
                this.m_sqlManager.remove(dbc, sel);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void deleteUserPublishListEntries(CmsDbContext dbc, List<CmsUserPublishListEntry> publishListDeletions) throws CmsDataAccessException {
        try {
            for (CmsUserPublishListEntry entry : publishListDeletions) {
                Query q = this.m_sqlManager.createQuery(dbc, "C_USER_PUBLISH_LIST_DELETE_2");
                q.setParameter(1, (Object)entry.getUserId().toString());
                q.setParameter(2, (Object)entry.getStructureId().toString());
                q.executeUpdate();
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void destroy() throws Throwable {
        this.m_sqlManager = null;
        this.m_driverManager = null;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SHUTDOWN_DRIVER_1", this.getClass().getName()));
        }
    }

    @Override
    public void fillDefaults(CmsDbContext dbc) throws CmsDataAccessException {
        try {
            if (this.readProject(dbc, CmsProject.ONLINE_PROJECT_ID) != null) {
                return;
            }
        }
        catch (CmsDataAccessException cmsDataAccessException) {
            // empty catch block
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_FILL_DEFAULTS_0"));
        }
        String adminUser = OpenCms.getDefaultUsers().getUserAdmin();
        CmsUser admin = this.m_driverManager.readUser(dbc, adminUser);
        String administratorsGroup = OpenCms.getDefaultUsers().getGroupAdministrators();
        CmsGroup administrators = this.m_driverManager.readGroup(dbc, administratorsGroup);
        String usersGroup = OpenCms.getDefaultUsers().getGroupUsers();
        CmsGroup users = this.m_driverManager.readGroup(dbc, usersGroup);
        CmsProject onlineProject = this.createProject(dbc, CmsProject.ONLINE_PROJECT_ID, admin, users, administrators, "Online", "The Online project", 0, CmsProject.PROJECT_TYPE_NORMAL);
        CmsFolder rootFolder = new CmsFolder(new CmsUUID(), new CmsUUID(), "/", 0, 0, onlineProject.getUuid(), CmsResource.STATE_CHANGED, 0L, admin.getId(), 0L, admin.getId(), 0L, Long.MAX_VALUE, 0);
        this.m_driverManager.getVfsDriver(dbc).createResource(dbc, onlineProject.getUuid(), rootFolder, null);
        this.m_driverManager.getProjectDriver(dbc).createProjectResource(dbc, onlineProject.getUuid(), rootFolder.getRootPath());
        CmsFolder systemFolder = new CmsFolder(new CmsUUID(), new CmsUUID(), "/system", 0, 0, onlineProject.getUuid(), CmsResource.STATE_CHANGED, 0L, admin.getId(), 0L, admin.getId(), 0L, Long.MAX_VALUE, 0);
        this.m_driverManager.getVfsDriver(dbc).createResource(dbc, onlineProject.getUuid(), systemFolder, null);
        CmsProject setupProject = this.m_driverManager.getProjectDriver(dbc).createProject(dbc, CmsUUID.getConstantUUID("_setupProject"), admin, administrators, administrators, "_setupProject", "The Project for the initial import", 0, CmsProject.PROJECT_TYPE_TEMPORARY);
        rootFolder.setState(CmsResource.STATE_CHANGED);
        CmsResource offlineRootFolder = this.m_driverManager.getVfsDriver(dbc).createResource(dbc, setupProject.getUuid(), rootFolder, null);
        offlineRootFolder.setState(CmsResource.STATE_UNCHANGED);
        this.m_driverManager.getVfsDriver(dbc).writeResource(dbc, setupProject.getUuid(), offlineRootFolder, 0);
        this.m_driverManager.getProjectDriver(dbc).createProjectResource(dbc, setupProject.getUuid(), offlineRootFolder.getRootPath());
        systemFolder.setState(CmsResource.STATE_CHANGED);
        CmsResource offlineSystemFolder = this.m_driverManager.getVfsDriver(dbc).createResource(dbc, setupProject.getUuid(), systemFolder, null);
        offlineSystemFolder.setState(CmsResource.STATE_UNCHANGED);
        this.m_driverManager.getVfsDriver(dbc).writeResource(dbc, setupProject.getUuid(), offlineSystemFolder, 0);
    }

    @Override
    public CmsSqlManager getSqlManager() {
        return this.m_sqlManager;
    }

    @Override
    public List<CmsResource> getUsersPubList(CmsDbContext dbc, CmsUUID userId) throws CmsDataAccessException {
        ArrayList<CmsResource> result = new ArrayList<CmsResource>();
        try {
            Query q = this.m_sqlManager.createQuery(dbc, "C_USER_PUBLISH_LIST_READ_1");
            q.setParameter(1, (Object)userId.toString());
            List queryResults = q.getResultList();
            for (Object[] queryResult : queryResults) {
                CmsDAOOfflineStructure structure = (CmsDAOOfflineStructure)queryResult[1];
                CmsDAOOfflineResources resource = (CmsDAOOfflineResources)queryResult[2];
                CmsDAOUserPublishListEntry entry = (CmsDAOUserPublishListEntry)queryResult[0];
                Object[] resourceEntry = new Object[]{resource, structure, resource.getProjectLastModified()};
                CmsResource resourceObj = ((CmsVfsDriver)this.m_driverManager.getVfsDriver(dbc)).createResource(resourceEntry, dbc.currentProject().getUuid());
                resourceObj.setDateLastModified(entry.getDateChanged());
                result.add(resourceObj);
            }
            return result;
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return result;
        }
    }

    @Override
    public void init(CmsDbContext dbc, CmsConfigurationManager configurationManager, List<String> successiveDrivers, CmsDriverManager driverManager) {
        CmsParameterConfiguration config = configurationManager.getConfiguration();
        String poolUrl = config.get("db.project.pool");
        String classname = config.get("db.project.sqlmanager");
        this.m_sqlManager = this.initSqlManager(classname);
        this.m_driverManager = driverManager;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ASSIGNED_POOL_1", poolUrl));
        }
        if (successiveDrivers != null && !successiveDrivers.isEmpty() && LOG.isWarnEnabled()) {
            LOG.warn((Object)Messages.get().getBundle().key("LOG_SUCCESSIVE_DRIVERS_UNSUPPORTED_1", this.getClass().getName()));
        }
    }

    @Override
    public CmsSqlManager initSqlManager(String classname) {
        return CmsSqlManager.getInstance(classname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(CmsDbContext dbc, List<CmsLogEntry> logEntries) throws CmsDbSqlException {
        try {
            EntityManager em = this.m_sqlManager.getEntityManager(dbc);
            em.getTransaction().commit();
            for (CmsLogEntry logEntry : logEntries) {
                em.getTransaction().begin();
                CmsDAOLog daoLog = new CmsDAOLog();
                daoLog.setUserId(logEntry.getUserId().toString());
                daoLog.setLogDate(logEntry.getDate());
                daoLog.setStructureId(logEntry.getStructureId() == null ? null : logEntry.getStructureId().toString());
                daoLog.setLogType(logEntry.getType().getId());
                daoLog.setLogData(CmsStringUtil.arrayAsString(logEntry.getData(), "|"));
                em.persist((Object)daoLog);
                try {
                    if (em.getTransaction() == null || !em.getTransaction().isActive()) continue;
                    em.getTransaction().commit();
                }
                catch (RuntimeException e) {
                    if (em.getTransaction() == null || !em.getTransaction().isActive()) continue;
                    em.getTransaction().rollback();
                }
                finally {
                    em.clear();
                }
            }
            em.getTransaction().begin();
        }
        catch (PersistenceException e) {
            throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", ""), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publishDeletedFolder(CmsDbContext dbc, I_CmsReport report, int m, int n, CmsProject onlineProject, CmsFolder currentFolder, CmsUUID publishHistoryId, int publishTag) throws CmsDataAccessException {
        try {
            report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_2", String.valueOf(m), String.valueOf(n)), 3);
            report.print(Messages.get().container("RPT_DELETE_FOLDER_0"), 3);
            report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", dbc.removeSiteRoot(currentFolder.getRootPath())));
            report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
            CmsResourceState folderState = this.fixMovedResource(dbc, onlineProject, currentFolder, publishHistoryId, publishTag);
            CmsFolder onlineFolder = this.m_driverManager.readFolder(dbc, currentFolder.getRootPath(), CmsResourceFilter.ALL);
            List<CmsResource> movedFiles = null;
            I_CmsVfsDriver vfsDriver = this.m_driverManager.getVfsDriver(dbc);
            movedFiles = vfsDriver.readResourceTree(dbc, onlineProject.getUuid(), currentFolder.getRootPath(), -1, null, 0L, 0L, 0L, 0L, 0L, 0L, 128);
            for (CmsResource delFile : movedFiles) {
                try {
                    CmsResource offlineResource = vfsDriver.readResource(dbc, dbc.currentProject().getUuid(), delFile.getStructureId(), true);
                    CmsFile offlineFile = new CmsFile(offlineResource);
                    offlineFile.setContents(vfsDriver.readContent(dbc, dbc.currentProject().getUuid(), offlineFile.getResourceId()));
                    this.internalWriteHistory(dbc, offlineFile, CmsResource.STATE_DELETED, null, publishHistoryId, publishTag);
                    vfsDriver.deletePropertyObjects(dbc, onlineProject.getUuid(), delFile, 1);
                    vfsDriver.removeFile(dbc, onlineProject.getUuid(), delFile);
                    this.m_sqlManager.getEntityManager(dbc).getTransaction().commit();
                    this.m_sqlManager.getEntityManager(dbc).getTransaction().begin();
                }
                catch (CmsDataAccessException e) {
                    if (!LOG.isWarnEnabled()) continue;
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_REMOVING_RESOURCE_1", delFile.getName()), (Throwable)e);
                }
            }
            this.internalWriteHistory(dbc, currentFolder, folderState, null, publishHistoryId, publishTag);
            try {
                vfsDriver.deletePropertyObjects(dbc, onlineProject.getUuid(), onlineFolder, 1);
                vfsDriver.deletePropertyObjects(dbc, dbc.currentProject().getUuid(), currentFolder, 1);
            }
            catch (CmsDataAccessException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_DELETING_PROPERTIES_1", currentFolder.getRootPath()), (Throwable)e);
                }
                throw e;
            }
            try {
                vfsDriver.removeFolder(dbc, dbc.currentProject(), currentFolder);
                vfsDriver.removeFolder(dbc, onlineProject, currentFolder);
            }
            catch (CmsDataAccessException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_REMOVING_RESOURCE_1", currentFolder.getRootPath()), (Throwable)e);
                }
                throw e;
            }
            try {
                this.m_driverManager.getUserDriver(dbc).removeAccessControlEntries(dbc, onlineProject, onlineFolder.getResourceId());
                this.m_driverManager.getUserDriver(dbc).removeAccessControlEntries(dbc, dbc.currentProject(), currentFolder.getResourceId());
            }
            catch (CmsDataAccessException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_REMOVING_ACL_1", currentFolder.getRootPath()), (Throwable)e);
                }
                throw e;
            }
            try {
                vfsDriver.deleteRelations(dbc, onlineProject.getUuid(), onlineFolder, CmsRelationFilter.TARGETS);
                vfsDriver.deleteRelations(dbc, dbc.currentProject().getUuid(), currentFolder, CmsRelationFilter.TARGETS);
            }
            catch (CmsDataAccessException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_REMOVING_RELATIONS_1", currentFolder.getRootPath()), (Throwable)e);
                }
                throw e;
            }
            String deletedResourceRootPath = currentFolder.getRootPath();
            for (CmsProject project : this.readProjectsForResource(dbc, deletedResourceRootPath)) {
                this.deleteProjectResource(dbc, project.getUuid(), deletedResourceRootPath);
            }
            report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
            if (LOG.isDebugEnabled() && LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_DEL_FOLDER_3", currentFolder.getRootPath(), String.valueOf(m), String.valueOf(n)));
            }
        }
        finally {
            OpenCms.fireCmsEvent(new CmsEvent(15, Collections.singletonMap("resource", currentFolder)));
        }
    }

    @Override
    public void publishFile(CmsDbContext dbc, I_CmsReport report, int m, int n, CmsProject onlineProject, CmsResource offlineResource, Set<CmsUUID> publishedContentIds, CmsUUID publishHistoryId, int publishTag) throws CmsDataAccessException {
        try {
            report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_2", String.valueOf(m), String.valueOf(n)), 3);
            if (offlineResource.getState().isDeleted()) {
                report.print(Messages.get().container("RPT_DELETE_FILE_0"), 3);
                report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", dbc.removeSiteRoot(offlineResource.getRootPath())));
                report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                this.publishDeletedFile(dbc, onlineProject, offlineResource, publishHistoryId, publishTag);
                dbc.pop();
                this.m_driverManager.getHistoryDriver(dbc).deleteEntries(dbc, new CmsHistoryFile(offlineResource), OpenCms.getSystemInfo().getHistoryVersionsAfterDeletion(), -1L);
                report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_DEL_FILE_3", String.valueOf(m), String.valueOf(n), offlineResource.getRootPath()));
                }
            } else if (offlineResource.getState().isChanged()) {
                report.print(Messages.get().container("RPT_PUBLISH_FILE_0"), 3);
                report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", dbc.removeSiteRoot(offlineResource.getRootPath())));
                report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                this.publishChangedFile(dbc, onlineProject, offlineResource, publishedContentIds, publishHistoryId, publishTag);
                dbc.pop();
                this.m_driverManager.getHistoryDriver(dbc).deleteEntries(dbc, new CmsHistoryFile(offlineResource), OpenCms.getSystemInfo().getHistoryVersions(), -1L);
                report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_PUBLISHING_FILE_3", offlineResource.getRootPath(), String.valueOf(m), String.valueOf(n)));
                }
            } else if (offlineResource.getState().isNew()) {
                report.print(Messages.get().container("RPT_PUBLISH_FILE_0"), 3);
                report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", dbc.removeSiteRoot(offlineResource.getRootPath())));
                report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                this.publishNewFile(dbc, onlineProject, offlineResource, publishedContentIds, publishHistoryId, publishTag);
                dbc.pop();
                this.m_driverManager.getHistoryDriver(dbc).deleteEntries(dbc, new CmsHistoryFile(offlineResource), OpenCms.getSystemInfo().getHistoryVersions(), -1L);
                report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                if (LOG.isDebugEnabled() && LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_PUBLISHING_FILE_3", offlineResource.getRootPath(), String.valueOf(m), String.valueOf(n)));
                }
            } else {
                report.print(Messages.get().container("RPT_PUBLISH_FILE_0"), 3);
                report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", dbc.removeSiteRoot(offlineResource.getRootPath())));
                report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                report.println(org.opencms.report.Messages.get().container("RPT_FAILED_0"), 5);
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_PUBLISHING_FILE_3", String.valueOf(m), String.valueOf(n), offlineResource));
                }
            }
        }
        catch (CmsException e) {
            throw new CmsDataAccessException(e.getMessageContainer(), (Throwable)e);
        }
        finally {
            OpenCms.fireCmsEvent(new CmsEvent(15, Collections.singletonMap("resource", offlineResource)));
        }
    }

    @Override
    public CmsFile publishFileContent(CmsDbContext dbc, CmsProject offlineProject, CmsProject onlineProject, CmsResource offlineResource, Set<CmsUUID> publishedResourceIds, boolean needToUpdateContent, int publishTag) throws CmsDataAccessException {
        CmsFile newFile = null;
        try {
            CmsUUID projectId = dbc.getProjectId();
            boolean dbcHasProjectId = projectId != null && !projectId.isNullUUID();
            CmsUUID projectIdForReading = !dbcHasProjectId ? offlineProject.getUuid() : CmsProject.ONLINE_PROJECT_ID;
            dbc.setProjectId(offlineProject.getUuid());
            byte[] offlineContent = this.m_driverManager.getVfsDriver(dbc).readContent(dbc, projectIdForReading, offlineResource.getResourceId());
            CmsFile offlineFile = new CmsFile(offlineResource);
            offlineFile.setContents(offlineContent);
            dbc.setProjectId(projectId);
            newFile = (CmsFile)offlineFile.clone();
            newFile.setState(CmsResource.STATE_UNCHANGED);
            boolean createSibling = true;
            if (!offlineFile.getState().isNew()) {
                createSibling = false;
            } else if (!this.m_driverManager.getVfsDriver(dbc).validateResourceIdExists(dbc, onlineProject.getUuid(), offlineFile.getResourceId())) {
                createSibling = false;
            }
            boolean alreadyPublished = publishedResourceIds.contains(offlineResource.getResourceId());
            needToUpdateContent &= !alreadyPublished;
            if (createSibling) {
                if (!alreadyPublished) {
                    this.m_driverManager.getVfsDriver(dbc).createResource(dbc, onlineProject.getUuid(), newFile, null);
                } else {
                    this.m_driverManager.getVfsDriver(dbc).createSibling(dbc, onlineProject, offlineResource);
                }
                newFile = new CmsFile(offlineResource);
                newFile.setContents(offlineContent);
            } else {
                this.m_driverManager.getVfsDriver(dbc).publishResource(dbc, onlineProject, newFile, offlineFile);
            }
            this.m_driverManager.getVfsDriver(dbc).publishVersions(dbc, offlineResource, !alreadyPublished);
            this.m_driverManager.getVfsDriver(dbc).createOnlineContent(dbc, offlineFile.getResourceId(), offlineFile.getContents(), publishTag, true, needToUpdateContent);
            publishedResourceIds.add(offlineResource.getResourceId());
        }
        catch (CmsDataAccessException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_PUBLISHING_FILE_CONTENT_1", offlineResource.toString()), (Throwable)e);
            }
            throw e;
        }
        return newFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publishFolder(CmsDbContext dbc, I_CmsReport report, int m, int n, CmsProject onlineProject, CmsFolder offlineFolder, CmsUUID publishHistoryId, int publishTag) throws CmsDataAccessException {
        try {
            report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_2", String.valueOf(m), String.valueOf(n)), 3);
            report.print(Messages.get().container("RPT_PUBLISH_FOLDER_0"), 3);
            report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", dbc.removeSiteRoot(offlineFolder.getRootPath())));
            report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
            CmsResourceState resourceState = this.fixMovedResource(dbc, onlineProject, offlineFolder, publishHistoryId, publishTag);
            CmsResource onlineFolder = null;
            if (offlineFolder.getState().isNew()) {
                try {
                    CmsFolder newFolder = (CmsFolder)offlineFolder.clone();
                    newFolder.setState(CmsResource.STATE_UNCHANGED);
                    onlineFolder = this.m_driverManager.getVfsDriver(dbc).createResource(dbc, onlineProject.getUuid(), newFolder, null);
                    this.m_driverManager.getVfsDriver(dbc).publishResource(dbc, onlineProject, onlineFolder, offlineFolder);
                    this.m_driverManager.getVfsDriver().publishVersions(dbc, offlineFolder, true);
                }
                catch (CmsVfsResourceAlreadyExistsException e) {
                    if (!offlineFolder.getRootPath().equals("/") && !offlineFolder.getRootPath().equals("/system/") && LOG.isWarnEnabled()) {
                        LOG.warn((Object)Messages.get().getBundle().key("LOG_WARN_FOLDER_WRONG_STATE_CN_1", offlineFolder.getRootPath()));
                    }
                    try {
                        onlineFolder = this.m_driverManager.getVfsDriver(dbc).readFolder(dbc, onlineProject.getUuid(), offlineFolder.getRootPath());
                        this.m_driverManager.getVfsDriver(dbc).publishResource(dbc, onlineProject, onlineFolder, offlineFolder);
                        this.m_driverManager.getVfsDriver(dbc).publishVersions(dbc, offlineFolder, true);
                    }
                    catch (CmsDataAccessException e1) {
                        if (LOG.isErrorEnabled()) {
                            LOG.error((Object)Messages.get().getBundle().key("LOG_READING_RESOURCE_1", offlineFolder.getRootPath()), (Throwable)e);
                        }
                        throw e1;
                    }
                }
                catch (CmsDataAccessException e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)Messages.get().getBundle().key("LOG_PUBLISHING_RESOURCE_1", offlineFolder.getRootPath()), (Throwable)e);
                    }
                    throw e;
                }
            } else if (offlineFolder.getState().isChanged()) {
                try {
                    onlineFolder = this.m_driverManager.getVfsDriver(dbc).readFolder(dbc, onlineProject.getUuid(), offlineFolder.getStructureId());
                }
                catch (CmsVfsResourceNotFoundException e) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)Messages.get().getBundle().key("LOG_WARN_FOLDER_WRONG_STATE_NC_1", offlineFolder.getRootPath()));
                    }
                    try {
                        onlineFolder = this.m_driverManager.getVfsDriver(dbc).createResource(dbc, onlineProject.getUuid(), offlineFolder, null);
                        this.internalResetResourceState(dbc, onlineFolder);
                    }
                    catch (CmsDataAccessException e1) {
                        if (LOG.isErrorEnabled()) {
                            LOG.error((Object)Messages.get().getBundle().key("LOG_PUBLISHING_RESOURCE_1", offlineFolder.getRootPath()), (Throwable)e);
                        }
                        throw e1;
                    }
                }
                try {
                    this.m_driverManager.getVfsDriver(dbc).publishResource(dbc, onlineProject, onlineFolder, offlineFolder);
                    this.m_driverManager.getVfsDriver(dbc).publishVersions(dbc, offlineFolder, true);
                }
                catch (CmsDataAccessException e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)Messages.get().getBundle().key("LOG_PUBLISHING_RESOURCE_1", offlineFolder.getRootPath()), (Throwable)e);
                    }
                    throw e;
                }
            }
            if (onlineFolder != null) {
                try {
                    this.m_driverManager.getUserDriver(dbc).publishAccessControlEntries(dbc, dbc.currentProject(), onlineProject, offlineFolder.getResourceId(), onlineFolder.getResourceId());
                }
                catch (CmsDataAccessException e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)Messages.get().getBundle().key("LOG_PUBLISHING_ACL_1", offlineFolder.getRootPath()), (Throwable)e);
                    }
                    throw e;
                }
            }
            List<CmsProperty> offlineProperties = null;
            try {
                this.m_driverManager.getVfsDriver(dbc).deletePropertyObjects(dbc, onlineProject.getUuid(), onlineFolder, 1);
                offlineProperties = this.m_driverManager.getVfsDriver(dbc).readPropertyObjects(dbc, dbc.currentProject(), offlineFolder);
                CmsProperty.setAutoCreatePropertyDefinitions(offlineProperties, true);
                this.m_driverManager.getVfsDriver(dbc).writePropertyObjects(dbc, onlineProject, onlineFolder, offlineProperties);
            }
            catch (CmsDataAccessException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_PUBLISHING_PROPERTIES_1", offlineFolder.getRootPath()), (Throwable)e);
                }
                throw e;
            }
            this.internalWriteHistory(dbc, offlineFolder, resourceState, offlineProperties, publishHistoryId, publishTag);
            this.m_driverManager.getVfsDriver(dbc).updateRelations(dbc, onlineProject, offlineFolder);
            report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_PUBLISHING_FOLDER_3", String.valueOf(m), String.valueOf(n), offlineFolder.getRootPath()));
            }
        }
        finally {
            OpenCms.fireCmsEvent(new CmsEvent(15, Collections.singletonMap("resource", offlineFolder)));
        }
    }

    @Override
    public void publishProject(CmsDbContext dbc, I_CmsReport report, CmsProject onlineProject, CmsPublishList publishList, int publishTag) throws CmsException {
        CmsMessageContainer message;
        int publishedFileCount;
        int deletedFolderCount;
        int publishedFolderCount;
        block34: {
            List<CmsResource> deletedFolders;
            I_CmsProjectDriver projectDriver;
            HashSet<CmsUUID> publishedIds;
            block33: {
                publishedFolderCount = 0;
                deletedFolderCount = 0;
                publishedFileCount = 0;
                HashSet<CmsUUID> publishedContentIds = new HashSet<CmsUUID>();
                publishedIds = new HashSet<CmsUUID>();
                if (OpenCms.getSystemInfo().isHistoryEnabled()) {
                    try {
                        this.m_driverManager.getHistoryDriver(dbc).writeProject(dbc, publishTag, System.currentTimeMillis());
                        dbc.pop();
                    }
                    catch (Throwable t) {
                        dbc.report(report, Messages.get().container("ERR_WRITING_HISTORY_OF_PROJECT_1", dbc.currentProject().getName()), t);
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_START_PUBLISHING_PROJECT_2", dbc.currentProject().getName(), dbc.currentUser().getName()));
                }
                publishedFolderCount = 0;
                int foldersSize = publishList.getFolderList().size();
                if (foldersSize > 0) {
                    report.println(Messages.get().container("RPT_PUBLISH_FOLDERS_BEGIN_0"), 2);
                }
                Iterator<CmsResource> itFolders = publishList.getFolderList().iterator();
                projectDriver = this.m_driverManager.getProjectDriver(dbc);
                I_CmsHistoryDriver historyDriver = this.m_driverManager.getHistoryDriver(dbc);
                while (itFolders.hasNext()) {
                    CmsResource currentFolder = itFolders.next();
                    try {
                        if (currentFolder.getState().isNew() || currentFolder.getState().isChanged()) {
                            projectDriver.publishFolder(dbc, report, ++publishedFolderCount, foldersSize, onlineProject, new CmsFolder(currentFolder), publishList.getPublishHistoryId(), publishTag);
                            dbc.pop();
                            publishedIds.add(currentFolder.getStructureId());
                            CmsLogEntryType type = currentFolder.getState().isNew() ? CmsLogEntryType.RESOURCE_PUBLISHED_NEW : CmsLogEntryType.RESOURCE_PUBLISHED_MODIFIED;
                            this.m_driverManager.log(dbc, new CmsLogEntry(dbc, currentFolder.getStructureId(), type, new String[]{currentFolder.getRootPath()}), true);
                            historyDriver.deleteEntries(dbc, new CmsHistoryFile(currentFolder), OpenCms.getSystemInfo().getHistoryVersions(), -1L);
                            this.internalResetResourceState(dbc, currentFolder);
                            this.m_driverManager.unlockResource(dbc, currentFolder, true, true);
                        } else {
                            report.print(Messages.get().container("RPT_PUBLISH_FOLDER_0"), 3);
                            report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", dbc.removeSiteRoot(currentFolder.getRootPath())));
                            report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                            report.println(org.opencms.report.Messages.get().container("RPT_FAILED_0"), 5);
                            if (LOG.isErrorEnabled()) {
                                LOG.error((Object)Messages.get().getBundle().key("LOG_PUBLISHING_FILE_3", String.valueOf(++publishedFolderCount), String.valueOf(foldersSize), currentFolder));
                            }
                        }
                        dbc.pop();
                    }
                    catch (Throwable t) {
                        dbc.report(report, Messages.get().container("ERR_ERROR_PUBLISHING_FOLDER_1", currentFolder.getRootPath()), t);
                    }
                }
                if (foldersSize > 0) {
                    report.println(Messages.get().container("RPT_PUBLISH_FOLDERS_END_0"), 2);
                }
                publishedFileCount = 0;
                int filesSize = publishList.getFileList().size();
                if (filesSize > 0) {
                    report.println(Messages.get().container("RPT_PUBLISH_FILES_BEGIN_0"), 2);
                }
                HashSet<CmsUUID> deletedResourceIds = new HashSet<CmsUUID>();
                HashSet<CmsUUID> changedResourceIds = new HashSet<CmsUUID>();
                for (CmsResource res : publishList.getFileList()) {
                    if (res.getState().isDeleted()) {
                        deletedResourceIds.add(res.getResourceId());
                        continue;
                    }
                    changedResourceIds.add(res.getResourceId());
                }
                Sets.SetView changedAndDeletedResourceIds = Sets.intersection(deletedResourceIds, changedResourceIds);
                dbc.setAttribute("changedAndDeleted", changedAndDeletedResourceIds);
                for (CmsResource currentResource : publishList.getFileList()) {
                    try {
                        projectDriver.publishFile(dbc, report, ++publishedFileCount, filesSize, onlineProject, currentResource, publishedContentIds, publishList.getPublishHistoryId(), publishTag);
                        CmsResourceState state = currentResource.getState();
                        if (!state.isDeleted()) {
                            this.internalResetResourceState(dbc, currentResource);
                        }
                        this.m_driverManager.unlockResource(dbc, currentResource, true, true);
                        CmsLogEntryType type = state.isNew() ? CmsLogEntryType.RESOURCE_PUBLISHED_NEW : (state.isDeleted() ? CmsLogEntryType.RESOURCE_PUBLISHED_DELETED : CmsLogEntryType.RESOURCE_PUBLISHED_MODIFIED);
                        this.m_driverManager.log(dbc, new CmsLogEntry(dbc, currentResource.getStructureId(), type, new String[]{currentResource.getRootPath()}), true);
                        publishedIds.add(currentResource.getStructureId());
                        dbc.pop();
                    }
                    catch (Throwable t) {
                        dbc.report(report, Messages.get().container("ERR_ERROR_PUBLISHING_FILE_1", currentResource.getRootPath()), t);
                    }
                }
                if (filesSize > 0) {
                    report.println(Messages.get().container("RPT_PUBLISH_FILES_END_0"), 2);
                }
                if (!(deletedFolders = publishList.getDeletedFolderList()).isEmpty()) break block33;
                this.m_driverManager.getVfsDriver(dbc).publishVersions(dbc, null, false);
                Object[] msgArgs = new Object[]{String.valueOf(publishedFileCount), String.valueOf(publishedFolderCount), String.valueOf(deletedFolderCount), report.formatRuntime()};
                CmsMessageContainer message2 = Messages.get().container("RPT_PUBLISH_STAT_4", msgArgs);
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)message2.key());
                }
                report.println(message2);
                return;
            }
            try {
                deletedFolderCount = 0;
                int deletedFoldersSize = deletedFolders.size();
                if (deletedFoldersSize > 0) {
                    report.println(Messages.get().container("RPT_DELETE_FOLDERS_BEGIN_0"), 2);
                }
                for (CmsResource currentFolder : deletedFolders) {
                    try {
                        projectDriver.publishDeletedFolder(dbc, report, ++deletedFolderCount, deletedFoldersSize, onlineProject, new CmsFolder(currentFolder), publishList.getPublishHistoryId(), publishTag);
                        dbc.pop();
                        this.m_driverManager.getHistoryDriver(dbc).deleteEntries(dbc, new CmsHistoryFile(currentFolder), OpenCms.getSystemInfo().getHistoryVersionsAfterDeletion(), -1L);
                        publishedIds.add(currentFolder.getStructureId());
                        this.m_driverManager.unlockResource(dbc, currentFolder, true, true);
                        this.m_driverManager.log(dbc, new CmsLogEntry(dbc, currentFolder.getStructureId(), CmsLogEntryType.RESOURCE_PUBLISHED_DELETED, new String[]{currentFolder.getRootPath()}), true);
                        dbc.pop();
                    }
                    catch (Throwable t) {
                        dbc.report(report, Messages.get().container("ERR_ERROR_PUBLISHING_DELETED_FOLDER_1", currentFolder.getRootPath()), t);
                    }
                }
                if (deletedFoldersSize <= 0) break block34;
                report.println(Messages.get().container("RPT_DELETE_FOLDERS_END_0"), 2);
            }
            catch (OutOfMemoryError o) {
                try {
                    OpenCms.fireCmsEvent(new CmsEvent(5, Collections.emptyMap()));
                    message = Messages.get().container("ERR_OUT_OF_MEMORY_0");
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)message.key(), (Throwable)o);
                    }
                    throw new CmsDataAccessException(message, (Throwable)o);
                }
                catch (Throwable throwable) {
                    this.m_driverManager.getVfsDriver(dbc).publishVersions(dbc, null, false);
                    Object[] msgArgs = new Object[]{String.valueOf(publishedFileCount), String.valueOf(publishedFolderCount), String.valueOf(deletedFolderCount), report.formatRuntime()};
                    CmsMessageContainer message3 = Messages.get().container("RPT_PUBLISH_STAT_4", msgArgs);
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)message3.key());
                    }
                    report.println(message3);
                    throw throwable;
                }
            }
        }
        this.m_driverManager.getVfsDriver(dbc).publishVersions(dbc, null, false);
        Object[] msgArgs = new Object[]{String.valueOf(publishedFileCount), String.valueOf(publishedFolderCount), String.valueOf(deletedFolderCount), report.formatRuntime()};
        message = Messages.get().container("RPT_PUBLISH_STAT_4", msgArgs);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)message.key());
        }
        report.println(message);
    }

    @Override
    public List<CmsLock> readLocks(CmsDbContext dbc) throws CmsDataAccessException {
        ArrayList<CmsLock> locks = new ArrayList<CmsLock>(256);
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_RESOURCE_LOCKS_READALL);
            List res = q.getResultList();
            for (CmsDAOResourceLocks rl : res) {
                CmsProject project;
                String resourcePath = rl.getResourcePath();
                CmsUUID userId = new CmsUUID(rl.getUserId());
                CmsUUID projectId = new CmsUUID(rl.getProjectId());
                int lockType = rl.getLockType();
                try {
                    project = this.readProject(dbc, projectId);
                }
                catch (CmsDataAccessException dae) {
                    project = null;
                }
                if (project == null) continue;
                CmsLock lock = new CmsLock(resourcePath, userId, project, CmsLockType.valueOf(lockType));
                locks.add(lock);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_DBG_READ_LOCKS_1", new Integer(locks.size())));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return locks;
    }

    @Override
    public List<CmsLogEntry> readLog(CmsDbContext dbc, CmsLogFilter filter) throws CmsDataAccessException {
        ArrayList<CmsLogEntry> entries = new ArrayList<CmsLogEntry>();
        try {
            StringBuffer queryBuf = new StringBuffer(256);
            queryBuf.append(this.m_sqlManager.readQuery(C_LOG_READ_ENTRIES));
            CmsPair<String, List<I_CmsQueryParameter>> conditionsAndParameters = this.prepareLogConditions(filter);
            List<I_CmsQueryParameter> params = conditionsAndParameters.getSecond();
            queryBuf.append(conditionsAndParameters.getFirst());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)queryBuf.toString());
            }
            Query q = this.m_sqlManager.createQueryFromJPQL(dbc, queryBuf.toString());
            for (int i = 0; i < params.size(); ++i) {
                I_CmsQueryParameter param = params.get(i);
                param.insertIntoQuery(q, i + 1);
            }
            List res = q.getResultList();
            for (CmsDAOLog log : res) {
                entries.add(this.internalReadLogEntry(log));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", C_LOG_READ_ENTRIES), (Throwable)e);
        }
        return entries;
    }

    @Override
    public CmsProject readProject(CmsDbContext dbc, CmsUUID id) throws CmsDataAccessException {
        CmsProject project = null;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_PROJECTS_READ_1);
            q.setParameter(1, (Object)id.toString());
            try {
                CmsDAOProjects p = (CmsDAOProjects)q.getSingleResult();
                project = this.internalCreateProject(p);
            }
            catch (NoResultException e) {
                throw new CmsDbEntryNotFoundException(Messages.get().container("ERR_NO_PROJECT_WITH_ID_1", String.valueOf(id)));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return project;
    }

    @Override
    public CmsProject readProject(CmsDbContext dbc, String projectFqn) throws CmsDataAccessException {
        CmsProject project = null;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_PROJECTS_READ_BYNAME_2);
            q.setParameter(1, (Object)CmsOrganizationalUnit.getSimpleName(projectFqn));
            q.setParameter(2, (Object)("/" + CmsOrganizationalUnit.getParentFqn(projectFqn)));
            try {
                CmsDAOProjects p = (CmsDAOProjects)q.getSingleResult();
                project = this.internalCreateProject(p);
            }
            catch (NoResultException e) {
                throw new CmsDbEntryNotFoundException(Messages.get().container("ERR_NO_PROJECT_WITH_NAME_1", projectFqn));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return project;
    }

    @Override
    public String readProjectResource(CmsDbContext dbc, CmsUUID projectId, String resourcePath) throws CmsDataAccessException {
        String resName = null;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_PROJECTRESOURCES_READ_2);
            q.setParameter(1, (Object)projectId.toString());
            q.setParameter(2, (Object)resourcePath);
            try {
                resName = (String)q.getSingleResult();
            }
            catch (NoResultException e) {
                throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_NO_PROJECTRESOURCE_1", resourcePath));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return resName;
    }

    @Override
    public List<String> readProjectResources(CmsDbContext dbc, CmsProject project) throws CmsDataAccessException {
        ArrayList<String> result = new ArrayList<String>();
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_PROJECTRESOURCES_READ_BY_ID_1);
            q.setParameter(1, (Object)project.getUuid().toString());
            List res = q.getResultList();
            for (String r : res) {
                result.add(r);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return result;
    }

    @Override
    public List<CmsProject> readProjects(CmsDbContext dbc, String ouFqn) throws CmsDataAccessException {
        if (dbc.getRequestContext() != null && dbc.getRequestContext().getAttribute(DBC_ATTR_READ_PROJECT_FOR_RESOURCE) != null) {
            dbc.getRequestContext().removeAttribute(DBC_ATTR_READ_PROJECT_FOR_RESOURCE);
            return this.readProjectsForResource(dbc, ouFqn);
        }
        ArrayList<CmsProject> projects = new ArrayList<CmsProject>();
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_PROJECTS_READ_BYOU_1);
            q.setParameter(1, (Object)("/" + ouFqn + "%"));
            List res = q.getResultList();
            for (CmsDAOProjects p : res) {
                projects.add(this.internalCreateProject(p));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return projects;
    }

    @Override
    public List<CmsProject> readProjectsForGroup(CmsDbContext dbc, CmsGroup group) throws CmsDataAccessException {
        ArrayList<CmsProject> projects = new ArrayList<CmsProject>();
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_PROJECTS_READ_BYGROUP_2);
            q.setParameter(1, (Object)group.getId().toString());
            q.setParameter(2, (Object)group.getId().toString());
            List res = q.getResultList();
            for (CmsDAOProjects p : res) {
                projects.add(this.internalCreateProject(p));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return projects;
    }

    @Override
    public List<CmsProject> readProjectsForManagerGroup(CmsDbContext dbc, CmsGroup group) throws CmsDataAccessException {
        ArrayList<CmsProject> projects = new ArrayList<CmsProject>();
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_PROJECTS_READ_BYMANAGER_1);
            q.setParameter(1, (Object)group.getId().toString());
            List res = q.getResultList();
            for (CmsDAOProjects p : res) {
                projects.add(this.internalCreateProject(p));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return projects;
    }

    public List<CmsProject> readProjectsForResource(CmsDbContext dbc, String rootPath) throws CmsDataAccessException {
        ArrayList<CmsProject> projects = new ArrayList<CmsProject>();
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_PROJECTS_READ_BYRESOURCE_1);
            q.setParameter(1, (Object)CmsVfsDriver.escapeDbWildcard(rootPath + "%"));
            List res = q.getResultList();
            if (res.size() > 0) {
                projects.add(this.internalCreateProject((CmsDAOProjects)res.get(0)));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return projects;
    }

    @Override
    public List<CmsProject> readProjectsForUser(CmsDbContext dbc, CmsUser user) throws CmsDataAccessException {
        ArrayList<CmsProject> projects = new ArrayList<CmsProject>();
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_PROJECTS_READ_BYUSER_1);
            q.setParameter(1, (Object)user.getId().toString());
            List res = q.getResultList();
            for (CmsDAOProjects p : res) {
                projects.add(this.internalCreateProject(p));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return projects;
    }

    @Override
    public List<CmsPublishedResource> readPublishedResources(CmsDbContext dbc, CmsUUID publishHistoryId) throws CmsDataAccessException {
        ArrayList<CmsPublishedResource> publishedResources = new ArrayList<CmsPublishedResource>();
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_SELECT_PUBLISHED_RESOURCES);
            q.setParameter(1, (Object)publishHistoryId.toString());
            List res = q.getResultList();
            for (CmsDAOPublishHistory ph : res) {
                CmsUUID structureId = new CmsUUID(ph.getStructureId());
                CmsUUID resourceId = new CmsUUID(ph.getResourceId());
                String rootPath = ph.getResourcePath();
                int resourceState = ph.getResourceState();
                int resourceType = ph.getResourceType();
                int siblingCount = ph.getSiblingCount();
                int publishTag = ph.getPublishTag();
                CmsResourceState state = resourceState == CmsPublishedResource.STATE_MOVED_SOURCE.getState() ? CmsPublishedResource.STATE_MOVED_SOURCE : (resourceState == CmsPublishedResource.STATE_MOVED_DESTINATION.getState() ? CmsPublishedResource.STATE_MOVED_DESTINATION : CmsResourceState.valueOf(resourceState));
                publishedResources.add(new CmsPublishedResource(structureId, resourceId, publishTag, rootPath, resourceType, structureId.isNullUUID() ? false : CmsFolder.isFolderType(resourceType), state, siblingCount));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return publishedResources;
    }

    @Override
    public CmsPublishJobInfoBean readPublishJob(CmsDbContext dbc, CmsUUID publishHistoryId) throws CmsDataAccessException {
        CmsPublishJobInfoBean result = null;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_PUBLISHJOB_READ_JOB);
            q.setParameter(1, (Object)publishHistoryId.toString());
            try {
                CmsDAOPublishJobs pj = (CmsDAOPublishJobs)q.getSingleResult();
                result = this.createPublishJobInfoBean(pj);
            }
            catch (NoResultException e) {
                throw new CmsDbEntryNotFoundException(Messages.get().container("ERR_READ_PUBLISH_JOB_1", publishHistoryId.toString()));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return result;
    }

    @Override
    public List<CmsPublishJobInfoBean> readPublishJobs(CmsDbContext dbc, long startTime, long endTime) throws CmsDataAccessException {
        ArrayList<CmsPublishJobInfoBean> result = null;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_PUBLISHJOB_READ_JOBS_IN_TIMERANGE);
            q.setParameter(1, (Object)startTime);
            q.setParameter(2, (Object)endTime);
            List res = q.getResultList();
            result = new ArrayList<CmsPublishJobInfoBean>();
            for (CmsDAOPublishJobs pj : res) {
                result.add(this.createPublishJobInfoBean(pj));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return result;
    }

    @Override
    public CmsPublishList readPublishList(CmsDbContext dbc, CmsUUID publishHistoryId) throws CmsDataAccessException {
        CmsPublishList publishList = null;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_PUBLISHJOB_READ_PUBLISHLIST);
            q.setParameter(1, (Object)publishHistoryId.toString());
            try {
                CmsDAOPublishJobs pj = (CmsDAOPublishJobs)q.getSingleResult();
                publishList = this.internalDeserializePublishList(pj.getPublishList());
            }
            catch (NoResultException e) {
                throw new CmsDataAccessException(Messages.get().container("ERR_READ_PUBLISH_JOB_1", publishHistoryId.toString()));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        catch (Exception e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_PUBLISHLIST_DESERIALIZATION_FAILED_1", publishHistoryId), (Throwable)e);
        }
        return publishList;
    }

    @Override
    public byte[] readPublishReportContents(CmsDbContext dbc, CmsUUID publishHistoryId) throws CmsDataAccessException {
        byte[] bytes = null;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_PUBLISHJOB_READ_REPORT);
            q.setParameter(1, (Object)publishHistoryId.toString());
            try {
                CmsDAOPublishJobs pj = (CmsDAOPublishJobs)q.getSingleResult();
                bytes = pj.getPublishReport();
            }
            catch (NoResultException e) {
                throw new CmsDataAccessException(Messages.get().container("ERR_READ_PUBLISH_JOB_1", publishHistoryId.toString()));
            }
        }
        catch (PersistenceException e) {
            LOG.error((Object)C_PUBLISHJOB_READ_REPORT, (Throwable)e);
            bytes = Messages.get().container("ERR_GENERIC_SQL_1", C_PUBLISHJOB_READ_REPORT).key().getBytes();
        }
        return bytes;
    }

    @Override
    public String readStaticExportPublishedResourceParameters(CmsDbContext dbc, String rfsName) throws CmsDataAccessException {
        String returnValue = null;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_STATICEXPORT_READ_PUBLISHED_LINK_PARAMETERS);
            q.setParameter(1, (Object)rfsName);
            try {
                returnValue = (String)q.getSingleResult();
            }
            catch (NoResultException noResultException) {}
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return returnValue;
    }

    @Override
    public List<String> readStaticExportResources(CmsDbContext dbc, int parameterResources, long timestamp) throws CmsDataAccessException {
        ArrayList<String> returnValue = new ArrayList<String>();
        if (parameterResources == 1) {
            timestamp = 0L;
        }
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_STATICEXPORT_READ_ALL_PUBLISHED_LINKS);
            q.setParameter(1, (Object)parameterResources);
            q.setParameter(2, (Object)timestamp);
            List res = q.getResultList();
            for (String path : res) {
                returnValue.add(path);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return returnValue;
    }

    @Override
    public void setDriverManager(CmsDriverManager driverManager) {
        this.m_driverManager = driverManager;
    }

    @Override
    public void setSqlManager(org.opencms.db.CmsSqlManager manager) {
        this.m_sqlManager = (CmsSqlManager)manager;
    }

    @Override
    public void unmarkProjectResources(CmsDbContext dbc, CmsProject project) throws CmsDataAccessException {
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_RESOURCES_UNMARK);
            q.setParameter(1, (Object)project.getUuid().toString());
            List res = q.getResultList();
            for (CmsDAOOfflineResources r : res) {
                r.setProjectLastModified("00000000-0000-0000-0000-000000000000");
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void writeLocks(CmsDbContext dbc, List<CmsLock> locks) throws CmsDataAccessException {
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_RESOURCE_LOCKS_DELETEALL);
            List res = q.getResultList();
            int deleted = 0;
            for (CmsDAOResourceLocks r : res) {
                this.m_sqlManager.remove(dbc, r);
                ++deleted;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_DBG_CLEAR_LOCKS_1", new Integer(deleted)));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"SQL :Inserting rows in the CMS_RESOURCE_LOCKS table.");
            }
            Iterator<CmsLock> i = locks.iterator();
            int count = 0;
            while (i.hasNext()) {
                CmsLock editLock;
                CmsDAOResourceLocks rl;
                CmsLock lock = i.next();
                CmsLock sysLock = lock.getSystemLock();
                if (sysLock.isPersistent()) {
                    rl = new CmsDAOResourceLocks();
                    rl.setResourcePath(sysLock.getResourceName());
                    rl.setUserId(sysLock.getUserId().toString());
                    rl.setProjectId(sysLock.getProjectId().toString());
                    rl.setLockType(sysLock.getType().hashCode());
                    this.m_sqlManager.persist(dbc, rl);
                    ++count;
                }
                if (!(editLock = lock.getEditionLock()).isPersistent()) continue;
                rl = new CmsDAOResourceLocks();
                rl.setResourcePath(editLock.getResourceName());
                rl.setUserId(editLock.getUserId().toString());
                rl.setProjectId(editLock.getProjectId().toString());
                rl.setLockType(editLock.getType().hashCode());
                this.m_sqlManager.persist(dbc, rl);
                ++count;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_DBG_WRITE_LOCKS_1", new Integer(count)));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void writeProject(CmsDbContext dbc, CmsProject project) throws CmsDataAccessException {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(project.getDescription())) {
            project.setDescription(" ");
        }
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_PROJECTS_WRITE_6);
            q.setParameter(1, (Object)project.getUuid().toString());
            List res = q.getResultList();
            for (CmsDAOProjects pr : res) {
                pr.setProjectDescription(project.getDescription());
                pr.setGroupId(project.getGroupId().toString());
                pr.setManagerGroupId(project.getManagerGroupId().toString());
                pr.setProjectFlags(project.getFlags());
                pr.setProjectType(project.getType().getMode());
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void writePublishHistory(CmsDbContext dbc, CmsUUID publishId, CmsPublishedResource resource) throws CmsDataAccessException {
        try {
            CmsDAOPublishHistory ph = new CmsDAOPublishHistory();
            ph.setPublishTag(resource.getPublishTag());
            ph.setStructureId(resource.getStructureId().toString());
            ph.setResourceId(resource.getResourceId().toString());
            ph.setResourcePath(resource.getRootPath());
            ph.setResourceState(resource.getMovedState().getState());
            ph.setResourceType(resource.getType());
            ph.setHistoryId(publishId.toString());
            ph.setSiblingCount(resource.getSiblingCount());
            this.m_sqlManager.persist(dbc, ph);
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void writePublishJob(CmsDbContext dbc, CmsPublishJobInfoBean publishJob) throws CmsDataAccessException {
        try {
            CmsDAOPublishJobs pj = this.m_sqlManager.find(dbc, CmsDAOPublishJobs.class, publishJob.getPublishHistoryId().toString());
            if (pj != null) {
                pj.setProjectId(publishJob.getProjectId().toString());
                pj.setProjectName(publishJob.getProjectName());
                pj.setUserId(publishJob.getUserId().toString());
                pj.setPublishLocale(publishJob.getLocale().toString());
                pj.setPublishFlags(publishJob.getFlags());
                pj.setResourceCount(publishJob.getSize());
                pj.setEnqueueTime(publishJob.getEnqueueTime());
                pj.setStartTime(publishJob.getStartTime());
                pj.setFinishTime(publishJob.getFinishTime());
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void writePublishReport(CmsDbContext dbc, CmsUUID publishId, byte[] content) throws CmsDataAccessException {
        try {
            CmsDAOPublishJobs pj = this.m_sqlManager.find(dbc, CmsDAOPublishJobs.class, publishId.toString());
            if (pj != null) {
                pj.setPublishReport(content);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void writeStaticExportPublishedResource(CmsDbContext dbc, String resourceName, int linkType, String linkParameter, long timestamp) throws CmsDataAccessException {
        int returnValue = 0;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_STATICEXPORT_READ_PUBLISHED_RESOURCES);
            q.setParameter(1, (Object)resourceName);
            try {
                returnValue = CmsDataTypeUtil.numberToInt((Number)q.getSingleResult());
            }
            catch (NoResultException noResultException) {}
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        if (returnValue == 0) {
            try {
                CmsDAOStaticExportLinks sel = new CmsDAOStaticExportLinks();
                sel.setLinkId(new CmsUUID().toString());
                sel.setLinkRfsPath(resourceName);
                sel.setLinkType(linkType);
                sel.setLinkParameter(linkParameter);
                sel.setLinkTimestamp(timestamp);
                this.m_sqlManager.persist(dbc, sel);
            }
            catch (PersistenceException e) {
                throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
            }
        }
    }

    @Override
    public void writeUserPublishListEntries(CmsDbContext dbc, List<CmsUserPublishListEntry> publishListAdditions) throws CmsDataAccessException {
        try {
            for (CmsUserPublishListEntry entry : publishListAdditions) {
                Query delete = this.m_sqlManager.createQuery(dbc, "C_USER_PUBLISH_LIST_DELETE_2");
                delete.setParameter(1, (Object)entry.getUserId().toString());
                delete.setParameter(2, (Object)entry.getStructureId().toString());
                delete.executeUpdate();
                CmsDAOUserPublishListEntry newEntry = new CmsDAOUserPublishListEntry(entry.getUserId(), entry.getStructureId(), entry.getDateChanged());
                this.m_sqlManager.getEntityManager(dbc).persist((Object)newEntry);
            }
            this.m_sqlManager.getEntityManager(dbc).flush();
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    protected CmsPublishJobInfoBean createPublishJobInfoBean(CmsDAOPublishJobs pj) {
        return new CmsPublishJobInfoBean(new CmsUUID(pj.getHistoryId()), new CmsUUID(pj.getProjectId()), pj.getProjectName(), new CmsUUID(pj.getUserId()), pj.getPublishLocale(), pj.getPublishFlags(), pj.getResourceCount(), pj.getEnqueueTime(), pj.getStartTime(), pj.getFinishTime());
    }

    protected CmsResourceState fixMovedResource(CmsDbContext dbc, CmsProject onlineProject, CmsResource offlineResource, CmsUUID publishHistoryId, int publishTag) throws CmsDataAccessException {
        CmsResource onlineResource;
        try {
            onlineResource = this.m_driverManager.getVfsDriver(dbc).readResource(dbc, onlineProject.getUuid(), offlineResource.getStructureId(), true);
            if (onlineResource.getRootPath().equals(offlineResource.getRootPath())) {
                return offlineResource.getState();
            }
        }
        catch (CmsVfsResourceNotFoundException e) {
            return offlineResource.getState();
        }
        this.m_driverManager.getVfsDriver(dbc).moveResource(dbc, onlineProject.getUuid(), onlineResource, offlineResource.getRootPath());
        try {
            this.m_driverManager.getProjectDriver(dbc).writePublishHistory(dbc, publishHistoryId, new CmsPublishedResource(onlineResource, publishTag, CmsPublishedResource.STATE_MOVED_SOURCE));
        }
        catch (CmsDataAccessException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_WRITING_PUBLISHING_HISTORY_1", onlineResource.getRootPath()), (Throwable)e);
            }
            throw e;
        }
        return offlineResource.getState().isDeleted() ? CmsResource.STATE_DELETED : CmsPublishedResource.STATE_MOVED_DESTINATION;
    }

    protected String getParameterString(Collection<?> data) {
        StringBuffer conditions = new StringBuffer();
        conditions.append(" (");
        Iterator<?> it = data.iterator();
        while (it.hasNext()) {
            it.next();
            conditions.append("?");
            if (!it.hasNext()) continue;
            conditions.append(", ");
        }
        conditions.append(") ");
        return conditions.toString();
    }

    protected CmsProject internalCreateProject(CmsDAOProjects p) {
        String ou = CmsOrganizationalUnit.removeLeadingSeparator(p.getProjectOu());
        return new CmsProject(new CmsUUID(p.getProjectId()), ou + p.getProjectName(), p.getProjectDescription(), new CmsUUID(p.getUserId()), new CmsUUID(p.getGroupId()), new CmsUUID(p.getManagerGroupId()), p.getProjectFlags(), p.getDateCreated(), CmsProject.CmsProjectType.valueOf(p.getProjectType()));
    }

    protected CmsPublishList internalDeserializePublishList(byte[] bytes) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
        ObjectInputStream oin = new ObjectInputStream(bin);
        return (CmsPublishList)oin.readObject();
    }

    protected CmsLogEntry internalReadLogEntry(CmsDAOLog daoLog) {
        CmsUUID userId = new CmsUUID(daoLog.getUserId());
        long date = daoLog.getLogDate();
        CmsUUID structureId = new CmsUUID(daoLog.getStructureId());
        CmsLogEntryType type = CmsLogEntryType.valueOf(daoLog.getLogType());
        String[] data = CmsStringUtil.splitAsArray(daoLog.getLogData(), '|');
        return new CmsLogEntry(userId, date, structureId, type, data);
    }

    protected void internalResetResourceState(CmsDbContext dbc, CmsResource resource) throws CmsDataAccessException {
        try {
            resource.setState(CmsResource.STATE_UNCHANGED);
            this.m_driverManager.getVfsDriver(dbc).writeResourceState(dbc, dbc.currentProject(), resource, 3, true);
        }
        catch (CmsDataAccessException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_ERROR_RESETTING_RESOURCE_STATE_1", resource.getRootPath()), (Throwable)e);
            }
            throw e;
        }
    }

    protected byte[] internalSerializePublishList(CmsPublishList publishList) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oout = new ObjectOutputStream(bout);
        oout.writeObject(publishList);
        oout.close();
        return bout.toByteArray();
    }

    protected void internalWriteHistory(CmsDbContext dbc, CmsResource resource, CmsResourceState state, List<CmsProperty> properties, CmsUUID publishHistoryId, int publishTag) throws CmsDataAccessException {
        try {
            if (OpenCms.getSystemInfo().isHistoryEnabled()) {
                if (properties == null) {
                    properties = this.m_driverManager.getVfsDriver(dbc).readPropertyObjects(dbc, dbc.currentProject(), resource);
                }
                this.m_driverManager.getHistoryDriver(dbc).writeResource(dbc, resource, properties, publishTag);
            }
            this.m_driverManager.getProjectDriver().writePublishHistory(dbc, publishHistoryId, new CmsPublishedResource(resource, publishTag, state));
        }
        catch (CmsDataAccessException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_WRITING_PUBLISHING_HISTORY_1", resource.getRootPath()), (Throwable)e);
            }
            throw e;
        }
    }

    protected CmsPair<String, List<I_CmsQueryParameter>> prepareLogConditions(CmsLogFilter filter) {
        Set<CmsLogEntryType> excludeTypes;
        Set<CmsLogEntryType> includeTypes;
        ArrayList<I_CmsQueryParameter> params = new ArrayList<I_CmsQueryParameter>();
        StringBuffer conditions = new StringBuffer();
        if (filter.getUserId() != null) {
            if (conditions.length() == 0) {
                conditions.append(" (");
            } else {
                conditions.append(" AND (");
            }
            conditions.append(this.m_sqlManager.readQuery(C_LOG_FILTER_USER_ID));
            params.add(new CmsQueryStringParameter(filter.getUserId().toString()));
            conditions.append(") ");
        }
        if (filter.getStructureId() != null) {
            if (conditions.length() == 0) {
                conditions.append(" (");
            } else {
                conditions.append(" AND (");
            }
            conditions.append(this.m_sqlManager.readQuery(C_LOG_FILTER_RESOURCE_ID));
            params.add(new CmsQueryStringParameter(filter.getStructureId().toString()));
            conditions.append(") ");
        }
        if (filter.getDateFrom() != 0L) {
            if (conditions.length() == 0) {
                conditions.append(" (");
            } else {
                conditions.append(" AND (");
            }
            conditions.append(this.m_sqlManager.readQuery(C_LOG_FILTER_DATE_FROM));
            params.add(new CmsQueryLongParameter(filter.getDateFrom()));
            conditions.append(") ");
        }
        if (filter.getDateTo() != 0L) {
            if (conditions.length() == 0) {
                conditions.append(" (");
            } else {
                conditions.append(" AND (");
            }
            conditions.append(this.m_sqlManager.readQuery(C_LOG_FILTER_DATE_TO));
            params.add(new CmsQueryLongParameter(filter.getDateTo()));
            conditions.append(") ");
        }
        if (!(includeTypes = filter.getIncludeTypes()).isEmpty()) {
            if (conditions.length() == 0) {
                conditions.append(" (");
            } else {
                conditions.append(" AND (");
            }
            conditions.append(this.m_sqlManager.readQuery(C_LOG_FILTER_INCLUDE_TYPE));
            conditions.append(" (");
            Iterator<CmsLogEntryType> it = includeTypes.iterator();
            while (it.hasNext()) {
                CmsLogEntryType type = it.next();
                conditions.append("?");
                params.add(new CmsQueryIntParameter(type.getId()));
                if (!it.hasNext()) continue;
                conditions.append(", ");
            }
            conditions.append(") ");
            conditions.append(") ");
        }
        if (!(excludeTypes = filter.getExcludeTypes()).isEmpty()) {
            if (conditions.length() == 0) {
                conditions.append(" (");
            } else {
                conditions.append(" AND (");
            }
            conditions.append(this.m_sqlManager.readQuery(C_LOG_FILTER_EXCLUDE_TYPE));
            conditions.append(" (");
            Iterator<CmsLogEntryType> it = excludeTypes.iterator();
            while (it.hasNext()) {
                CmsLogEntryType type = it.next();
                conditions.append("?");
                params.add(new CmsQueryIntParameter(type.getId()));
                if (!it.hasNext()) continue;
                conditions.append(", ");
            }
            conditions.append(") ");
            conditions.append(") ");
        }
        return CmsPair.create(conditions.toString(), params);
    }

    protected void publishChangedFile(CmsDbContext dbc, CmsProject onlineProject, CmsResource offlineResource, Set<CmsUUID> publishedResourceIds, CmsUUID publishHistoryId, int publishTag) throws CmsDataAccessException {
        CmsFile newFile;
        List<CmsProperty> offlineProperties;
        CmsResource onlineResource = null;
        boolean needToUpdateContent = true;
        boolean existsOnline = this.m_driverManager.getVfsDriver(dbc).validateStructureIdExists(dbc, CmsProject.ONLINE_PROJECT_ID, offlineResource.getStructureId());
        CmsResourceState resourceState = existsOnline ? this.fixMovedResource(dbc, onlineProject, offlineResource, publishHistoryId, publishTag) : offlineResource.getState();
        try {
            int flags = offlineResource.getFlags();
            offlineResource.setFlags(flags &= 0xFFFFFFFD);
            if (existsOnline) {
                onlineResource = this.m_driverManager.getVfsDriver(dbc).readResource(dbc, onlineProject.getUuid(), offlineResource.getStructureId(), false);
                needToUpdateContent = onlineResource.getDateContent() < offlineResource.getDateContent();
                this.m_driverManager.getVfsDriver(dbc).deletePropertyObjects(dbc, onlineProject.getUuid(), onlineResource, 1);
                if (!onlineResource.getResourceId().equals(offlineResource.getResourceId()) && (offlineProperties = this.m_driverManager.getVfsDriver(dbc).readPropertyObjects(dbc, dbc.currentProject(), onlineResource)).size() > 0) {
                    for (int i = 0; i < offlineProperties.size(); ++i) {
                        CmsProperty property = offlineProperties.get(i);
                        property.setStructureValue(null);
                        property.setResourceValue("");
                    }
                    this.m_driverManager.getVfsDriver(dbc).writePropertyObjects(dbc, dbc.currentProject(), onlineResource, offlineProperties);
                }
            }
        }
        catch (CmsDataAccessException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_DELETING_PROPERTIES_1", offlineResource.toString()), (Throwable)e);
            }
            throw e;
        }
        try {
            newFile = this.m_driverManager.getProjectDriver(dbc).publishFileContent(dbc, dbc.currentProject(), onlineProject, offlineResource, publishedResourceIds, needToUpdateContent, publishTag);
        }
        catch (CmsDataAccessException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_PUBLISHING_RESOURCE_1", offlineResource.getRootPath()), (Throwable)e);
            }
            throw e;
        }
        try {
            offlineProperties = this.m_driverManager.getVfsDriver(dbc).readPropertyObjects(dbc, dbc.currentProject(), offlineResource);
            CmsProperty.setAutoCreatePropertyDefinitions(offlineProperties, true);
            this.m_driverManager.getVfsDriver(dbc).writePropertyObjects(dbc, onlineProject, newFile, offlineProperties);
        }
        catch (CmsDataAccessException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_PUBLISHING_PROPERTIES_1", newFile.getRootPath()), (Throwable)e);
            }
            throw e;
        }
        try {
            this.m_driverManager.getUserDriver(dbc).publishAccessControlEntries(dbc, dbc.currentProject(), onlineProject, newFile.getResourceId(), offlineResource.getResourceId());
        }
        catch (CmsDataAccessException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_PUBLISHING_ACL_1", newFile.getRootPath()), (Throwable)e);
            }
            throw e;
        }
        CmsFile offlineFile = new CmsFile(offlineResource);
        offlineFile.setContents(newFile.getContents());
        this.internalWriteHistory(dbc, offlineFile, resourceState, offlineProperties, publishHistoryId, publishTag);
        this.m_driverManager.getVfsDriver(dbc).updateRelations(dbc, onlineProject, offlineResource);
    }

    protected void publishDeletedFile(CmsDbContext dbc, CmsProject onlineProject, CmsResource offlineResource, CmsUUID publishHistoryId, int publishTag) throws CmsDataAccessException {
        CmsResourceState resourceState = this.fixMovedResource(dbc, onlineProject, offlineResource, publishHistoryId, publishTag);
        boolean existsOnline = this.m_driverManager.getVfsDriver(dbc).validateStructureIdExists(dbc, CmsProject.ONLINE_PROJECT_ID, offlineResource.getStructureId());
        CmsResource onlineResource = null;
        if (existsOnline) {
            try {
                onlineResource = this.m_driverManager.getVfsDriver(dbc).readResource(dbc, onlineProject.getUuid(), offlineResource.getStructureId(), true);
            }
            catch (CmsDataAccessException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_READING_RESOURCE_1", offlineResource.getRootPath()), (Throwable)e);
                }
                throw e;
            }
        }
        if (offlineResource.isLabeled() && !this.m_driverManager.labelResource(dbc, offlineResource, null, 2)) {
            int flags = offlineResource.getFlags();
            offlineResource.setFlags(flags &= 0xFFFFFFFD);
        }
        CmsFile offlineFile = new CmsFile(offlineResource);
        offlineFile.setContents(this.m_driverManager.getVfsDriver(dbc).readContent(dbc, dbc.currentProject().getUuid(), offlineFile.getResourceId()));
        this.internalWriteHistory(dbc, offlineFile, resourceState, null, publishHistoryId, publishTag);
        int propertyDeleteOption = -1;
        try {
            propertyDeleteOption = offlineResource.getSiblingCount() > 1 ? 2 : 1;
            if (existsOnline) {
                this.m_driverManager.getVfsDriver(dbc).deletePropertyObjects(dbc, onlineProject.getUuid(), onlineResource, propertyDeleteOption);
            }
            this.m_driverManager.getVfsDriver(dbc).deletePropertyObjects(dbc, dbc.currentProject().getUuid(), offlineResource, propertyDeleteOption);
            if (existsOnline && onlineResource != null && !onlineResource.getResourceId().equals(offlineResource.getResourceId())) {
                this.m_driverManager.getVfsDriver(dbc).deletePropertyObjects(dbc, dbc.currentProject().getUuid(), onlineResource, 1);
            }
        }
        catch (CmsDataAccessException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_DELETING_PROPERTIES_1", offlineResource.getRootPath()), (Throwable)e);
            }
            throw e;
        }
        try {
            this.m_driverManager.getVfsDriver(dbc).removeFile(dbc, dbc.currentProject().getUuid(), offlineResource);
            if (existsOnline && onlineResource != null) {
                this.m_driverManager.getVfsDriver(dbc).removeFile(dbc, onlineProject.getUuid(), onlineResource);
            }
        }
        catch (CmsDataAccessException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_REMOVING_RESOURCE_1", offlineResource.getRootPath()), (Throwable)e);
            }
            throw e;
        }
        try {
            if (existsOnline && onlineResource != null && onlineResource.getSiblingCount() == 1) {
                this.m_driverManager.getUserDriver(dbc).removeAccessControlEntries(dbc, onlineProject, onlineResource.getResourceId());
            }
            if (offlineResource.getSiblingCount() == 1) {
                this.m_driverManager.getUserDriver(dbc).removeAccessControlEntries(dbc, dbc.currentProject(), offlineResource.getResourceId());
            }
        }
        catch (CmsDataAccessException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_REMOVING_ACL_1", offlineResource.toString()), (Throwable)e);
            }
            throw e;
        }
        try {
            this.m_driverManager.getVfsDriver(dbc).deleteRelations(dbc, onlineProject.getUuid(), offlineResource, CmsRelationFilter.TARGETS);
            this.m_driverManager.getVfsDriver(dbc).deleteRelations(dbc, dbc.currentProject().getUuid(), offlineResource, CmsRelationFilter.TARGETS);
        }
        catch (CmsDataAccessException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_REMOVING_RELATIONS_1", offlineResource.toString()), (Throwable)e);
            }
            throw e;
        }
        if (OpenCms.getSubscriptionManager().isEnabled()) {
            try {
                CmsVisitEntryFilter filter = CmsVisitEntryFilter.ALL.filterResource(offlineResource.getStructureId());
                this.m_driverManager.getSubscriptionDriver().deleteVisits(dbc, OpenCms.getSubscriptionManager().getPoolName(), filter);
            }
            catch (CmsDataAccessException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_REMOVING_VISITEDLOG_1", offlineResource.toString()), (Throwable)e);
                }
                throw e;
            }
            try {
                this.m_driverManager.getSubscriptionDriver().setSubscribedResourceAsDeleted(dbc, OpenCms.getSubscriptionManager().getPoolName(), offlineResource);
            }
            catch (CmsDataAccessException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_REMOVING_SUBSCRIPTIONS_1", offlineResource.toString()), (Throwable)e);
                }
                throw e;
            }
        }
    }

    protected void publishNewFile(CmsDbContext dbc, CmsProject onlineProject, CmsResource offlineResource, Set<CmsUUID> publishedContentIds, CmsUUID publishHistoryId, int publishTag) throws CmsDataAccessException {
        List<CmsProperty> offlineProperties;
        CmsFile newFile;
        CmsResourceState resourceState = this.fixMovedResource(dbc, onlineProject, offlineResource, publishHistoryId, publishTag);
        try {
            int flags = offlineResource.getFlags();
            offlineResource.setFlags(flags &= 0xFFFFFFFD);
            newFile = this.m_driverManager.getProjectDriver(dbc).publishFileContent(dbc, dbc.currentProject(), onlineProject, offlineResource, publishedContentIds, true, publishTag);
        }
        catch (CmsVfsResourceAlreadyExistsException e) {
            try {
                this.m_driverManager.getVfsDriver(dbc).removeFile(dbc, onlineProject.getUuid(), offlineResource);
                publishedContentIds.remove(offlineResource.getResourceId());
                newFile = this.m_driverManager.getProjectDriver(dbc).publishFileContent(dbc, dbc.currentProject(), onlineProject, offlineResource, publishedContentIds, true, publishTag);
            }
            catch (CmsDataAccessException e1) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_PUBLISHING_RESOURCE_1", offlineResource.getRootPath()), (Throwable)e);
                }
                throw e1;
            }
        }
        catch (CmsDataAccessException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_PUBLISHING_RESOURCE_1", offlineResource.getRootPath()), (Throwable)e);
            }
            throw e;
        }
        try {
            offlineProperties = this.m_driverManager.getVfsDriver(dbc).readPropertyObjects(dbc, dbc.currentProject(), offlineResource);
            CmsProperty.setAutoCreatePropertyDefinitions(offlineProperties, true);
            this.m_driverManager.getVfsDriver(dbc).writePropertyObjects(dbc, onlineProject, newFile, offlineProperties);
        }
        catch (CmsDataAccessException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_PUBLISHING_PROPERTIES_1", newFile.getRootPath()), (Throwable)e);
            }
            throw e;
        }
        try {
            this.m_driverManager.getUserDriver(dbc).publishAccessControlEntries(dbc, dbc.currentProject(), onlineProject, offlineResource.getResourceId(), newFile.getResourceId());
        }
        catch (CmsDataAccessException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_PUBLISHING_ACL_1", newFile.getRootPath()), (Throwable)e);
            }
            throw e;
        }
        CmsFile offlineFile = new CmsFile(offlineResource);
        offlineFile.setContents(newFile.getContents());
        this.internalWriteHistory(dbc, offlineFile, resourceState, offlineProperties, publishHistoryId, publishTag);
        this.m_driverManager.getVfsDriver(dbc).updateRelations(dbc, onlineProject, offlineResource);
    }
}

