/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.collectors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsDataAccessException;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.collectors.A_CmsResourceCollector;
import org.opencms.file.collectors.CmsDateResourceComparator;
import org.opencms.file.collectors.Messages;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;

public class CmsChangedResourceCollector
extends A_CmsResourceCollector {
    public static final String PARAM_KEY_COUNT = "count";
    public static final String PARAM_KEY_DATEFROM = "datefrom";
    public static final String PARAM_KEY_DATETO = "dateto";
    public static final String PARAM_KEY_EXCLUDETYPE = "excludetype";
    public static final String PARAM_KEY_RESOURCE = "resource";
    public static final String PARAM_KEY_SORTBY = "sortby";
    private static final String[] COLLECTORS = new String[]{"allChangedInFolderDateDesc", "allChangedInFolderDateAsc", "allChangedInSubTreeDateDesc", "allChangedInSubTreeDateAsc"};
    private static final List<String> COLLECTORS_LIST = Collections.unmodifiableList(Arrays.asList(COLLECTORS));
    private static final Log LOG = CmsLog.getLog(CmsChangedResourceCollector.class);

    @Override
    public List<String> getCollectorNames() {
        return COLLECTORS_LIST;
    }

    @Override
    public String getCreateLink(CmsObject cms, String collectorName, String param) {
        return null;
    }

    @Override
    public String getCreateParam(CmsObject cms, String collectorName, String param) {
        return null;
    }

    @Override
    public List<CmsResource> getResults(CmsObject cms, String collectorName, String param) throws CmsDataAccessException, CmsException {
        return this.getResults(cms, collectorName, param, -1);
    }

    @Override
    public List<CmsResource> getResults(CmsObject cms, String collectorName, String param, int numResults) throws CmsDataAccessException, CmsException {
        if (collectorName == null) {
            collectorName = COLLECTORS[0];
        }
        switch (COLLECTORS_LIST.indexOf(collectorName)) {
            case 0: {
                return this.allChangedInFolderDate(cms, param, false, false, numResults);
            }
            case 1: {
                return this.allChangedInFolderDate(cms, param, false, true, numResults);
            }
            case 2: {
                return this.allChangedInFolderDate(cms, param, true, false, numResults);
            }
            case 3: {
                return this.allChangedInFolderDate(cms, param, true, true, numResults);
            }
        }
        throw new CmsDataAccessException(Messages.get().container("ERR_COLLECTOR_NAME_INVALID_1", collectorName));
    }

    protected List<CmsResource> allChangedInFolderDate(CmsObject cms, String param, boolean tree, boolean asc, int numResults) throws CmsException {
        Map<String, String> params = this.getParameters(param);
        String foldername = "/";
        if (params.containsKey(PARAM_KEY_RESOURCE)) {
            foldername = CmsResource.getFolderPath(params.get(PARAM_KEY_RESOURCE));
        }
        long dateFrom = 0L;
        long dateTo = Long.MAX_VALUE;
        if (params.containsKey(PARAM_KEY_DATEFROM)) {
            try {
                dateFrom = Long.parseLong(params.get(PARAM_KEY_DATEFROM));
            }
            catch (NumberFormatException e) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_COLLECTOR_PARAM_INVALID_1", "datefrom=" + params.get(PARAM_KEY_DATEFROM)));
                throw e;
            }
        }
        if (params.containsKey(PARAM_KEY_DATETO)) {
            try {
                dateTo = Long.parseLong(params.get(PARAM_KEY_DATETO));
            }
            catch (NumberFormatException e) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_COLLECTOR_PARAM_INVALID_1", "dateto=" + params.get(PARAM_KEY_DATETO)));
                throw e;
            }
        }
        CmsResourceFilter filter = CmsResourceFilter.DEFAULT_FILES.addExcludeFlags(1024).addRequireLastModifiedAfter(dateFrom).addRequireLastModifiedBefore(dateTo);
        if (params.containsKey(PARAM_KEY_EXCLUDETYPE)) {
            String excludeType = params.get(PARAM_KEY_EXCLUDETYPE);
            int typeId = -1;
            try {
                I_CmsResourceType resourceType = OpenCms.getResourceManager().getResourceType(excludeType);
                typeId = resourceType.getTypeId();
            }
            catch (CmsLoaderException e1) {
                try {
                    int typeInt = Integer.parseInt(excludeType);
                    I_CmsResourceType resourceType = OpenCms.getResourceManager().getResourceType(typeInt);
                    typeId = resourceType.getTypeId();
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)Messages.get().getBundle().key("LOG_RESTYPE_INTID_2", resourceType.getTypeName(), new Integer(resourceType.getTypeId())));
                    }
                }
                catch (NumberFormatException e2) {
                    throw new CmsRuntimeException(Messages.get().container("ERR_COLLECTOR_PARAM_INVALID_1", "excludetype=" + params.get(PARAM_KEY_EXCLUDETYPE)), (Throwable)e2);
                }
                catch (CmsLoaderException e2) {
                    throw new CmsRuntimeException(Messages.get().container("ERR_UNKNOWN_RESTYPE_1", excludeType), (Throwable)e2);
                }
            }
            if (typeId != -1) {
                filter = filter.addExcludeType(typeId);
            }
        }
        List<CmsResource> result = cms.readResources(foldername, filter, tree);
        String sortBy = CmsDateResourceComparator.DATE_ATTRIBUTES_LIST.get(1);
        if (params.containsKey(PARAM_KEY_SORTBY)) {
            sortBy = params.get(PARAM_KEY_SORTBY);
        }
        ArrayList<String> dateIdentifiers = new ArrayList<String>(1);
        dateIdentifiers.add(sortBy);
        CmsDateResourceComparator comparator = new CmsDateResourceComparator(cms, dateIdentifiers, asc);
        Collections.sort(result, comparator);
        int count = -1;
        if (params.containsKey(PARAM_KEY_COUNT)) {
            try {
                count = Integer.parseInt(params.get(PARAM_KEY_COUNT));
            }
            catch (NumberFormatException e) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_COLLECTOR_PARAM_INVALID_1", "count=" + params.get(PARAM_KEY_COUNT)));
                throw e;
            }
        }
        if (count > 0 || numResults > 0) {
            return this.shrinkToFit(result, count, numResults);
        }
        return result;
    }

    private Map<String, String> getParameters(String param) {
        if (CmsStringUtil.isNotEmpty(param)) {
            return CmsStringUtil.splitAsMap(param, "|", "=");
        }
        return Collections.emptyMap();
    }
}

