/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsConfigurationCopyResource;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.db.CmsSecurityManager;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsException;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.Messages;
import org.opencms.file.types.CmsResourceTypeUnknownFile;
import org.opencms.file.types.CmsResourceTypeUnknownFolder;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.loader.CmsLoaderException;
import org.opencms.loader.CmsResourceManager;
import org.opencms.lock.CmsLockType;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsLink;
import org.opencms.relations.I_CmsLinkParseable;
import org.opencms.staticexport.CmsLinkManager;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.containerpage.CmsFormatterConfiguration;

public abstract class A_CmsResourceType
implements I_CmsResourceType {
    public static final String CONFIGURATION_GALLERY_JAVASCRIPT_PATH = "gallery.javascript.path";
    public static final String CONFIGURATION_GALLERY_PREVIEW_PROVIDER = "gallery.preview.provider";
    public static final String CONFIGURATION_GALLERY_TYPE_NAMES = "gallery.type.names";
    public static final String CONFIGURATION_INTERNAL = "resource.flag.internal";
    public static final String DEFAULT_GALLERY_PREVIEW_PROVIDER = "org.opencms.ade.galleries.preview.CmsBinaryPreviewProvider";
    public static final String MACRO_RESOURCE_FOLDER_PATH = "resource.folder.path";
    public static final String MACRO_RESOURCE_FOLDER_PATH_TOUCH = "resource.folder.path.touch";
    public static final String MACRO_RESOURCE_NAME = "resource.name";
    public static final String MACRO_RESOURCE_PARENT_PATH = "resource.parent.path";
    public static final String MACRO_RESOURCE_ROOT_PATH = "resource.root.path";
    public static final String MACRO_RESOURCE_SITE_PATH = "resource.site.path";
    private static final Log LOG = CmsLog.getLog(A_CmsResourceType.class);
    protected boolean m_addititionalModuleResourceType;
    protected String m_className;
    protected CmsParameterConfiguration m_configuration;
    protected List<CmsConfigurationCopyResource> m_copyResources;
    protected List<CmsProperty> m_defaultProperties;
    protected boolean m_frozen;
    protected List<String> m_mappings = new ArrayList<String>();
    protected String m_moduleName;
    protected int m_typeId = -1;
    protected String m_typeName;
    private String m_adjustLinksFolder;
    protected String m_galleryPreviewProvider;
    private String m_galleryTypeNames;
    private List<I_CmsResourceType> m_galleryTypes;
    private Boolean m_internal;

    public A_CmsResourceType() {
        this.m_defaultProperties = new ArrayList<CmsProperty>();
        this.m_copyResources = new ArrayList<CmsConfigurationCopyResource>();
        this.m_configuration = new CmsParameterConfiguration();
    }

    @Override
    public void addConfigurationParameter(String paramName, String paramValue) {
        this.m_configuration.add(paramName, paramValue);
        if (CmsStringUtil.isNotEmpty(paramName) && CmsStringUtil.isNotEmpty(paramValue)) {
            if (CONFIGURATION_INTERNAL.equalsIgnoreCase(paramName)) {
                this.m_internal = Boolean.valueOf(paramValue.trim());
            }
            if (CONFIGURATION_GALLERY_TYPE_NAMES.equalsIgnoreCase(paramName)) {
                this.m_galleryTypeNames = paramValue.trim();
            }
        }
    }

    public void addCopyResource(String source, String target, String type) throws CmsConfigurationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)org.opencms.file.types.Messages.get().getBundle().key("LOG_ADD_COPY_RESOURCE_4", new Object[]{this, source, target, type}));
        }
        if (this.m_frozen) {
            throw new CmsConfigurationException(org.opencms.file.types.Messages.get().container("ERR_CONFIG_FROZEN_3", this.getClass().getName(), this.getTypeName(), new Integer(this.getTypeId())));
        }
        CmsConfigurationCopyResource copyResource = new CmsConfigurationCopyResource(source, target, type);
        this.m_copyResources.add(copyResource);
    }

    public void addDefaultProperty(CmsProperty property) throws CmsConfigurationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)org.opencms.file.types.Messages.get().getBundle().key("LOG_ADD_DFLT_PROP_2", this, property));
        }
        if (this.m_frozen) {
            throw new CmsConfigurationException(org.opencms.file.types.Messages.get().container("ERR_CONFIG_FROZEN_3", this.getClass().getName(), this.getTypeName(), new Integer(this.getTypeId())));
        }
        this.m_defaultProperties.add(property);
    }

    @Override
    public void addMappingType(String mapping) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)org.opencms.file.types.Messages.get().getBundle().key("LOG_ADD_MAPPING_TYPE_2", mapping, this));
        }
        if (this.m_mappings == null) {
            this.m_mappings = new ArrayList<String>();
        }
        this.m_mappings.add(mapping);
    }

    @Override
    public void changeLock(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource) throws CmsException {
        securityManager.changeLock(cms.getRequestContext(), resource);
    }

    @Override
    public void chflags(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, int flags) throws CmsException {
        securityManager.chflags(cms.getRequestContext(), resource, flags);
    }

    @Override
    public void chtype(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, I_CmsResourceType type) throws CmsException {
        this.chtype(cms, securityManager, resource, type.getTypeId());
    }

    @Override
    @Deprecated
    public void chtype(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, int type) throws CmsException {
        securityManager.chtype(cms.getRequestContext(), resource, type);
        this.createRelations(cms, securityManager, resource.getRootPath());
    }

    @Override
    public void copyResource(CmsObject cms, CmsSecurityManager securityManager, CmsResource source, String destination, CmsResource.CmsResourceCopyMode siblingMode) throws CmsException {
        securityManager.copyResource(cms.getRequestContext(), source, cms.getRequestContext().addSiteRoot(destination), siblingMode);
        this.createRelations(cms, securityManager, cms.getRequestContext().addSiteRoot(destination));
    }

    @Override
    public void copyResourceToProject(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource) throws CmsException {
        securityManager.copyResourceToProject(cms.getRequestContext(), resource);
    }

    @Override
    public CmsResource createResource(CmsObject cms, CmsSecurityManager securityManager, String resourcename, byte[] content, List<CmsProperty> properties) throws CmsException {
        CmsMacroResolver resolver = this.getMacroResolver(cms, resourcename);
        List<CmsProperty> newProperties = this.processDefaultProperties(properties, resolver);
        CmsResource result = securityManager.createResource(cms.getRequestContext(), cms.getRequestContext().addSiteRoot(resourcename), this.getTypeId(), content, newProperties);
        if (this.m_internal != null && this.m_internal.booleanValue()) {
            securityManager.chflags(cms.getRequestContext(), result, result.getFlags() ^ 0x200);
        }
        this.processCopyResources(cms, resourcename, resolver);
        this.createRelations(cms, securityManager, cms.getRequestContext().addSiteRoot(resourcename));
        return result;
    }

    @Override
    public CmsResource createSibling(CmsObject cms, CmsSecurityManager securityManager, CmsResource source, String destination, List<CmsProperty> properties) throws CmsException {
        CmsResource sibling = securityManager.createSibling(cms.getRequestContext(), source, cms.getRequestContext().addSiteRoot(destination), properties);
        this.createRelations(cms, securityManager, sibling.getRootPath());
        return sibling;
    }

    @Override
    public void deleteResource(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, CmsResource.CmsResourceDeleteMode siblingMode) throws CmsException {
        securityManager.deleteResource(cms.getRequestContext(), resource, siblingMode);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof I_CmsResourceType) {
            I_CmsResourceType other = (I_CmsResourceType)obj;
            if (this.getTypeName() != null && this.getTypeName().equals(other.getTypeName())) {
                return true;
            }
            if (this.getTypeId() == other.getTypeId()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getAdjustLinksFolder() {
        return this.m_adjustLinksFolder;
    }

    @Override
    public String getCachePropertyDefault() {
        return null;
    }

    @Override
    public String getClassName() {
        return this.m_className;
    }

    @Override
    public CmsParameterConfiguration getConfiguration() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)org.opencms.file.types.Messages.get().getBundle().key("LOG_GET_CONFIGURATION_1", this));
        }
        return this.m_configuration;
    }

    @Override
    public List<CmsConfigurationCopyResource> getConfiguredCopyResources() {
        return this.m_copyResources;
    }

    @Override
    public List<CmsProperty> getConfiguredDefaultProperties() {
        return this.m_defaultProperties;
    }

    @Override
    public List<String> getConfiguredMappings() {
        return this.m_mappings;
    }

    @Override
    public CmsFormatterConfiguration getFormattersForResource(CmsObject cms, CmsResource res) {
        return CmsFormatterConfiguration.EMPTY_CONFIGURATION;
    }

    @Override
    public String getGalleryPreviewProvider() {
        if (this.m_galleryPreviewProvider == null) {
            this.m_galleryPreviewProvider = this.getConfiguration().getString(CONFIGURATION_GALLERY_PREVIEW_PROVIDER, null);
        }
        return this.m_galleryPreviewProvider;
    }

    @Override
    public List<I_CmsResourceType> getGalleryTypes() {
        if (this.m_galleryTypes == null) {
            this.m_galleryTypes = new ArrayList<I_CmsResourceType>();
            if (!CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_galleryTypeNames)) {
                CmsResourceManager rm = OpenCms.getResourceManager();
                for (String typeName : CmsStringUtil.splitAsList(this.m_galleryTypeNames, '|')) {
                    try {
                        this.m_galleryTypes.add(rm.getResourceType(typeName));
                    }
                    catch (CmsLoaderException e) {
                        if (!LOG.isWarnEnabled()) continue;
                        LOG.warn((Object)org.opencms.file.types.Messages.get().container("ERR_COULD_NOT_READ_RESOURCE_TYPE_1", typeName));
                    }
                }
            }
        }
        return this.m_galleryTypes;
    }

    @Override
    public abstract int getLoaderId();

    @Override
    public String getModuleName() {
        return this.m_moduleName;
    }

    @Override
    @Deprecated
    public int getTypeId() {
        return this.m_typeId;
    }

    @Override
    public String getTypeName() {
        return this.m_typeName;
    }

    public int hashCode() {
        return this.getTypeName().hashCode();
    }

    @Override
    public CmsResource importResource(CmsObject cms, CmsSecurityManager securityManager, String resourcename, CmsResource resource, byte[] content, List<CmsProperty> properties) throws CmsException {
        resource.setDateLastModified(resource.getDateLastModified());
        resource.setState(CmsResource.STATE_NEW);
        return securityManager.importResource(cms.getRequestContext(), cms.getRequestContext().addSiteRoot(resourcename), resource, content, properties, true);
    }

    @Override
    public final void initConfiguration() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)org.opencms.file.types.Messages.get().getBundle().key("LOG_INIT_CONFIGURATION_1", this));
        }
    }

    @Override
    public void initConfiguration(String name, String id, String className) throws CmsConfigurationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)org.opencms.file.types.Messages.get().getBundle().key("LOG_INIT_CONFIGURATION_3", this, name, id));
        }
        if (this.m_frozen) {
            throw new CmsConfigurationException(org.opencms.configuration.Messages.get().container("ERR_CONFIG_FROZEN_3", className, this.getTypeName(), new Integer(this.getTypeId())));
        }
        this.m_frozen = true;
        if (name != null) {
            this.m_typeName = name;
        }
        if (id != null) {
            this.m_typeId = Integer.valueOf(id);
        }
        if (className != null) {
            this.m_className = className;
        }
        if (this.getTypeName() == null || this.getClassName() == null || this.getTypeId() < 0 && !this.m_typeName.equals(CmsResourceTypeUnknownFile.getStaticTypeName()) && !this.m_typeName.equals(CmsResourceTypeUnknownFolder.getStaticTypeName())) {
            throw new CmsConfigurationException(org.opencms.file.types.Messages.get().container("ERR_INVALID_RESTYPE_CONFIG_3", className, this.m_typeName, new Integer(this.m_typeId)));
        }
        this.m_defaultProperties = Collections.unmodifiableList(this.m_defaultProperties);
        this.m_copyResources = Collections.unmodifiableList(this.m_copyResources);
        this.m_mappings = Collections.unmodifiableList(this.m_mappings);
        this.m_configuration = CmsParameterConfiguration.unmodifiableVersion(this.m_configuration);
    }

    @Override
    public void initialize(CmsObject cms) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)org.opencms.file.types.Messages.get().getBundle().key("LOG_INITIALIZE_1", this));
        }
    }

    @Override
    public boolean isAdditionalModuleResourceType() {
        return this.m_addititionalModuleResourceType;
    }

    @Override
    public boolean isDirectEditable() {
        return false;
    }

    @Override
    public boolean isFolder() {
        return false;
    }

    @Override
    public boolean isIdentical(I_CmsResourceType type) {
        if (type == null) {
            return false;
        }
        return this.getTypeId() == type.getTypeId() && this.getTypeName().equals(type.getTypeName());
    }

    @Override
    public void lockResource(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, CmsLockType type) throws CmsException {
        securityManager.lockResource(cms.getRequestContext(), resource, type);
    }

    @Override
    public void moveResource(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, String destination) throws CmsException, CmsIllegalArgumentException {
        String dest = cms.getRequestContext().addSiteRoot(destination);
        if (resource.getRootPath().equals(dest)) {
            throw new CmsVfsException(Messages.get().container("ERR_MOVE_SAME_NAME_1", destination));
        }
        try {
            securityManager.readResource(cms.getRequestContext(), dest, CmsResourceFilter.ALL);
            throw new CmsVfsException(Messages.get().container("ERR_OVERWRITE_RESOURCE_2", cms.getRequestContext().removeSiteRoot(resource.getRootPath()), destination));
        }
        catch (CmsVfsResourceNotFoundException cmsVfsResourceNotFoundException) {
            String targetName = CmsResource.getName(destination).replace("/", "");
            CmsResource.checkResourceName(targetName);
            securityManager.moveResource(cms.getRequestContext(), resource, dest);
            return;
        }
    }

    @Override
    public void removeResourceFromProject(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource) throws CmsException {
        securityManager.removeResourceFromProject(cms.getRequestContext(), resource);
    }

    @Override
    public void replaceResource(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, I_CmsResourceType type, byte[] content, List<CmsProperty> properties) throws CmsException {
        this.replaceResource(cms, securityManager, resource, type.getTypeId(), content, properties);
    }

    @Override
    @Deprecated
    public void replaceResource(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, int type, byte[] content, List<CmsProperty> properties) throws CmsException {
        securityManager.replaceResource(cms.getRequestContext(), resource, type, content, properties);
        this.createRelations(cms, securityManager, resource.getRootPath());
    }

    @Override
    public void restoreResource(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, int version) throws CmsException {
        securityManager.restoreResource(cms.getRequestContext(), resource, version);
        this.createRelations(cms, securityManager, resource.getRootPath());
    }

    @Override
    public void setAdditionalModuleResourceType(boolean additionalType) {
        this.m_addititionalModuleResourceType = additionalType;
    }

    @Override
    public void setAdjustLinksFolder(String adjustLinksFolder) {
        this.m_adjustLinksFolder = adjustLinksFolder;
    }

    @Override
    public void setDateExpired(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, long dateExpired, boolean recursive) throws CmsException {
        securityManager.setDateExpired(cms.getRequestContext(), resource, dateExpired);
    }

    @Override
    public void setDateLastModified(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, long dateLastModified, boolean recursive) throws CmsException {
        securityManager.setDateLastModified(cms.getRequestContext(), resource, dateLastModified);
    }

    @Override
    public void setDateReleased(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, long dateReleased, boolean recursive) throws CmsException {
        securityManager.setDateReleased(cms.getRequestContext(), resource, dateReleased);
    }

    @Override
    public void setModuleName(String moduleName) {
        this.m_moduleName = moduleName;
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append("[ResourceType] class=");
        output.append(this.getClass().getName());
        output.append(" name=");
        output.append(this.getTypeName());
        output.append(" id=");
        output.append(this.getTypeId());
        output.append(" loaderId=");
        output.append(this.getLoaderId());
        return output.toString();
    }

    @Override
    public void undelete(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, boolean recursive) throws CmsException {
        securityManager.undelete(cms.getRequestContext(), resource);
    }

    @Override
    public void undoChanges(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, CmsResource.CmsResourceUndoMode mode) throws CmsException {
        securityManager.undoChanges(cms.getRequestContext(), resource, mode);
        this.updateRelationForUndo(cms, securityManager, resource);
    }

    @Override
    public void unlockResource(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource) throws CmsException {
        securityManager.unlockResource(cms.getRequestContext(), resource);
    }

    @Override
    public CmsFile writeFile(CmsObject cms, CmsSecurityManager securityManager, CmsFile resource) throws CmsException {
        if (resource.isFile()) {
            CmsFile file = securityManager.writeFile(cms.getRequestContext(), resource);
            I_CmsResourceType type = this.getResourceType(file);
            List<CmsLink> links = null;
            if (type instanceof I_CmsLinkParseable) {
                links = ((I_CmsLinkParseable)((Object)type)).parseLinks(cms, file);
            }
            securityManager.updateRelationsForResource(cms.getRequestContext(), file, links);
            return file;
        }
        throw new CmsVfsException(org.opencms.file.types.Messages.get().container("ERR_WRITE_FILE_IS_FOLDER_1", cms.getSitePath(resource)));
    }

    @Override
    public void writePropertyObject(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, CmsProperty property) throws CmsException {
        securityManager.writePropertyObject(cms.getRequestContext(), resource, property);
    }

    @Override
    public void writePropertyObjects(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, List<CmsProperty> properties) throws CmsException {
        securityManager.writePropertyObjects(cms.getRequestContext(), resource, properties);
    }

    protected CmsResource createRelations(CmsObject cms, CmsSecurityManager securityManager, String resourceName) throws CmsException {
        CmsResource resource = securityManager.readResource(cms.getRequestContext(), resourceName, CmsResourceFilter.ALL);
        I_CmsResourceType resourceType = this.getResourceType(resource);
        List<CmsLink> links = null;
        if (resourceType instanceof I_CmsLinkParseable) {
            I_CmsLinkParseable linkParseable = (I_CmsLinkParseable)((Object)resourceType);
            links = linkParseable.parseLinks(cms, cms.readFile(resource));
        }
        securityManager.updateRelationsForResource(cms.getRequestContext(), resource, links);
        return resource;
    }

    protected CmsMacroResolver getMacroResolver(CmsObject cms, String resourcename) {
        CmsMacroResolver result = CmsMacroResolver.newInstance().setCmsObject(cms);
        if (this.isFolder() && !CmsResource.isFolder(resourcename)) {
            resourcename = resourcename.concat("/");
        }
        result.addMacro(MACRO_RESOURCE_ROOT_PATH, cms.getRequestContext().addSiteRoot(resourcename));
        result.addMacro(MACRO_RESOURCE_SITE_PATH, resourcename);
        result.addMacro(MACRO_RESOURCE_FOLDER_PATH, CmsResource.getFolderPath(resourcename));
        result.addMacro(MACRO_RESOURCE_FOLDER_PATH_TOUCH, CmsResource.getFolderPath(resourcename));
        result.addMacro(MACRO_RESOURCE_PARENT_PATH, CmsResource.getParentFolder(resourcename));
        result.addMacro(MACRO_RESOURCE_NAME, CmsResource.getName(resourcename));
        return result;
    }

    protected I_CmsResourceType getResourceType(CmsResource resource) {
        return OpenCms.getResourceManager().getResourceType(resource);
    }

    protected void processCopyResources(CmsObject cms, String resourcename, CmsMacroResolver resolver) {
        HashMap<String, String> copiedResources = new HashMap<String, String>();
        for (CmsConfigurationCopyResource oriCopyResource : this.m_copyResources) {
            String oriTarget;
            String target = oriTarget = oriCopyResource.getTarget();
            ArrayList<CmsConfigurationCopyResource> copyResources = new ArrayList<CmsConfigurationCopyResource>();
            try {
                if (oriCopyResource.getSource().endsWith("*")) {
                    String source = oriCopyResource.getSource().substring(0, oriCopyResource.getSource().length() - 1);
                    List<CmsResource> sources = cms.readResources(source, CmsResourceFilter.IGNORE_EXPIRATION, false);
                    for (CmsResource sourceRes : sources) {
                        copyResources.add(new CmsConfigurationCopyResource(cms.getSitePath(sourceRes), oriCopyResource.getTarget(), oriCopyResource.getTypeString()));
                    }
                    copiedResources.put(source, resolver.resolveMacros(target));
                } else {
                    copyResources.add(oriCopyResource);
                }
                for (CmsConfigurationCopyResource copyResource : copyResources) {
                    target = copyResource.getTarget();
                    if (copyResource.isTargetWasNull() || CmsMacroResolver.isMacro(target, MACRO_RESOURCE_FOLDER_PATH) || CmsMacroResolver.isMacro(target, MACRO_RESOURCE_FOLDER_PATH_TOUCH)) {
                        target = target.concat(CmsResource.getName(copyResource.getSource()));
                    }
                    target = resolver.resolveMacros(target);
                    target = CmsFileUtil.normalizePath(CmsLinkManager.getAbsoluteUri(target, resourcename), '/');
                    cms.copyResource(copyResource.getSource(), target, copyResource.getType());
                    copiedResources.put(copyResource.getSource(), target);
                    if (!CmsMacroResolver.isMacro(oriTarget, MACRO_RESOURCE_FOLDER_PATH_TOUCH)) continue;
                    CmsResource res = cms.readResource(target);
                    if (res.isFile()) {
                        CmsFile file = cms.readFile(res);
                        cms.writeFile(file);
                        continue;
                    }
                    for (CmsResource subRes : cms.readResources(target, CmsResourceFilter.DEFAULT_FILES, true)) {
                        CmsFile file = cms.readFile(subRes);
                        cms.writeFile(file);
                    }
                }
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)org.opencms.file.types.Messages.get().getBundle().key("LOG_PROCESS_COPY_RESOURCES_3", resourcename, oriCopyResource, target), (Throwable)e);
                    continue;
                }
                LOG.error((Object)org.opencms.file.types.Messages.get().getBundle().key("LOG_PROCESS_COPY_RESOURCES_3", resourcename, oriCopyResource, target));
            }
        }
        try {
            if (!CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_adjustLinksFolder) && !copiedResources.isEmpty()) {
                String realAdjustFolderPath = resolver.resolveMacros(this.m_adjustLinksFolder);
                cms.adjustLinks(copiedResources, realAdjustFolderPath);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (CmsIllegalArgumentException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected List<CmsProperty> processDefaultProperties(List<CmsProperty> properties, CmsMacroResolver resolver) {
        if (this.m_defaultProperties == null || this.m_defaultProperties.size() == 0) {
            return properties;
        }
        ArrayList<CmsProperty> result = new ArrayList<CmsProperty>();
        Iterator<CmsProperty> i = this.m_defaultProperties.iterator();
        while (i.hasNext()) {
            CmsProperty property = i.next().clone();
            if (property.getResourceValue() != null) {
                property.setResourceValue(resolver.resolveMacros(property.getResourceValue()));
            }
            if (property.getStructureValue() != null) {
                property.setStructureValue(resolver.resolveMacros(property.getStructureValue()));
            }
            result.add(property);
        }
        if (properties != null) {
            result.addAll(properties);
        }
        return result;
    }

    protected void updateRelationForUndo(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource) throws CmsException {
        CmsResource undoneResource1 = null;
        try {
            undoneResource1 = this.createRelations(cms, securityManager, resource.getRootPath());
        }
        catch (CmsVfsResourceNotFoundException cmsVfsResourceNotFoundException) {
            // empty catch block
        }
        CmsResource undoneResource2 = securityManager.readResource(cms.getRequestContext(), resource.getStructureId(), CmsResourceFilter.ALL);
        if (!undoneResource2.equals(undoneResource1)) {
            List<CmsLink> links;
            block9: {
                I_CmsResourceType resourceType = this.getResourceType(resource);
                links = null;
                if (resourceType instanceof I_CmsLinkParseable) {
                    I_CmsLinkParseable linkParseable = (I_CmsLinkParseable)((Object)resourceType);
                    if (undoneResource1 == null || !undoneResource2.getRootPath().equals(undoneResource1.getRootPath())) {
                        try {
                            links = linkParseable.parseLinks(cms, cms.readFile(undoneResource2));
                        }
                        catch (CmsException e) {
                            if (LOG.isWarnEnabled()) {
                                LOG.warn((Object)e);
                            }
                        }
                        catch (CmsRuntimeException e) {
                            if (!LOG.isWarnEnabled()) break block9;
                            LOG.warn((Object)e);
                        }
                    }
                }
            }
            securityManager.updateRelationsForResource(cms.getRequestContext(), undoneResource2, links);
        }
    }
}

