/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.wrapper;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsResourceState;
import org.opencms.db.Messages;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.types.CmsResourceTypeBinary;
import org.opencms.file.types.CmsResourceTypeFolder;
import org.opencms.file.wrapper.A_CmsResourceWrapper;
import org.opencms.loader.CmsLoaderException;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsResourceWrapperModules
extends A_CmsResourceWrapper {
    private static final Log LOG = CmsLog.getLog(CmsResourceWrapperModules.class);
    public static final String BASE_PATH = "/modules";
    public static final String IMPORT_PATH = "/modules/import";
    public static final String EXPORT_PATH = "/modules/export";
    public static final String LOG_PATH = "/modules/log";
    public static final List<String> FOLDERS = Collections.unmodifiableList(Arrays.asList("/modules", "/modules/import", "/modules/export", "/modules/log"));
    private Map<String, CmsFile> m_importDataCache = new ConcurrentHashMap<String, CmsFile>();
    ConcurrentHashMap<String, Long> m_importFileUpdateCache = new ConcurrentHashMap();

    @Override
    public List<CmsResource> addResourcesToFolder(CmsObject cms, String resourcename, CmsResourceFilter filter) throws CmsException {
        String resourceNameWithTrailingSlash = CmsStringUtil.joinPaths(resourcename, "/");
        if (this.matchPath("/", resourceNameWithTrailingSlash)) {
            return this.getVirtualResourcesForRoot(cms);
        }
        if (this.matchPath(BASE_PATH, resourceNameWithTrailingSlash)) {
            return this.getVirtualResourcesForBasePath(cms);
        }
        if (this.matchPath(EXPORT_PATH, resourceNameWithTrailingSlash)) {
            return this.getVirtualResourcesForExport(cms);
        }
        if (this.matchPath(IMPORT_PATH, resourceNameWithTrailingSlash)) {
            return this.getVirtualResourcesForImport(cms);
        }
        if (this.matchPath(LOG_PATH, resourceNameWithTrailingSlash)) {
            return this.getVirtualLogResources(cms);
        }
        return Collections.emptyList();
    }

    @Override
    public CmsResource createResource(CmsObject cms, String resourcename, int type, byte[] content, List<CmsProperty> properties) throws CmsException, CmsIllegalArgumentException {
        if (this.matchParentPath(IMPORT_PATH, resourcename)) {
            CmsResource res = this.createFakeBinaryFile(resourcename, 0L);
            CmsFile file = new CmsFile(res);
            file.setContents(content);
            OpenCms.getModuleManager().getImportExportRepository().importModule(CmsResource.getName(resourcename), content);
            this.m_importFileUpdateCache.put(resourcename, System.currentTimeMillis());
            return file;
        }
        return super.createResource(cms, resourcename, type, content, properties);
    }

    @Override
    public boolean deleteResource(CmsObject cms, String resourcename, CmsResource.CmsResourceDeleteMode siblingMode) throws CmsException {
        if (this.matchParentPath(EXPORT_PATH, resourcename)) {
            String fileName = CmsResource.getName(resourcename);
            boolean result = OpenCms.getModuleManager().getImportExportRepository().deleteModule(fileName);
            return result;
        }
        return false;
    }

    @Override
    public CmsLock getLock(CmsObject cms, CmsResource resource) throws CmsException {
        if (this.isFakePath(resource.getRootPath())) {
            return CmsLock.getNullLock();
        }
        return super.getLock(cms, resource);
    }

    @Override
    public boolean isWrappedResource(CmsObject cms, CmsResource res) {
        return CmsStringUtil.isPrefixPath(BASE_PATH, res.getRootPath());
    }

    @Override
    public boolean lockResource(CmsObject cms, String resourcename, boolean temporary) {
        return this.isFakePath(resourcename);
    }

    @Override
    public CmsFile readFile(CmsObject cms, String resourcename, CmsResourceFilter filter) throws CmsException {
        cms.getRequestContext().removeAttribute("NO_FILESIZE_REQUIRED");
        CmsResource res = this.readResource(cms, resourcename, filter);
        return (CmsFile)res;
    }

    @Override
    public CmsResource readResource(CmsObject cms, String resourcepath, CmsResourceFilter filter) throws CmsException {
        CmsFile resultFile;
        if (resourcepath.endsWith("desktop.ini")) {
            return null;
        }
        for (String folder : FOLDERS) {
            if (!this.matchPath(resourcepath, folder)) continue;
            return this.createFakeFolder(folder);
        }
        if (this.matchParentPath(IMPORT_PATH, resourcepath) && this.hasImportFile(resourcepath)) {
            CmsFile importData = this.m_importDataCache.get(resourcepath);
            if (importData != null) {
                return importData;
            }
            return new CmsFile(this.createFakeBinaryFile(resourcepath));
        }
        if (this.matchParentPath(EXPORT_PATH, resourcepath)) {
            resultFile = new CmsFile(this.createFakeBinaryFile(resourcepath));
            if (cms.getRequestContext().getAttribute("NO_FILESIZE_REQUIRED") == null) {
                LOG.info((Object)("Getting data for " + resourcepath));
                byte[] data = OpenCms.getModuleManager().getImportExportRepository().getExportedModuleData(CmsResource.getName(resourcepath), cms.getRequestContext().getCurrentProject());
                resultFile.setContents(data);
            }
            return resultFile;
        }
        if (this.matchParentPath(LOG_PATH, resourcepath)) {
            resultFile = new CmsFile(this.createFakeBinaryFile(resourcepath));
            String moduleName = CmsResource.getName(resourcepath).replaceFirst("\\.log$", "");
            try {
                byte[] data = OpenCms.getModuleManager().getImportExportRepository().getModuleLog().readLog(moduleName);
                resultFile.setContents(data);
                return resultFile;
            }
            catch (IOException e) {
                throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_READ_RESOURCE_1", resourcepath), (Throwable)e);
            }
        }
        return super.readResource(cms, resourcepath, filter);
    }

    @Override
    public boolean unlockResource(CmsObject cms, String resourcename) {
        return this.isFakePath(resourcename);
    }

    @Override
    public CmsFile writeFile(CmsObject cms, CmsFile resource) throws CmsException {
        if (this.matchParentPath(IMPORT_PATH, resource.getRootPath())) {
            OpenCms.getModuleManager().getImportExportRepository().importModule(CmsResource.getName(resource.getRootPath()), resource.getContents());
            this.m_importFileUpdateCache.put(resource.getRootPath(), System.currentTimeMillis());
            this.m_importDataCache.put(resource.getRootPath(), resource);
            return resource;
        }
        return super.writeFile(cms, resource);
    }

    protected CmsResource createFakeBinaryFile(String rootPath) throws CmsLoaderException {
        return this.createFakeBinaryFile(rootPath, 0L);
    }

    protected CmsResource createFakeBinaryFile(String rootPath, long dateLastModified) throws CmsLoaderException {
        CmsUUID structureId = CmsUUID.getConstantUUID("s-" + rootPath);
        CmsUUID resourceId = CmsUUID.getConstantUUID("r-" + rootPath);
        int type = OpenCms.getResourceManager().getResourceType(CmsResourceTypeBinary.getStaticTypeName()).getTypeId();
        boolean isFolder = false;
        int flags = 0;
        CmsUUID projectId = CmsProject.ONLINE_PROJECT_ID;
        CmsResourceState state = CmsResource.STATE_UNCHANGED;
        long dateCreated = 0L;
        long dateReleased = 1L;
        long dateContent = 1L;
        int version = 0;
        CmsUUID userCreated = CmsUUID.getNullUUID();
        CmsUUID userLastModified = CmsUUID.getNullUUID();
        long dateExpired = Integer.MAX_VALUE;
        int linkCount = 0;
        int size = 1;
        CmsResource resource = new CmsResource(structureId, resourceId, rootPath, type, isFolder, flags, projectId, state, dateCreated, userCreated, dateLastModified, userLastModified, dateReleased, dateExpired, linkCount, size, dateContent, version);
        return resource;
    }

    protected CmsResource createFakeFolder(String rootPath) throws CmsLoaderException {
        if (rootPath.endsWith("/")) {
            rootPath = CmsFileUtil.removeTrailingSeparator(rootPath);
        }
        CmsUUID structureId = CmsUUID.getConstantUUID("s-" + rootPath);
        CmsUUID resourceId = CmsUUID.getConstantUUID("r-" + rootPath);
        int type = OpenCms.getResourceManager().getResourceType(CmsResourceTypeFolder.getStaticTypeName()).getTypeId();
        boolean isFolder = true;
        int flags = 0;
        CmsUUID projectId = CmsProject.ONLINE_PROJECT_ID;
        CmsResourceState state = CmsResource.STATE_UNCHANGED;
        long dateCreated = 0L;
        long dateLastModified = 0L;
        long dateReleased = 1L;
        long dateContent = 1L;
        int version = 0;
        CmsUUID userCreated = CmsUUID.getNullUUID();
        CmsUUID userLastModified = CmsUUID.getNullUUID();
        long dateExpired = Integer.MAX_VALUE;
        int linkCount = 0;
        int size = -1;
        CmsResource resource = new CmsResource(structureId, resourceId, rootPath, type, isFolder, flags, projectId, state, dateCreated, userCreated, dateLastModified, userLastModified, dateReleased, dateExpired, linkCount, size, dateContent, version);
        return resource;
    }

    private List<CmsResource> getVirtualLogResources(CmsObject cms) throws CmsException {
        ArrayList virtualResources = Lists.newArrayList();
        for (CmsModule module : OpenCms.getModuleManager().getAllInstalledModules()) {
            String path = CmsStringUtil.joinPaths(LOG_PATH, module.getName() + ".log");
            CmsResource res = this.createFakeBinaryFile(path);
            virtualResources.add(res);
        }
        return virtualResources;
    }

    private List<CmsResource> getVirtualResourcesForBasePath(CmsObject cms) throws CmsException {
        return Arrays.asList(this.createFakeFolder(IMPORT_PATH), this.createFakeFolder(EXPORT_PATH), this.createFakeFolder(LOG_PATH));
    }

    private List<CmsResource> getVirtualResourcesForExport(CmsObject cms) throws CmsException {
        ArrayList virtualResources = Lists.newArrayList();
        for (String name : OpenCms.getModuleManager().getImportExportRepository().getModuleFileNames()) {
            String path = CmsStringUtil.joinPaths(EXPORT_PATH, name);
            CmsResource res = this.createFakeBinaryFile(path);
            virtualResources.add(res);
        }
        return virtualResources;
    }

    private List<CmsResource> getVirtualResourcesForImport(CmsObject cms) {
        ArrayList result = Lists.newArrayList();
        return result;
    }

    private List<CmsResource> getVirtualResourcesForRoot(CmsObject cms) throws CmsException {
        CmsResource resource = this.createFakeFolder(BASE_PATH);
        return Arrays.asList(resource);
    }

    private boolean hasImportFile(String resourcepath) {
        Long value = this.m_importFileUpdateCache.get(resourcepath);
        if (value == null) {
            return false;
        }
        long age = System.currentTimeMillis() - value;
        return age < 5000L;
    }

    private boolean isFakePath(String resourcename) {
        for (String folder : FOLDERS) {
            if (!this.matchPath(folder, resourcename) && !this.matchParentPath(folder, resourcename)) continue;
            return true;
        }
        return false;
    }

    private boolean matchParentPath(String expectedParent, String path) {
        String parent = CmsResource.getParentFolder(path);
        if (parent == null) {
            return false;
        }
        return this.matchPath(expectedParent, parent);
    }

    private boolean matchPath(String expected, String actual) {
        return CmsStringUtil.joinPaths(actual, "/").equals(CmsStringUtil.joinPaths(expected, "/"));
    }
}

