/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.wrapper;

import org.opencms.file.CmsFile;
import org.opencms.file.CmsResource;

public class CmsWrappedResource {
    private CmsResource m_base;
    private boolean m_isFolder;
    private int m_length;
    private String m_rootPath;
    private int m_typeId;

    public CmsWrappedResource(CmsResource res) {
        this.m_base = res;
        this.m_rootPath = res.getRootPath();
        this.m_typeId = res.getTypeId();
        this.m_isFolder = res.isFolder();
        this.m_length = res.getLength();
    }

    public CmsFile getFile() {
        if (this.m_base instanceof CmsFile) {
            CmsFile file = (CmsFile)this.m_base;
            return new CmsFile(file.getStructureId(), file.getResourceId(), this.m_rootPath, this.m_typeId, file.getFlags(), file.getProjectLastModified(), file.getState(), file.getDateCreated(), file.getUserCreated(), file.getDateLastModified(), file.getUserLastModified(), file.getDateReleased(), file.getDateExpired(), file.getSiblingCount(), file.getLength(), file.getDateContent(), file.getVersion(), file.getContents());
        }
        return new CmsFile(this.getResource());
    }

    public int getLength() {
        return this.m_length;
    }

    public CmsResource getResource() {
        return new CmsResource(this.m_base.getStructureId(), this.m_base.getResourceId(), this.m_rootPath, this.m_typeId, this.m_isFolder, this.m_base.getFlags(), this.m_base.getProjectLastModified(), this.m_base.getState(), this.m_base.getDateCreated(), this.m_base.getUserCreated(), this.m_base.getDateLastModified(), this.m_base.getUserLastModified(), this.m_base.getDateReleased(), this.m_base.getDateExpired(), this.m_base.getSiblingCount(), this.m_length, this.m_base.getDateContent(), this.m_base.getVersion());
    }

    public String getRootPath() {
        return this.m_rootPath;
    }

    public int getTypeId() {
        return this.m_typeId;
    }

    public boolean isFolder() {
        return this.m_isFolder;
    }

    public void setFolder(boolean isFolder) {
        this.m_isFolder = isFolder;
        if (this.m_isFolder && !this.m_rootPath.endsWith("/")) {
            this.m_rootPath = this.m_rootPath + "/";
        }
    }

    public void setLength(int length) {
        this.m_length = length;
    }

    public void setRootPath(String rootPath) {
        this.m_rootPath = rootPath;
    }

    public void setTypeId(int typeId) {
        this.m_typeId = typeId;
    }
}

