/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.flex;

import org.apache.commons.logging.Log;
import org.opencms.flex.Messages;
import org.opencms.jsp.util.CmsJspDeviceSelectorDesktopMobileTablet;
import org.opencms.jsp.util.I_CmsJspDeviceSelector;
import org.opencms.main.CmsLog;

public class CmsFlexCacheConfiguration {
    private static final Log LOG = CmsLog.getLog(CmsFlexCacheConfiguration.class);
    private long m_avgCacheBytes;
    private boolean m_cacheEnabled;
    private boolean m_cacheOffline;
    private I_CmsJspDeviceSelector m_deviceSelector;
    private String m_deviceSelectorConfiguration;
    private long m_maxCacheBytes;
    private int m_maxEntryBytes;
    private int m_maxKeys;

    public long getAvgCacheBytes() {
        return this.m_avgCacheBytes;
    }

    public I_CmsJspDeviceSelector getDeviceSelector() {
        if (this.m_deviceSelector == null) {
            this.m_deviceSelector = new CmsJspDeviceSelectorDesktopMobileTablet();
        }
        return this.m_deviceSelector;
    }

    public String getDeviceSelectorConfiguration() {
        return this.m_deviceSelectorConfiguration;
    }

    public long getMaxCacheBytes() {
        return this.m_maxCacheBytes;
    }

    public int getMaxEntryBytes() {
        return this.m_maxEntryBytes;
    }

    public int getMaxKeys() {
        return this.m_maxKeys;
    }

    public void initialize(String enabled, String offline, String maxCacheBytes, String avgCacheBytes, String maxEntryBytes, String maxKeys) {
        this.setCacheEnabled(Boolean.valueOf(enabled));
        this.setCacheOffline(Boolean.valueOf(offline));
        this.setMaxCacheBytes(Long.parseLong(maxCacheBytes));
        this.setAvgCacheBytes(Long.parseLong(avgCacheBytes));
        this.setMaxEntryBytes(Integer.parseInt(maxEntryBytes));
        this.setMaxKeys(Integer.parseInt(maxKeys));
    }

    public boolean isCacheEnabled() {
        return this.m_cacheEnabled;
    }

    public boolean isCacheOffline() {
        return this.m_cacheOffline;
    }

    public void setAvgCacheBytes(long avgCacheBytes) {
        this.m_avgCacheBytes = avgCacheBytes;
    }

    public void setCacheEnabled(boolean enabled) {
        this.m_cacheEnabled = enabled;
    }

    public void setCacheOffline(boolean cacheOffline) {
        this.m_cacheOffline = cacheOffline;
    }

    public void setDeviceSelectorConfiguration(String deviceSelector) {
        Object objectInstance;
        this.m_deviceSelectorConfiguration = deviceSelector;
        try {
            objectInstance = Class.forName(this.m_deviceSelectorConfiguration).newInstance();
        }
        catch (Throwable t) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_CLASS_INIT_FAILURE_1", this.m_deviceSelectorConfiguration), t);
            return;
        }
        if (objectInstance instanceof I_CmsJspDeviceSelector) {
            this.m_deviceSelector = (I_CmsJspDeviceSelector)objectInstance;
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_FLEXCACHE_DEVICE_SELECTOR_SUCCESS_1", this.m_deviceSelectorConfiguration));
            }
        } else if (CmsLog.INIT.isFatalEnabled()) {
            CmsLog.INIT.fatal((Object)Messages.get().getBundle().key("INIT_FLEXCACHE_DEVICE_SELECTOR_FAILURE_1", this.m_deviceSelectorConfiguration));
        }
    }

    public void setMaxCacheBytes(long maxCacheBytes) {
        this.m_maxCacheBytes = maxCacheBytes;
    }

    public void setMaxEntryBytes(int maxEntryBytes) {
        this.m_maxEntryBytes = maxEntryBytes;
    }

    public void setMaxKeys(int maxKeys) {
        this.m_maxKeys = maxKeys;
    }
}

