/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.gwt;

import java.util.ArrayList;
import java.util.List;
import org.opencms.gwt.shared.CmsIconUtil;
import org.opencms.util.CmsStringUtil;

public class CmsIconCssRuleBuilder {
    private String m_imageUri = "INVALID_ICON";
    private List<String> m_selectors = new ArrayList<String>();

    public void addSelectorForSubType(String type, String suffix, boolean small) {
        String template = " .%1$s.%2$s.%3$s";
        String selector = String.format(template, "cms_type_icon", CmsIconUtil.getResourceTypeIconClass(type, small), CmsIconUtil.getResourceSubTypeIconClass(type, suffix, small));
        this.m_selectors.add(selector);
    }

    public void addSelectorForType(String type, boolean small) {
        String template = " div.%1$s.%2$s, span.%1$s.%2$s";
        String selector = String.format(template, "cms_type_icon", CmsIconUtil.getResourceTypeIconClass(type, small));
        this.m_selectors.add(selector);
    }

    public void setImageUri(String imageUri) {
        this.m_imageUri = imageUri;
    }

    public void writeCss(StringBuffer buffer) {
        buffer.append(CmsStringUtil.listAsString(this.m_selectors, ", "));
        buffer.append(" { background-image: url(\"");
        buffer.append(this.m_imageUri);
        buffer.append("\");} ");
    }
}

