/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.gwt;

import java.util.Map;
import org.opencms.file.types.CmsResourceTypeUnknownFile;
import org.opencms.gwt.CmsIconCssRuleBuilder;
import org.opencms.main.CmsEvent;
import org.opencms.main.I_CmsEventListener;
import org.opencms.main.OpenCms;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.workplace.explorer.CmsIconRule;

public final class CmsIconUtil
extends org.opencms.gwt.shared.CmsIconUtil
implements I_CmsEventListener {
    public static final String ICON_MODEL_GROUP_BIG = "modelpage_groups_big.png";
    public static final String ICON_MODEL_GROUP_REUSE_BIG = "modelgroup_reuse_big.png";
    public static final String ICON_MODEL_GROUP_REUSE_SMALL = "modelgroup_reuse.png";
    public static final String ICON_MODEL_GROUP_SMALL = "modelpage_groups.png";
    public static final String ICON_NAV_LEVEL_BIG = "navlevel_big.png";
    public static final String ICON_NAV_LEVEL_SMALL = "navlevel.png";
    public static final String NOT_FOUND_ICON_BIG = "resourceNotFoundBig.png";
    public static final String NOT_FOUND_ICON_SMALL = "resourceNotFoundSmall.png";
    private static String m_cachedCss;
    private static boolean m_listenerRegistered;

    private CmsIconUtil() {
    }

    public static String buildResourceIconCss() {
        if (!m_listenerRegistered) {
            CmsIconUtil.registerListener();
        }
        if (m_cachedCss == null) {
            CmsIconUtil.rebuildCss();
        }
        return m_cachedCss;
    }

    private static synchronized void rebuildCss() {
        if (m_cachedCss == null) {
            CssBuilder builder = new CssBuilder();
            m_cachedCss = builder.buildResourceIconCss();
        }
    }

    private static synchronized void registerListener() {
        if (!m_listenerRegistered) {
            OpenCms.getEventManager().addCmsEventListener(new CmsIconUtil(), new int[]{5});
            m_listenerRegistered = true;
        }
    }

    @Override
    public void cmsEvent(CmsEvent event) {
        m_cachedCss = null;
    }

    public static class CssBuilder {
        private StringBuffer m_buffer = new StringBuffer(1024);

        public String buildResourceIconCss() {
            this.m_buffer.append(this.buildUnknownIconCss());
            for (CmsExplorerTypeSettings type : OpenCms.getWorkplaceManager().getExplorerTypeSettings()) {
                this.addCssForType(type);
            }
            this.addPseudoTypes();
            this.addResourceNotFoundIconRule();
            return this.m_buffer.toString();
        }

        public String buildUnknownIconCss() {
            String unknown = this.getIconUri(OpenCms.getWorkplaceManager().getExplorerTypeSetting(CmsResourceTypeUnknownFile.getStaticTypeName()).getBigIconIfAvailable());
            String template = "div.%1$s, span.%1$s { background: transparent scroll 50%% 50%% no-repeat url(\"%2$s\");} ";
            return String.format(template, "cms_type_icon", unknown);
        }

        private void addCssForIconRule(String typeName, CmsIconRule rule) {
            String extension = rule.getExtension();
            if (rule.getBigIcon() != null) {
                CmsIconCssRuleBuilder cssBig = new CmsIconCssRuleBuilder();
                cssBig.addSelectorForSubType(typeName, extension, false);
                cssBig.setImageUri(this.getIconUri(rule.getBigIcon()));
                cssBig.writeCss(this.m_buffer);
                CmsIconCssRuleBuilder cssSmall = new CmsIconCssRuleBuilder();
                cssSmall.addSelectorForSubType(typeName, extension, true);
                cssSmall.setImageUri(this.getIconUri(rule.getIcon()));
                cssSmall.writeCss(this.m_buffer);
            } else {
                CmsIconCssRuleBuilder css = new CmsIconCssRuleBuilder();
                css.addSelectorForSubType(typeName, extension, false);
                css.addSelectorForSubType(typeName, extension, true);
                css.setImageUri(this.getIconUri(rule.getIcon()));
                css.writeCss(this.m_buffer);
            }
        }

        private void addCssForType(CmsExplorerTypeSettings explorerType) {
            CmsIconCssRuleBuilder cssSmall;
            CmsIconCssRuleBuilder css;
            String typeName = explorerType.getName();
            if (explorerType.getBigIcon() != null) {
                css = new CmsIconCssRuleBuilder();
                css.setImageUri(this.getIconUri(explorerType.getBigIcon()));
                css.addSelectorForType(typeName, false);
                css.writeCss(this.m_buffer);
                cssSmall = new CmsIconCssRuleBuilder();
                cssSmall.setImageUri(this.getIconUri(explorerType.getIcon()));
                cssSmall.addSelectorForType(typeName, true);
                cssSmall.writeCss(this.m_buffer);
            } else if (explorerType.getOriginalIcon() != null) {
                css = new CmsIconCssRuleBuilder();
                css.setImageUri(this.getIconUri(explorerType.getIcon()));
                css.addSelectorForType(typeName, true);
                css.addSelectorForType(typeName, false);
                css.writeCss(this.m_buffer);
            } else {
                css = new CmsIconCssRuleBuilder();
                css.setImageUri(this.getIconUri("document_big.png"));
                css.addSelectorForType(typeName, false);
                css.writeCss(this.m_buffer);
                cssSmall = new CmsIconCssRuleBuilder();
                cssSmall.setImageUri(this.getIconUri("document.png"));
                cssSmall.addSelectorForType(typeName, true);
                cssSmall.writeCss(this.m_buffer);
            }
            Map<String, CmsIconRule> iconRules = explorerType.getIconRules();
            for (Map.Entry<String, CmsIconRule> entry : iconRules.entrySet()) {
                CmsIconRule rule = entry.getValue();
                this.addCssForIconRule(typeName, rule);
            }
        }

        private void addPseudoTypes() {
            CmsExplorerTypeSettings navlevel = new CmsExplorerTypeSettings();
            navlevel.setName("navlevel");
            navlevel.setIcon(CmsIconUtil.ICON_NAV_LEVEL_SMALL);
            navlevel.setBigIcon(CmsIconUtil.ICON_NAV_LEVEL_BIG);
            this.addCssForType(navlevel);
            CmsExplorerTypeSettings modelgroupReuse = new CmsExplorerTypeSettings();
            modelgroupReuse.setName("modelgroupreuse");
            modelgroupReuse.setIcon(CmsIconUtil.ICON_MODEL_GROUP_REUSE_SMALL);
            modelgroupReuse.setBigIcon(CmsIconUtil.ICON_MODEL_GROUP_REUSE_BIG);
            this.addCssForType(modelgroupReuse);
            CmsExplorerTypeSettings modelgroupPage = new CmsExplorerTypeSettings();
            modelgroupPage.setName("modelgrouppage");
            modelgroupPage.setIcon(CmsIconUtil.ICON_MODEL_GROUP_SMALL);
            modelgroupPage.setBigIcon(CmsIconUtil.ICON_MODEL_GROUP_BIG);
            this.addCssForType(modelgroupPage);
        }

        private void addResourceNotFoundIconRule() {
            CmsIconCssRuleBuilder cssBig = new CmsIconCssRuleBuilder();
            cssBig.addSelectorForType("cms_resource_not_found", false);
            cssBig.setImageUri(this.getIconUri(CmsIconUtil.NOT_FOUND_ICON_BIG));
            cssBig.writeCss(this.m_buffer);
            CmsIconCssRuleBuilder cssSmall = new CmsIconCssRuleBuilder();
            cssSmall.addSelectorForType("cms_resource_not_found", true);
            cssSmall.setImageUri(this.getIconUri(CmsIconUtil.NOT_FOUND_ICON_SMALL));
            cssSmall.writeCss(this.m_buffer);
        }

        private String getIconUri(String icon) {
            return CmsWorkplace.getResourceUri("filetypes/" + icon);
        }
    }
}

