/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.i18n;

import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsVfsBundleParameters;
import org.opencms.i18n.CmsVfsResourceBundle;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;

public class CmsVfsBundleLoaderProperties
implements CmsVfsResourceBundle.I_Loader {
    private static final Log LOG = CmsLog.getLog(CmsVfsBundleLoaderProperties.class);

    @Override
    public Map<Locale, Map<String, String>> loadData(CmsObject cms, CmsVfsBundleParameters params) throws Exception {
        CmsFile file = cms.readFile(params.getBasePath());
        String encoding = this.getEncoding(cms, file);
        Properties props = new Properties();
        props.load(new InputStreamReader((InputStream)new ByteArrayInputStream(file.getContents()), encoding));
        HashMap messages = Maps.newHashMap();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            messages.put((String)entry.getKey(), (String)entry.getValue());
        }
        HashMap result = Maps.newHashMap();
        result.put(params.getLocale(), messages);
        return result;
    }

    private String getEncoding(CmsObject cms, CmsResource res) {
        String defaultEncoding = OpenCms.getSystemInfo().getDefaultEncoding();
        try {
            CmsProperty encProp = cms.readPropertyObject(res, "content-encoding", true);
            String encoding = encProp.getValue(defaultEncoding);
            return encoding;
        }
        catch (Exception e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            return defaultEncoding;
        }
    }
}

