/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.importexport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.dom4j.Element;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.importexport.CmsImportExportException;
import org.opencms.importexport.CmsImportVersion5;
import org.opencms.importexport.Messages;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsDataTypeUtil;

@Deprecated
public class CmsImportVersion6
extends CmsImportVersion5 {
    public static final int IMPORT_VERSION6 = 6;
    private static final Log LOG = CmsLog.getLog(CmsImportVersion6.class);

    public CmsImportVersion6() {
        this.m_convertToXmlPage = true;
    }

    @Override
    public int getVersion() {
        return 6;
    }

    @Override
    protected void importUsers() throws CmsImportExportException {
        try {
            List userNodes = this.m_docXml.selectNodes("//userdata");
            for (int i = 0; i < userNodes.size(); ++i) {
                Element currentElement = (Element)userNodes.get(i);
                String name = this.getChildElementTextValue(currentElement, "name");
                name = OpenCms.getImportExportManager().translateUser(name);
                String pwd = this.getChildElementTextValue(currentElement, "password");
                String password = new String(Base64.decodeBase64((byte[])pwd.trim().getBytes()));
                String flags = this.getChildElementTextValue(currentElement, "flags");
                String firstname = this.getChildElementTextValue(currentElement, "firstname");
                String lastname = this.getChildElementTextValue(currentElement, "lastname");
                String email = this.getChildElementTextValue(currentElement, "email");
                long dateCreated = Long.parseLong(this.getChildElementTextValue(currentElement, "datecreated"));
                HashMap<String, Object> userInfo = new HashMap<String, Object>();
                for (Element infoEntryNode : currentElement.selectNodes("./userinfo/entry")) {
                    String key = infoEntryNode.attributeValue("name");
                    String type = infoEntryNode.attributeValue("type");
                    String value = infoEntryNode.getTextTrim();
                    userInfo.put(key, CmsDataTypeUtil.dataImport(value, type));
                }
                List groupNodes = currentElement.selectNodes("*/groupname");
                ArrayList<String> userGroups = new ArrayList<String>();
                for (int j = 0; j < groupNodes.size(); ++j) {
                    Element currentGroup = (Element)groupNodes.get(j);
                    String userInGroup = this.getChildElementTextValue(currentGroup, "name");
                    userInGroup = OpenCms.getImportExportManager().translateGroup(userInGroup);
                    userGroups.add(userInGroup);
                }
                this.importUser(name, flags, password, firstname, lastname, email, dateCreated, userInfo, userGroups);
            }
        }
        catch (CmsImportExportException e) {
            throw e;
        }
        catch (Exception e) {
            this.m_report.println(e);
            CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_IMPORTING_USERS_0");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)message.key(), (Throwable)e);
            }
            throw new CmsImportExportException(message, (Throwable)e);
        }
    }
}

