/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jlan;

import com.google.common.base.Joiner;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.core.DeviceContext;
import org.alfresco.jlan.server.filesys.AccessDeniedException;
import org.alfresco.jlan.server.filesys.DiskInterface;
import org.alfresco.jlan.server.filesys.FileExistsException;
import org.alfresco.jlan.server.filesys.FileInfo;
import org.alfresco.jlan.server.filesys.FileOpenParams;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.SearchContext;
import org.alfresco.jlan.server.filesys.TreeConnection;
import org.alfresco.jlan.util.WildCard;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceAlreadyExistsException;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.wrapper.CmsObjectWrapper;
import org.opencms.jlan.CmsJlanDeviceContext;
import org.opencms.jlan.CmsJlanNetworkFile;
import org.opencms.jlan.CmsJlanRepository;
import org.opencms.jlan.CmsJlanSearch;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsSecurityException;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.I_CmsRegexSubstitution;
import org.springframework.extensions.config.ConfigElement;

public class CmsJlanDiskInterface
implements DiskInterface {
    public static final String NO_FILESIZE_REQUIRED = "NO_FILESIZE_REQUIRED";
    public static final CmsResourceFilter STANDARD_FILTER = CmsResourceFilter.ONLY_VISIBLE_NO_DELETED;
    private static final Log LOG = CmsLog.getLog(CmsJlanDiskInterface.class);

    public static IOException convertCmsException(CmsException e) {
        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        if (e instanceof CmsSecurityException) {
            return new AccessDeniedException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof CmsVfsResourceAlreadyExistsException) {
            return new FileExistsException("File exists: " + e);
        }
        if (e instanceof CmsVfsResourceNotFoundException) {
            return new FileNotFoundException("File does not exist: " + e);
        }
        return new IOException(e);
    }

    protected static String getCmsPath(String path, boolean fileTranslation) {
        String slashPath = path.replace('\\', '/');
        String[] segments = slashPath.split("/");
        ArrayList<String> nonEmptySegments = new ArrayList<String>();
        for (String segment : segments) {
            if (segment.length() <= 0) continue;
            String translatedSegment = "*".equals(segment) ? "*" : (fileTranslation ? OpenCms.getResourceManager().getFileTranslator().translateResource(segment) : segment);
            nonEmptySegments.add(translatedSegment);
        }
        String result = "/" + Joiner.on((String)"/").join(nonEmptySegments);
        return result;
    }

    public void closeFile(SrvSession session, TreeConnection connection, NetworkFile file) throws IOException {
        file.close();
    }

    public DeviceContext createContext(String shareName, ConfigElement args) {
        return null;
    }

    public void createDirectory(SrvSession session, TreeConnection connection, FileOpenParams params) throws IOException {
        this.internalCreateFile(session, connection, params, "folder");
    }

    public NetworkFile createFile(SrvSession session, TreeConnection connection, FileOpenParams params) throws IOException {
        return this.internalCreateFile(session, connection, params, null);
    }

    public void deleteDirectory(SrvSession session, TreeConnection connection, String path) throws IOException {
        this.deleteFile(session, connection, path);
    }

    public void deleteFile(SrvSession session, TreeConnection connection, String path) throws IOException {
        try {
            CmsJlanNetworkFile file = this.getFileForPath(session, connection, path);
            if (file == null) {
                LOG.warn((Object)("Couldn't delete file " + path + " because it doesn't exist anymore."));
            } else {
                file.delete();
            }
        }
        catch (CmsException e) {
            throw CmsJlanDiskInterface.convertCmsException(e);
        }
    }

    public int fileExists(SrvSession session, TreeConnection connection, String path) {
        try {
            CmsObjectWrapper cms = this.getCms(session, connection);
            cms.getRequestContext().setAttribute(NO_FILESIZE_REQUIRED, Boolean.TRUE);
            CmsJlanNetworkFile file = this.getFileForPath(cms, session, connection, path);
            if (file == null) {
                return 0;
            }
            return file.isDirectory() ? 2 : 1;
        }
        catch (Exception e) {
            System.out.println(e);
            return 0;
        }
    }

    public void flushFile(SrvSession session, TreeConnection connection, NetworkFile file) throws IOException {
        file.flushFile();
    }

    public FileInfo getFileInformation(SrvSession session, TreeConnection connection, String path) throws IOException {
        try {
            if (path == null) {
                throw new FileNotFoundException("file not found: " + path);
            }
            CmsJlanNetworkFile file = this.getFileForPath(session, connection, path);
            if (file == null) {
                return null;
            }
            return file.getFileInfo();
        }
        catch (CmsException e) {
            throw CmsJlanDiskInterface.convertCmsException(e);
        }
    }

    public boolean isReadOnly(SrvSession session, DeviceContext context) {
        return false;
    }

    public NetworkFile openFile(SrvSession session, TreeConnection connection, FileOpenParams params) throws IOException {
        String path = params.getPath();
        CmsJlanRepository repository = ((CmsJlanDeviceContext)connection.getContext()).getRepository();
        String cmsPath = CmsJlanDiskInterface.getCmsPath(path, repository.isFileTranslationEnabled());
        try {
            CmsObjectWrapper cms = this.getCms(session, connection);
            CmsResource resource = cms.readResource(cmsPath, STANDARD_FILTER);
            return new CmsJlanNetworkFile(repository, cms, resource, path);
        }
        catch (CmsException e) {
            throw CmsJlanDiskInterface.convertCmsException(e);
        }
    }

    public int readFile(SrvSession sess, TreeConnection tree, NetworkFile file, byte[] buf, int bufPos, int siz, long filePos) throws IOException {
        if (file.isDirectory()) {
            throw new AccessDeniedException();
        }
        int rdlen = file.readFile(buf, siz, bufPos, filePos);
        if (rdlen < 0) {
            rdlen = 0;
        }
        return rdlen;
    }

    public void renameFile(SrvSession session, TreeConnection connection, String oldName, String newName) throws IOException {
        CmsJlanRepository repository = ((CmsJlanDeviceContext)connection.getContext()).getRepository();
        String cmsNewPath = CmsJlanDiskInterface.getCmsPath(newName, repository.isFileTranslationEnabled());
        try {
            CmsJlanNetworkFile file = this.getFileForPath(session, connection, oldName);
            file.moveTo(cmsNewPath);
        }
        catch (CmsException e) {
            throw CmsJlanDiskInterface.convertCmsException(e);
        }
        catch (CmsRuntimeException e) {
            throw new IOException(e);
        }
    }

    public long seekFile(SrvSession session, TreeConnection connection, NetworkFile file, long pos, int seekMode) throws IOException {
        return file.seekFile(pos, seekMode);
    }

    public void setFileInformation(SrvSession session, TreeConnection connection, String path, FileInfo info) throws IOException {
        try {
            CmsObjectWrapper cms = this.getCms(session, connection);
            CmsJlanRepository repository = ((CmsJlanDeviceContext)connection.getContext()).getRepository();
            String cmsPath = CmsJlanDiskInterface.getCmsPath(path, repository.isFileTranslationEnabled());
            CmsResource resource = cms.readResource(cmsPath, STANDARD_FILTER);
            CmsJlanNetworkFile file = new CmsJlanNetworkFile(repository, cms, resource, path);
            file.setFileInformation(info);
        }
        catch (CmsException e) {
            throw CmsJlanDiskInterface.convertCmsException(e);
        }
    }

    public SearchContext startSearch(SrvSession session, TreeConnection connection, String searchPath, int searchAttributes) {
        try {
            CmsJlanRepository repository = ((CmsJlanDeviceContext)connection.getContext()).getRepository();
            String cmsPath = CmsJlanDiskInterface.getCmsPath(searchPath, repository.isFileTranslationEnabled());
            if (cmsPath.endsWith("/")) {
                cmsPath = cmsPath + "*";
            }
            String name = CmsResource.getName(cmsPath);
            String parent = CmsResource.getParentFolder(cmsPath);
            if (WildCard.containsWildcards((String)name)) {
                CmsJlanNetworkFile parentFile = this.getFileForPath(session, connection, parent);
                return new CmsJlanSearch(parentFile.search(name, searchAttributes));
            }
            CmsJlanNetworkFile file = this.getFileForPath(session, connection, cmsPath);
            return new CmsJlanSearch(Collections.singletonList(file));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void treeClosed(SrvSession sess, TreeConnection tree) {
    }

    public void treeOpened(SrvSession arg0, TreeConnection arg1) {
    }

    public void truncateFile(SrvSession session, TreeConnection connection, NetworkFile file, long size) throws IOException {
        file.truncateFile(size);
    }

    public int writeFile(SrvSession session, TreeConnection connection, NetworkFile file, byte[] data, int bufferOffset, int length, long fileOffset) throws IOException {
        if (file.isDirectory()) {
            throw new AccessDeniedException("Can't write data to a directory!");
        }
        file.writeFile(data, length, bufferOffset, fileOffset);
        return length;
    }

    protected CmsObjectWrapper getCms(SrvSession session, TreeConnection connection) throws CmsException {
        CmsJlanRepository repository = ((CmsJlanDeviceContext)connection.getContext()).getRepository();
        CmsObjectWrapper result = repository.getCms(session, connection);
        return result;
    }

    protected CmsJlanNetworkFile getFileForPath(CmsObjectWrapper cms, SrvSession session, TreeConnection connection, String path) throws CmsException {
        try {
            CmsJlanRepository repository = ((CmsJlanDeviceContext)connection.getContext()).getRepository();
            boolean fileTranslations = repository.isFileTranslationEnabled();
            String cmsPath = CmsJlanDiskInterface.getCmsPath(path, fileTranslations);
            CmsResource resource = cms.readResource(cmsPath, STANDARD_FILTER);
            CmsJlanNetworkFile result = new CmsJlanNetworkFile(repository, cms, resource, path);
            return result;
        }
        catch (CmsVfsResourceNotFoundException e) {
            return null;
        }
    }

    protected CmsJlanNetworkFile getFileForPath(SrvSession session, TreeConnection connection, String path) throws CmsException {
        CmsObjectWrapper cms = this.getCms(session, connection);
        return this.getFileForPath(cms, session, connection, path);
    }

    protected NetworkFile internalCreateFile(SrvSession session, TreeConnection connection, FileOpenParams params, String typeName) throws IOException {
        String path = params.getPath();
        CmsJlanRepository repository = ((CmsJlanDeviceContext)connection.getContext()).getRepository();
        String cmsPath = CmsJlanDiskInterface.getCmsPath(path, repository.isFileTranslationEnabled());
        try {
            CmsObjectWrapper cms = this.getCms(session, connection);
            if (typeName == null) {
                typeName = OpenCms.getResourceManager().getDefaultTypeForName(cmsPath).getTypeName();
            }
            CmsResource createdResource = cms.createResource(cmsPath, OpenCms.getResourceManager().getResourceType(typeName).getTypeId());
            this.tryUnlock(cms, cmsPath);
            CmsJlanNetworkFile result = new CmsJlanNetworkFile(repository, cms, createdResource, path);
            result.setFullName(params.getPath());
            return result;
        }
        catch (CmsVfsResourceAlreadyExistsException e) {
            throw new FileExistsException("File exists: " + path);
        }
        catch (CmsException e) {
            throw new IOException(e);
        }
        catch (CmsRuntimeException e) {
            throw new IOException(e);
        }
    }

    protected String translateName(String path) {
        return CmsStringUtil.substitute(Pattern.compile("/([^/]+)$"), path, new I_CmsRegexSubstitution(){

            @Override
            public String substituteMatch(String text, Matcher matcher) {
                String name = text.substring(matcher.start(1), matcher.end(1));
                return "/" + OpenCms.getResourceManager().getFileTranslator().translateResource(name);
            }
        });
    }

    private void tryUnlock(CmsObjectWrapper cms, String path) {
        try {
            cms.unlockResource(path);
        }
        catch (Throwable e) {
            LOG.info((Object)e.getLocalizedMessage(), e);
        }
    }
}

