/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jlan;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.alfresco.jlan.server.filesys.AccessDeniedException;
import org.alfresco.jlan.server.filesys.FileInfo;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.util.WildCard;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsResource;
import org.opencms.file.wrapper.CmsObjectWrapper;
import org.opencms.file.wrapper.CmsWrappedResource;
import org.opencms.jlan.CmsFileBuffer;
import org.opencms.jlan.CmsJlanDiskInterface;
import org.opencms.jlan.CmsJlanRepository;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsUUID;

public class CmsJlanNetworkFile
extends NetworkFile {
    private static final Log LOG = CmsLog.getLog(CmsJlanNetworkFile.class);
    private CmsFileBuffer m_buffer = new CmsFileBuffer();
    private boolean m_bufferInitialized;
    private CmsObjectWrapper m_cms;
    private int m_lastFlush;
    private CmsResource m_resource;
    private CmsJlanRepository m_repository;

    public CmsJlanNetworkFile(CmsJlanRepository repository, CmsObjectWrapper cms, CmsResource resource, String fullName) {
        super(resource.getName());
        this.m_resource = resource;
        this.m_repository = repository;
        this.m_cms = cms;
        this.updateFromResource();
        this.setFullName(this.normalizeName(fullName));
        this.setFileId(resource.getStructureId().hashCode());
    }

    public void closeFile() throws IOException {
        if (this.hasDeleteOnClose()) {
            this.delete();
        } else {
            this.flushFile();
            if (this.getWriteCount() > 0) {
                try {
                    this.m_cms.unlockResource(this.m_cms.getSitePath(this.m_resource));
                }
                catch (CmsException e) {
                    LOG.error((Object)("Couldn't unlock file: " + this.m_resource.getRootPath()));
                }
            }
        }
    }

    public void delete() throws IOException {
        try {
            this.load(false);
            this.ensureLock();
            this.m_cms.deleteResource(this.m_cms.getSitePath(this.m_resource), CmsResource.DELETE_PRESERVE_SIBLINGS);
            if (!this.m_resource.getState().isNew()) {
                try {
                    this.m_cms.unlockResource(this.m_cms.getSitePath(this.m_resource));
                }
                catch (CmsException e) {
                    LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        catch (CmsException e) {
            throw CmsJlanDiskInterface.convertCmsException(e);
        }
    }

    public void flushFile() throws IOException {
        int writeCount = this.getWriteCount();
        try {
            CmsFile file;
            if (writeCount > this.m_lastFlush && (file = this.getFile()) != null) {
                CmsWrappedResource wr = new CmsWrappedResource(file);
                String rootPath = this.m_cms.getRequestContext().addSiteRoot(CmsJlanDiskInterface.getCmsPath(this.getFullName(), this.m_repository.isFileTranslationEnabled()));
                wr.setRootPath(rootPath);
                file = wr.getFile();
                file.setContents(this.m_buffer.getContents());
                this.ensureLock();
                this.m_cms.writeFile(file);
            }
            this.m_lastFlush = writeCount;
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw new IOException(e);
        }
    }

    public FileInfo getFileInfo() throws IOException {
        try {
            this.load(false);
            if (this.m_resource.isFile()) {
                long flen;
                long alloc = flen = (long)this.m_resource.getLength();
                int fattr = 0;
                if (this.m_cms.getRequestContext().getCurrentProject().isOnlineProject()) {
                    ++fattr;
                }
                FileInfo finfo = new FileInfo(this.m_resource.getName(), flen, fattr);
                long fdate = this.m_resource.getDateLastModified();
                finfo.setModifyDateTime(fdate);
                finfo.setAllocationSize(alloc);
                finfo.setFileId(this.m_resource.getStructureId().hashCode());
                finfo.setCreationDateTime(this.m_resource.getDateCreated());
                finfo.setChangeDateTime(fdate);
                return finfo;
            }
            int fattr = 16;
            if (this.m_cms.getRequestContext().getCurrentProject().isOnlineProject()) {
                ++fattr;
            }
            FileInfo finfo = new FileInfo(this.m_resource.getName(), 1L, fattr);
            long fdate = this.m_resource.getDateLastModified();
            finfo.setModifyDateTime(fdate);
            finfo.setAllocationSize(1L);
            finfo.setFileId(this.m_resource.getStructureId().hashCode());
            finfo.setCreationDateTime(this.m_resource.getDateCreated());
            finfo.setChangeDateTime(fdate);
            return finfo;
        }
        catch (CmsException e) {
            throw CmsJlanDiskInterface.convertCmsException(e);
        }
    }

    public void moveTo(String cmsNewPath) throws CmsException {
        CmsResource updatedRes;
        this.ensureLock();
        this.m_cms.moveResource(this.m_cms.getSitePath(this.m_resource), cmsNewPath);
        CmsUUID id = this.m_resource.getStructureId();
        this.m_resource = updatedRes = this.m_cms.readResource(id, CmsJlanDiskInterface.STANDARD_FILTER);
        this.updateFromResource();
    }

    public void openFile(boolean arg0) {
    }

    public int readFile(byte[] buffer, int length, int bufferOffset, long fileOffset) throws IOException {
        try {
            this.load(true);
            int result = this.m_buffer.read(buffer, length, bufferOffset, (int)fileOffset);
            return result;
        }
        catch (CmsException e) {
            throw CmsJlanDiskInterface.convertCmsException(e);
        }
    }

    public List<CmsJlanNetworkFile> search(String name, int searchAttributes) throws IOException {
        try {
            this.load(false);
            if (this.m_resource.isFolder()) {
                ArrayList<CmsJlanNetworkFile> result = new ArrayList<CmsJlanNetworkFile>();
                String regex = WildCard.convertToRegexp((String)name);
                Pattern pattern = Pattern.compile(regex);
                List<CmsResource> children = this.m_cms.getResourcesInFolder(this.m_cms.getSitePath(this.m_resource), CmsJlanDiskInterface.STANDARD_FILTER);
                for (CmsResource child : children) {
                    CmsJlanNetworkFile childFile = new CmsJlanNetworkFile(this.m_repository, this.m_cms, child, this.getFullChildPath(child));
                    if (!this.matchesSearchAttributes(searchAttributes) || !pattern.matcher(child.getName()).matches()) continue;
                    result.add(childFile);
                }
                return result;
            }
            throw new AccessDeniedException("Can't search a non-directory!");
        }
        catch (CmsException e) {
            throw CmsJlanDiskInterface.convertCmsException(e);
        }
    }

    public long seekFile(long pos, int typ) throws IOException {
        try {
            this.load(true);
            switch (typ) {
                case 1: {
                    this.m_buffer.seek(this.m_buffer.getPosition() + pos);
                    break;
                }
                case 2: {
                    long newPos = this.m_buffer.getLength() + pos;
                    this.m_buffer.seek(newPos);
                    break;
                }
                default: {
                    this.m_buffer.seek(pos);
                }
            }
            return this.m_buffer.getPosition();
        }
        catch (CmsException e) {
            throw new IOException(e);
        }
    }

    public void setFileInformation(FileInfo info) {
        if (info.hasSetFlag(1)) {
            this.setDeleteOnClose(true);
        }
    }

    public void truncateFile(long size) throws IOException {
        try {
            this.load(true);
            this.m_buffer.truncate((int)size);
            this.incrementWriteCount();
        }
        catch (CmsException e) {
            throw CmsJlanDiskInterface.convertCmsException(e);
        }
    }

    public void writeFile(byte[] data, int len, int pos, long offset) throws IOException {
        try {
            if (this.m_resource.isFolder()) {
                throw new AccessDeniedException("Can't write data to folder!");
            }
            this.load(true);
            this.m_buffer.seek(offset);
            byte[] dataToWrite = Arrays.copyOfRange(data, pos, pos + len);
            this.m_buffer.write(dataToWrite);
            this.incrementWriteCount();
        }
        catch (CmsException e) {
            throw CmsJlanDiskInterface.convertCmsException(e);
        }
    }

    protected void ensureLock() throws CmsException {
        CmsLock lock = this.m_cms.getLock(this.m_resource);
        if (lock.isUnlocked() || !lock.isLockableBy(this.m_cms.getRequestContext().getCurrentUser())) {
            this.m_cms.lockResourceTemporary(this.m_cms.getSitePath(this.m_resource));
        }
    }

    protected CmsFile getFile() {
        if (this.m_resource instanceof CmsFile) {
            return (CmsFile)this.m_resource;
        }
        return null;
    }

    protected String getFullChildPath(CmsResource child) {
        String childName = child.getName();
        String sep = this.getFullName().endsWith("\\") ? "" : "\\";
        return this.getFullName() + sep + childName;
    }

    protected void load(boolean needContent) throws IOException, CmsException {
        if (this.m_resource.isFolder() && needContent) {
            throw new AccessDeniedException("Operation not supported for directories!");
        }
        if (this.m_resource.isFile() && needContent && !(this.m_resource instanceof CmsFile)) {
            this.m_resource = this.m_cms.readFile(this.m_cms.getSitePath(this.m_resource), CmsJlanDiskInterface.STANDARD_FILTER);
        }
        if (!this.m_bufferInitialized && this.getFile() != null) {
            this.m_buffer.init(this.getFile().getContents());
            this.m_bufferInitialized = true;
        }
    }

    protected boolean matchesSearchAttributes(int attributes) {
        if (this.isDirectory()) {
            return (attributes & 0x10) != 0;
        }
        return true;
    }

    protected void updateFromResource() {
        this.setCreationDate(this.m_resource.getDateCreated());
        int length = this.m_resource.getLength();
        if (this.m_resource.isFolder()) {
            length = 1;
        }
        this.setFileSize(length);
        this.setModifyDate(this.m_resource.getDateLastModified());
        this.setAttributes(this.m_resource.isFile() ? 0 : 16);
    }

    private String normalizeName(String fullName) {
        return fullName.replaceAll("[/\\\\]+", "\\\\");
    }
}

