/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.containerpage.CmsContainerpageService;
import org.opencms.ade.containerpage.CmsElementUtil;
import org.opencms.ade.containerpage.CmsModelGroupHelper;
import org.opencms.ade.containerpage.shared.CmsContainer;
import org.opencms.ade.containerpage.shared.CmsFormatterConfig;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.history.CmsHistoryResourceHandler;
import org.opencms.flex.CmsFlexController;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsSingleTreeLocaleHandler;
import org.opencms.jsp.CmsJspTagEditable;
import org.opencms.jsp.CmsJspTagInclude;
import org.opencms.jsp.Messages;
import org.opencms.jsp.util.CmsJspStandardContextBean;
import org.opencms.loader.CmsLoaderException;
import org.opencms.loader.CmsTemplateContext;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalStateException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.site.CmsSite;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.containerpage.CmsADESessionCache;
import org.opencms.xml.containerpage.CmsContainerBean;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.CmsFormatterConfiguration;
import org.opencms.xml.containerpage.CmsGroupContainerBean;
import org.opencms.xml.containerpage.CmsXmlContainerPage;
import org.opencms.xml.containerpage.CmsXmlContainerPageFactory;
import org.opencms.xml.containerpage.CmsXmlGroupContainer;
import org.opencms.xml.containerpage.CmsXmlGroupContainerFactory;
import org.opencms.xml.containerpage.CmsXmlInheritGroupContainerHandler;
import org.opencms.xml.containerpage.I_CmsFormatterBean;

public class CmsJspTagContainer
extends BodyTagSupport {
    public static final String DEFAULT_MAX_ELEMENTS = "100";
    public static final String DETAIL_CONTAINERS_FOLDER_NAME = ".detailContainers";
    public static final String DUMMY_ELEMENT = "<div class='cmsTemplateContextDummyMarker' style='display: none !important;'></div>";
    private static final String DEFAULT_TAG_NAME = "div";
    private static final Log LOG = CmsLog.getLog(CmsJspTagContainer.class);
    private static final long serialVersionUID = -1228397990961282556L;
    public static final String LOCALE_ALL = "ALL";
    private String m_bodyContent;
    private boolean m_detailOnly;
    private boolean m_detailView;
    private String m_editableBy;
    private boolean m_editableRequest;
    private String m_maxElements;
    private String m_name;
    private String m_namePrefix;
    private String m_param;
    private CmsContainerBean m_parentContainer;
    private CmsContainerElementBean m_parentElement;
    private String m_tag;
    private String m_tagClass;
    private String m_type;
    private String m_width;

    public static I_CmsFormatterBean ensureValidFormatterSettings(CmsObject cms, CmsContainerElementBean element, CmsADEConfigData adeConfig, String containerName, String containerType, int containerWidth, boolean allowNested) {
        I_CmsFormatterBean formatterBean = CmsJspTagContainer.getFormatterConfigurationForElement(cms, element, adeConfig, containerName, containerType, containerWidth, allowNested);
        String settingsKey = CmsFormatterConfig.getSettingsKeyForContainer(containerName);
        if (formatterBean != null) {
            String formatterConfigId = formatterBean.getId();
            if (formatterConfigId == null) {
                formatterConfigId = "schema_formatter" + formatterBean.getJspStructureId().toString();
            }
            element.getSettings().put(settingsKey, formatterConfigId);
            element.setFormatterId(formatterBean.getJspStructureId());
        }
        return formatterBean;
    }

    public static String getDetailContainerLocale(CmsObject cms, String contentLocale, CmsResource resource) {
        boolean singleLocale = CmsJspTagContainer.useSingleLocaleDetailContainers(cms.getRequestContext().getSiteRoot());
        if (!singleLocale) {
            try {
                CmsProperty prop = cms.readPropertyObject(resource, "locale.independent-details", true);
                singleLocale = Boolean.parseBoolean(prop.getValue());
            }
            catch (Exception e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        return singleLocale ? LOCALE_ALL : contentLocale;
    }

    public static String getDetailContentPath(String detailContainersPage) {
        String detailName = CmsResource.getName(detailContainersPage);
        String parentFolder = CmsResource.getParentFolder(CmsResource.getParentFolder(detailContainersPage));
        if (parentFolder.endsWith("/.detailContainers/")) {
            parentFolder = CmsResource.getParentFolder(parentFolder);
        }
        detailName = CmsStringUtil.joinPaths(parentFolder, detailName);
        return detailName;
    }

    public static Optional<CmsResource> getDetailOnlyPage(CmsObject cms, CmsResource detailContent, String contentLocale) {
        try {
            CmsObject rootCms = OpenCms.initCmsObject(cms);
            rootCms.getRequestContext().setSiteRoot("");
            String path = CmsJspTagContainer.getDetailOnlyPageName(detailContent.getRootPath(), contentLocale);
            if (rootCms.existsResource(path, CmsResourceFilter.ALL)) {
                CmsResource detailOnlyRes = rootCms.readResource(path, CmsResourceFilter.ALL);
                return Optional.of((Object)detailOnlyRes);
            }
            return Optional.absent();
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            return Optional.absent();
        }
    }

    public static CmsContainerPageBean getDetailOnlyPage(CmsObject cms, ServletRequest req) {
        CmsJspStandardContextBean standardContext = CmsJspStandardContextBean.getInstance(req);
        CmsContainerPageBean detailOnlyPage = standardContext.getDetailOnlyPage();
        if (standardContext.isDetailRequest() && detailOnlyPage == null) {
            try {
                CmsObject rootCms = OpenCms.initCmsObject(cms);
                rootCms.getRequestContext().setSiteRoot("");
                String locale = CmsJspTagContainer.getDetailContainerLocale(cms, cms.getRequestContext().getLocale().toString(), cms.readResource(cms.getRequestContext().getUri()));
                String resourceName = CmsJspTagContainer.getDetailOnlyPageName(standardContext.getDetailContent().getRootPath(), locale);
                CmsResource resource = null;
                if (rootCms.existsResource(resourceName)) {
                    resource = rootCms.readResource(resourceName);
                } else {
                    resourceName = CmsJspTagContainer.getDetailOnlyPageName(standardContext.getDetailContent().getRootPath(), null);
                    if (rootCms.existsResource(resourceName)) {
                        resource = rootCms.readResource(resourceName);
                    }
                }
                CmsXmlContainerPage xmlContainerPage = null;
                if (resource != null) {
                    xmlContainerPage = CmsXmlContainerPageFactory.unmarshal(rootCms, resource, req);
                }
                if (xmlContainerPage != null) {
                    detailOnlyPage = xmlContainerPage.getContainerPage(rootCms);
                    standardContext.setDetailOnlyPage(detailOnlyPage);
                }
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return detailOnlyPage;
    }

    public static String getDetailOnlyPageName(String detailContentSitePath, String contentLocale) {
        String result = CmsResource.getFolderPath(detailContentSitePath);
        result = contentLocale != null ? CmsStringUtil.joinPaths(result, DETAIL_CONTAINERS_FOLDER_NAME, contentLocale.toString(), CmsResource.getName(detailContentSitePath)) : CmsStringUtil.joinPaths(result, DETAIL_CONTAINERS_FOLDER_NAME, CmsResource.getName(detailContentSitePath));
        return result;
    }

    public static List<CmsResource> getDetailOnlyResources(CmsObject cms, CmsResource resource) {
        ArrayList<CmsResource> result = new ArrayList<CmsResource>();
        HashSet<String> resourcePaths = new HashSet<String>();
        String sitePath = cms.getSitePath(resource);
        for (Locale locale : OpenCms.getLocaleManager().getAvailableLocales()) {
            resourcePaths.add(CmsJspTagContainer.getDetailOnlyPageName(sitePath, locale.toString()));
        }
        resourcePaths.add(CmsJspTagContainer.getDetailOnlyPageName(sitePath, null));
        resourcePaths.add(CmsJspTagContainer.getDetailOnlyPageName(sitePath, LOCALE_ALL));
        for (String path : resourcePaths) {
            try {
                CmsResource detailContainers = cms.readResource(path, CmsResourceFilter.IGNORE_EXPIRATION);
                result.add(detailContainers);
            }
            catch (CmsException cmsException) {}
        }
        return result;
    }

    public static I_CmsFormatterBean getFormatterConfigurationForElement(CmsObject cms, CmsContainerElementBean element, CmsADEConfigData adeConfig, String containerName, String containerType, int containerWidth, boolean allowNested) {
        I_CmsFormatterBean formatterBean = null;
        String settingsKey = CmsFormatterConfig.getSettingsKeyForContainer(containerName);
        if (element.getFormatterId() != null && !element.getFormatterId().isNullUUID()) {
            if (!element.getSettings().containsKey(settingsKey) || element.getSettings().get(settingsKey).startsWith("schema_formatter")) {
                for (I_CmsFormatterBean formatter : adeConfig.getFormatters(cms, element.getResource()).getAllMatchingFormatters(containerType, containerWidth, allowNested)) {
                    if (!element.getFormatterId().equals(formatter.getJspStructureId())) continue;
                    String formatterConfigId = formatter.getId();
                    if (formatterConfigId == null) {
                        formatterConfigId = "schema_formatter" + element.getFormatterId().toString();
                    }
                    formatterBean = formatter;
                    break;
                }
            } else {
                String formatterConfigId = element.getSettings().get(settingsKey);
                if (CmsUUID.isValidUUID(formatterConfigId)) {
                    formatterBean = OpenCms.getADEManager().getCachedFormatters(cms.getRequestContext().getCurrentProject().isOnlineProject()).getFormatters().get(new CmsUUID(formatterConfigId));
                }
            }
        } else {
            String formatterConfigId;
            if (element.getSettings().containsKey(settingsKey) && CmsUUID.isValidUUID(formatterConfigId = element.getSettings().get(settingsKey))) {
                formatterBean = OpenCms.getADEManager().getCachedFormatters(cms.getRequestContext().getCurrentProject().isOnlineProject()).getFormatters().get(new CmsUUID(formatterConfigId));
            }
            if (formatterBean == null) {
                formatterBean = adeConfig.getFormatters(cms, element.getResource()).getDefaultFormatter(containerType, containerWidth, allowNested);
            }
        }
        return formatterBean;
    }

    public static List<CmsContainerElementBean> getGroupContainerElements(CmsObject cms, CmsContainerElementBean element, ServletRequest req, String containerType) throws CmsException {
        CmsXmlGroupContainer xmlGroupContainer = CmsXmlGroupContainerFactory.unmarshal(cms, element.getResource(), req);
        CmsGroupContainerBean groupContainer = xmlGroupContainer.getGroupContainer(cms);
        if (!CmsElementUtil.checkGroupAllowed(containerType, groupContainer)) {
            LOG.warn((Object)new CmsIllegalStateException(Messages.get().container("ERR_XSD_NO_TEMPLATE_FORMATTER_3", element.getResource().getRootPath(), OpenCms.getResourceManager().getResourceType(element.getResource()).getTypeName(), containerType)));
            return Collections.emptyList();
        }
        List<CmsContainerElementBean> subElements = groupContainer.getElements();
        return subElements;
    }

    public static List<CmsContainerElementBean> getInheritedContainerElements(CmsObject cms, CmsContainerElementBean element) {
        CmsResource resource = element.getResource();
        return CmsXmlInheritGroupContainerHandler.loadInheritContainerElements(cms, resource);
    }

    public static boolean isDetailContainersPage(CmsObject cms, String detailContainersPage) {
        boolean result = false;
        try {
            String detailName = CmsResource.getName(detailContainersPage);
            String parentFolder = CmsResource.getParentFolder(detailContainersPage);
            if (!parentFolder.endsWith("/.detailContainers/")) {
                parentFolder = CmsResource.getParentFolder(parentFolder);
            }
            detailName = CmsStringUtil.joinPaths(CmsResource.getParentFolder(parentFolder), detailName);
            result = parentFolder.endsWith("/.detailContainers/") && cms.existsResource(detailName, CmsResourceFilter.IGNORE_EXPIRATION);
        }
        catch (Throwable t) {
            LOG.debug((Object)t.getLocalizedMessage(), t);
        }
        return result;
    }

    public static boolean useSingleLocaleDetailContainers(String siteRoot) {
        boolean result = false;
        if (siteRoot != null && OpenCms.getLocaleManager().getLocaleHandler() instanceof CmsSingleTreeLocaleHandler) {
            CmsSite site = OpenCms.getSiteManager().getSiteForSiteRoot(siteRoot);
            result = site != null && CmsSite.LocalizationMode.singleTree.equals((Object)site.getLocalizationMode());
        }
        return result;
    }

    protected static String getTagClose(String tagName) {
        return "</" + tagName + ">";
    }

    protected static String getTagOpen(String tagName, String containerName, String tagClass, boolean nested, boolean online, String containerData) {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append("<").append(tagName).append(" ");
        if (!online || !nested) {
            buffer.append(" id=\"").append(containerName).append("\" ");
        }
        if (containerData != null) {
            buffer.append(" rel=\"").append(containerData).append("\" ");
            String string = tagClass = tagClass == null ? "cms_ade_container" : tagClass + " " + "cms_ade_container";
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(tagClass)) {
            buffer.append("class=\"").append(tagClass).append("\" ");
        }
        buffer.append(">");
        return buffer.toString();
    }

    public int doAfterBody() {
        BodyContent bc = this.getBodyContent();
        if (bc != null) {
            this.m_bodyContent = bc.getString();
            try {
                bc.clear();
            }
            catch (IOException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        ServletRequest req = this.pageContext.getRequest();
        if (CmsFlexController.isCmsRequest(req)) {
            try {
                boolean detailOnly;
                CmsFlexController controller = CmsFlexController.getController(req);
                CmsObject cms = controller.getCmsObject();
                String requestUri = cms.getRequestContext().getUri();
                Locale locale = cms.getRequestContext().getLocale();
                CmsJspStandardContextBean standardContext = CmsJspStandardContextBean.getInstance(req);
                this.m_editableRequest = standardContext.getIsEditMode();
                this.m_parentElement = standardContext.getElement();
                this.m_parentContainer = standardContext.getContainer();
                CmsContainerPageBean containerPage = standardContext.getPage();
                if (containerPage == null) {
                    CmsResource pageResource = (CmsResource)((Object)CmsHistoryResourceHandler.getHistoryResource(req));
                    if (pageResource == null) {
                        pageResource = cms.readResource(requestUri);
                    }
                    CmsXmlContainerPage xmlContainerPage = CmsXmlContainerPageFactory.unmarshal(cms, pageResource, req);
                    CmsModelGroupHelper modelHelper = new CmsModelGroupHelper(cms, OpenCms.getADEManager().lookupConfiguration(cms, cms.getRequestContext().getRootUri()), this.getSessionCache(cms), CmsContainerpageService.isEditingModelGroups(cms, pageResource));
                    containerPage = modelHelper.readModelGroups(xmlContainerPage.getContainerPage(cms));
                    standardContext.setPage(containerPage);
                }
                CmsResource detailContent = standardContext.getDetailContent();
                CmsContainerBean container = null;
                boolean bl = detailOnly = this.m_detailOnly || this.m_parentContainer != null && this.m_parentContainer.isDetailOnly();
                if (detailOnly) {
                    if (detailContent == null) {
                        return 6;
                    }
                    CmsContainerPageBean detailOnlyPage = CmsJspTagContainer.getDetailOnlyPage(cms, req);
                    if (detailOnlyPage != null) {
                        container = detailOnlyPage.getContainers().get(this.getName());
                    }
                } else if (containerPage != null) {
                    container = containerPage.getContainers().get(this.getName());
                }
                int maxElements = this.getMaxElements(requestUri);
                if (container == null) {
                    container = new CmsContainerBean(this.getName(), this.getType(), this.m_parentElement != null ? this.m_parentElement.getInstanceId() : null, this.m_parentContainer == null || this.m_detailOnly && !this.m_parentContainer.isDetailOnly(), maxElements, Collections.emptyList());
                }
                container.setParam(this.getParam());
                container.setDetailOnly(detailOnly);
                boolean isUsedAsDetailView = false;
                if (this.m_detailView && detailContent != null) {
                    isUsedAsDetailView = true;
                }
                String tagName = CmsStringUtil.isEmptyOrWhitespaceOnly(this.getTag()) ? DEFAULT_TAG_NAME : this.getTag();
                this.pageContext.getOut().print(CmsJspTagContainer.getTagOpen(tagName, this.getName(), this.getTagClass(), this.isNested(), !this.m_editableRequest, this.m_editableRequest ? this.getContainerData(cms, maxElements, isUsedAsDetailView, detailOnly) : null));
                standardContext.setContainer(container);
                if (!this.getType().equals(container.getType())) {
                    container.setType(this.getType());
                    LOG.warn((Object)new CmsIllegalStateException(Messages.get().container("LOG_WRONG_CONTAINER_TYPE_4", new Object[]{requestUri, locale, this.getName(), this.getType()})));
                }
                container.setMaxElements(maxElements);
                container.setWidth("" + this.getContainerWidth());
                ArrayList<CmsContainerElementBean> allElements = new ArrayList<CmsContainerElementBean>();
                CmsContainerElementBean detailElement = null;
                if (isUsedAsDetailView) {
                    detailElement = this.generateDetailViewElement(cms, detailContent, container);
                }
                if (detailElement != null) {
                    allElements.add(detailElement);
                } else {
                    allElements.addAll(container.getElements());
                }
                int numRenderedElements = 0;
                for (CmsContainerElementBean elementBean : allElements) {
                    try {
                        boolean rendered = this.renderContainerElement((HttpServletRequest)req, cms, standardContext, elementBean, locale, numRenderedElements >= maxElements);
                        if (!rendered) continue;
                        ++numRenderedElements;
                    }
                    catch (Exception e) {
                        if (!LOG.isErrorEnabled()) continue;
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                if (numRenderedElements == 0 && this.m_bodyContent != null && CmsJspTagEditable.isEditableRequest(req)) {
                    this.pageContext.getOut().print(this.m_bodyContent);
                }
                this.pageContext.getOut().print(CmsJspTagContainer.getTagClose(tagName));
            }
            catch (Exception ex) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_PROCESS_TAG_1", "container"), (Throwable)ex);
                }
                throw new JspException((Throwable)ex);
            }
        }
        this.m_type = null;
        this.m_name = null;
        this.m_param = null;
        this.m_maxElements = null;
        this.m_tag = null;
        this.m_tagClass = null;
        this.m_detailView = false;
        this.m_detailOnly = false;
        this.m_width = null;
        this.m_editableBy = null;
        this.m_bodyContent = null;
        CmsJspStandardContextBean.getInstance(this.pageContext.getRequest()).setElement(this.m_parentElement);
        CmsJspStandardContextBean.getInstance(this.pageContext.getRequest()).setContainer(this.m_parentContainer);
        this.m_parentElement = null;
        this.m_parentContainer = null;
        return super.doEndTag();
    }

    public int doStartTag() {
        return 2;
    }

    public String getDetailview() {
        return String.valueOf(this.m_detailView);
    }

    public String getEditableby() {
        return this.m_editableBy;
    }

    public String getMaxElements() {
        return CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_maxElements) ? DEFAULT_MAX_ELEMENTS : this.m_maxElements;
    }

    public String getName() {
        if (this.isNested()) {
            return (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_namePrefix) ? this.m_parentElement.getInstanceId() : this.m_namePrefix) + "-" + this.m_name;
        }
        return this.m_name;
    }

    public String getNameprefix() {
        return this.m_namePrefix;
    }

    public String getParam() {
        return this.m_param;
    }

    public String getTag() {
        return this.m_tag;
    }

    public String getTagClass() {
        return this.m_tagClass;
    }

    public String getType() {
        return CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_type) ? this.getName() : this.m_type;
    }

    public String getWidth() {
        return this.m_width;
    }

    public void setDetailonly(String detailOnly) {
        this.m_detailOnly = Boolean.parseBoolean(detailOnly);
    }

    public void setDetailview(String detailView) {
        this.m_detailView = Boolean.parseBoolean(detailView);
    }

    public void setEditableby(String editableBy) {
        this.m_editableBy = editableBy;
    }

    public void setMaxElements(String maxElements) {
        this.m_maxElements = maxElements;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setNameprefix(String namePrefix) {
        this.m_namePrefix = namePrefix;
    }

    public void setParam(String param) {
        this.m_param = param;
    }

    public void setTag(String tag) {
        this.m_tag = tag;
    }

    public void setTagClass(String tagClass) {
        this.m_tagClass = tagClass;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public void setWidth(String width) {
        this.m_width = width;
    }

    protected String getContainerData(CmsObject cms, int maxElements, boolean isDetailView, boolean isDetailOnly) {
        int width = -1;
        try {
            if (this.getWidth() != null) {
                width = Integer.parseInt(this.getWidth());
            }
        }
        catch (NumberFormatException e) {
            LOG.debug((Object)"Error parsing container width.", (Throwable)e);
        }
        CmsContainer cont = new CmsContainer(this.getName(), this.getType(), this.m_bodyContent, width, maxElements, isDetailView, this.isEditable(cms), null, this.m_parentContainer != null ? this.m_parentContainer.getName() : null, this.m_parentElement != null ? this.m_parentElement.getInstanceId() : null);
        cont.setDeatilOnly(isDetailOnly);
        String result = "";
        try {
            result = CmsContainerpageService.getSerializedContainerInfo(cont);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return result;
    }

    protected boolean isEditable(CmsObject cms) {
        boolean result = false;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_editableBy)) {
            String[] principals = this.m_editableBy.split(",");
            List<Object> groups = null;
            for (int i = 0; i < principals.length; ++i) {
                block20: {
                    String key = principals[i];
                    String principal = key.substring(key.indexOf(46) + 1, key.length());
                    if (CmsGroup.hasPrefix(key)) {
                        principal = OpenCms.getImportExportManager().translateGroup(principal);
                        try {
                            CmsGroup group = cms.readGroup(principal);
                            if (groups == null) {
                                try {
                                    groups = cms.getGroupsOfUser(cms.getRequestContext().getCurrentUser().getName(), false);
                                }
                                catch (Exception ex) {
                                    if (LOG.isErrorEnabled()) {
                                        LOG.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
                                    }
                                    groups = Collections.emptyList();
                                }
                            }
                            result = groups.contains(group);
                        }
                        catch (CmsException e) {
                            if (LOG.isErrorEnabled()) {
                                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                            }
                            break block20;
                        }
                    }
                    if (CmsUser.hasPrefix(key)) {
                        principal = OpenCms.getImportExportManager().translateUser(principal);
                        try {
                            result = cms.getRequestContext().getCurrentUser().equals(cms.readUser(principal));
                        }
                        catch (CmsException e) {
                            if (LOG.isErrorEnabled()) {
                                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                            }
                        }
                    } else if (CmsRole.hasPrefix(key)) {
                        CmsRole role = CmsRole.valueOfRoleName(principal);
                        if (role == null) {
                            role = CmsRole.valueOfGroupName(principal);
                        }
                        if (role != null) {
                            result = OpenCms.getRoleManager().hasRole(cms, role.forOrgUnit(cms.getRequestContext().getCurrentUser().getOuFqn()));
                        }
                    }
                }
                if (!result) {
                    continue;
                }
                break;
            }
        } else {
            result = OpenCms.getRoleManager().hasRole(cms, CmsRole.ELEMENT_AUTHOR);
        }
        return result;
    }

    protected boolean isNested() {
        return this.m_parentContainer != null && this.m_parentElement != null;
    }

    protected void printElementWrapperTagEnd(boolean isGroupcontainer) throws IOException {
        if (this.m_editableRequest) {
            String result = isGroupcontainer ? "</div>" : "<div class=\"cms_ade_element_end\" style=\"display:none\"></div>";
            this.pageContext.getOut().print(result);
        }
    }

    protected void printElementWrapperTagStart(CmsObject cms, CmsContainerElementBean elementBean, CmsContainerPageBean page, boolean isGroupContainer) throws Exception {
        if (this.m_editableRequest) {
            StringBuffer result = new StringBuffer("<div class='");
            if (isGroupContainer) {
                result.append("cms_ade_groupcontainer");
            } else {
                result.append("cms_ade_element_start");
            }
            String serializedElement = this.getElementInfo(cms, elementBean, page);
            result.append("'");
            result.append(" rel='").append(serializedElement);
            if (isGroupContainer) {
                result.append("'>");
            } else {
                result.append("' style='display:none;'></div>");
            }
            this.pageContext.getOut().print((Object)result);
        }
    }

    private CmsContainerElementBean generateDetailViewElement(CmsObject cms, CmsResource detailContent, CmsContainerBean container) {
        CmsADEConfigData config;
        CmsFormatterConfiguration formatters;
        I_CmsFormatterBean formatter;
        CmsContainerElementBean element = null;
        if (detailContent != null && (formatter = (formatters = (config = OpenCms.getADEManager().lookupConfiguration(cms, cms.getRequestContext().getRootUri())).getFormatters(cms, detailContent)).getDetailFormatter(this.getType(), this.getContainerWidth())) != null) {
            HashMap<String, String> settings = new HashMap<String, String>();
            if (!container.getElements().isEmpty()) {
                CmsContainerElementBean el = container.getElements().get(0);
                try {
                    el.initResource(cms);
                    if (el.getResource().getTypeId() == detailContent.getTypeId()) {
                        settings.putAll(el.getIndividualSettings());
                    }
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            settings.put("element_instance_id", detailContent.getStructureId().toString());
            element = new CmsContainerElementBean(detailContent.getStructureId(), formatter.getJspStructureId(), settings, false);
        }
        return element;
    }

    private int getContainerWidth() {
        int containerWidth = -1;
        try {
            containerWidth = Integer.parseInt(this.m_width);
        }
        catch (NumberFormatException e) {
            LOG.debug((Object)"Error parsing container width.", (Throwable)e);
        }
        return containerWidth;
    }

    private String getElementInfo(CmsObject cms, CmsContainerElementBean elementBean, CmsContainerPageBean page) throws Exception {
        return CmsContainerpageService.getSerializedElementInfo(cms, (HttpServletRequest)this.pageContext.getRequest(), (HttpServletResponse)this.pageContext.getResponse(), elementBean, page);
    }

    private int getMaxElements(String requestUri) {
        String containerMaxElements = this.getMaxElements();
        int maxElements = -1;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(containerMaxElements)) {
            try {
                maxElements = Integer.parseInt(containerMaxElements);
            }
            catch (NumberFormatException e) {
                throw new CmsIllegalStateException(Messages.get().container("LOG_WRONG_CONTAINER_MAXELEMENTS_3", new Object[]{requestUri, this.getName(), containerMaxElements}), (Throwable)e);
            }
        } else if (LOG.isWarnEnabled()) {
            LOG.warn((Object)Messages.get().getBundle().key("LOG_MAXELEMENTS_NOT_SET_2", new Object[]{this.getName(), requestUri}));
        }
        return maxElements;
    }

    private CmsADESessionCache getSessionCache(CmsObject cms) {
        return this.m_editableRequest ? CmsADESessionCache.getCache((HttpServletRequest)this.pageContext.getRequest(), cms) : null;
    }

    private void printElementErrorTag(String elementSitePath, String formatterSitePath, Exception exception) throws IOException {
        if (this.m_editableRequest) {
            String stacktrace = CmsException.getStackTraceAsString(exception);
            stacktrace = CmsStringUtil.isEmptyOrWhitespaceOnly(stacktrace) ? null : CmsEncoder.escapeXml(stacktrace);
            StringBuffer errorBox = new StringBuffer(256);
            errorBox.append("<div style=\"display:block; padding: 5px; border: red solid 2px; color: black; background: white;\" class=\"");
            errorBox.append("cms_ade_element_error");
            errorBox.append("\">");
            errorBox.append(Messages.get().getBundle().key("ERR_CONTAINER_PAGE_ELEMENT_RENDER_ERROR_2", elementSitePath, formatterSitePath));
            errorBox.append("<br />");
            errorBox.append(exception.getLocalizedMessage());
            if (stacktrace != null) {
                errorBox.append("<span onclick=\"opencms.openStacktraceDialog(event);\" style=\"border: 1px solid black; cursor: pointer;\">");
                errorBox.append(Messages.get().getBundle().key("GUI_LABEL_STACKTRACE_0"));
                String title = Messages.get().getBundle().key("ERR_CONTAINER_PAGE_ELEMENT_RENDER_ERROR_2", elementSitePath, formatterSitePath);
                errorBox.append("<span title=\"");
                errorBox.append(CmsEncoder.escapeXml(title));
                errorBox.append("\" class=\"hiddenStacktrace\" style=\"display:none;\">");
                errorBox.append(stacktrace);
                errorBox.append("</span></span>");
            }
            errorBox.append("</div>");
            this.pageContext.getOut().print(errorBox.toString());
        }
    }

    private boolean renderContainerElement(HttpServletRequest request, CmsObject cms, CmsJspStandardContextBean standardContext, CmsContainerElementBean element, Locale locale, boolean alreadyFull) throws Exception {
        String rpcContextOverride;
        CmsTemplateContext context = (CmsTemplateContext)request.getAttribute("templateContext");
        if (context == null && alreadyFull) {
            return false;
        }
        String contextKey = null;
        contextKey = context != null ? context.getKey() : (rpcContextOverride = (String)request.getAttribute("ATTR_RPC_CONTEXT_OVERRIDE"));
        boolean showInContext = this.shouldShowInContext(element, context != null ? context.getKey() : null);
        boolean isOnline = cms.getRequestContext().getCurrentProject().isOnlineProject();
        if (!this.m_editableRequest && !showInContext) {
            return false;
        }
        element.initResource(cms);
        if (!this.m_editableRequest && !element.isReleasedAndNotExpired()) {
            return false;
        }
        ServletRequest req = this.pageContext.getRequest();
        ServletResponse res = this.pageContext.getResponse();
        String containerType = this.getType();
        int containerWidth = this.getContainerWidth();
        CmsADEConfigData adeConfig = OpenCms.getADEManager().lookupConfiguration(cms, cms.getRequestContext().getRootUri());
        boolean isGroupContainer = element.isGroupContainer(cms);
        boolean isInheritedContainer = element.isInheritedContainer(cms);
        I_CmsFormatterBean formatterConfig = null;
        if (!isGroupContainer && !isInheritedContainer) {
            formatterConfig = CmsJspTagContainer.ensureValidFormatterSettings(cms, element, adeConfig, this.getName(), containerType, containerWidth, true);
            element.initSettings(cms, formatterConfig);
        }
        if (this.m_editableRequest) {
            this.getSessionCache(cms).setCacheContainerElement(element.editorHash(), element);
        }
        if (isGroupContainer || isInheritedContainer) {
            if (alreadyFull) {
                return false;
            }
            List<CmsContainerElementBean> subElements = isGroupContainer ? CmsJspTagContainer.getGroupContainerElements(cms, element, req, containerType) : CmsJspTagContainer.getInheritedContainerElements(cms, element);
            this.printElementWrapperTagStart(cms, element, standardContext.getPage(), true);
            for (CmsContainerElementBean subelement : subElements) {
                try {
                    subelement.initResource(cms);
                    boolean shouldShowSubElementInContext = this.shouldShowInContext(subelement, contextKey);
                    if (!this.m_editableRequest && (!shouldShowSubElementInContext || !subelement.isReleasedAndNotExpired())) continue;
                    I_CmsFormatterBean subElementFormatterConfig = CmsJspTagContainer.ensureValidFormatterSettings(cms, subelement, adeConfig, this.getName(), containerType, containerWidth, false);
                    subelement.initSettings(cms, subElementFormatterConfig);
                    if (this.m_editableRequest) {
                        this.getSessionCache(cms).setCacheContainerElement(subelement.editorHash(), subelement);
                    }
                    if (subElementFormatterConfig == null) {
                        if (!LOG.isErrorEnabled()) continue;
                        LOG.error((Object)new CmsIllegalStateException(Messages.get().container("ERR_XSD_NO_TEMPLATE_FORMATTER_3", subelement.getSitePath(), OpenCms.getResourceManager().getResourceType(subelement.getResource()).getTypeName(), containerType)));
                        continue;
                    }
                    this.printElementWrapperTagStart(cms, subelement, standardContext.getPage(), false);
                    standardContext.setElement(subelement);
                    try {
                        String formatterSitePath;
                        try {
                            CmsResource formatterResource = cms.readResource(subElementFormatterConfig.getJspStructureId());
                            formatterSitePath = cms.getSitePath(formatterResource);
                        }
                        catch (CmsVfsResourceNotFoundException ex) {
                            LOG.debug((Object)"Formatter JSP not found by id, try using path.", (Throwable)ex);
                            formatterSitePath = cms.getRequestContext().removeSiteRoot(subElementFormatterConfig.getJspRootPath());
                        }
                        if (shouldShowSubElementInContext) {
                            CmsJspTagInclude.includeTagAction(this.pageContext, formatterSitePath, null, locale, false, isOnline, null, CmsRequestUtil.getAtrributeMap(req), req, res);
                        } else {
                            this.pageContext.getOut().print(DUMMY_ELEMENT);
                        }
                    }
                    catch (Exception e) {
                        if (LOG.isErrorEnabled()) {
                            LOG.error((Object)Messages.get().getBundle().key("ERR_CONTAINER_PAGE_ELEMENT_RENDER_ERROR_2", subelement.getSitePath(), subElementFormatterConfig), (Throwable)e);
                        }
                        this.printElementErrorTag(subelement.getSitePath(), subElementFormatterConfig.getJspRootPath(), e);
                    }
                    this.printElementWrapperTagEnd(false);
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error((Object)e);
                }
            }
            this.printElementWrapperTagEnd(true);
            return true;
        }
        boolean result = true;
        if (alreadyFull) {
            result = false;
            if (!showInContext) {
                this.printElementWrapperTagStart(cms, element, standardContext.getPage(), false);
                this.pageContext.getOut().print(DUMMY_ELEMENT);
                this.printElementWrapperTagEnd(false);
            }
        } else {
            String formatter = null;
            try {
                if (formatterConfig != null) {
                    try {
                        CmsResource formatterResource = cms.readResource(formatterConfig.getJspStructureId());
                        formatter = cms.getSitePath(formatterResource);
                    }
                    catch (CmsVfsResourceNotFoundException ex) {
                        LOG.debug((Object)"Formatter JSP not found by id, try using path.", (Throwable)ex);
                        if (cms.existsResource(cms.getRequestContext().removeSiteRoot(formatterConfig.getJspRootPath()))) {
                            formatter = cms.getRequestContext().removeSiteRoot(formatterConfig.getJspRootPath());
                        }
                    }
                } else {
                    formatter = cms.getSitePath(cms.readResource(element.getFormatterId()));
                }
            }
            catch (CmsException e) {
                LOG.debug((Object)"Formatter resource can not be found, try reading it from the configuration.", (Throwable)e);
                CmsFormatterConfiguration elementFormatters = adeConfig.getFormatters(cms, element.getResource());
                I_CmsFormatterBean elementFormatterBean = elementFormatters.getDefaultFormatter(containerType, containerWidth, true);
                if (elementFormatterBean == null) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)new CmsIllegalStateException(Messages.get().container("ERR_XSD_NO_TEMPLATE_FORMATTER_3", element.getSitePath(), OpenCms.getResourceManager().getResourceType(element.getResource()).getTypeName(), containerType)));
                    }
                    return false;
                }
                try {
                    CmsResource formatterResource = cms.readResource(elementFormatterBean.getJspStructureId());
                    formatter = cms.getSitePath(formatterResource);
                }
                catch (CmsVfsResourceNotFoundException ex) {
                    LOG.debug((Object)"Formatter JSP not found by id, try using path.", (Throwable)ex);
                    formatter = cms.getRequestContext().removeSiteRoot(elementFormatterBean.getJspRootPath());
                }
            }
            this.printElementWrapperTagStart(cms, element, standardContext.getPage(), false);
            standardContext.setElement(element);
            try {
                if (!showInContext) {
                    this.pageContext.getOut().print(DUMMY_ELEMENT);
                    result = false;
                } else {
                    CmsJspTagInclude.includeTagAction(this.pageContext, formatter, null, locale, false, isOnline, null, CmsRequestUtil.getAtrributeMap(req), req, res);
                }
            }
            catch (Exception e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_CONTAINER_PAGE_ELEMENT_RENDER_ERROR_2", element.getSitePath(), formatter), (Throwable)e);
                }
                this.printElementErrorTag(element.getSitePath(), formatter, e);
            }
            this.printElementWrapperTagEnd(false);
        }
        return result;
    }

    private boolean shouldShowInContext(CmsContainerElementBean element, String contextKey) {
        if (contextKey == null) {
            return true;
        }
        try {
            if (element.getResource() != null && !OpenCms.getTemplateContextManager().shouldShowType(contextKey, OpenCms.getResourceManager().getResourceType(element.getResource().getTypeId()).getTypeName())) {
                return false;
            }
        }
        catch (CmsLoaderException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        Map<String, String> settings = element.getSettings();
        if (settings == null) {
            return true;
        }
        String contextsAllowed = settings.get("templateContexts");
        if (contextsAllowed == null) {
            return true;
        }
        if (contextsAllowed.equals("none")) {
            return false;
        }
        List<String> contextsAllowedList = CmsStringUtil.splitAsList(contextsAllowed, "|");
        return contextsAllowedList.contains(contextKey);
    }
}

