/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.flex.CmsFlexController;
import org.opencms.jsp.CmsJspImageScalerTagSupport;
import org.opencms.jsp.Messages;
import org.opencms.jsp.util.CmsJspImageBean;
import org.opencms.jsp.util.CmsJspScaledImageBean;
import org.opencms.loader.CmsImageScaler;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.staticexport.CmsLinkManager;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsUriSplitter;

public class CmsJspTagScaleImage
extends CmsJspImageScalerTagSupport {
    private static final Log LOG = CmsLog.getLog(CmsJspTagScaleImage.class);
    private static final long serialVersionUID = -6639978110802734737L;
    private List<String> m_hiDpiVariantList;
    private String m_var;

    public int doEndTag() throws JspException {
        this.release();
        return 6;
    }

    public int doStartTag() throws JspException {
        if (this.m_scaler.getWidth() <= 0 && this.m_scaler.getHeight() <= 0) {
            throw new JspException("At least one of the attributes width or height has to be set");
        }
        ServletRequest req = this.pageContext.getRequest();
        if (CmsFlexController.isCmsRequest(req)) {
            try {
                CmsJspScaledImageBean scaledImage;
                block7: {
                    scaledImage = null;
                    try {
                        scaledImage = this.imageTagAction();
                    }
                    catch (CmsException e) {
                        if (!LOG.isWarnEnabled()) break block7;
                        LOG.warn((Object)Messages.get().getBundle().key("ERR_IMAGE_TAG_VFS_ACCESS_1", this.m_src), (Throwable)e);
                    }
                }
                this.pageContext.getRequest().setAttribute(this.m_var, (Object)scaledImage);
            }
            catch (Exception ex) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_PROCESS_TAG_1", "scaleImage"), (Throwable)ex);
                }
                return 0;
            }
        }
        return 1;
    }

    @Override
    public void release() {
        this.m_hiDpiVariantList = null;
        this.m_var = null;
        super.release();
    }

    public void setHiDpiVariants(String value) {
        this.m_hiDpiVariantList = new ArrayList<String>(4);
        String[] multipliers = StringUtils.split((String)value, (char)',');
        Collections.addAll(this.m_hiDpiVariantList, multipliers);
    }

    public void setVar(String value) {
        this.m_var = value;
    }

    private void handleHiDpiVariants(CmsObject cms, CmsResource imageRes, CmsImageScaler scaler, CmsJspScaledImageBean scaledImage, CmsImageScaler originalScaler) {
        int targetWidth = this.m_scaler.getWidth();
        int targetHeight = this.m_scaler.getHeight();
        int originalWidth = originalScaler.getWidth();
        int originalHeight = originalScaler.getHeight();
        for (String multiplierString : this.m_hiDpiVariantList) {
            if (!multiplierString.matches("^[0-9]+(.[0-9]+)?x$")) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)String.format("Illegal multiplier format: %s not usable for image scaling", multiplierString));
                continue;
            }
            float multiplier = NumberUtils.createFloat((String)multiplierString.substring(0, multiplierString.length() - 1)).floatValue();
            int width = Math.round((float)targetWidth * multiplier);
            int height = Math.round((float)targetHeight * multiplier);
            if (originalWidth < width || originalHeight < height) continue;
            CmsImageScaler hiDpiScaler = (CmsImageScaler)scaler.clone();
            hiDpiScaler.setWidth(width);
            hiDpiScaler.setHeight(height);
            String imageSrc = cms.getSitePath(imageRes);
            if (hiDpiScaler.isValid()) {
                imageSrc = imageSrc + hiDpiScaler.toRequestParam();
            }
            CmsJspImageBean image = new CmsJspImageBean();
            image.setSrcUrl(OpenCms.getLinkManager().substituteLink(cms, imageSrc));
            image.setWidth(width);
            image.setHeight(height);
            image.setScaler(hiDpiScaler);
            scaledImage.addHiDpiImage(multiplierString, image);
        }
    }

    private CmsJspScaledImageBean imageTagAction() throws CmsException {
        String[] scaleStr;
        ServletRequest request = this.pageContext.getRequest();
        CmsFlexController controller = CmsFlexController.getController(request);
        CmsObject cms = controller.getCmsObject();
        String src = CmsLinkManager.getAbsoluteUri(this.m_src, controller.getCurrentRequest().getElementUri());
        CmsUriSplitter splitSrc = new CmsUriSplitter(src);
        String scaleParam = null;
        if (splitSrc.getQuery() != null && (scaleStr = CmsRequestUtil.createParameterMap(splitSrc.getQuery()).get("__scale")) != null) {
            scaleParam = scaleStr[0];
        }
        CmsResource imageRes = cms.readResource(splitSrc.getPrefix());
        CmsImageScaler originalScaler = new CmsImageScaler(cms, imageRes);
        this.initScaler(originalScaler, scaleParam);
        String imageSrc = cms.getSitePath(imageRes);
        if (this.m_scaler.isValid()) {
            imageSrc = imageSrc + this.m_scaler.toRequestParam();
        }
        CmsJspScaledImageBean scaledImage = new CmsJspScaledImageBean();
        scaledImage.setSrcUrl(OpenCms.getLinkManager().substituteLink(cms, imageSrc));
        scaledImage.setWidth(this.m_scaler.getWidth());
        scaledImage.setHeight(this.m_scaler.getHeight());
        scaledImage.setScaler(this.m_scaler);
        if (this.m_hiDpiVariantList != null && this.m_hiDpiVariantList.size() > 0) {
            this.handleHiDpiVariants(cms, imageRes, this.m_scaler, scaledImage, originalScaler);
        }
        return scaledImage;
    }

    private void initScaler(CmsImageScaler originalScaler, String scaleParams) {
        int m_width = this.m_scaler.getWidth();
        int m_height = this.m_scaler.getHeight();
        if (scaleParams != null && !"undefined".equals(scaleParams)) {
            CmsImageScaler cropScaler = null;
            cropScaler = new CmsImageScaler(scaleParams);
            if (this.m_scaler.getType() == 5) {
                cropScaler.setWidth(cropScaler.getCropWidth());
                cropScaler.setHeight(cropScaler.getCropHeight());
            }
            this.m_scaler = cropScaler.getCropScaler(this.m_scaler);
            m_width = this.m_scaler.getWidth();
            m_height = this.m_scaler.getHeight();
        }
        if (m_width <= 0 || m_height <= 0) {
            float ratio = !this.m_scaler.isCropping() ? (float)originalScaler.getWidth() / (float)originalScaler.getHeight() : (float)this.m_scaler.getCropWidth() / (float)this.m_scaler.getCropHeight();
            if (m_width <= 0) {
                m_width = Math.round((float)m_height * ratio);
                this.m_scaler.setWidth(m_width);
            } else if (m_height <= 0) {
                m_height = Math.round((float)m_width / ratio);
                this.m_scaler.setHeight(m_height);
            }
        }
        if ((this.m_scaler.getHeight() <= 0 || this.m_scaler.getWidth() <= 0 || this.m_scaler.getType() == 5 && this.m_scaler.isValid() && !this.m_scaler.isCropping()) && originalScaler.isValid()) {
            this.m_scaler = originalScaler.getReScaler(this.m_scaler);
        }
    }
}

