/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.flex.CmsFlexController;
import org.opencms.ugc.CmsUgcSession;
import org.opencms.ugc.CmsUgcSessionFactory;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsJspTagUgc
extends TagSupport {
    private static final long serialVersionUID = 7290192201848437667L;
    public static final String DEFAULT_ERROR_MESSAGE_ATTR = "formError";
    public static final String DEFAULT_SESSION_ID_ATTR = "formSessionId";
    private String m_configPath;
    private String m_editId;
    private String m_editName;
    private String m_error;
    private String m_var;

    public int doEndTag() throws JspException {
        this.m_configPath = null;
        this.m_editId = null;
        this.m_editName = null;
        this.m_error = null;
        this.m_var = null;
        return super.doEndTag();
    }

    public int doStartTag() throws JspException {
        HttpServletRequest req = (HttpServletRequest)this.pageContext.getRequest();
        CmsFlexController controller = CmsFlexController.getController((ServletRequest)req);
        if (controller != null) {
            CmsObject cms = controller.getCmsObject();
            try {
                CmsUgcSession ugcsession = null;
                if (this.m_editName == null && this.m_editId != null) {
                    CmsResource res = cms.readResource(new CmsUUID(this.m_editId));
                    this.m_editName = res.getName();
                }
                if (this.m_editName != null) {
                    ugcsession = CmsUgcSessionFactory.getInstance().createSessionForFile(cms, req, this.m_configPath, this.m_editName);
                } else {
                    ugcsession = CmsUgcSessionFactory.getInstance().createSession(cms, req, this.m_configPath);
                    ugcsession.createXmlContent();
                }
                this.pageContext.setAttribute(this.m_var == null ? DEFAULT_SESSION_ID_ATTR : this.m_var, (Object)ugcsession.getId().toString());
            }
            catch (Exception e) {
                this.pageContext.setAttribute(this.m_error == null ? DEFAULT_ERROR_MESSAGE_ATTR : this.m_error, (Object)e.getLocalizedMessage());
            }
        }
        return super.doStartTag();
    }

    public String getConfigPath() {
        return this.m_configPath;
    }

    public String getEditId() {
        return this.m_editId;
    }

    public String getEditName() {
        return this.m_editName;
    }

    public String getError() {
        return this.m_error;
    }

    public String getVar() {
        return this.m_var;
    }

    public void setConfigPath(String configPath) {
        this.m_configPath = CmsStringUtil.isEmptyOrWhitespaceOnly(configPath) ? null : configPath;
    }

    public void setEditId(String editId) {
        this.m_editId = CmsStringUtil.isEmptyOrWhitespaceOnly(editId) ? null : editId;
    }

    public void setEditName(String editName) {
        this.m_editName = CmsStringUtil.isEmptyOrWhitespaceOnly(editName) ? null : editName;
    }

    public void setError(String error) {
        this.m_error = CmsStringUtil.isEmptyOrWhitespaceOnly(error) ? null : error;
    }

    public void setVar(String var) {
        this.m_var = CmsStringUtil.isEmptyOrWhitespaceOnly(var) ? null : var;
    }
}

