/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.search.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationFacet;

public class CmsSearchConfigurationFacet
implements I_CmsSearchConfigurationFacet {
    protected Integer m_minCount;
    protected String m_name;
    protected String m_label;
    protected List<String> m_preselection;
    protected boolean m_isAndFacet;
    protected boolean m_ignoreFacetFilters;
    protected String m_ignoreTags;

    public CmsSearchConfigurationFacet(Integer minCount, String label, String name, Boolean isAndFacet, List<String> preselection, Boolean ignoreFiltersFromFacets) {
        this.m_minCount = minCount;
        String string = this.m_label = label == null ? name : label;
        if (isAndFacet != null) {
            this.m_isAndFacet = isAndFacet;
        }
        this.m_name = name;
        this.m_preselection = preselection == null ? new ArrayList() : preselection;
        this.m_ignoreFacetFilters = ignoreFiltersFromFacets == null ? false : ignoreFiltersFromFacets;
        this.m_ignoreTags = this.getName();
    }

    @Override
    public boolean getIgnoreAllFacetFilters() {
        return this.m_ignoreFacetFilters;
    }

    @Override
    public String getIgnoreMaxParamKey() {
        return this.getParamKey() + "_ignoremax";
    }

    @Override
    public String getIgnoreTags() {
        return this.m_ignoreTags;
    }

    @Override
    public boolean getIsAndFacet() {
        return this.m_isAndFacet;
    }

    @Override
    public String getLabel() {
        return this.m_label;
    }

    @Override
    public Integer getMinCount() {
        return this.m_minCount;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getParamKey() {
        return "facet_" + this.getName();
    }

    @Override
    public List<String> getPreSelection() {
        return this.m_preselection;
    }

    @Override
    public void propagateAllFacetNames(Collection<String> names) {
        if (this.m_ignoreFacetFilters) {
            this.m_ignoreTags = StringUtils.join(names, (char)',') + ",q";
        }
    }
}

