/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.search.config.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.jsp.search.config.CmsSearchConfigurationCommon;
import org.opencms.jsp.search.config.CmsSearchConfigurationDidYouMean;
import org.opencms.jsp.search.config.CmsSearchConfigurationFacetField;
import org.opencms.jsp.search.config.CmsSearchConfigurationFacetQuery;
import org.opencms.jsp.search.config.CmsSearchConfigurationFacetRange;
import org.opencms.jsp.search.config.CmsSearchConfigurationHighlighting;
import org.opencms.jsp.search.config.CmsSearchConfigurationPagination;
import org.opencms.jsp.search.config.CmsSearchConfigurationSortOption;
import org.opencms.jsp.search.config.CmsSearchConfigurationSorting;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationCommon;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationDidYouMean;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationFacet;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationFacetField;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationFacetQuery;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationFacetRange;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationHighlighting;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationPagination;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationSortOption;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationSorting;
import org.opencms.jsp.search.config.parser.I_CmsSearchConfigurationParser;
import org.opencms.jsp.search.config.parser.Messages;
import org.opencms.main.CmsLog;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentValueSequence;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsXMLSearchConfigurationParser
implements I_CmsSearchConfigurationParser {
    protected static final Log LOG = CmsLog.getLog(CmsXMLSearchConfigurationParser.class);
    private static final String XML_ELEMENT_QUERYPARAM = "QueryParam";
    private static final String XML_ELEMENT_LAST_QUERYPARAM = "LastQueryParam";
    private static final String XML_ELEMENT_ESCAPE_QUERY_CHARACTERS = "EscapeQueryCharacters";
    private static final String XML_ELEMENT_RELOADED_PARAM = "ReloadedParam";
    private static final String XML_ELEMENT_SEARCH_FOR_EMPTY_QUERY = "SearchForEmptyQuery";
    private static final String XML_ELEMENT_IGNORE_QUERY = "IgnoreQuery";
    private static final String XML_ELEMENT_IGNORE_RELEASE_DATE = "IgnoreReleaseDate";
    private static final String XML_ELEMENT_IGNORE_EXPIRATION_DATE = "IgnoreExpirationDate";
    private static final String XML_ELEMENT_QUERY_MODIFIER = "QueryModifier";
    private static final String XML_ELEMENT_PAGEPARAM = "PageParam";
    private static final String XML_ELEMENT_INDEX = "Index";
    private static final String XML_ELEMENT_CORE = "Core";
    private static final String XML_ELEMENT_EXTRASOLRPARAMS = "ExtraSolrParams";
    private static final String XML_ELEMENT_ADDITIONAL_PARAMETERS = "AdditionalRequestParams";
    private static final String XML_ELEMENT_ADDITIONAL_PARAMETERS_PARAM = "Param";
    private static final String XML_ELEMENT_ADDITIONAL_PARAMETERS_SOLRQUERY = "SolrQuery";
    private static final String XML_ELEMENT_PAGESIZE = "PageSize";
    private static final String XML_ELEMENT_PAGENAVLENGTH = "PageNavLength";
    private static final String XML_ELEMENT_FIELD_FACETS = "FieldFacet";
    private static final String XML_ELEMENT_QUERY_FACET = "QueryFacet";
    private static final String XML_ELEMENT_FACET_LIMIT = "Limit";
    private static final String XML_ELEMENT_FACET_MINCOUNT = "MinCount";
    private static final String XML_ELEMENT_FACET_LABEL = "Label";
    private static final String XML_ELEMENT_FACET_FIELD = "Field";
    private static final String XML_ELEMENT_FACET_NAME = "Name";
    private static final String XML_ELEMENT_FACET_PREFIX = "Prefix";
    private static final String XML_ELEMENT_FACET_ORDER = "Order";
    private static final String XML_ELEMENT_FACET_FILTERQUERYMODIFIER = "FilterQueryModifier";
    private static final String XML_ELEMENT_FACET_ISANDFACET = "IsAndFacet";
    private static final String XML_ELEMENT_FACET_PRESELECTION = "PreSelection";
    private static final String XML_ELEMENT_FACET_IGNOREALLFACETFILTERS = "IgnoreAllFacetFilters";
    private static final String XML_ELEMENT_QUERY_FACET_QUERY = "QueryItem";
    private static final String XML_ELEMENT_QUERY_FACET_QUERY_QUERY = "Query";
    private static final String XML_ELEMENT_QUERY_FACET_QUERY_LABEL = "Label";
    private static final String XML_ELEMENT_SORTPARAM = "SortParam";
    private static final String XML_ELEMENT_SORTOPTIONS = "SortOption";
    private static final String XML_ELEMENT_SORTOPTION_LABEL = "Label";
    private static final String XML_ELEMENT_SORTOPTION_PARAMVALUE = "ParamValue";
    private static final String XML_ELEMENT_SORTOPTION_SOLRVALUE = "SolrValue";
    private static final String XML_ELEMENT_HIGHLIGHTER = "Highlighting";
    private static final String XML_ELEMENT_HIGHLIGHTER_FIELD = "Field";
    private static final String XML_ELEMENT_HIGHLIGHTER_SNIPPETS = "Snippets";
    private static final String XML_ELEMENT_HIGHLIGHTER_FRAGSIZE = "FragSize";
    private static final String XML_ELEMENT_HIGHLIGHTER_ALTERNATE_FIELD = "AlternateField";
    private static final String XML_ELEMENT_HIGHLIGHTER_MAX_LENGTH_ALTERNATE_FIELD = "MaxAlternateFieldLength";
    private static final String XML_ELEMENT_HIGHLIGHTER_SIMPLE_PRE = "SimplePre";
    private static final String XML_ELEMENT_HIGHLIGHTER_SIMPLE_POST = "SimplePost";
    private static final String XML_ELEMENT_HIGHLIGHTER_FORMATTER = "Formatter";
    private static final String XML_ELEMENT_HIGHLIGHTER_FRAGMENTER = "Fragmenter";
    private static final String XML_ELEMENT_HIGHLIGHTER_FASTVECTORHIGHLIGHTING = "UseFastVectorHighlighting";
    private static final String XML_ELEMENT_DIDYOUMEAN = "DidYouMean";
    private static final String XML_ELEMENT_DIDYOUMEAN_QUERYPARAM = "QueryParam";
    private static final String XML_ELEMENT_DIDYOUMEAN_COLLATE = "Collate";
    private static final String XML_ELEMENT_DIDYOUMEAN_COUNT = "Count";
    private static final String XML_ELEMENT_RANGE_FACETS = "RangeFacet";
    private static final String XML_ELEMENT_RANGE_FACET_RANGE = "Range";
    private static final String XML_ELEMENT_RANGE_FACET_START = "Start";
    private static final String XML_ELEMENT_RANGE_FACET_END = "End";
    private static final String XML_ELEMENT_RANGE_FACET_GAP = "Gap";
    private static final String XML_ELEMENT_RANGE_FACET_OTHER = "Other";
    private static final String XML_ELEMENT_RANGE_FACET_HARDEND = "HardEnd";
    private static final String DEFAULT_QUERY_PARAM = "q";
    private static final String DEFAULT_LAST_QUERY_PARAM = "lq";
    private static final String DEFAULT_RELOADED_PARAM = "reloaded";
    private static final String DEFAULT_SORT_PARAM = "sort";
    private static final String DEFAULT_PAGE_PARAM = "page";
    private static final Integer DEFAULT_PAGE_SIZE = 10;
    private static final Integer DEFAULT_PAGENAVLENGTH = 5;
    CmsXmlContent m_xml;
    Locale m_locale;

    public CmsXMLSearchConfigurationParser(CmsXmlContent xml, Locale locale) {
        this.m_xml = xml;
        this.m_locale = locale;
    }

    @Override
    public I_CmsSearchConfigurationCommon parseCommon() {
        return new CmsSearchConfigurationCommon(this.getQueryParam(), this.getLastQueryParam(), this.parseOptionalBooleanValue(XML_ELEMENT_ESCAPE_QUERY_CHARACTERS), this.getFirstCallParam(), this.getSearchForEmtpyQuery(), this.getIgnoreQuery(), this.getQueryModifier(), this.getIndex(), this.getCore(), this.getExtraSolrParams(), this.getAdditionalRequestParameters(), this.getIgnoreReleaseDate(), this.getIgnoreExpirationDate());
    }

    @Override
    public I_CmsSearchConfigurationDidYouMean parseDidYouMean() {
        I_CmsXmlContentValue didYouMean = this.m_xml.getValue(XML_ELEMENT_DIDYOUMEAN, this.m_locale);
        if (didYouMean == null) {
            return null;
        }
        String pathPrefix = didYouMean.getPath() + "/";
        String param = this.parseOptionalStringValue(pathPrefix + "QueryParam");
        if (null == param) {
            param = this.getQueryParam();
        }
        Boolean collate = this.parseOptionalBooleanValue(pathPrefix + XML_ELEMENT_DIDYOUMEAN_COLLATE);
        Integer count = this.parseOptionalIntValue(pathPrefix + XML_ELEMENT_DIDYOUMEAN_COUNT);
        return new CmsSearchConfigurationDidYouMean(param, collate, count);
    }

    @Override
    public Map<String, I_CmsSearchConfigurationFacetField> parseFieldFacets() {
        LinkedHashMap<String, I_CmsSearchConfigurationFacetField> facetConfigs = new LinkedHashMap<String, I_CmsSearchConfigurationFacetField>();
        CmsXmlContentValueSequence fieldFacets = this.m_xml.getValueSequence(XML_ELEMENT_FIELD_FACETS, this.m_locale);
        if (fieldFacets != null) {
            for (int i = 0; i < fieldFacets.getElementCount(); ++i) {
                I_CmsSearchConfigurationFacetField config = this.parseFieldFacet(fieldFacets.getValue(i).getPath() + "/");
                if (config == null) continue;
                facetConfigs.put(config.getName(), config);
            }
        }
        return facetConfigs;
    }

    @Override
    public I_CmsSearchConfigurationHighlighting parseHighlighter() {
        I_CmsXmlContentValue highlighter = this.m_xml.getValue(XML_ELEMENT_HIGHLIGHTER, this.m_locale);
        if (highlighter == null) {
            return null;
        }
        try {
            String pathPrefix = highlighter.getPath() + "/";
            String field = this.parseMandatoryStringValue(pathPrefix + "Field");
            Integer snippets = this.parseOptionalIntValue(pathPrefix + XML_ELEMENT_HIGHLIGHTER_SNIPPETS);
            Integer fragsize = this.parseOptionalIntValue(pathPrefix + XML_ELEMENT_HIGHLIGHTER_FRAGSIZE);
            String alternateField = this.parseOptionalStringValue(pathPrefix + XML_ELEMENT_HIGHLIGHTER_ALTERNATE_FIELD);
            Integer maxAlternateFieldLength = this.parseOptionalIntValue(pathPrefix + XML_ELEMENT_HIGHLIGHTER_MAX_LENGTH_ALTERNATE_FIELD);
            String pre = this.parseOptionalStringValue(pathPrefix + XML_ELEMENT_HIGHLIGHTER_SIMPLE_PRE);
            String post = this.parseOptionalStringValue(pathPrefix + XML_ELEMENT_HIGHLIGHTER_SIMPLE_POST);
            String formatter = this.parseOptionalStringValue(pathPrefix + XML_ELEMENT_HIGHLIGHTER_FORMATTER);
            String fragmenter = this.parseOptionalStringValue(pathPrefix + XML_ELEMENT_HIGHLIGHTER_FRAGMENTER);
            Boolean useFastVectorHighlighting = this.parseOptionalBooleanValue(pathPrefix + XML_ELEMENT_HIGHLIGHTER_FASTVECTORHIGHLIGHTING);
            return new CmsSearchConfigurationHighlighting(field, snippets, fragsize, alternateField, maxAlternateFieldLength, pre, post, formatter, fragmenter, useFastVectorHighlighting);
        }
        catch (Exception e) {
            LOG.error((Object)Messages.get().getBundle().key("ERR_MANDATORY_HIGHLIGHTING_FIELD_MISSING_0"), (Throwable)e);
            return null;
        }
    }

    @Override
    public I_CmsSearchConfigurationPagination parsePagination() {
        return new CmsSearchConfigurationPagination(this.getPageParam(), this.getPageSize(), this.getPageNavLength());
    }

    @Override
    public I_CmsSearchConfigurationFacetQuery parseQueryFacet() {
        String pathPrefix = "QueryFacet/";
        try {
            List<I_CmsSearchConfigurationFacetQuery.I_CmsFacetQueryItem> queries = this.parseFacetQueryItems("QueryFacet/QueryItem");
            String label = this.parseOptionalStringValue("QueryFacet/Label");
            Boolean isAndFacet = this.parseOptionalBooleanValue("QueryFacet/IsAndFacet");
            List<String> preselection = this.parseOptionalStringValues("QueryFacet/PreSelection");
            Boolean ignoreAllFacetFilters = this.parseOptionalBooleanValue("QueryFacet/IgnoreAllFacetFilters");
            return new CmsSearchConfigurationFacetQuery(queries, label, isAndFacet, preselection, ignoreAllFacetFilters);
        }
        catch (Exception e) {
            LOG.error((Object)Messages.get().getBundle().key("ERR_QUERY_FACET_MANDATORY_KEY_MISSING_1", XML_ELEMENT_QUERY_FACET_QUERY), (Throwable)e);
            return null;
        }
    }

    @Override
    public Map<String, I_CmsSearchConfigurationFacetRange> parseRangeFacets() {
        LinkedHashMap<String, I_CmsSearchConfigurationFacetRange> facetConfigs = new LinkedHashMap<String, I_CmsSearchConfigurationFacetRange>();
        CmsXmlContentValueSequence rangeFacets = this.m_xml.getValueSequence(XML_ELEMENT_RANGE_FACETS, this.m_locale);
        if (rangeFacets != null) {
            for (int i = 0; i < rangeFacets.getElementCount(); ++i) {
                I_CmsSearchConfigurationFacetRange config = this.parseRangeFacet(rangeFacets.getValue(i).getPath() + "/");
                if (config == null) continue;
                facetConfigs.put(config.getName(), config);
            }
        }
        return facetConfigs;
    }

    @Override
    public I_CmsSearchConfigurationSorting parseSorting() {
        List<I_CmsSearchConfigurationSortOption> options = this.getSortOptions();
        I_CmsSearchConfigurationSortOption defaultOption = options != null && !options.isEmpty() ? options.get(0) : null;
        return new CmsSearchConfigurationSorting(this.getSortParam(), options, defaultOption);
    }

    protected List<I_CmsSearchConfigurationFacetQuery.I_CmsFacetQueryItem> parseFacetQueryItems(String path) throws Exception {
        List<I_CmsXmlContentValue> values = this.m_xml.getValues(path, this.m_locale);
        if (values == null) {
            return null;
        }
        ArrayList<I_CmsSearchConfigurationFacetQuery.I_CmsFacetQueryItem> parsedItems = new ArrayList<I_CmsSearchConfigurationFacetQuery.I_CmsFacetQueryItem>(values.size());
        for (I_CmsXmlContentValue value : values) {
            I_CmsSearchConfigurationFacetQuery.I_CmsFacetQueryItem item = this.parseFacetQueryItem(value.getPath() + "/");
            if (null == item) continue;
            parsedItems.add(item);
        }
        return parsedItems;
    }

    protected I_CmsSearchConfigurationFacetField parseFieldFacet(String pathPrefix) {
        try {
            I_CmsSearchConfigurationFacet.SortOrder order;
            String field = this.parseMandatoryStringValue(pathPrefix + "Field");
            String name = this.parseOptionalStringValue(pathPrefix + XML_ELEMENT_FACET_NAME);
            String label = this.parseOptionalStringValue(pathPrefix + "Label");
            Integer minCount = this.parseOptionalIntValue(pathPrefix + XML_ELEMENT_FACET_MINCOUNT);
            Integer limit = this.parseOptionalIntValue(pathPrefix + XML_ELEMENT_FACET_LIMIT);
            String prefix = this.parseOptionalStringValue(pathPrefix + XML_ELEMENT_FACET_PREFIX);
            String sorder = this.parseOptionalStringValue(pathPrefix + XML_ELEMENT_FACET_ORDER);
            try {
                order = I_CmsSearchConfigurationFacet.SortOrder.valueOf(sorder);
            }
            catch (Exception e) {
                order = null;
            }
            String filterQueryModifier = this.parseOptionalStringValue(pathPrefix + XML_ELEMENT_FACET_FILTERQUERYMODIFIER);
            Boolean isAndFacet = this.parseOptionalBooleanValue(pathPrefix + XML_ELEMENT_FACET_ISANDFACET);
            List<String> preselection = this.parseOptionalStringValues(pathPrefix + XML_ELEMENT_FACET_PRESELECTION);
            Boolean ignoreAllFacetFilters = this.parseOptionalBooleanValue(pathPrefix + XML_ELEMENT_FACET_IGNOREALLFACETFILTERS);
            return new CmsSearchConfigurationFacetField(field, name, minCount, limit, prefix, label, order, filterQueryModifier, isAndFacet, preselection, ignoreAllFacetFilters);
        }
        catch (Exception e) {
            LOG.error((Object)Messages.get().getBundle().key("ERR_FIELD_FACET_MANDATORY_KEY_MISSING_1", "Field"), (Throwable)e);
            return null;
        }
    }

    protected Boolean parseOptionalBooleanValue(String path) {
        I_CmsXmlContentValue value = this.m_xml.getValue(path, this.m_locale);
        if (value == null) {
            return null;
        }
        String stringValue = value.getStringValue(null);
        try {
            Boolean boolValue = Boolean.valueOf(stringValue);
            return boolValue;
        }
        catch (NumberFormatException e) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_OPTIONAL_BOOLEAN_MISSING_1", path), (Throwable)e);
            return null;
        }
    }

    protected Integer parseOptionalIntValue(String path) {
        I_CmsXmlContentValue value = this.m_xml.getValue(path, this.m_locale);
        if (value == null) {
            return null;
        }
        String stringValue = value.getStringValue(null);
        try {
            Integer intValue = Integer.valueOf(stringValue);
            return intValue;
        }
        catch (NumberFormatException e) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_OPTIONAL_INTEGER_MISSING_1", path), (Throwable)e);
            return null;
        }
    }

    protected String parseOptionalStringValue(String path) {
        I_CmsXmlContentValue value = this.m_xml.getValue(path, this.m_locale);
        if (value == null) {
            return null;
        }
        return value.getStringValue(null);
    }

    protected List<String> parseOptionalStringValues(String path) {
        List<I_CmsXmlContentValue> values = this.m_xml.getValues(path, this.m_locale);
        if (values == null) {
            return null;
        }
        ArrayList<String> stringValues = new ArrayList<String>(values.size());
        for (I_CmsXmlContentValue value : values) {
            stringValues.add(value.getStringValue(null));
        }
        return stringValues;
    }

    protected I_CmsSearchConfigurationFacetRange parseRangeFacet(String pathPrefix) {
        try {
            String range = this.parseMandatoryStringValue(pathPrefix + XML_ELEMENT_RANGE_FACET_RANGE);
            String name = this.parseOptionalStringValue(pathPrefix + XML_ELEMENT_FACET_NAME);
            String label = this.parseOptionalStringValue(pathPrefix + "Label");
            Integer minCount = this.parseOptionalIntValue(pathPrefix + XML_ELEMENT_FACET_MINCOUNT);
            String start = this.parseMandatoryStringValue(pathPrefix + XML_ELEMENT_RANGE_FACET_START);
            String end = this.parseMandatoryStringValue(pathPrefix + XML_ELEMENT_RANGE_FACET_END);
            String gap = this.parseMandatoryStringValue(pathPrefix + XML_ELEMENT_RANGE_FACET_GAP);
            String sother = this.parseOptionalStringValue(pathPrefix + XML_ELEMENT_RANGE_FACET_OTHER);
            ArrayList<I_CmsSearchConfigurationFacetRange.Other> other = null;
            if (sother != null) {
                List<String> sothers = Arrays.asList(sother.split(","));
                other = new ArrayList<I_CmsSearchConfigurationFacetRange.Other>(sothers.size());
                for (String so : sothers) {
                    try {
                        I_CmsSearchConfigurationFacetRange.Other o = I_CmsSearchConfigurationFacetRange.Other.valueOf(so);
                        other.add(o);
                    }
                    catch (Exception e) {
                        LOG.error((Object)Messages.get().getBundle().key("ERR_INVALID_OTHER_OPTION_1", so), (Throwable)e);
                    }
                }
            }
            Boolean hardEnd = this.parseOptionalBooleanValue(pathPrefix + XML_ELEMENT_RANGE_FACET_HARDEND);
            Boolean isAndFacet = this.parseOptionalBooleanValue(pathPrefix + XML_ELEMENT_FACET_ISANDFACET);
            List<String> preselection = this.parseOptionalStringValues(pathPrefix + XML_ELEMENT_FACET_PRESELECTION);
            Boolean ignoreAllFacetFilters = this.parseOptionalBooleanValue(pathPrefix + XML_ELEMENT_FACET_IGNOREALLFACETFILTERS);
            return new CmsSearchConfigurationFacetRange(range, start, end, gap, other, hardEnd, name, minCount, label, isAndFacet, preselection, ignoreAllFacetFilters);
        }
        catch (Exception e) {
            LOG.error((Object)Messages.get().getBundle().key("ERR_RANGE_FACET_MANDATORY_KEY_MISSING_1", "Range, Start, End, Gap"), (Throwable)e);
            return null;
        }
    }

    private Map<String, String> getAdditionalRequestParameters() {
        List<I_CmsXmlContentValue> parametersToParse = this.m_xml.getValues(XML_ELEMENT_ADDITIONAL_PARAMETERS, this.m_locale);
        HashMap<String, String> result = new HashMap<String, String>(parametersToParse.size());
        for (I_CmsXmlContentValue additionalParam : parametersToParse) {
            String param = this.m_xml.getValue(additionalParam.getPath() + "/" + XML_ELEMENT_ADDITIONAL_PARAMETERS_PARAM, this.m_locale).getStringValue(null);
            String solrQuery = this.m_xml.getValue(additionalParam.getPath() + "/" + XML_ELEMENT_ADDITIONAL_PARAMETERS_SOLRQUERY, this.m_locale).getStringValue(null);
            result.put(param, solrQuery);
        }
        return result;
    }

    private String getCore() {
        try {
            return this.parseMandatoryStringValue(XML_ELEMENT_CORE);
        }
        catch (Exception e) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_NO_CORE_SPECIFIED_0"), (Throwable)e);
            return null;
        }
    }

    private String getExtraSolrParams() {
        return this.parseOptionalStringValue(XML_ELEMENT_EXTRASOLRPARAMS);
    }

    private String getFirstCallParam() {
        String param = this.parseOptionalStringValue(XML_ELEMENT_RELOADED_PARAM);
        if (param == null) {
            return DEFAULT_RELOADED_PARAM;
        }
        return param;
    }

    private Boolean getIgnoreExpirationDate() {
        return this.parseOptionalBooleanValue(XML_ELEMENT_IGNORE_EXPIRATION_DATE);
    }

    private Boolean getIgnoreQuery() {
        return this.parseOptionalBooleanValue(XML_ELEMENT_IGNORE_QUERY);
    }

    private Boolean getIgnoreReleaseDate() {
        return this.parseOptionalBooleanValue(XML_ELEMENT_IGNORE_RELEASE_DATE);
    }

    private String getIndex() {
        try {
            return this.parseMandatoryStringValue(XML_ELEMENT_INDEX);
        }
        catch (Exception e) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_NO_INDEX_SPECIFIED_0"), (Throwable)e);
            return null;
        }
    }

    private String getLastQueryParam() {
        String param = this.parseOptionalStringValue(XML_ELEMENT_LAST_QUERYPARAM);
        if (param == null) {
            return DEFAULT_LAST_QUERY_PARAM;
        }
        return param;
    }

    private Integer getPageNavLength() {
        Integer param = this.parseOptionalIntValue(XML_ELEMENT_PAGENAVLENGTH);
        if (param == null) {
            return DEFAULT_PAGENAVLENGTH;
        }
        return param;
    }

    private String getPageParam() {
        String param = this.parseOptionalStringValue(XML_ELEMENT_PAGEPARAM);
        if (param == null) {
            return DEFAULT_PAGE_PARAM;
        }
        return param;
    }

    private Integer getPageSize() {
        Integer pageSize = this.parseOptionalIntValue(XML_ELEMENT_PAGESIZE);
        if (pageSize == null) {
            return DEFAULT_PAGE_SIZE;
        }
        return pageSize;
    }

    private String getQueryModifier() {
        return this.parseOptionalStringValue(XML_ELEMENT_QUERY_MODIFIER);
    }

    private String getQueryParam() {
        String param = this.parseOptionalStringValue("QueryParam");
        if (param == null) {
            return DEFAULT_QUERY_PARAM;
        }
        return param;
    }

    private Boolean getSearchForEmtpyQuery() {
        return this.parseOptionalBooleanValue(XML_ELEMENT_SEARCH_FOR_EMPTY_QUERY);
    }

    private List<I_CmsSearchConfigurationSortOption> getSortOptions() {
        ArrayList<I_CmsSearchConfigurationSortOption> options = new ArrayList<I_CmsSearchConfigurationSortOption>();
        CmsXmlContentValueSequence sortOptions = this.m_xml.getValueSequence(XML_ELEMENT_SORTOPTIONS, this.m_locale);
        if (sortOptions == null) {
            return null;
        }
        for (int i = 0; i < sortOptions.getElementCount(); ++i) {
            I_CmsSearchConfigurationSortOption option = this.parseSortOption(sortOptions.getValue(i).getPath() + "/");
            if (option == null) continue;
            options.add(option);
        }
        return options;
    }

    private String getSortParam() {
        String param = this.parseOptionalStringValue(XML_ELEMENT_SORTPARAM);
        if (param == null) {
            return DEFAULT_SORT_PARAM;
        }
        return param;
    }

    private I_CmsSearchConfigurationFacetQuery.I_CmsFacetQueryItem parseFacetQueryItem(String prefix) {
        I_CmsXmlContentValue query = this.m_xml.getValue(prefix + XML_ELEMENT_QUERY_FACET_QUERY_QUERY, this.m_locale);
        if (null != query) {
            String queryString = query.getStringValue(null);
            I_CmsXmlContentValue label = this.m_xml.getValue(prefix + "Label", this.m_locale);
            String labelString = null != label ? label.getStringValue(null) : null;
            return new CmsSearchConfigurationFacetQuery.CmsFacetQueryItem(queryString, labelString);
        }
        return null;
    }

    private String parseMandatoryStringValue(String path) throws Exception {
        String value = this.parseOptionalStringValue(path);
        if (value == null) {
            throw new Exception();
        }
        return value;
    }

    private I_CmsSearchConfigurationSortOption parseSortOption(String pathPrefix) {
        try {
            String solrValue = this.parseMandatoryStringValue(pathPrefix + XML_ELEMENT_SORTOPTION_SOLRVALUE);
            String paramValue = this.parseOptionalStringValue(pathPrefix + XML_ELEMENT_SORTOPTION_PARAMVALUE);
            paramValue = paramValue == null ? solrValue : paramValue;
            String label = this.parseOptionalStringValue(pathPrefix + "Label");
            label = label == null ? paramValue : label;
            return new CmsSearchConfigurationSortOption(label, paramValue, solrValue);
        }
        catch (Exception e) {
            LOG.error((Object)Messages.get().getBundle().key("ERR_SORT_OPTION_NOT_PARSABLE_1", XML_ELEMENT_SORTOPTION_SOLRVALUE), (Throwable)e);
            return null;
        }
    }
}

