/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.search.controller;

import java.util.Map;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationDidYouMean;
import org.opencms.jsp.search.controller.I_CmsSearchControllerDidYouMean;
import org.opencms.jsp.search.state.CmsSearchStateDidYouMean;
import org.opencms.jsp.search.state.I_CmsSearchStateDidYouMean;
import org.opencms.search.solr.CmsSolrQuery;

public class CmsSearchControllerDidYouMean
implements I_CmsSearchControllerDidYouMean {
    private final I_CmsSearchConfigurationDidYouMean m_config;
    private final I_CmsSearchStateDidYouMean m_state;

    public CmsSearchControllerDidYouMean(I_CmsSearchConfigurationDidYouMean config) {
        this.m_config = config;
        this.m_state = new CmsSearchStateDidYouMean();
    }

    @Override
    public void addParametersForCurrentState(Map<String, String[]> parameters) {
    }

    @Override
    public void addQueryParts(CmsSolrQuery query) {
        query.set("spellcheck", new String[]{"true"});
        String queryString = this.m_state.getQuery();
        query.set("spellcheck.q", new String[]{queryString});
        if (this.m_config.getCollate()) {
            query.set("spellcheck.collate", new String[]{"true"});
        } else {
            query.set("spellcheck.collate", new String[]{"false"});
        }
        query.set("spellcheck.extendedResults", new String[]{"true"});
        query.set("spellcheck.count", new String[]{Integer.valueOf(this.m_config.getCount()).toString()});
    }

    @Override
    public I_CmsSearchConfigurationDidYouMean getConfig() {
        return this.m_config;
    }

    @Override
    public I_CmsSearchStateDidYouMean getState() {
        return this.m_state;
    }

    @Override
    public void updateForQueryChange() {
    }

    @Override
    public void updateFromRequestParameters(Map<String, String[]> parameters, boolean isReloaded) {
        String[] queryStrings;
        if (parameters.containsKey(this.m_config.getQueryParam()) && (queryStrings = parameters.get(this.m_config.getQueryParam())).length > 0) {
            this.m_state.setQuery(queryStrings[0]);
            return;
        }
        this.m_state.setQuery("");
    }
}

