/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.search.controller;

import java.util.Iterator;
import java.util.Map;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationFacetQuery;
import org.opencms.jsp.search.controller.I_CmsSearchControllerFacetQuery;
import org.opencms.jsp.search.state.CmsSearchStateFacet;
import org.opencms.jsp.search.state.I_CmsSearchStateFacet;
import org.opencms.search.solr.CmsSolrQuery;

public class CmsSearchControllerFacetQuery
implements I_CmsSearchControllerFacetQuery {
    private final I_CmsSearchConfigurationFacetQuery m_config;
    private final I_CmsSearchStateFacet m_state;

    public CmsSearchControllerFacetQuery(I_CmsSearchConfigurationFacetQuery config) {
        this.m_config = config;
        this.m_state = new CmsSearchStateFacet();
    }

    @Override
    public void addParametersForCurrentState(Map<String, String[]> parameters) {
        if (!this.m_state.getCheckedEntries().isEmpty()) {
            parameters.put(this.m_config.getParamKey(), this.m_state.getCheckedEntries().toArray(new String[this.m_state.getCheckedEntries().size()]));
        }
        if (this.m_state.getIgnoreChecked()) {
            parameters.put(this.m_config.getIgnoreMaxParamKey(), null);
        }
    }

    @Override
    public void addQueryParts(CmsSolrQuery query) {
        this.addFacetPart(query);
        this.addFilterQueryParts(query);
    }

    @Override
    public I_CmsSearchConfigurationFacetQuery getConfig() {
        return this.m_config;
    }

    @Override
    public I_CmsSearchStateFacet getState() {
        return this.m_state;
    }

    @Override
    public void updateForQueryChange() {
        this.m_state.setIgnoreChecked(true);
    }

    @Override
    public void updateFromRequestParameters(Map<String, String[]> parameters, boolean isReloaded) {
        block3: {
            block2: {
                this.m_state.setUseLimit(!parameters.containsKey(this.m_config.getIgnoreMaxParamKey()));
                if (!isReloaded) break block2;
                this.m_state.clearChecked();
                if (this.m_state.getIgnoreChecked() || !parameters.containsKey(this.m_config.getParamKey())) break block3;
                String[] checked = parameters.get(this.m_config.getParamKey());
                for (int i = 0; i < checked.length; ++i) {
                    this.m_state.addChecked(checked[i]);
                }
                break block3;
            }
            for (String checked : this.m_config.getPreSelection()) {
                this.m_state.addChecked(checked);
            }
        }
    }

    protected void addFacetPart(CmsSolrQuery query) {
        query.set("facet", new String[]{"true"});
        String excludes = "";
        if (this.m_config.getIgnoreAllFacetFilters() || !this.m_state.getCheckedEntries().isEmpty() && !this.m_config.getIsAndFacet()) {
            excludes = "{!ex=" + this.m_config.getIgnoreTags() + "}";
        }
        for (I_CmsSearchConfigurationFacetQuery.I_CmsFacetQueryItem q : this.m_config.getQueryList()) {
            query.add("facet.query", new String[]{excludes + q.getQuery()});
        }
    }

    protected void addFilterQueryParts(CmsSolrQuery query) {
        if (!this.m_state.getCheckedEntries().isEmpty()) {
            String concater;
            Iterator<String> fieldIterator = this.m_state.getCheckedEntries().iterator();
            StringBuffer value = new StringBuffer();
            value.append("{!tag=").append(this.m_config.getName()).append("}(").append(fieldIterator.next());
            String string = concater = this.m_config.getIsAndFacet() ? " AND " : " OR ";
            while (fieldIterator.hasNext()) {
                value.append(concater);
                value.append(fieldIterator.next());
            }
            value.append(')');
            query.add("fq", new String[]{value.toString()});
        }
    }
}

