/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.search.controller;

import java.util.Iterator;
import java.util.Map;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationFacetRange;
import org.opencms.jsp.search.controller.I_CmsSearchControllerFacetRange;
import org.opencms.jsp.search.state.CmsSearchStateFacet;
import org.opencms.jsp.search.state.I_CmsSearchStateFacet;
import org.opencms.search.solr.CmsSolrQuery;

public class CmsSearchControllerFacetRange
implements I_CmsSearchControllerFacetRange {
    private final I_CmsSearchConfigurationFacetRange m_config;
    private final I_CmsSearchStateFacet m_state;

    public CmsSearchControllerFacetRange(I_CmsSearchConfigurationFacetRange config) {
        this.m_config = config;
        this.m_state = new CmsSearchStateFacet();
    }

    @Override
    public void addParametersForCurrentState(Map<String, String[]> parameters) {
        if (!this.m_state.getCheckedEntries().isEmpty()) {
            parameters.put(this.m_config.getParamKey(), this.m_state.getCheckedEntries().toArray(new String[this.m_state.getCheckedEntries().size()]));
        }
        if (this.m_state.getIgnoreChecked()) {
            parameters.put(this.m_config.getIgnoreMaxParamKey(), null);
        }
    }

    @Override
    public void addQueryParts(CmsSolrQuery query) {
        this.addFacetPart(query);
        this.addFilterQueryParts(query);
    }

    @Override
    public I_CmsSearchConfigurationFacetRange getConfig() {
        return this.m_config;
    }

    @Override
    public I_CmsSearchStateFacet getState() {
        return this.m_state;
    }

    @Override
    public void updateForQueryChange() {
        this.m_state.setIgnoreChecked(true);
    }

    @Override
    public void updateFromRequestParameters(Map<String, String[]> parameters, boolean isReloaded) {
        block3: {
            block2: {
                this.m_state.setUseLimit(!parameters.containsKey(this.m_config.getIgnoreMaxParamKey()));
                if (!isReloaded) break block2;
                this.m_state.clearChecked();
                if (this.m_state.getIgnoreChecked() || !parameters.containsKey(this.m_config.getParamKey())) break block3;
                String[] checked = parameters.get(this.m_config.getParamKey());
                for (int i = 0; i < checked.length; ++i) {
                    this.m_state.addChecked(checked[i]);
                }
                break block3;
            }
            for (String checked : this.m_config.getPreSelection()) {
                this.m_state.addChecked(checked);
            }
        }
    }

    protected void addFacetOptions(StringBuffer query) {
        this.appendFacetOption(query, "range.start", this.m_config.getStart());
        this.appendFacetOption(query, "range.end", this.m_config.getEnd());
        this.appendFacetOption(query, "range.gap", this.m_config.getGap());
        for (I_CmsSearchConfigurationFacetRange.Other o : this.m_config.getOther()) {
            this.appendFacetOption(query, "range.other", o.toString());
        }
        this.appendFacetOption(query, "range.hardend", Boolean.toString(this.m_config.getHardEnd()));
        if (this.m_config.getMinCount() != null) {
            this.appendFacetOption(query, "mincount", this.m_config.getMinCount().toString());
        }
    }

    protected void addFacetPart(CmsSolrQuery query) {
        StringBuffer value = new StringBuffer();
        value.append("{!key=").append(this.m_config.getName());
        this.addFacetOptions(value);
        if (this.m_config.getIgnoreAllFacetFilters() || !this.m_state.getCheckedEntries().isEmpty() && !this.m_config.getIsAndFacet()) {
            value.append(" ex=").append(this.m_config.getIgnoreTags());
        }
        value.append("}");
        value.append(this.m_config.getRange());
        query.add("facet.range", new String[]{value.toString()});
    }

    protected void addFilterQueryParts(CmsSolrQuery query) {
        if (!this.m_state.getCheckedEntries().isEmpty()) {
            String concater;
            StringBuffer value = new StringBuffer();
            value.append("{!tag=").append(this.m_config.getName()).append('}');
            value.append(this.m_config.getRange());
            value.append(":(");
            Iterator<String> fieldIterator = this.m_state.getCheckedEntries().iterator();
            value.append(this.generateRange(fieldIterator.next()));
            String string = concater = this.m_config.getIsAndFacet() ? " AND " : " OR ";
            while (fieldIterator.hasNext()) {
                value.append(concater);
                value.append(this.generateRange(fieldIterator.next()));
            }
            if (this.m_config.getHardEnd()) {
                value.append(concater);
                value.append("[" + this.m_config.getStart() + " TO " + this.m_config.getEnd() + "}");
            }
            value.append(')');
            query.add("fq", new String[]{value.toString()});
        }
    }

    protected void appendFacetOption(StringBuffer query, String name, String value) {
        query.append(" facet.").append(name).append("=").append(value);
    }

    private Object generateRange(String startValue) {
        return "[" + startValue + " TO " + startValue + this.m_config.getGap() + "}";
    }
}

