/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.xml.containerpage.CmsDynamicFunctionBean;

public class CmsDynamicFunctionFormatWrapper {
    private static final Log LOG = CmsLog.getLog(CmsDynamicFunctionFormatWrapper.class);
    private CmsObject m_cms;
    private CmsDynamicFunctionBean.Format m_format;
    private CmsResource m_jspResource;

    public CmsDynamicFunctionFormatWrapper(CmsObject cms, CmsDynamicFunctionBean.Format format) {
        this.m_cms = cms;
        this.m_format = format;
        if (format != null) {
            try {
                this.m_jspResource = cms.readResource(format.getJspStructureId());
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public boolean getExists() {
        return this.m_jspResource != null;
    }

    public String getJsp() {
        if (this.m_jspResource != null) {
            return this.m_cms.getSitePath(this.m_jspResource);
        }
        return "";
    }

    public Map<String, String> getParam() {
        return this.getParameters();
    }

    public Map<String, String> getParameters() {
        if (this.m_format != null) {
            return this.m_format.getParameters();
        }
        return Collections.emptyMap();
    }
}

