/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.relations.CmsLink;
import org.opencms.relations.CmsRelationType;
import org.opencms.staticexport.CmsLinkManager;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.util.I_CmsMacroResolver;

public class CmsJspLinkMacroResolver
implements I_CmsMacroResolver {
    public static final char KEY_SEPARATOR = ':';
    public static final String MACRO_LINK = "link:";
    public static final String MACRO_LINK_STRONG = "link.strong:";
    public static final String MACRO_LINK_WEAK = "link.weak:";
    public static final String[] VALUE_NAME_ARRAY = new String[]{"link:", "link.weak:", "link.strong:"};
    public static final List<String> VALUE_NAMES = Collections.unmodifiableList(Arrays.asList(VALUE_NAME_ARRAY));
    private CmsObject m_cms;
    private boolean m_forRfs;
    private String m_jspRootPath;
    private List<CmsLink> m_links = new ArrayList<CmsLink>();

    public CmsJspLinkMacroResolver(CmsObject cms, String jspRootPath, boolean forRfs) {
        this.m_cms = cms;
        this.m_forRfs = forRfs;
        this.m_jspRootPath = jspRootPath;
    }

    public List<CmsLink> getLinks() {
        return this.m_links;
    }

    @Override
    public String getMacroValue(String macro) {
        String path = null;
        String id = null;
        Iterator<String> it = VALUE_NAMES.iterator();
        while (it.hasNext()) {
            String cmd = it.next().toString();
            if (!macro.startsWith(cmd)) continue;
            path = macro.substring(cmd.length());
            macro = cmd;
            break;
        }
        if (path == null) {
            return null;
        }
        int pos = path.indexOf(58);
        if (pos > -1 && path.length() > pos + 1) {
            id = path.substring(pos + 1);
        }
        if (pos > -1) {
            path = path.substring(0, pos);
        }
        CmsUUID uuid = null;
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(id)) {
            id = path != null ? path : null;
        }
        if (id != null) {
            try {
                uuid = new CmsUUID(id);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (path == null || path.trim().length() == 0) {
            path = null;
        } else {
            boolean isAbsolute = path.charAt(0) == '/';
            path = CmsFileUtil.normalizePath(path, '/');
            if (!isAbsolute) {
                path = path.substring(1);
            }
            if (isAbsolute && !path.startsWith(this.m_cms.getRequestContext().getSiteRoot())) {
                path = this.m_cms.getRequestContext().addSiteRoot(path);
            } else if (this.m_jspRootPath != null) {
                path = CmsLinkManager.getAbsoluteUri(path, CmsResource.getParentFolder(this.m_jspRootPath));
            }
        }
        CmsRelationType type = CmsRelationType.JSP_WEAK;
        if (macro == MACRO_LINK_STRONG) {
            type = CmsRelationType.JSP_STRONG;
        }
        CmsLink link = new CmsLink("link0", type, uuid, path, true);
        link.checkConsistency(this.m_cms);
        this.m_links.add(link);
        if (this.m_forRfs) {
            return this.m_cms.getRequestContext().removeSiteRoot(link.getTarget());
        }
        StringBuffer newMacro = new StringBuffer(128);
        newMacro.append('%');
        newMacro.append('(');
        newMacro.append(macro);
        newMacro.append(link.getSitePath());
        if (link.getStructureId() != null && !link.getStructureId().isNullUUID()) {
            newMacro.append(':').append(link.getStructureId());
        }
        newMacro.append(')');
        return newMacro.toString();
    }

    @Override
    public boolean isKeepEmptyMacros() {
        return true;
    }

    @Override
    public String resolveMacros(String input) {
        this.m_links.clear();
        String result = input != null ? CmsMacroResolver.resolveMacros(input, this) : null;
        return result;
    }
}

