/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsADEManager;
import org.opencms.ade.configuration.CmsFunctionReference;
import org.opencms.ade.containerpage.CmsContainerpageService;
import org.opencms.ade.containerpage.shared.CmsFormatterConfig;
import org.opencms.ade.containerpage.shared.CmsInheritanceInfo;
import org.opencms.ade.detailpage.CmsDetailPageInfo;
import org.opencms.ade.detailpage.CmsDetailPageResourceHandler;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.history.CmsHistoryResourceHandler;
import org.opencms.flex.CmsFlexController;
import org.opencms.flex.CmsFlexRequest;
import org.opencms.i18n.CmsLocaleGroupService;
import org.opencms.jsp.CmsJspBean;
import org.opencms.jsp.CmsJspResourceWrapper;
import org.opencms.jsp.CmsJspTagContainer;
import org.opencms.jsp.CmsJspTagEditable;
import org.opencms.jsp.Messages;
import org.opencms.jsp.jsonpart.CmsJsonPartFilter;
import org.opencms.jsp.util.A_CmsJspValueWrapper;
import org.opencms.jsp.util.CmsDynamicFunctionBeanWrapper;
import org.opencms.jsp.util.CmsDynamicFunctionFormatWrapper;
import org.opencms.jsp.util.CmsJspCategoryAccessBean;
import org.opencms.jsp.util.CmsJspContentAccessBean;
import org.opencms.jsp.util.CmsJspVfsAccessBean;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.CmsSystemInfo;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsCategory;
import org.opencms.relations.CmsCategoryService;
import org.opencms.util.CmsCollectionsGenericWrapper;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.containerpage.CmsContainerBean;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.CmsDynamicFunctionBean;
import org.opencms.xml.containerpage.CmsDynamicFunctionParser;
import org.opencms.xml.containerpage.CmsFormatterConfiguration;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;

public final class CmsJspStandardContextBean {
    public static final String ATTRIBUTE_CMS_OBJECT = "__cmsObject";
    public static final String ATTRIBUTE_NAME = "cms";
    protected static final Log LOG = CmsLog.getLog(CmsJspStandardContextBean.class);
    protected CmsObject m_cms;
    private Map<String, CmsCategory> m_categories;
    private Map<String, CmsJspCategoryAccessBean> m_allSubCategories;
    private CmsContainerBean m_container;
    private CmsResource m_detailContentResource;
    private CmsContainerPageBean m_detailOnlyPage;
    private boolean m_edited;
    private CmsContainerElementBean m_element;
    private Map<String, CmsContainerElementBean> m_elementInstances;
    private Map<String, CmsDynamicFunctionBeanWrapper> m_function;
    private Map<String, String> m_functionDetailPage;
    private boolean m_isDragMode;
    private Boolean m_isEditMode;
    private Map<String, String> m_localeTitles;
    private CmsContainerPageBean m_page;
    private CmsResource m_pageResource;
    private Map<String, CmsContainerBean> m_parentContainers;
    private Map<String, List<CmsCategory>> m_pathCategories;
    private ServletRequest m_request;
    private Map<String, CmsJspCategoryAccessBean> m_resourceCategories;
    private CmsJspResourceWrapper m_resourceWrapper;
    private Map<String, String> m_typeDetailPage;
    private CmsJspVfsAccessBean m_vfsBean;

    private CmsJspStandardContextBean() {
    }

    private CmsJspStandardContextBean(ServletRequest req) {
        CmsFlexController controller = CmsFlexController.getController(req);
        this.m_request = req;
        CmsObject cms = controller != null ? controller.getCmsObject() : (CmsObject)req.getAttribute(ATTRIBUTE_CMS_OBJECT);
        if (cms == null) {
            throw new CmsRuntimeException(Messages.get().container("ERR_MISSING_CMS_CONTROLLER_1", CmsJspBean.class.getName()));
        }
        this.updateCmsObject(cms);
        this.m_detailContentResource = CmsDetailPageResourceHandler.getDetailResource(req);
    }

    public static CmsJspStandardContextBean getInstance(ServletRequest req) {
        CmsJspStandardContextBean result;
        Object attribute = req.getAttribute(ATTRIBUTE_NAME);
        if (attribute != null && attribute instanceof CmsJspStandardContextBean) {
            result = (CmsJspStandardContextBean)attribute;
        } else {
            result = new CmsJspStandardContextBean(req);
            req.setAttribute(ATTRIBUTE_NAME, (Object)result);
        }
        return result;
    }

    public CmsJspStandardContextBean createCopy() {
        CmsJspStandardContextBean result = new CmsJspStandardContextBean();
        result.m_container = this.m_container;
        if (this.m_detailContentResource != null) {
            result.m_detailContentResource = this.m_detailContentResource.getCopy();
        }
        result.m_element = this.m_element;
        result.setPage(this.m_page);
        return result;
    }

    public String elementCachingHash() {
        String result = "";
        if (this.m_element != null) {
            result = this.m_element.editorHash();
            if (this.m_container != null) {
                result = result + "w:" + this.m_container.getWidth() + "cName:" + this.m_container.getName() + "cType:" + this.m_container.getType();
            }
        }
        return result;
    }

    public List<Locale> getAvailableLocales() {
        return OpenCms.getLocaleManager().getAvailableLocales(this.m_cms, this.getRequestContext().getUri());
    }

    public CmsContainerBean getContainer() {
        return this.m_container;
    }

    public CmsResource getDetailContent() {
        return this.m_detailContentResource;
    }

    public CmsUUID getDetailContentId() {
        return this.m_detailContentResource == null ? null : this.m_detailContentResource.getStructureId();
    }

    public String getDetailContentSitePath() {
        return this.m_cms == null || this.m_detailContentResource == null ? null : this.m_cms.getSitePath(this.m_detailContentResource);
    }

    public CmsContainerPageBean getDetailOnlyPage() {
        return this.m_detailOnlyPage;
    }

    public CmsContainerElementWrapper getElement() {
        return this.m_element != null ? new CmsContainerElementWrapper(this.m_element) : null;
    }

    public String getEnableReload() {
        return this.getReloadMarker();
    }

    public Map<String, CmsDynamicFunctionBeanWrapper> getFunction() {
        if (this.m_function == null) {
            Transformer transformer = new Transformer(){

                public Object transform(Object input) {
                    try {
                        CmsDynamicFunctionBean dynamicFunction = CmsJspStandardContextBean.this.readDynamicFunctionBean((String)input);
                        CmsDynamicFunctionBeanWrapper wrapper = new CmsDynamicFunctionBeanWrapper(CmsJspStandardContextBean.this.m_cms, dynamicFunction);
                        return wrapper;
                    }
                    catch (CmsException e) {
                        LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                        return new CmsDynamicFunctionBeanWrapper(CmsJspStandardContextBean.this.m_cms, null);
                    }
                }
            };
            this.m_function = CmsCollectionsGenericWrapper.createLazyMap(transformer);
        }
        return this.m_function;
    }

    @Deprecated
    public Map<String, String> getFunctionDetail() {
        return this.getFunctionDetailPage();
    }

    public Map<String, String> getFunctionDetailPage() {
        if (this.m_functionDetailPage == null) {
            this.m_functionDetailPage = CmsCollectionsGenericWrapper.createLazyMap(new CmsDetailLookupTransformer("function@"));
        }
        return this.m_functionDetailPage;
    }

    public Map<CmsJspContentAccessBean, CmsDynamicFunctionFormatWrapper> getFunctionFormatFromContent() {
        Transformer transformer = new Transformer(){

            public Object transform(Object contentAccess) {
                CmsXmlContent content = (CmsXmlContent)((CmsJspContentAccessBean)contentAccess).getRawContent();
                CmsDynamicFunctionParser parser = new CmsDynamicFunctionParser();
                CmsDynamicFunctionBean functionBean = null;
                try {
                    functionBean = parser.parseFunctionBean(CmsJspStandardContextBean.this.m_cms, content);
                }
                catch (CmsException e) {
                    LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                    return new CmsDynamicFunctionFormatWrapper(CmsJspStandardContextBean.this.m_cms, null);
                }
                String type = CmsJspStandardContextBean.this.getContainer().getType();
                String width = CmsJspStandardContextBean.this.getContainer().getWidth();
                int widthNum = -1;
                try {
                    widthNum = Integer.parseInt(width);
                }
                catch (NumberFormatException e) {
                    LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                CmsDynamicFunctionBean.Format format = functionBean.getFormatForContainer(CmsJspStandardContextBean.this.m_cms, type, widthNum);
                CmsDynamicFunctionFormatWrapper wrapper = new CmsDynamicFunctionFormatWrapper(CmsJspStandardContextBean.this.m_cms, format);
                return wrapper;
            }
        };
        return CmsCollectionsGenericWrapper.createLazyMap(transformer);
    }

    public boolean getIsEditMode() {
        if (this.m_isEditMode == null) {
            this.m_isEditMode = CmsJspTagEditable.isEditableRequest(this.m_request);
        }
        return this.m_isEditMode;
    }

    public boolean getIsJSONRequest() {
        return CmsJsonPartFilter.isJsonRequest(this.m_request);
    }

    public boolean getIsOnlineProject() {
        return this.m_cms.getRequestContext().getCurrentProject().isOnlineProject();
    }

    public Locale getLocale() {
        return this.getRequestContext().getLocale();
    }

    public Map<String, CmsJspResourceWrapper> getLocaleResource() {
        Map<String, CmsJspResourceWrapper> result = this.getResourceWrapperForPage().getLocaleResource();
        List<Locale> locales = CmsLocaleGroupService.getPossibleLocales(this.m_cms, this.getContainerPage());
        for (Locale locale : locales) {
            if (result.containsKey(locale.toString())) continue;
            result.put(locale.toString(), null);
        }
        return result;
    }

    public Locale getMainLocale() {
        return this.getResourceWrapperForPage().getMainLocale();
    }

    public CmsContainerPageBean getPage() {
        return this.m_page;
    }

    public CmsContainerBean getParentContainer() {
        CmsContainerBean result = null;
        if (this.getContainer() != null && this.getContainer().getParentInstanceId() != null) {
            result = this.m_parentContainers.get(this.getContainer().getParentInstanceId());
        }
        return result;
    }

    public Map<String, CmsContainerBean> getParentContainers() {
        if (this.m_parentContainers == null) {
            this.initPageData();
        }
        return Collections.unmodifiableMap(this.m_parentContainers);
    }

    public CmsContainerElementBean getParentElement() {
        return this.getParentElement(this.getElement());
    }

    public Map<String, String> getPreviewFormatter() {
        Transformer transformer = new Transformer(){

            public Object transform(Object uri) {
                try {
                    String rootPath = CmsJspStandardContextBean.this.m_cms.getRequestContext().addSiteRoot((String)uri);
                    CmsResource resource = CmsJspStandardContextBean.this.m_cms.readResource((String)uri);
                    CmsADEManager adeManager = OpenCms.getADEManager();
                    CmsADEConfigData configData = adeManager.lookupConfiguration(CmsJspStandardContextBean.this.m_cms, rootPath);
                    CmsFormatterConfiguration formatterConfig = configData.getFormatters(CmsJspStandardContextBean.this.m_cms, resource);
                    if (formatterConfig == null) {
                        return "";
                    }
                    I_CmsFormatterBean previewFormatter = formatterConfig.getPreviewFormatter();
                    if (previewFormatter == null) {
                        return "";
                    }
                    CmsUUID structureId = previewFormatter.getJspStructureId();
                    CmsJspStandardContextBean.this.m_cms.readResource(structureId);
                    CmsResource formatterResource = CmsJspStandardContextBean.this.m_cms.readResource(structureId);
                    String formatterSitePath = CmsJspStandardContextBean.this.m_cms.getRequestContext().removeSiteRoot(formatterResource.getRootPath());
                    return formatterSitePath;
                }
                catch (CmsException e) {
                    LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                    return "";
                }
            }
        };
        return CmsCollectionsGenericWrapper.createLazyMap(transformer);
    }

    public Map<String, CmsJspCategoryAccessBean> getReadAllSubCategories() {
        if (null == this.m_allSubCategories) {
            this.m_allSubCategories = CmsCollectionsGenericWrapper.createLazyMap(new Transformer(){

                public Object transform(Object categoryPath) {
                    try {
                        List<CmsCategory> categories = CmsCategoryService.getInstance().readCategories(CmsJspStandardContextBean.this.m_cms, (String)categoryPath, true, CmsJspStandardContextBean.this.m_cms.getRequestContext().getUri());
                        CmsJspCategoryAccessBean result = new CmsJspCategoryAccessBean(categories, (String)categoryPath);
                        return result;
                    }
                    catch (CmsException e) {
                        LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                        return null;
                    }
                }
            });
        }
        return this.m_allSubCategories;
    }

    public CmsJspCategoryAccessBean getReadCategories() {
        return this.getReadResourceCategories().get(this.getRequestContext().getRootUri());
    }

    public Map<String, CmsCategory> getReadCategory() {
        if (null == this.m_categories) {
            this.m_categories = CmsCollectionsGenericWrapper.createLazyMap(new Transformer(){

                public Object transform(Object categoryPath) {
                    try {
                        return CmsCategoryService.getInstance().readCategory(CmsJspStandardContextBean.this.m_cms, (String)categoryPath, CmsJspStandardContextBean.this.getRequestContext().getUri());
                    }
                    catch (CmsException e) {
                        LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                        return null;
                    }
                }
            });
        }
        return this.m_categories;
    }

    public Map<String, List<CmsCategory>> getReadPathCategories() {
        if (null == this.m_pathCategories) {
            this.m_pathCategories = CmsCollectionsGenericWrapper.createLazyMap(new Transformer(){

                public Object transform(Object categoryPath) {
                    ArrayList<CmsCategory> result = new ArrayList<CmsCategory>();
                    String path = (String)categoryPath;
                    if (null == path || path.length() <= 1) {
                        return result;
                    }
                    path = path.substring(0, path.length() - 1);
                    List<String> pathParts = Arrays.asList(path.split("/"));
                    String currentPath = "";
                    for (String part : pathParts) {
                        currentPath = currentPath + part + "/";
                        CmsCategory category = CmsJspStandardContextBean.this.getReadCategory().get(currentPath);
                        if (null == category) continue;
                        result.add(category);
                    }
                    return result;
                }
            });
        }
        return this.m_pathCategories;
    }

    public Map<String, CmsJspCategoryAccessBean> getReadResourceCategories() {
        if (null == this.m_resourceCategories) {
            this.m_resourceCategories = CmsCollectionsGenericWrapper.createLazyMap(new Transformer(){

                public Object transform(Object resourceName) {
                    try {
                        CmsResource resource = CmsJspStandardContextBean.this.m_cms.readResource(CmsJspStandardContextBean.this.getRequestContext().removeSiteRoot((String)resourceName));
                        return new CmsJspCategoryAccessBean(CmsJspStandardContextBean.this.m_cms, resource);
                    }
                    catch (CmsException e) {
                        LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                        return null;
                    }
                }
            });
        }
        return this.m_resourceCategories;
    }

    public String getReloadMarker() {
        if (this.m_cms.getRequestContext().getCurrentProject().isOnlineProject()) {
            return "";
        }
        return "<!--FORMATTER_RELOAD_g3jf9o0n-->";
    }

    public CmsRequestContext getRequestContext() {
        return this.m_cms.getRequestContext();
    }

    public String getSubSitePath() {
        return this.m_cms.getRequestContext().removeSiteRoot(OpenCms.getADEManager().getSubSiteRoot(this.m_cms, this.m_cms.getRequestContext().getRootUri()));
    }

    public CmsSystemInfo getSystemInfo() {
        return OpenCms.getSystemInfo();
    }

    public TemplateBean getTemplate() {
        TemplateBean templateBean = (TemplateBean)this.getRequestAttribute("ATTR_TEMPLATE_BEAN");
        if (templateBean == null) {
            templateBean = new TemplateBean("", "");
        }
        return templateBean;
    }

    public String getTitle() {
        return this.getLocaleSpecificTitle(null);
    }

    public Map<String, String> getTitleLocale() {
        if (this.m_localeTitles == null) {
            this.m_localeTitles = CmsCollectionsGenericWrapper.createLazyMap(new Transformer(){

                public Object transform(Object inputLocale) {
                    Locale locale = null;
                    if (null != inputLocale) {
                        if (inputLocale instanceof Locale) {
                            locale = (Locale)inputLocale;
                        } else if (inputLocale instanceof String) {
                            try {
                                locale = LocaleUtils.toLocale((String)((String)inputLocale));
                            }
                            catch (IllegalArgumentException | NullPointerException runtimeException) {
                                // empty catch block
                            }
                        }
                    }
                    return CmsJspStandardContextBean.this.getLocaleSpecificTitle(locale);
                }
            });
        }
        return this.m_localeTitles;
    }

    public Map<String, String> getTypeDetailPage() {
        if (this.m_typeDetailPage == null) {
            this.m_typeDetailPage = CmsCollectionsGenericWrapper.createLazyMap(new CmsDetailLookupTransformer(""));
        }
        return this.m_typeDetailPage;
    }

    public CmsJspVfsAccessBean getVfs() {
        if (this.m_vfsBean == null) {
            this.m_vfsBean = CmsJspVfsAccessBean.create(this.m_cms);
        }
        return this.m_vfsBean;
    }

    public Locale getWorkplaceLocale() {
        return OpenCms.getWorkplaceManager().getWorkplaceLocale(this.m_cms);
    }

    public boolean isDetailPageAvailable() {
        boolean result = false;
        if (this.m_cms != null && this.m_element != null && !this.m_element.isInMemoryOnly() && this.m_element.getResource() != null) {
            try {
                String detailPage = OpenCms.getADEManager().getDetailPageFinder().getDetailPage(this.m_cms, this.m_element.getResource().getRootPath(), this.m_cms.getRequestContext().getUri(), null);
                result = detailPage != null;
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public boolean isDetailRequest() {
        return this.m_detailContentResource != null;
    }

    public boolean isDragMode() {
        return this.m_isDragMode;
    }

    public boolean isEdited() {
        return this.m_edited;
    }

    public boolean isModelGroupElement() {
        return this.m_element != null && !this.m_element.isInMemoryOnly() && this.isModelGroupPage() && this.m_element.isModelGroup();
    }

    public boolean isModelGroupPage() {
        CmsResource page = this.getContainerPage();
        return page != null && CmsContainerpageService.isEditingModelGroups(this.m_cms, page);
    }

    public void setContainer(CmsContainerBean container) {
        this.m_container = container;
    }

    public void setDetailOnlyPage(CmsContainerPageBean detailOnlyPage) {
        this.m_detailOnlyPage = detailOnlyPage;
        this.clearPageData();
    }

    public void setDragMode(boolean isDragMode) {
        this.m_isDragMode = isDragMode;
    }

    public void setEdited(boolean edited) {
        this.m_edited = edited;
    }

    public void setElement(CmsContainerElementBean element) {
        this.m_element = element;
    }

    public void setPage(CmsContainerPageBean page) {
        this.m_page = page;
        this.clearPageData();
    }

    public void updateCmsObject(CmsObject cms) {
        try {
            this.m_cms = OpenCms.initCmsObject(cms);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            this.m_cms = cms;
        }
    }

    public void updateRequestData(CmsFlexRequest cmsFlexRequest) {
        CmsResource detailRes;
        this.m_detailContentResource = detailRes = CmsDetailPageResourceHandler.getDetailResource((ServletRequest)cmsFlexRequest);
        this.m_request = cmsFlexRequest;
    }

    protected I_CmsFormatterBean getElementFormatter(CmsContainerElementBean element) {
        String formatterConfigId;
        if (this.m_elementInstances == null) {
            this.initPageData();
        }
        I_CmsFormatterBean formatter = null;
        CmsContainerBean container = this.m_parentContainers.get(element.getInstanceId());
        if (container == null) {
            container = this.getContainer();
        }
        String containerName = container.getName();
        Map<String, String> settings = element.getSettings();
        if (settings != null && CmsUUID.isValidUUID(formatterConfigId = settings.get(CmsFormatterConfig.getSettingsKeyForContainer(containerName)))) {
            formatter = OpenCms.getADEManager().getCachedFormatters(false).getFormatters().get(new CmsUUID(formatterConfigId));
        }
        if (formatter == null) {
            try {
                CmsResource resource = this.m_cms.readResource(this.m_cms.getRequestContext().getUri());
                CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(this.m_cms, resource.getRootPath());
                CmsFormatterConfiguration formatters = config.getFormatters(this.m_cms, resource);
                int width = -2;
                try {
                    width = Integer.parseInt(container.getWidth());
                }
                catch (Exception e) {
                    LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                formatter = formatters.getDefaultSchemaFormatter(container.getType(), width);
            }
            catch (CmsException e1) {
                LOG.error((Object)e1.getLocalizedMessage(), (Throwable)e1);
            }
        }
        return formatter;
    }

    protected String getLocaleSpecificTitle(Locale locale) {
        String result = null;
        try {
            CmsResource res;
            CmsFile file;
            CmsXmlContent content;
            if (this.isDetailRequest() && (result = (content = CmsXmlContentFactory.unmarshal(this.m_cms, file = this.m_cms.readFile(res = this.getDetailContent()))).getHandler().getTitleMapping(this.m_cms, content, this.m_cms.getRequestContext().getLocale())) == null) {
                result = this.m_cms.readPropertyObject(res, "Title", false, locale).getValue();
            }
            if (result == null) {
                result = this.m_cms.readPropertyObject(this.m_cms.getRequestContext().getUri(), "Title", true, locale).getValue();
            }
        }
        catch (CmsException e) {
            LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(result)) {
            result = "";
        }
        return result;
    }

    protected CmsContainerElementBean getParentElement(CmsContainerElementBean element) {
        if (this.m_elementInstances == null) {
            this.initPageData();
        }
        CmsContainerElementBean parent = null;
        CmsContainerBean cont = this.m_parentContainers.get(element.getInstanceId());
        if (cont != null && cont.isNestedContainer()) {
            parent = this.m_elementInstances.get(cont.getParentInstanceId());
        }
        return parent;
    }

    protected CmsDynamicFunctionBean readDynamicFunctionBean(String configuredName) throws CmsException {
        CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(this.m_cms, this.m_cms.addSiteRoot(this.m_cms.getRequestContext().getUri()));
        CmsFunctionReference functionRef = config.getFunctionReference(configuredName);
        if (functionRef == null) {
            return null;
        }
        CmsDynamicFunctionParser parser = new CmsDynamicFunctionParser();
        CmsResource functionResource = this.m_cms.readResource(functionRef.getStructureId());
        CmsDynamicFunctionBean result = parser.parseFunctionBean(this.m_cms, functionResource);
        return result;
    }

    private void clearPageData() {
        this.m_elementInstances = null;
        this.m_parentContainers = null;
    }

    private CmsResource getContainerPage() {
        try {
            if (this.m_pageResource == null) {
                this.m_pageResource = (CmsResource)((Object)CmsHistoryResourceHandler.getHistoryResource(this.m_request));
                if (this.m_pageResource == null) {
                    this.m_pageResource = this.m_cms.readResource(this.m_cms.getRequestContext().getUri());
                }
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return this.m_pageResource;
    }

    private <A> A getRequestAttribute(String name) {
        Object attribute = this.m_request.getAttribute(name);
        return (A)(attribute != null ? attribute : null);
    }

    private CmsJspResourceWrapper getResourceWrapperForPage() {
        if (this.m_resourceWrapper != null) {
            return this.m_resourceWrapper;
        }
        this.m_resourceWrapper = new CmsJspResourceWrapper(this.m_cms, this.getContainerPage());
        return this.m_resourceWrapper;
    }

    private void initPageData() {
        this.m_elementInstances = new HashMap<String, CmsContainerElementBean>();
        this.m_parentContainers = new HashMap<String, CmsContainerBean>();
        if (this.m_page != null) {
            for (CmsContainerBean container : this.m_page.getContainers().values()) {
                for (CmsContainerElementBean element : container.getElements()) {
                    this.m_elementInstances.put(element.getInstanceId(), element);
                    this.m_parentContainers.put(element.getInstanceId(), container);
                    try {
                        if (!element.isGroupContainer(this.m_cms) && !element.isInheritedContainer(this.m_cms)) continue;
                        List<CmsContainerElementBean> children = element.isGroupContainer(this.m_cms) ? CmsJspTagContainer.getGroupContainerElements(this.m_cms, element, this.m_request, container.getType()) : CmsJspTagContainer.getInheritedContainerElements(this.m_cms, element);
                        for (CmsContainerElementBean childElement : children) {
                            this.m_elementInstances.put(childElement.getInstanceId(), childElement);
                            this.m_parentContainers.put(childElement.getInstanceId(), container);
                        }
                    }
                    catch (CmsException e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
            if (this.m_detailOnlyPage != null) {
                for (CmsContainerBean container : this.m_detailOnlyPage.getContainers().values()) {
                    for (CmsContainerElementBean element : container.getElements()) {
                        this.m_elementInstances.put(element.getInstanceId(), element);
                        this.m_parentContainers.put(element.getInstanceId(), container);
                    }
                }
            }
        }
    }

    public static class TemplateBean {
        private boolean m_forced;
        private String m_name;
        private CmsResource m_resource;
        private String m_uri;

        public TemplateBean(String name, CmsResource resource) {
            this.m_resource = resource;
            this.m_name = name;
        }

        public TemplateBean(String name, String uri) {
            this.m_name = name;
            this.m_uri = uri;
        }

        public String getName() {
            return this.m_name;
        }

        public CmsResource getResource() {
            return this.m_resource;
        }

        public String getUri() {
            if (this.m_resource != null) {
                return this.m_resource.getRootPath();
            }
            return this.m_uri;
        }

        public boolean isForced() {
            return this.m_forced;
        }

        public void setForced(boolean forced) {
            this.m_forced = forced;
        }
    }

    public class SettingsTransformer
    implements Transformer {
        private I_CmsFormatterBean m_formatter;
        private CmsContainerElementBean m_transformElement;

        SettingsTransformer(CmsContainerElementBean element) {
            this.m_transformElement = element;
            this.m_formatter = CmsJspStandardContextBean.this.getElementFormatter(element);
        }

        public Object transform(Object arg0) {
            return new ElementSettingWrapper(this.m_transformElement.getSettings().get(arg0), this.m_formatter != null ? this.m_formatter.getSettings().get(arg0) != null : this.m_transformElement.getSettings().get(arg0) != null);
        }
    }

    public class ElementSettingWrapper
    extends A_CmsJspValueWrapper {
        private boolean m_exists;
        private String m_value;

        ElementSettingWrapper(String value, boolean exists) {
            this.m_value = value;
            this.m_exists = exists;
        }

        @Override
        public boolean getExists() {
            return this.m_exists;
        }

        @Override
        public boolean getIsEmpty() {
            return CmsStringUtil.isEmpty(this.m_value);
        }

        @Override
        public boolean getIsEmptyOrWhitespaceOnly() {
            return CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_value);
        }

        @Override
        public boolean getIsSet() {
            return this.getExists() && !this.getIsEmpty();
        }

        public String getValue() {
            return this.m_value;
        }

        public String toString() {
            return this.m_value != null ? this.m_value : "";
        }
    }

    public class CmsDetailLookupTransformer
    implements Transformer {
        private String m_prefix;

        public CmsDetailLookupTransformer(String prefix) {
            this.m_prefix = prefix;
        }

        public Object transform(Object input) {
            String type = this.m_prefix + String.valueOf(input);
            CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(CmsJspStandardContextBean.this.m_cms, CmsJspStandardContextBean.this.m_cms.addSiteRoot(CmsJspStandardContextBean.this.m_cms.getRequestContext().getUri()));
            List<CmsDetailPageInfo> detailPages = config.getDetailPagesForType(type);
            if (detailPages == null || detailPages.size() == 0) {
                return "[No detail page configured for type =" + type + "=]";
            }
            CmsDetailPageInfo mainDetailPage = detailPages.get(0);
            CmsUUID id = mainDetailPage.getId();
            try {
                CmsResource r = CmsJspStandardContextBean.this.m_cms.readResource(id);
                return OpenCms.getLinkManager().substituteLink(CmsJspStandardContextBean.this.m_cms, r);
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                return "[Error reading detail page for type =" + type + "=]";
            }
        }
    }

    public class CmsContainerElementWrapper
    extends CmsContainerElementBean {
        private CmsContainerElementBean m_wrappedElement;

        protected CmsContainerElementWrapper(CmsContainerElementBean element) {
            this.m_wrappedElement = element;
        }

        @Override
        public CmsContainerElementBean clone() {
            return this.m_wrappedElement.clone();
        }

        @Override
        public String editorHash() {
            return this.m_wrappedElement.editorHash();
        }

        @Override
        public boolean equals(Object obj) {
            return this.m_wrappedElement.equals(obj);
        }

        @Override
        public CmsUUID getFormatterId() {
            return this.m_wrappedElement.getFormatterId();
        }

        @Override
        public CmsUUID getId() {
            return this.m_wrappedElement.getId();
        }

        @Override
        public Map<String, String> getIndividualSettings() {
            return this.m_wrappedElement.getIndividualSettings();
        }

        @Override
        public CmsInheritanceInfo getInheritanceInfo() {
            return this.m_wrappedElement.getInheritanceInfo();
        }

        @Override
        public String getInstanceId() {
            return this.m_wrappedElement.getInstanceId();
        }

        public CmsContainerElementWrapper getParent() {
            CmsContainerElementBean parent = CmsJspStandardContextBean.this.getParentElement(this.m_wrappedElement);
            return parent != null ? new CmsContainerElementWrapper(CmsJspStandardContextBean.this.getParentElement(this.m_wrappedElement)) : null;
        }

        @Override
        public CmsResource getResource() {
            return this.m_wrappedElement.getResource();
        }

        public String getResourceTypeName() {
            String result = "";
            try {
                result = OpenCms.getResourceManager().getResourceType(this.m_wrappedElement.getResource()).getTypeName();
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            return result;
        }

        public Map<String, ElementSettingWrapper> getSetting() {
            return CmsCollectionsGenericWrapper.createLazyMap(new SettingsTransformer(this.m_wrappedElement));
        }

        @Override
        public Map<String, String> getSettings() {
            return this.m_wrappedElement.getSettings();
        }

        @Override
        public String getSitePath() {
            return this.m_wrappedElement.getSitePath();
        }

        @Override
        public int hashCode() {
            return this.m_wrappedElement.hashCode();
        }

        @Override
        public void initResource(CmsObject cms) throws CmsException {
            this.m_wrappedElement.initResource(cms);
        }

        @Override
        public void initSettings(CmsObject cms, I_CmsFormatterBean formatterBean) {
            this.m_wrappedElement.initSettings(cms, formatterBean);
        }

        @Override
        public boolean isCreateNew() {
            return this.m_wrappedElement.isCreateNew();
        }

        @Override
        public boolean isGroupContainer(CmsObject cms) throws CmsException {
            return this.m_wrappedElement.isGroupContainer(cms);
        }

        @Override
        public boolean isInheritedContainer(CmsObject cms) throws CmsException {
            return this.m_wrappedElement.isInheritedContainer(cms);
        }

        @Override
        public boolean isInMemoryOnly() {
            return this.m_wrappedElement.isInMemoryOnly();
        }

        @Override
        public boolean isReleasedAndNotExpired() {
            return this.m_wrappedElement.isReleasedAndNotExpired();
        }

        @Override
        public boolean isTemporaryContent() {
            return this.m_wrappedElement.isTemporaryContent();
        }

        @Override
        public void removeInstanceId() {
            this.m_wrappedElement.removeInstanceId();
        }

        @Override
        public void setFormatterId(CmsUUID formatterId) {
            this.m_wrappedElement.setFormatterId(formatterId);
        }

        @Override
        public void setHistoryFile(CmsFile file) {
            this.m_wrappedElement.setHistoryFile(file);
        }

        @Override
        public void setInheritanceInfo(CmsInheritanceInfo inheritanceInfo) {
            this.m_wrappedElement.setInheritanceInfo(inheritanceInfo);
        }

        @Override
        public void setTemporaryFile(CmsFile elementFile) {
            this.m_wrappedElement.setTemporaryFile(elementFile);
        }

        @Override
        public String toString() {
            return this.m_wrappedElement.toString();
        }
    }
}

