/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.mail;

import org.apache.commons.logging.Log;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.opencms.mail.CmsMailHost;
import org.opencms.mail.Messages;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;

public final class CmsMailUtil {
    private static final Log LOG = CmsLog.getLog(CmsMailUtil.class);
    public static final String SECURITY_SSL = "SSL";
    public static final String SECURITY_STARTTLS = "STARTTLS";

    private CmsMailUtil() {
    }

    public static void configureMail(CmsMailHost host, Email mail) {
        String security;
        mail.setHostName(host.getHostname());
        mail.setSmtpPort(host.getPort());
        String userName = host.getUsername();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(userName)) {
            mail.setAuthentication(userName, host.getPassword());
        }
        String string = security = host.getSecurity() != null ? host.getSecurity().trim() : null;
        if (SECURITY_SSL.equalsIgnoreCase(security)) {
            mail.setSslSmtpPort("" + host.getPort());
            mail.setSSLOnConnect(true);
        } else if (SECURITY_STARTTLS.equalsIgnoreCase(security)) {
            mail.setStartTLSEnabled(true);
        }
        try {
            mail.setFrom(OpenCms.getSystemInfo().getMailSettings().getMailFromDefault());
        }
        catch (EmailException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_INVALID_SENDER_ADDRESS_0"), (Throwable)e);
        }
    }
}

