/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.helpers.Loader;

public final class CmsLog {
    public static final String FILE_LOG = "opencms.log";
    public static final String FOLDER_LOGS = "logs" + File.separatorChar;
    public static Log INIT;
    private static String m_logFileRfsFolder;
    private static String m_logFileRfsPath;

    private CmsLog() {
    }

    public static Log getLog(Object obj) {
        if (obj instanceof String) {
            return LogFactory.getLog((String)((String)obj));
        }
        if (obj instanceof Class) {
            return LogFactory.getLog((Class)((Class)obj));
        }
        return LogFactory.getLog(obj.getClass());
    }

    protected static String getLogFileRfsPath() {
        return m_logFileRfsPath;
    }

    private static File getFileForURL(URL url) {
        File result;
        try {
            result = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            result = new File(url.getPath());
        }
        return result;
    }

    static {
        try {
            URL url = Loader.getResource((String)"log4j.properties");
            if (url != null) {
                ExtendedProperties configuration;
                boolean setLogFile;
                File log4jProps = new File(URLDecoder.decode(url.getPath(), Charset.defaultCharset().name()));
                String path = log4jProps.getAbsolutePath();
                String webInfPath = log4jProps.getParent();
                String tldFilePath = (webInfPath = webInfPath.substring(0, webInfPath.lastIndexOf(File.separatorChar) + 1)) + "opencms.tld";
                File tldFile = new File(tldFilePath);
                if (tldFile.exists() && (setLogFile = (configuration = new ExtendedProperties(path)).getBoolean("opencms.set.logfile", false))) {
                    String logFilePath = webInfPath + FOLDER_LOGS + FILE_LOG;
                    File logFile = new File(logFilePath);
                    m_logFileRfsPath = logFile.getAbsolutePath();
                    m_logFileRfsFolder = logFile.getParent() + File.separatorChar;
                    System.setProperty("opencms.logfile", m_logFileRfsPath);
                    System.setProperty("opencms.logfolder", m_logFileRfsFolder);
                    PropertyConfigurator.configure((String)path);
                }
                INIT = LogFactory.getLog((String)"org.opencms.init");
                INIT.info((Object)(". Log4j config file    : " + path));
            }
        }
        catch (SecurityException e) {
            e.printStackTrace(System.err);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

