/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.module;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.configuration.CmsConfigurationManager;
import org.opencms.configuration.CmsModuleConfiguration;
import org.opencms.db.CmsExportPoint;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.lock.CmsLock;
import org.opencms.lock.CmsLockException;
import org.opencms.lock.CmsLockFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsIllegalStateException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.module.CmsModuleDependency;
import org.opencms.module.CmsModuleImportExportHandler;
import org.opencms.module.CmsModuleImportExportRepository;
import org.opencms.module.I_CmsModuleAction;
import org.opencms.module.Messages;
import org.opencms.report.I_CmsReport;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.security.CmsSecurityException;
import org.opencms.util.CmsStringUtil;

public class CmsModuleManager {
    public static final int DEPENDENCY_MODE_DELETE = 0;
    public static final int DEPENDENCY_MODE_IMPORT = 1;
    private static final Log LOG = CmsLog.getLog(CmsModuleManager.class);
    private CmsModuleImportExportRepository m_importExportRepository = new CmsModuleImportExportRepository();
    private Set<CmsExportPoint> m_moduleExportPoints;
    private Map<String, CmsModule> m_modules;

    public CmsModuleManager(List<CmsModule> configuredModules) {
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_MOD_MANAGER_CREATED_0"));
        }
        this.m_modules = new Hashtable<String, CmsModule>();
        for (int i = 0; i < configuredModules.size(); ++i) {
            CmsModule module = configuredModules.get(i);
            this.m_modules.put(module.getName(), module);
            if (!CmsLog.INIT.isInfoEnabled()) continue;
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_MOD_CONFIGURED_1", module.getName()));
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_NUM_MODS_CONFIGURED_1", new Integer(this.m_modules.size())));
        }
        this.m_moduleExportPoints = Collections.emptySet();
    }

    public static Map<String, List<String>> buildDepsForAllModules(String rfsAbsPath, boolean mode) throws CmsConfigurationException {
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
        List<CmsModule> modules = rfsAbsPath == null ? OpenCms.getModuleManager().getAllInstalledModules() : new ArrayList<CmsModule>(CmsModuleManager.getAllModulesFromPath(rfsAbsPath).keySet());
        for (CmsModule module : modules) {
            for (CmsModuleDependency dependency : module.getDependencies()) {
                List<String> moduleDependencies;
                String moduleDependencyName = dependency.getName();
                if (mode) {
                    moduleDependencies = (ArrayList<String>)ret.get(moduleDependencyName);
                    if (moduleDependencies == null) {
                        moduleDependencies = new ArrayList<String>();
                        ret.put(moduleDependencyName, moduleDependencies);
                    }
                    moduleDependencies.add(module.getName());
                    continue;
                }
                moduleDependencies = (List)ret.get(module.getName());
                if (moduleDependencies == null) {
                    moduleDependencies = new ArrayList();
                    ret.put(module.getName(), moduleDependencies);
                }
                moduleDependencies.add(dependency.getName());
            }
        }
        for (CmsModule module : modules) {
            if (ret.get(module.getName()) != null) continue;
            ret.put(module.getName(), new ArrayList());
        }
        return ret;
    }

    public static Map<String, List<String>> buildDepsForModulelist(List<String> moduleNames, String rfsAbsPath, boolean mode) throws CmsConfigurationException {
        Map<String, List<String>> ret = CmsModuleManager.buildDepsForAllModules(rfsAbsPath, mode);
        Iterator<CmsModule> itMods = rfsAbsPath == null ? OpenCms.getModuleManager().getAllInstalledModules().iterator() : CmsModuleManager.getAllModulesFromPath(rfsAbsPath).keySet().iterator();
        while (itMods.hasNext()) {
            CmsModule module = itMods.next();
            if (moduleNames.contains(module.getName())) continue;
            for (List<String> dependencies : ret.values()) {
                dependencies.remove(module.getName());
            }
            ret.remove(module.getName());
        }
        return ret;
    }

    public static Map<CmsModule, String> getAllModulesFromPath(String rfsAbsPath) throws CmsConfigurationException {
        File[] folderFiles;
        HashMap<CmsModule, String> modules = new HashMap<CmsModule, String>();
        if (rfsAbsPath == null) {
            return modules;
        }
        File folder = new File(rfsAbsPath);
        if (folder.exists() && (folderFiles = folder.listFiles()) != null) {
            for (int i = 0; i < folderFiles.length; ++i) {
                File manifest;
                File moduleFile = folderFiles[i];
                if (moduleFile.isFile() && !moduleFile.getAbsolutePath().toLowerCase().endsWith(".zip") || moduleFile.isDirectory() && (!(manifest = new File(moduleFile, "manifest.xml")).exists() || !manifest.canRead())) continue;
                modules.put(CmsModuleImportExportHandler.readModuleFromImport(moduleFile.getAbsolutePath()), moduleFile.getName());
            }
        }
        return modules;
    }

    public static List<String> topologicalSort(List<String> moduleNames, String rfsAbsPath) throws CmsConfigurationException {
        ArrayList<String> modules = new ArrayList<String>(moduleNames);
        ArrayList<String> retList = new ArrayList<String>();
        Map<String, List<String>> moduleDependencies = CmsModuleManager.buildDepsForModulelist(moduleNames, rfsAbsPath, true);
        boolean finished = false;
        while (!finished) {
            finished = true;
            Iterator itMods = modules.iterator();
            while (itMods.hasNext()) {
                String moduleName = (String)itMods.next();
                List<String> deps = moduleDependencies.get(moduleName);
                if (deps != null && !deps.isEmpty()) continue;
                retList.add(moduleName);
                for (List<String> dependencies : moduleDependencies.values()) {
                    dependencies.remove(moduleName);
                }
                finished = false;
                itMods.remove();
            }
        }
        if (!modules.isEmpty()) {
            throw new CmsIllegalStateException(Messages.get().container("ERR_MODULE_DEPENDENCY_CYCLE_1", ((Object)modules).toString()));
        }
        Collections.reverse(retList);
        return retList;
    }

    public synchronized void addModule(CmsObject cms, CmsModule module) throws CmsSecurityException, CmsConfigurationException {
        OpenCms.getRoleManager().checkRole(cms, CmsRole.DATABASE_MANAGER);
        if (this.m_modules.containsKey(module.getName())) {
            throw new CmsConfigurationException(Messages.get().container("ERR_MODULE_ALREADY_CONFIGURED_1", module.getName()));
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_CREATE_NEW_MOD_1", module.getName()));
        }
        module.initialize(cms);
        this.m_modules.put(module.getName(), module);
        try {
            I_CmsModuleAction moduleAction = module.getActionInstance();
            if (moduleAction != null) {
                moduleAction.moduleUpdate(module);
            }
        }
        catch (Throwable t) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_MOD_UPDATE_ERR_1", module.getName()), t);
        }
        this.initModuleExportPoints();
        this.updateModuleConfiguration();
    }

    public List<CmsModuleDependency> checkDependencies(CmsModule module, int mode) {
        ArrayList<CmsModuleDependency> result = new ArrayList<CmsModuleDependency>();
        if (mode == 0) {
            for (CmsModule otherModule : this.m_modules.values()) {
                CmsModuleDependency dependency = otherModule.checkDependency(module);
                if (dependency == null) continue;
                result.add(new CmsModuleDependency(otherModule.getName(), otherModule.getVersion()));
            }
        } else if (mode == 1) {
            Iterator<CmsModule> i = this.m_modules.values().iterator();
            result.addAll(module.getDependencies());
            while (i.hasNext() && result.size() > 0) {
                CmsModule otherModule = i.next();
                CmsModuleDependency dependency = module.checkDependency(otherModule);
                if (dependency == null) continue;
                result.remove(dependency);
            }
        } else {
            throw new CmsRuntimeException(Messages.get().container("ERR_CHECK_DEPENDENCY_INVALID_MODE_1", new Integer(mode)));
        }
        return result;
    }

    public void checkModuleSelectionList(List<String> moduleNames, String rfsAbsPath, boolean forDeletion) throws CmsIllegalArgumentException, CmsConfigurationException {
        Map<String, List<String>> moduleDependencies = CmsModuleManager.buildDepsForAllModules(rfsAbsPath, forDeletion);
        for (String moduleName : moduleNames) {
            List<String> dependencies = moduleDependencies.get(moduleName);
            if (dependencies == null) continue;
            ArrayList<String> depModules = new ArrayList<String>(dependencies);
            depModules.removeAll(moduleNames);
            if (depModules.isEmpty()) continue;
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_MODULE_SELECTION_INCONSISTENT_2", moduleName, ((Object)depModules).toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteModule(CmsObject cms, String moduleName, boolean replace, boolean preserveLibs, I_CmsReport report) throws CmsRoleViolationException, CmsConfigurationException, CmsLockException {
        CmsProject deleteProject;
        CmsProject previousProject;
        boolean removeResourceTypes;
        CmsModule module;
        block45: {
            String importSite;
            OpenCms.getRoleManager().checkRole(cms, CmsRole.DATABASE_MANAGER);
            if (!this.m_modules.containsKey(moduleName)) {
                throw new CmsConfigurationException(Messages.get().container("ERR_MODULE_NOT_CONFIGURED_1", moduleName));
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)Messages.get().getBundle().key("LOG_DEL_MOD_1", moduleName));
            }
            if (!CmsStringUtil.isEmptyOrWhitespaceOnly(importSite = (module = this.m_modules.get(moduleName)).getImportSite())) {
                try {
                    CmsObject newCms = OpenCms.initCmsObject(cms);
                    newCms.getRequestContext().setSiteRoot(importSite);
                    cms = newCms;
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (!replace) {
                List<CmsModuleDependency> dependencies = this.checkDependencies(module, 0);
                if (!dependencies.isEmpty()) {
                    StringBuffer message = new StringBuffer();
                    Iterator<CmsModuleDependency> it = dependencies.iterator();
                    while (it.hasNext()) {
                        message.append("  ").append(it.next().getName()).append("\r\n");
                    }
                    throw new CmsConfigurationException(Messages.get().container("ERR_MOD_DEPENDENCIES_2", moduleName, message.toString()));
                }
                try {
                    I_CmsModuleAction moduleAction = module.getActionInstance();
                    if (moduleAction != null) {
                        moduleAction.moduleUninstall(module);
                    }
                }
                catch (Throwable t) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_MOD_UNINSTALL_ERR_1", moduleName), t);
                    report.println(Messages.get().container("LOG_MOD_UNINSTALL_ERR_1", moduleName), 1);
                }
            }
            boolean bl = removeResourceTypes = !module.getResourceTypes().isEmpty();
            if (removeResourceTypes) {
                OpenCms.getWorkplaceManager().removeExplorerTypeSettings(module);
            }
            previousProject = cms.getRequestContext().getCurrentProject();
            deleteProject = null;
            try {
                deleteProject = cms.readProject(Messages.get().getBundle(cms.getRequestContext().getLocale()).key("GUI_DELETE_MODULE_PROJECT_NAME_1", new Object[]{moduleName}));
            }
            catch (CmsException e) {
                try {
                    deleteProject = cms.createProject(Messages.get().getBundle(cms.getRequestContext().getLocale()).key("GUI_DELETE_MODULE_PROJECT_NAME_1", new Object[]{moduleName}), Messages.get().getBundle(cms.getRequestContext().getLocale()).key("GUI_DELETE_MODULE_PROJECT_DESC_1", new Object[]{moduleName}), OpenCms.getDefaultUsers().getGroupAdministrators(), OpenCms.getDefaultUsers().getGroupAdministrators(), CmsProject.PROJECT_TYPE_TEMPORARY);
                }
                catch (CmsException e1) {
                    throw new CmsConfigurationException(e1.getMessageContainer(), (Throwable)e1);
                }
            }
            try {
                cms.getRequestContext().setCurrentProject(deleteProject);
                ArrayList<String> lockedResources = new ArrayList<String>();
                CmsLockFilter filter1 = CmsLockFilter.FILTER_ALL.filterNotLockableByUser(cms.getRequestContext().getCurrentUser());
                CmsLockFilter filter2 = CmsLockFilter.FILTER_INHERITED;
                List<String> moduleResources = module.getResources();
                for (int iLock = 0; iLock < moduleResources.size(); ++iLock) {
                    String resourceName = moduleResources.get(iLock);
                    try {
                        lockedResources.addAll(cms.getLockedResources(resourceName, filter1));
                        lockedResources.addAll(cms.getLockedResources(resourceName, filter2));
                        continue;
                    }
                    catch (CmsException e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)e.getMessageContainer(), (Throwable)e);
                        }
                        report.println(e.getMessageContainer(), 1);
                    }
                }
                if (lockedResources.isEmpty()) break block45;
                CmsMessageContainer msg = Messages.get().container("ERR_DELETE_MODULE_CHECK_LOCKS_2", moduleName, CmsStringUtil.collectionAsString(lockedResources, ","));
                report.addError(msg.key(cms.getRequestContext().getLocale()));
                report.println(msg);
                cms.getRequestContext().setCurrentProject(previousProject);
                try {
                    cms.deleteProject(deleteProject.getUuid());
                }
                catch (CmsException e1) {
                    throw new CmsConfigurationException(e1.getMessageContainer(), (Throwable)e1);
                }
                throw new CmsLockException(msg);
            }
            finally {
                cms.getRequestContext().setCurrentProject(previousProject);
            }
        }
        module = this.m_modules.remove(moduleName);
        if (preserveLibs) {
            HashSet<CmsExportPoint> exportPoints = new HashSet<CmsExportPoint>(this.m_moduleExportPoints);
            Iterator it = exportPoints.iterator();
            while (it.hasNext()) {
                CmsExportPoint point = (CmsExportPoint)it.next();
                if (!point.getUri().endsWith(module.getName() + "/lib/") && !point.getUri().endsWith(module.getName() + "/lib") || !point.getConfiguredDestination().equals("WEB-INF/lib/")) continue;
                it.remove();
            }
            this.m_moduleExportPoints = Collections.unmodifiableSet(exportPoints);
        }
        try {
            cms.getRequestContext().setCurrentProject(deleteProject);
            List<CmsResource> moduleResources = CmsModule.calculateModuleResources(cms, module);
            for (CmsResource resource : moduleResources) {
                try {
                    cms.copyResourceToProject(resource);
                }
                catch (CmsException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_MOVE_RESOURCE_FAILED_1", cms.getSitePath(resource)));
                    }
                    report.println(e.getMessageContainer(), 1);
                }
            }
            report.print(Messages.get().container("RPT_DELETE_MODULE_BEGIN_0"), 2);
            report.println(org.opencms.report.Messages.get().container("RPT_ARGUMENT_HTML_ITAG_1", moduleName), 2);
            for (CmsResource resource : moduleResources) {
                String sitePath = cms.getSitePath(resource);
                try {
                    CmsLock lock;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_DEL_MOD_RESOURCE_1", sitePath));
                    }
                    if ((lock = cms.getLock(resource)).isUnlocked()) {
                        cms.lockResource(resource);
                    } else if (lock.isLockableBy(cms.getRequestContext().getCurrentUser())) {
                        cms.changeLock(resource);
                    }
                    if (!resource.getState().isDeleted()) {
                        cms.deleteResource(sitePath, CmsResource.DELETE_PRESERVE_SIBLINGS);
                    }
                    report.print(Messages.get().container("RPT_DELETE_0"), 3);
                    report.println(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", sitePath));
                    if (resource.getState().isNew()) continue;
                    cms.unlockResource(resource);
                }
                catch (CmsException e) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_DEL_MOD_EXC_1", sitePath), (Throwable)e);
                    report.println(e.getMessageContainer(), 1);
                }
            }
            report.println(Messages.get().container("RPT_PUBLISH_PROJECT_BEGIN_0"), 2);
            cms.unlockProject(deleteProject.getUuid());
            OpenCms.getPublishManager().publishProject(cms, report);
            OpenCms.getPublishManager().waitWhileRunning();
            report.println(Messages.get().container("RPT_PUBLISH_PROJECT_END_0"), 2);
            report.println(Messages.get().container("RPT_DELETE_MODULE_END_0"), 2);
        }
        catch (CmsException e) {
            throw new CmsConfigurationException(e.getMessageContainer(), (Throwable)e);
        }
        finally {
            cms.getRequestContext().setCurrentProject(previousProject);
        }
        this.initModuleExportPoints();
        this.updateModuleConfiguration();
        if (removeResourceTypes) {
            OpenCms.getResourceManager().initialize(cms);
        }
    }

    public synchronized void deleteModule(CmsObject cms, String moduleName, boolean replace, I_CmsReport report) throws CmsRoleViolationException, CmsConfigurationException, CmsLockException {
        this.deleteModule(cms, moduleName, replace, false, report);
    }

    public List<CmsModule> getAllInstalledModules() {
        return new ArrayList<CmsModule>(this.m_modules.values());
    }

    public Set<CmsExportPoint> getExportPoints() {
        return this.m_moduleExportPoints;
    }

    public CmsModuleImportExportRepository getImportExportRepository() {
        return this.m_importExportRepository;
    }

    public CmsModule getModule(String name) {
        return this.m_modules.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getModuleNames() {
        Map<String, CmsModule> map = this.m_modules;
        synchronized (map) {
            return new HashSet<String>(this.m_modules.keySet());
        }
    }

    public boolean hasModule(String name) {
        return this.m_modules.containsKey(name);
    }

    public synchronized void initialize(CmsObject cms, CmsConfigurationManager configurationManager) throws CmsRoleViolationException {
        if (OpenCms.getRunLevel() > 1) {
            OpenCms.getRoleManager().checkRole(cms, CmsRole.DATABASE_MANAGER);
        }
        int count = 0;
        Iterator<String> it = this.m_modules.keySet().iterator();
        while (it.hasNext()) {
            CmsModule module = this.m_modules.get(it.next());
            if (module.getActionClass() == null) continue;
            I_CmsModuleAction moduleAction = module.getActionInstance();
            if (module.getActionClass() != null) {
                try {
                    moduleAction = (I_CmsModuleAction)Class.forName(module.getActionClass()).newInstance();
                }
                catch (Exception e) {
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_CREATE_INSTANCE_FAILED_1", module.getName()), (Throwable)e);
                }
            }
            if (moduleAction == null) continue;
            ++count;
            module.setActionInstance(moduleAction);
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_INITIALIZE_MOD_CLASS_1", moduleAction.getClass().getName()));
            }
            try {
                CmsObject adminCmsCopy = OpenCms.initCmsObject(cms);
                moduleAction.initialize(adminCmsCopy, configurationManager, module);
            }
            catch (Throwable t) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_INSTANCE_INIT_ERR_1", moduleAction.getClass().getName()), t);
            }
        }
        this.initModuleExportPoints();
        this.m_importExportRepository.initialize(cms);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_NUM_CLASSES_INITIALIZED_1", new Integer(count)));
        }
    }

    public synchronized void shutDown() {
        int count = 0;
        for (String moduleName : this.getModuleNames()) {
            I_CmsModuleAction moduleAction;
            CmsModule module = this.m_modules.get(moduleName);
            if (module == null || (moduleAction = module.getActionInstance()) == null) continue;
            ++count;
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SHUTDOWN_MOD_CLASS_1", moduleAction.getClass().getName()));
            }
            try {
                moduleAction.shutDown(module);
            }
            catch (Throwable t) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_INSTANCE_SHUTDOWN_ERR_1", moduleAction.getClass().getName()), t);
            }
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SHUTDOWN_NUM_MOD_CLASSES_1", new Integer(count)));
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SHUTDOWN_1", this.getClass().getName()));
        }
    }

    public synchronized void updateModule(CmsObject cms, CmsModule module) throws CmsRoleViolationException, CmsConfigurationException {
        OpenCms.getRoleManager().checkRole(cms, CmsRole.DATABASE_MANAGER);
        CmsModule oldModule = this.m_modules.get(module.getName());
        if (oldModule == null) {
            throw new CmsConfigurationException(Messages.get().container("ERR_OLD_MOD_ERR_1", module.getName()));
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_MOD_UPDATE_1", module.getName()));
        }
        module.getVersion().setUpdated(true);
        module.initialize(cms);
        this.m_modules.put(module.getName(), module);
        try {
            I_CmsModuleAction moduleAction = oldModule.getActionInstance();
            if (moduleAction != null) {
                moduleAction.moduleUpdate(module);
                module.setActionInstance(moduleAction);
            }
        }
        catch (Throwable t) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_INSTANCE_UPDATE_ERR_1", module.getName()), t);
        }
        this.initModuleExportPoints();
        this.updateModuleConfiguration();
    }

    private synchronized void initModuleExportPoints() {
        HashSet<CmsExportPoint> exportPoints = new HashSet<CmsExportPoint>();
        for (CmsModule module : this.m_modules.values()) {
            List<CmsExportPoint> moduleExportPoints = module.getExportPoints();
            for (int j = 0; j < moduleExportPoints.size(); ++j) {
                CmsExportPoint point = moduleExportPoints.get(j);
                if (exportPoints.contains(point)) {
                    if (!LOG.isWarnEnabled()) continue;
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_DUPLICATE_EXPORT_POINT_2", point, module.getName()));
                    continue;
                }
                exportPoints.add(point);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_ADD_EXPORT_POINT_2", point, module.getName()));
            }
        }
        this.m_moduleExportPoints = Collections.unmodifiableSet(exportPoints);
    }

    private void updateModuleConfiguration() {
        OpenCms.writeConfiguration(CmsModuleConfiguration.class);
    }
}

