/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.notification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.mail.EmailException;
import org.opencms.db.CmsDbEntryNotFoundException;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.notification.CmsContentNotification;
import org.opencms.notification.CmsExtendedNotificationCause;
import org.opencms.notification.Messages;
import org.opencms.util.CmsStringUtil;

public class CmsNotificationCandidates {
    private static final Log LOG = CmsLog.getLog(CmsNotificationCandidates.class);
    private CmsObject m_cms;
    private List<CmsExtendedNotificationCause> m_resources = new ArrayList<CmsExtendedNotificationCause>();

    public CmsNotificationCandidates(CmsObject cms) throws CmsException {
        this.m_cms = cms;
        this.m_cms.getRequestContext().setCurrentProject(this.m_cms.readProject(OpenCms.getSystemInfo().getNotificationProject()));
        String folder = "/";
        GregorianCalendar now = new GregorianCalendar(TimeZone.getDefault(), CmsLocaleManager.getDefaultLocale());
        now.setTimeInMillis(System.currentTimeMillis());
        GregorianCalendar inOneWeek = (GregorianCalendar)now.clone();
        inOneWeek.add(3, 1);
        try {
            for (CmsResource resource : this.m_cms.readResourcesWithProperty(folder, "notification-interval")) {
                int notification_interval = Integer.parseInt(this.m_cms.readPropertyObject(resource, "notification-interval", true).getValue());
                GregorianCalendar intervalBefore = new GregorianCalendar(TimeZone.getDefault(), CmsLocaleManager.getDefaultLocale());
                intervalBefore.setTimeInMillis(resource.getDateLastModified());
                intervalBefore.add(6, notification_interval);
                GregorianCalendar intervalAfter = (GregorianCalendar)intervalBefore.clone();
                intervalAfter.add(3, -1);
                for (int i = 0; i < 100 && intervalAfter.getTime().before(now.getTime()); ++i) {
                    if (intervalBefore.getTime().after(now.getTime())) {
                        this.m_resources.add(new CmsExtendedNotificationCause(resource, 2, intervalBefore.getTime()));
                    }
                    intervalBefore.add(6, notification_interval);
                    intervalAfter.add(6, notification_interval);
                }
            }
        }
        catch (CmsDbEntryNotFoundException notification_interval) {
            // empty catch block
        }
        GregorianCalendar oneYearAgo = (GregorianCalendar)now.clone();
        oneYearAgo.add(6, -OpenCms.getSystemInfo().getNotificationTime());
        CmsResourceFilter filter = CmsResourceFilter.IGNORE_EXPIRATION.addRequireLastModifiedBefore(oneYearAgo.getTimeInMillis());
        for (CmsResource resource : this.m_cms.readResources(folder, filter)) {
            this.m_resources.add(new CmsExtendedNotificationCause(resource, 1, new Date(resource.getDateLastModified())));
        }
        CmsResourceFilter resourceFilter = CmsResourceFilter.IGNORE_EXPIRATION.addRequireExpireBefore(inOneWeek.getTimeInMillis());
        resourceFilter = resourceFilter.addRequireExpireAfter(now.getTimeInMillis());
        for (CmsResource resource : this.m_cms.readResources(folder, resourceFilter)) {
            this.m_resources.add(new CmsExtendedNotificationCause(resource, 0, new Date(resource.getDateExpired())));
        }
        resourceFilter = CmsResourceFilter.IGNORE_EXPIRATION.addRequireReleaseBefore(inOneWeek.getTimeInMillis());
        resourceFilter = resourceFilter.addRequireReleaseAfter(now.getTimeInMillis());
        for (CmsResource resource : this.m_cms.readResources(folder, resourceFilter)) {
            this.m_resources.add(new CmsExtendedNotificationCause(resource, 3, new Date(resource.getDateReleased())));
        }
    }

    public String notifyResponsibles() throws CmsException {
        Iterator<CmsContentNotification> notifications = this.filterConfirmedResources(this.getContentNotifications()).iterator();
        if (notifications.hasNext()) {
            StringBuffer result = new StringBuffer(Messages.get().getBundle().key("LOG_NOTIFICATIONS_SENT_TO_0"));
            result.append(' ');
            while (notifications.hasNext()) {
                CmsContentNotification contentNotification = notifications.next();
                result.append(contentNotification.getResponsible().getName());
                if (notifications.hasNext()) {
                    result.append(", ");
                }
                try {
                    contentNotification.send();
                }
                catch (EmailException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            return result.toString();
        }
        return Messages.get().getBundle().key("LOG_NO_NOTIFICATIONS_SENT_0");
    }

    protected Collection<CmsContentNotification> getContentNotifications() throws CmsException {
        Iterator<CmsExtendedNotificationCause> notificationCandidates = this.m_resources.iterator();
        HashMap<CmsUser, CmsContentNotification> result = new HashMap<CmsUser, CmsContentNotification>();
        while (notificationCandidates.hasNext()) {
            CmsExtendedNotificationCause resourceInfo = notificationCandidates.next();
            CmsResource resource = resourceInfo.getResource();
            String enableNotification = this.m_cms.readPropertyObject(resource, "enable-notification", true).getValue();
            if (!Boolean.valueOf(enableNotification).booleanValue()) continue;
            try {
                for (CmsUser responsible : this.m_cms.readResponsibleUsers(resource)) {
                    List<CmsExtendedNotificationCause> resourcesForResponsible;
                    if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(responsible.getEmail())) continue;
                    CmsContentNotification contentNotification = (CmsContentNotification)((Object)result.get(responsible));
                    if (contentNotification == null) {
                        contentNotification = new CmsContentNotification(responsible, this.m_cms);
                        result.put(responsible, contentNotification);
                    }
                    if ((resourcesForResponsible = contentNotification.getNotificationCauses()) == null) {
                        resourcesForResponsible = new ArrayList<CmsExtendedNotificationCause>();
                        contentNotification.setNotificationCauses(resourcesForResponsible);
                    }
                    resourcesForResponsible.add(resourceInfo);
                }
            }
            catch (CmsException e) {
                if (!LOG.isInfoEnabled()) continue;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result.values();
    }

    private Collection<CmsContentNotification> filterConfirmedResources(Collection<CmsContentNotification> contentNotifications) {
        for (CmsContentNotification contentNotification : contentNotifications) {
            CmsUser responsible = contentNotification.getResponsible();
            ArrayList confirmedResourcesList = (ArrayList)responsible.getAdditionalInfo("ADDITIONAL_INFO_CONFIRMED_RESOURCES");
            if (confirmedResourcesList == null) {
                confirmedResourcesList = new ArrayList();
                responsible.setAdditionalInfo("ADDITIONAL_INFO_CONFIRMED_RESOURCES", new ArrayList());
            }
            List<CmsExtendedNotificationCause> notificationCandidates = contentNotification.getNotificationCauses();
            ArrayList<CmsExtendedNotificationCause> notificationResources = new ArrayList<CmsExtendedNotificationCause>(notificationCandidates);
            for (Object o : confirmedResourcesList) {
                if (!notificationResources.contains(o)) continue;
                notificationResources.remove(o);
            }
            for (Object o : new ArrayList(confirmedResourcesList)) {
                if (notificationCandidates.contains(o)) continue;
                confirmedResourcesList.remove(o);
            }
            if (notificationResources.isEmpty()) {
                contentNotifications.remove((Object)contentNotification);
            } else {
                contentNotification.setNotificationCauses(notificationResources);
            }
            try {
                this.m_cms.writeUser(responsible);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return contentNotifications;
    }
}

