/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.pdftools;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsUUID;

public class CmsPdfLink {
    public static final String NOSLASH_GROUP = "([^/]+)";
    public static final String PDF_LINK_PREFIX = "pdflink";
    public static final String PDF_LINK_REGEX = "pdflink/([^/]+)/([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})/([^/]+)\\.pdf/?";
    public static final Pattern PDF_LINK_REGEX_COMPILED = Pattern.compile("pdflink/([^/]+)/([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})/([^/]+)\\.pdf/?");
    private CmsResource m_content;
    private CmsResource m_formatter;
    private String m_link;
    private Locale m_locale;

    public CmsPdfLink(CmsObject cms, CmsResource formatter, CmsResource content) throws CmsException {
        Locale locale = cms.getRequestContext().getLocale();
        this.m_content = content;
        this.m_locale = locale;
        String detailName = cms.getDetailName(content, cms.getRequestContext().getLocale(), OpenCms.getLocaleManager().getDefaultLocales());
        String s = "/pdflink/" + locale + "/" + formatter.getStructureId() + "/" + detailName + ".pdf";
        this.m_link = OpenCms.getLinkManager().substituteLink(cms, s);
    }

    public CmsPdfLink(CmsObject cms, String link) throws CmsPdfLinkParseException, CmsException {
        Matcher matcher = PDF_LINK_REGEX_COMPILED.matcher(link);
        this.m_link = link;
        if (!matcher.find()) {
            throw new CmsPdfLinkParseException();
        }
        String localeStr = matcher.group(1);
        String formatterId = matcher.group(2);
        String detailName = matcher.group(3);
        CmsUUID id = cms.readIdForUrlName(detailName);
        this.m_content = cms.readResource(id, CmsResourceFilter.ignoreExpirationOffline(cms));
        this.m_locale = CmsLocaleManager.getLocale(localeStr);
        this.m_formatter = cms.readResource(new CmsUUID(formatterId));
    }

    public CmsResource getContent() {
        return this.m_content;
    }

    public CmsResource getFormatter() {
        return this.m_formatter;
    }

    public String getLink() {
        return this.m_link;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public static class CmsPdfLinkParseException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

